/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models.eimpf;

import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.projecthusky.cda.elga.generated.artdecor.AtcdabbrEntryImmunizationRecommendation;
import org.projecthusky.cda.elga.generated.artdecor.AtcdabbrEntryImmunizationTarget;
import org.projecthusky.cda.elga.generated.artdecor.AtcdabbrOtherVaccineProductNichtAngegeben;
import org.projecthusky.cda.elga.generated.artdecor.AtcdabrrEntryComment;
import org.projecthusky.cda.elga.models.Appendix;
import org.projecthusky.cda.elga.models.Comment;
import org.projecthusky.cda.elga.models.Drug;
import org.projecthusky.cda.elga.models.PractitionerCdaAt;
import org.projecthusky.cda.elga.models.Translation;
import org.projecthusky.cda.elga.models.eimpf.ImmunizationSchedule;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.ED;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.POCDMT000040Act;
import org.projecthusky.common.hl7cdar2.POCDMT000040Consumable;
import org.projecthusky.common.hl7cdar2.POCDMT000040Entry;
import org.projecthusky.common.hl7cdar2.POCDMT000040EntryRelationship;
import org.projecthusky.common.hl7cdar2.POCDMT000040ExternalDocument;
import org.projecthusky.common.hl7cdar2.POCDMT000040ManufacturedProduct;
import org.projecthusky.common.hl7cdar2.POCDMT000040Observation;
import org.projecthusky.common.hl7cdar2.POCDMT000040Reference;
import org.projecthusky.common.hl7cdar2.POCDMT000040SubstanceAdministration;
import org.projecthusky.common.hl7cdar2.SXCMTS;
import org.projecthusky.common.hl7cdar2.TEL;
import org.projecthusky.common.hl7cdar2.TS;
import org.projecthusky.common.hl7cdar2.XActRelationshipEntry;
import org.projecthusky.common.model.Code;
import org.projecthusky.common.model.Identificator;
import org.projecthusky.common.utils.time.DateTimes;

public class ImmunizationRecommendation {
    private Identificator id;
    private Code vaccinationIndication;
    private ZonedDateTime startRecommendation;
    private ZonedDateTime stopRecommendation;
    private Drug drug;
    private PractitionerCdaAt author;
    private ZonedDateTime timeAuthor;
    private List<Comment> comments;
    private Appendix externalDocument;
    private Appendix immunizationPlan;
    private List<Code> immunizationTargets;
    private ImmunizationSchedule schedule;
    private List<Translation> translations;

    public Identificator getId() {
        return this.id;
    }

    public void setId(Identificator id) {
        this.id = id;
    }

    public Code getVaccination() {
        return this.vaccinationIndication;
    }

    public void setVaccination(Code vaccination) {
        this.vaccinationIndication = vaccination;
    }

    public ZonedDateTime getStartRecommendation() {
        return this.startRecommendation;
    }

    public void setStartRecommendation(ZonedDateTime startRecommendation) {
        this.startRecommendation = startRecommendation;
    }

    public ZonedDateTime getStopRecommendation() {
        return this.stopRecommendation;
    }

    public void setStopRecommendation(ZonedDateTime stopRecommendation) {
        this.stopRecommendation = stopRecommendation;
    }

    public Drug getDrug() {
        return this.drug;
    }

    public void setDrug(Drug drug) {
        this.drug = drug;
    }

    public PractitionerCdaAt getAuthor() {
        return this.author;
    }

    public void setAuthor(PractitionerCdaAt author) {
        this.author = author;
    }

    public ZonedDateTime getTimeAuthor() {
        return this.timeAuthor;
    }

    public void setTimeAuthor(ZonedDateTime timeAuthor) {
        this.timeAuthor = timeAuthor;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public void setComments(List<Comment> comments) {
        this.comments = comments;
    }

    public Appendix getExternalDocument() {
        return this.externalDocument;
    }

    public void setExternalDocument(Appendix externalDocument) {
        this.externalDocument = externalDocument;
    }

    public Appendix getImmunizationPlan() {
        return this.immunizationPlan;
    }

    public void setImmunizationPlan(Appendix immunizationPlan) {
        this.immunizationPlan = immunizationPlan;
    }

    public List<Code> getImmunizationTargets() {
        return this.immunizationTargets;
    }

    public void setImmunizationTargets(List<Code> immunizationTargets) {
        this.immunizationTargets = immunizationTargets;
    }

    public ImmunizationSchedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(ImmunizationSchedule schedule) {
        this.schedule = schedule;
    }

    public List<Translation> getTranslations() {
        return this.translations;
    }

    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public POCDMT000040Entry getImmunizationRecommendationEntry(int index) {
        POCDMT000040Reference ref;
        POCDMT000040Entry entry = new POCDMT000040Entry();
        entry.setTypeCode(XActRelationshipEntry.DRIV);
        entry.setContextConductionInd(Boolean.valueOf(true));
        AtcdabbrEntryImmunizationRecommendation immunization = new AtcdabbrEntryImmunizationRecommendation();
        if (this.id != null) {
            immunization.getId().add(this.id.getHl7CdaR2Ii());
        }
        immunization.setText(new ED(null, new TEL("#recommendation-" + index)));
        immunization.getEffectiveTime().add(this.createIntervalEffectiveTime(DateTimes.toDateTs((TemporalAccessor)this.startRecommendation), DateTimes.toDateTs((TemporalAccessor)this.stopRecommendation)));
        if (this.vaccinationIndication != null) {
            immunization.setCode(new CD(this.vaccinationIndication.getCode(), this.vaccinationIndication.getCodeSystem(), this.vaccinationIndication.getCodeSystemName(), this.vaccinationIndication.getDisplayName()));
        }
        if (this.drug != null) {
            immunization.setConsumable(this.drug.getVaccineProduct(true));
        } else {
            POCDMT000040Consumable consumable = new POCDMT000040Consumable();
            consumable.getTypeCode().add("CSM");
            consumable.setManufacturedProduct((POCDMT000040ManufacturedProduct)new AtcdabbrOtherVaccineProductNichtAngegeben());
            immunization.setConsumable(consumable);
        }
        if (this.author != null) {
            if (this.timeAuthor == null) {
                this.timeAuthor = ZonedDateTime.now();
            }
            immunization.setHl7Author(this.author.getAtcdabbrOtherAuthorBodyEImpfpass(this.timeAuthor));
        }
        if (this.immunizationTargets != null && !this.immunizationTargets.isEmpty()) {
            this.setImmunizationTargets(immunization);
        }
        if (this.comments != null && !this.comments.isEmpty()) {
            this.setComments(immunization);
        }
        if (this.externalDocument != null) {
            ref = new POCDMT000040Reference();
            ref.setExternalDocument((POCDMT000040ExternalDocument)this.externalDocument.getAtcdabbrEntryExternalDocument(0));
            immunization.getReference().add(ref);
        }
        if (this.immunizationPlan != null) {
            ref = new POCDMT000040Reference();
            ref.setExternalDocument((POCDMT000040ExternalDocument)this.immunizationPlan.getAtcdabbrEntryImpfPlan(0));
            immunization.getReference().add(ref);
        }
        if (this.schedule != null) {
            immunization.setHl7Precondition(this.schedule.getImmunizationRecommendationEntry(index));
        }
        entry.setSubstanceAdministration((POCDMT000040SubstanceAdministration)immunization);
        return entry;
    }

    protected SXCMTS createIntervalEffectiveTime(TS low, TS high) {
        IVLTS time = new IVLTS();
        time.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "low", ""), TS.class, (Object)low));
        time.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "high", ""), TS.class, (Object)high));
        return time;
    }

    private void setComments(AtcdabbrEntryImmunizationRecommendation immunization) {
        int commmentIndex = 0;
        for (Comment comment : this.comments) {
            if (comment == null) continue;
            AtcdabrrEntryComment commentAct = comment.getAtcdabbrEntryComment(commmentIndex);
            commentAct.setText(new ED(null, new TEL("#impfempf-comment-" + commmentIndex++)));
            POCDMT000040EntryRelationship entryRel = AtcdabbrEntryImmunizationRecommendation.getPredefinedEntryRelationshipRsonTrue();
            entryRel.setAct((POCDMT000040Act)commentAct);
            immunization.addHl7EntryRelationship(entryRel);
        }
    }

    private void setImmunizationTargets(AtcdabbrEntryImmunizationRecommendation immunization) {
        int targetIndex = 0;
        for (Code immunizationTarget : this.immunizationTargets) {
            AtcdabbrEntryImmunizationTarget target = new AtcdabbrEntryImmunizationTarget();
            target.setCode((CD)new CE(immunizationTarget.getCode(), immunizationTarget.getCodeSystem(), immunizationTarget.getCodeSystemName(), immunizationTarget.getDisplayName()));
            target.setText(new ED(null, new TEL("#immunization-target-" + targetIndex++)));
            POCDMT000040EntryRelationship entryRel = AtcdabbrEntryImmunizationRecommendation.getPredefinedEntryRelationshipRsonTrue();
            entryRel.setObservation((POCDMT000040Observation)target);
            immunization.addHl7EntryRelationship(entryRel);
        }
    }
}

