/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models.lab;

import java.util.List;
import org.projecthusky.cda.elga.generated.artdecor.base.Annotation;
import org.projecthusky.cda.elga.generated.artdecor.base.NotifiableCondition;
import org.projecthusky.cda.elga.generated.artdecor.base.NotificationOrganizer;
import org.projecthusky.cda.elga.models.Appendix;
import org.projecthusky.cda.elga.models.lab.CultureGermDetection;
import org.projecthusky.cda.elga.models.lab.LaboratoryBatteryOrganizer;
import org.projecthusky.cda.elga.models.lab.LaboratoryObservation;
import org.projecthusky.cda.elga.models.lab.SpecimenCollection;
import org.projecthusky.common.hl7cdar2.ActRelationshipHasComponent;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.CS;
import org.projecthusky.common.hl7cdar2.ED;
import org.projecthusky.common.hl7cdar2.POCDMT000040Act;
import org.projecthusky.common.hl7cdar2.POCDMT000040Component4;
import org.projecthusky.common.hl7cdar2.POCDMT000040Entry;
import org.projecthusky.common.hl7cdar2.POCDMT000040EntryRelationship;
import org.projecthusky.common.hl7cdar2.POCDMT000040Observation;
import org.projecthusky.common.hl7cdar2.POCDMT000040ObservationMedia;
import org.projecthusky.common.hl7cdar2.POCDMT000040Organizer;
import org.projecthusky.common.hl7cdar2.POCDMT000040Procedure;
import org.projecthusky.common.hl7cdar2.TEL;
import org.projecthusky.common.hl7cdar2.XActClassDocumentEntryAct;
import org.projecthusky.common.hl7cdar2.XActRelationshipEntry;
import org.projecthusky.common.hl7cdar2.XActRelationshipEntryRelationship;
import org.projecthusky.common.hl7cdar2.XDocumentActMood;
import org.projecthusky.common.model.Code;
import org.projecthusky.common.model.Identificator;

public class LaboratoryReportData {
    private Code structure;
    private List<SpecimenCollection> specimenCollections;
    private List<LaboratoryBatteryOrganizer> reportGroups;
    private List<LaboratoryObservation> results;
    private List<LaboratoryObservation> resultsActive;
    private List<CultureGermDetection> detections;
    private List<String> notes;
    private List<Code> notifications;
    private List<Appendix> appendices;

    public Code getStructure() {
        return this.structure;
    }

    public List<SpecimenCollection> getSpecimenCollections() {
        return this.specimenCollections;
    }

    public List<LaboratoryBatteryOrganizer> getReportGroups() {
        return this.reportGroups;
    }

    public List<LaboratoryObservation> getResults() {
        return this.results;
    }

    public List<LaboratoryObservation> getResultsActive() {
        return this.resultsActive;
    }

    public List<CultureGermDetection> getDetections() {
        return this.detections;
    }

    public List<String> getNotes() {
        return this.notes;
    }

    public List<Code> getNotifications() {
        return this.notifications;
    }

    public List<Appendix> getAppendices() {
        return this.appendices;
    }

    public void setStructure(Code structure) {
        this.structure = structure;
    }

    public void setSpecimenCollections(List<SpecimenCollection> specimenCollections) {
        this.specimenCollections = specimenCollections;
    }

    public void setReportGroups(List<LaboratoryBatteryOrganizer> reportGroups) {
        this.reportGroups = reportGroups;
    }

    public void setResults(List<LaboratoryObservation> results) {
        this.results = results;
    }

    public void setResultsActive(List<LaboratoryObservation> resultsActive) {
        this.resultsActive = resultsActive;
    }

    public void setDetections(List<CultureGermDetection> detections) {
        this.detections = detections;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public void setNotifications(List<Code> notifications) {
        this.notifications = notifications;
    }

    public void setAppendices(List<Appendix> appendices) {
        this.appendices = appendices;
    }

    public POCDMT000040Entry getPOCDMT000040Entry(String authorOid) {
        POCDMT000040Entry entry = new POCDMT000040Entry();
        entry.setTypeCode(XActRelationshipEntry.DRIV);
        entry.getTemplateId().add(new Identificator("1.3.6.1.4.1.19376.1.3.1").getHl7CdaR2Ii());
        entry.setAct(this.getPOCDMT000040Act(authorOid));
        return entry;
    }

    private POCDMT000040Act getPOCDMT000040Act(String authorOid) {
        POCDMT000040Act act = new POCDMT000040Act();
        act.setClassCode(XActClassDocumentEntryAct.ACT);
        act.setMoodCode(XDocumentActMood.EVN);
        act.setCode((CD)this.structure.getHl7CdaR2Ce());
        act.setStatusCode(new CS("completed"));
        this.addEntryRelationships(act, authorOid);
        return act;
    }

    private void addEntryRelationships(POCDMT000040Act act, String authorOid) {
        if (this.specimenCollections != null && !this.specimenCollections.isEmpty()) {
            this.addSpecimenCollections(act, authorOid);
        } else if (this.reportGroups != null && !this.reportGroups.isEmpty()) {
            this.addReportGroups(act);
        } else if (this.results != null && !this.results.isEmpty()) {
            this.addResults(act);
        } else if (this.resultsActive != null && !this.resultsActive.isEmpty()) {
            this.addResultsActive(act);
        } else if (this.detections != null && !this.detections.isEmpty()) {
            this.addDetections(act);
        } else if (this.notes != null && !this.notes.isEmpty()) {
            this.addNotes(act);
        } else if (this.notifications != null && !this.notifications.isEmpty()) {
            this.addNotifications(act);
        } else if (this.appendices != null && !this.appendices.isEmpty()) {
            this.addAppendices(act);
        }
    }

    private void addSpecimenCollections(POCDMT000040Act act, String authorOid) {
        for (SpecimenCollection collection : this.specimenCollections) {
            act.getEntryRelationship().add(this.getEntryRelationship(null, null, null, null, collection.getLaboratorySpecimenCollection(authorOid)));
        }
    }

    private void addReportGroups(POCDMT000040Act act) {
        for (LaboratoryBatteryOrganizer reportGroup : this.reportGroups) {
            act.getEntryRelationship().add(this.getEntryRelationship(null, null, null, reportGroup.getLaboratoryBatteryOrganizer(), null));
        }
    }

    private void addResults(POCDMT000040Act act) {
        int index = 0;
        for (LaboratoryObservation observation : this.results) {
            act.getEntryRelationship().add(this.getEntryRelationship(null, observation.getLaboratoryObservation(index++), null, null, null));
        }
    }

    private void addResultsActive(POCDMT000040Act act) {
        for (LaboratoryObservation observation : this.resultsActive) {
            act.getEntryRelationship().add(this.getEntryRelationship(null, observation.getLaboratoryObservationActive(), null, null, null));
        }
    }

    private void addDetections(POCDMT000040Act act) {
        for (CultureGermDetection detection : this.detections) {
            act.getEntryRelationship().add(this.getEntryRelationship(null, null, null, detection.getKulturellerKeimnachweis(), null));
        }
    }

    private void addAppendices(POCDMT000040Act act) {
        int index = 0;
        for (Appendix appendix : this.appendices) {
            act.getEntryRelationship().add(this.getEntryRelationship(null, null, appendix.getEingebettetesObjektEntry("lab-speciality", index++), null, null));
        }
    }

    private void addNotes(POCDMT000040Act act) {
        for (int index = 0; index < this.notes.size(); ++index) {
            Annotation annotation = new Annotation();
            annotation.setText(new ED(null, new TEL("#common-remark-" + index)));
            act.getEntryRelationship().add(this.getEntryRelationship(annotation, null, null, null, null));
        }
    }

    private void addNotifications(POCDMT000040Act act) {
        for (Code notification : this.notifications) {
            NotificationOrganizer notificationOrganizer = new NotificationOrganizer();
            POCDMT000040Component4 comp = new POCDMT000040Component4();
            comp.setTypeCode(ActRelationshipHasComponent.COMP);
            NotifiableCondition condition = new NotifiableCondition();
            condition.getValue().add(notification.getHl7CdaR2Ce());
            comp.setObservation((POCDMT000040Observation)condition);
            notificationOrganizer.getComponent().add(comp);
            act.getEntryRelationship().add(this.getEntryRelationship(null, null, null, notificationOrganizer, null));
        }
    }

    private POCDMT000040EntryRelationship getEntryRelationship(POCDMT000040Act act, POCDMT000040Observation obersvation, POCDMT000040ObservationMedia obersvationMedia, POCDMT000040Organizer organizer, POCDMT000040Procedure procedure) {
        POCDMT000040EntryRelationship entryRel = new POCDMT000040EntryRelationship();
        entryRel.setTypeCode(XActRelationshipEntryRelationship.COMP);
        entryRel.setAct(act);
        entryRel.setOrganizer(organizer);
        entryRel.setObservationMedia(obersvationMedia);
        entryRel.setProcedure(procedure);
        entryRel.setObservation(obersvation);
        return entryRel;
    }
}

