/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.narrative;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.IVXBTS;
import org.projecthusky.common.hl7cdar2.StrucDocContent;
import org.projecthusky.common.hl7cdar2.StrucDocRenderMultiMedia;
import org.projecthusky.common.hl7cdar2.StrucDocTd;
import org.projecthusky.common.hl7cdar2.StrucDocTh;
import org.projecthusky.common.hl7cdar2.TS;
import org.projecthusky.common.utils.time.DateTimes;
import org.projecthusky.common.utils.time.Hl7Dtm;

public class BaseTextGenerator {
    protected StrucDocTd getCellTd(String text) {
        if (text == null) {
            text = "";
        }
        StrucDocTd td = new StrucDocTd();
        td.getContent().add(text);
        return td;
    }

    protected StrucDocTd getCellWithRenderMultiMedia(String referenceObject) {
        StrucDocTd td = new StrucDocTd();
        StrucDocRenderMultiMedia renderMultiMedia = new StrucDocRenderMultiMedia();
        renderMultiMedia.getReferencedObject().add(referenceObject);
        td.getContent().add(new JAXBElement(new QName("urn:hl7-org:v3", "RenderMultiMedia"), StrucDocRenderMultiMedia.class, (Object)renderMultiMedia));
        return td;
    }

    protected StrucDocTh getTableHeaderCell(String text, String styleCode) {
        StrucDocTh th = new StrucDocTh();
        if (styleCode != null) {
            th.getStyleCode().add(styleCode);
        }
        th.getContent().add(text);
        return th;
    }

    protected StrucDocTd getCellTdWithContent(String text, String contentId) {
        StrucDocTd td = new StrucDocTd();
        td.getContent().add(this.getStrucDocContent(text, contentId));
        return td;
    }

    protected JAXBElement<StrucDocContent> getStrucDocContent(String text, String contentId) {
        StrucDocContent content = new StrucDocContent();
        content.setID(contentId);
        content.getContent().add(text);
        return new JAXBElement(new QName("urn:hl7-org:v3", "content"), StrucDocContent.class, (Object)content);
    }

    protected Map<String, String> getTsElement(IVLTS time) {
        HashMap<String, String> tsElements = new HashMap<String, String>();
        if (time != null) {
            for (JAXBElement ts : time.getRest()) {
                String value = "";
                String elementName = "";
                if (ts != null && IVXBTS.class.equals((Object)ts.getDeclaredType()) && ts.getValue() != null) {
                    value = ((IVXBTS)ts.getValue()).getValue();
                } else if (ts != null && TS.class.equals((Object)ts.getDeclaredType()) && ts.getValue() != null) {
                    value = ((TS)ts.getValue()).getValue();
                }
                if (ts != null && ts.getName() != null) {
                    elementName = ts.getName().getLocalPart();
                }
                if (value == null || elementName == null) continue;
                tsElements.put(elementName, value);
            }
        }
        return tsElements;
    }

    protected StrucDocTd getCellTdTime(IVLTS time) {
        String startDateDisease = null;
        String endDateDisease = null;
        StringBuilder sb = new StringBuilder();
        StrucDocTd tdTime = new StrucDocTd();
        if (time != null) {
            Map<String, String> timeMap = this.getTsElement(time);
            startDateDisease = timeMap.get("low");
            endDateDisease = timeMap.get("high");
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy").withZone(ZoneId.systemDefault());
            if (startDateDisease != null) {
                sb.append(formatter.format(DateTimes.toInstant((Hl7Dtm)Hl7Dtm.fromHl7((String)startDateDisease))));
                sb.append(" - ");
            }
            if (endDateDisease != null) {
                sb.append(formatter.format(DateTimes.toInstant((Hl7Dtm)Hl7Dtm.fromHl7((String)endDateDisease))));
            }
        }
        tdTime.getContent().add(sb.toString());
        return tdTime;
    }

    protected StrucDocTd getCellTdCodes(List<CE> interpretationCodes) {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (CE interpret : interpretationCodes) {
            if (interpret != null) {
                sb.append(interpret.getDisplayName());
            }
            if (++index == interpretationCodes.size()) continue;
            sb.append(" , ");
        }
        return this.getCellTd(sb.toString());
    }

    protected StrucDocTd getCellTdCode(CD codeTest) {
        return this.getCellTd(codeTest.getDisplayName());
    }

    protected StrucDocTd getCellTdId(II codeId) {
        return this.getCellTd(String.format("%s - %s", codeId.getExtension(), codeId.getRoot()));
    }
}

