/*
 * This code is made available under the terms of the Eclipse Public License v1.0
 * in the github project https://github.com/project-husky/husky there you also
 * find a list of the contributors and the license information.
 *
 * This project has been developed further and modified by the joined working group Husky
 * on the basis of the eHealth Connector opensource project from June 28, 2021,
 * whereas medshare GmbH is the initial and main contributor/author of the eHealth Connector.
 */
package org.projecthusky.cda.elga.generated.artdecor.ems.enums;

import java.util.Objects;
import javax.annotation.processing.Generated;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

/**
 * Enumeration of ELGA_AuthorSpeciality values
 * <p>
 * EN: No designation found.<br>
 * DE: No designation found.<br>
 * FR: No designation found.<br>
 * IT: No designation found.<br>
 * <p>
 * Identifier: 1.2.40.0.34.10.6<br>
 * Effective date: 2020-09-18 09:23<br>
 * Version: 202009(-beta)<br>
 * Status: DRAFT
 */
@Generated(value = "org.projecthusky.codegenerator.ch.valuesets.UpdateValueSets", date = "2022-02-01")
public enum ElgaAuthorSpeciality implements ValueSetEnumInterface {

    /**
     * EN: Allgemeine Krankenanstalt.<br>
     */
    ALLGEMEINE_KRANKENANSTALT_L1("300",
                                 "1.2.40.0.34.5.2",
                                 "Allgemeine Krankenanstalt",
                                 "Allgemeine Krankenanstalt",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE"),
    /**
     * EN: Approbierte Ärztin/Approbierter Arzt.<br>
     */
    APPROBIERTE_RZTIN_APPROBIERTER_ARZT_L1("101",
                                           "1.2.40.0.34.5.2",
                                           "Approbierte Ärztin/Approbierter Arzt",
                                           "Approbierte Ärztin/Approbierter Arzt",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE"),
    /**
     * EN: Arbeitsmedizinisches Zentrum.<br>
     */
    ARBEITSMEDIZINISCHES_ZENTRUM_L1("322",
                                    "1.2.40.0.34.5.2",
                                    "Arbeitsmedizinisches Zentrum",
                                    "Arbeitsmedizinisches Zentrum",
                                    "TOTRANSLATE",
                                    "TOTRANSLATE",
                                    "TOTRANSLATE"),
    /**
     * EN: Augen- und Kontaktlinsenoptik.<br>
     */
    AUGEN_UND_KONTAKTLINSENOPTIK_L1("314",
                                    "1.2.40.0.34.5.2",
                                    "Augen- und Kontaktlinsenoptik",
                                    "Augen- und Kontaktlinsenoptik",
                                    "TOTRANSLATE",
                                    "TOTRANSLATE",
                                    "TOTRANSLATE"),
    /**
     * EN: Biomedizinische Analytikerin/Biomedizinischer Analytiker.<br>
     */
    BIOMEDIZINISCHE_ANALYTIKERIN_BIOMEDIZINISCHER_ANALYTIKER_L1("206",
                                                                "1.2.40.0.34.5.2",
                                                                "Biomedizinische Analytikerin/Biomedizinischer Analytiker",
                                                                "Biomedizinische Analytikerin/Biomedizinischer Analytiker",
                                                                "TOTRANSLATE",
                                                                "TOTRANSLATE",
                                                                "TOTRANSLATE"),
    /**
     * EN: Blutspendeeinrichtung.<br>
     */
    BLUTSPENDEEINRICHTUNG_L1("313",
                             "1.2.40.0.34.5.2",
                             "Blutspendeeinrichtung",
                             "Blutspendeeinrichtung",
                             "TOTRANSLATE",
                             "TOTRANSLATE",
                             "TOTRANSLATE"),
    /**
     * EN: Dentistin/Dentist.<br>
     */
    DENTISTIN_DENTIST_L1("156",
                         "1.2.40.0.34.5.2",
                         "Dentistin/Dentist",
                         "Dentistin/Dentist",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Diplomierte Gesundheits- und Krankenschwester/Diplomierter Gesundheits- und Krankenpfleger.<br>
     */
    DIPLOMIERTE_GESUNDHEITS_UND_KRANKENSCHWESTER_DIPLOMIERTER_GESUNDHEITS_UND_KRANKENPFLEGER_L1("212",
                                                                                                "1.2.40.0.34.5.2",
                                                                                                "Diplomierte Gesundheits- und Krankenschwester/Diplomierter Gesundheits- und Krankenpfleger",
                                                                                                "Diplomierte Gesundheits- und Krankenschwester/Diplomierter Gesundheits- und Krankenpfleger",
                                                                                                "TOTRANSLATE",
                                                                                                "TOTRANSLATE",
                                                                                                "TOTRANSLATE"),
    /**
     * EN: Diplomierte Kardiotechnikerin/Diplomierter Kardiotechniker.<br>
     */
    DIPLOMIERTE_KARDIOTECHNIKERIN_DIPLOMIERTER_KARDIOTECHNIKER_L1("216",
                                                                  "1.2.40.0.34.5.2",
                                                                  "Diplomierte Kardiotechnikerin/Diplomierter Kardiotechniker",
                                                                  "Diplomierte Kardiotechnikerin/Diplomierter Kardiotechniker",
                                                                  "TOTRANSLATE",
                                                                  "TOTRANSLATE",
                                                                  "TOTRANSLATE"),
    /**
     * EN: Diplomierte Kinderkrankenschwester/Diplomierter Kinderkrankenpfleger.<br>
     */
    DIPLOMIERTE_KINDERKRANKENSCHWESTER_DIPLOMIERTER_KINDERKRANKENPFLEGER_L1("213",
                                                                            "1.2.40.0.34.5.2",
                                                                            "Diplomierte Kinderkrankenschwester/Diplomierter Kinderkrankenpfleger",
                                                                            "Diplomierte Kinderkrankenschwester/Diplomierter Kinderkrankenpfleger",
                                                                            "TOTRANSLATE",
                                                                            "TOTRANSLATE",
                                                                            "TOTRANSLATE"),
    /**
     * EN: Diplomierte psychiatrische Gesundheits- und Krankenschwester/Diplomierter psychiatrischer Gesundheits- und Krankenpfleger.<br>
     */
    DIPLOMIERTE_PSYCHIATRISCHE_GESUNDHEITS_UND_KRANKENSCHWESTER_DIPLOMIERTER_PSYCHIATRISCHER_GESUNDHEITS_UND_KRANKENPFLEGER_L1("214",
                                                                                                                               "1.2.40.0.34.5.2",
                                                                                                                               "Diplomierte psychiatrische Gesundheits- und Krankenschwester/Diplomierter psychiatrischer Gesundheits- und Krankenpfleger",
                                                                                                                               "Diplomierte psychiatrische Gesundheits- und Krankenschwester/Diplomierter psychiatrischer Gesundheits- und Krankenpfleger",
                                                                                                                               "TOTRANSLATE",
                                                                                                                               "TOTRANSLATE",
                                                                                                                               "TOTRANSLATE"),
    /**
     * EN: Diätologin/Diätologe.<br>
     */
    DI_TOLOGIN_DI_TOLOGE_L1("208",
                            "1.2.40.0.34.5.2",
                            "Diätologin/Diätologe",
                            "Diätologin/Diätologe",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: ELGA-Ombudsstelle.<br>
     */
    ELGA_OMBUDSSTELLE_L1("403",
                         "1.2.40.0.34.5.2",
                         "ELGA-Ombudsstelle",
                         "ELGA-Ombudsstelle",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Ergotherapeutin/Ergotherapeut.<br>
     */
    ERGOTHERAPEUTIN_ERGOTHERAPEUT_L1("209",
                                     "1.2.40.0.34.5.2",
                                     "Ergotherapeutin/Ergotherapeut",
                                     "Ergotherapeutin/Ergotherapeut",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE"),
    /**
     * EN: Ergänzende Rollen.<br>
     */
    ERG_NZENDE_ROLLEN("30",
                      "1.2.40.0.34.5.2",
                      "Ergänzende Rollen",
                      "Ergänzende Rollen",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Anatomie.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_ANATOMIE_L2("103",
                                        "1.2.40.0.34.5.160",
                                        "Fachärztin/Facharzt für Anatomie",
                                        "Fachärztin/Facharzt für Anatomie",
                                        "TOTRANSLATE",
                                        "TOTRANSLATE",
                                        "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Anästhesiologie und Intensivmedizin.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_AN_STHESIOLOGIE_UND_INTENSIVMEDIZIN_L2("102",
                                                                   "1.2.40.0.34.5.160",
                                                                   "Fachärztin/Facharzt für Anästhesiologie und Intensivmedizin",
                                                                   "Fachärztin/Facharzt für Anästhesiologie und Intensivmedizin",
                                                                   "TOTRANSLATE",
                                                                   "TOTRANSLATE",
                                                                   "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Arbeitsmedizin.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_ARBEITSMEDIZIN_L2("104",
                                              "1.2.40.0.34.5.160",
                                              "Fachärztin/Facharzt für Arbeitsmedizin",
                                              "Fachärztin/Facharzt für Arbeitsmedizin",
                                              "TOTRANSLATE",
                                              "TOTRANSLATE",
                                              "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Augenheilkunde und Optometrie.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_AUGENHEILKUNDE_UND_OPTOMETRIE_L2("105",
                                                             "1.2.40.0.34.5.160",
                                                             "Fachärztin/Facharzt für Augenheilkunde und Optometrie",
                                                             "Fachärztin/Facharzt für Augenheilkunde und Optometrie",
                                                             "TOTRANSLATE",
                                                             "TOTRANSLATE",
                                                             "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Blutgruppenserologie und Transfusionsmedizin.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_BLUTGRUPPENSEROLOGIE_UND_TRANSFUSIONSMEDIZIN_L2("106",
                                                                            "1.2.40.0.34.5.160",
                                                                            "Fachärztin/Facharzt für Blutgruppenserologie und Transfusionsmedizin",
                                                                            "Fachärztin/Facharzt für Blutgruppenserologie und Transfusionsmedizin",
                                                                            "TOTRANSLATE",
                                                                            "TOTRANSLATE",
                                                                            "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Chirurgie.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_CHIRURGIE_L2("107",
                                         "1.2.40.0.34.5.160",
                                         "Fachärztin/Facharzt für Chirurgie",
                                         "Fachärztin/Facharzt für Chirurgie",
                                         "TOTRANSLATE",
                                         "TOTRANSLATE",
                                         "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Frauenheilkunde und Geburtshilfe.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_FRAUENHEILKUNDE_UND_GEBURTSHILFE_L2("108",
                                                                "1.2.40.0.34.5.160",
                                                                "Fachärztin/Facharzt für Frauenheilkunde und Geburtshilfe",
                                                                "Fachärztin/Facharzt für Frauenheilkunde und Geburtshilfe",
                                                                "TOTRANSLATE",
                                                                "TOTRANSLATE",
                                                                "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Gerichtsmedizin.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_GERICHTSMEDIZIN_L2("109",
                                               "1.2.40.0.34.5.160",
                                               "Fachärztin/Facharzt für Gerichtsmedizin",
                                               "Fachärztin/Facharzt für Gerichtsmedizin",
                                               "TOTRANSLATE",
                                               "TOTRANSLATE",
                                               "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Hals-, Nasen- und Ohrenkrankheiten.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_HALS_NASEN_UND_OHRENKRANKHEITEN_L2("110",
                                                               "1.2.40.0.34.5.160",
                                                               "Fachärztin/Facharzt für Hals-, Nasen- und Ohrenkrankheiten",
                                                               "Fachärztin/Facharzt für Hals-, Nasen- und Ohrenkrankheiten",
                                                               "TOTRANSLATE",
                                                               "TOTRANSLATE",
                                                               "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Haut- und Geschlechtskrankheiten.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_HAUT_UND_GESCHLECHTSKRANKHEITEN_L2("111",
                                                               "1.2.40.0.34.5.160",
                                                               "Fachärztin/Facharzt für Haut- und Geschlechtskrankheiten",
                                                               "Fachärztin/Facharzt für Haut- und Geschlechtskrankheiten",
                                                               "TOTRANSLATE",
                                                               "TOTRANSLATE",
                                                               "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Herzchirurgie.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_HERZCHIRURGIE_L2("112",
                                             "1.2.40.0.34.5.160",
                                             "Fachärztin/Facharzt für Herzchirurgie",
                                             "Fachärztin/Facharzt für Herzchirurgie",
                                             "TOTRANSLATE",
                                             "TOTRANSLATE",
                                             "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Histologie und Embryologie.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_HISTOLOGIE_UND_EMBRYOLOGIE_L2("113",
                                                          "1.2.40.0.34.5.160",
                                                          "Fachärztin/Facharzt für Histologie und Embryologie",
                                                          "Fachärztin/Facharzt für Histologie und Embryologie",
                                                          "TOTRANSLATE",
                                                          "TOTRANSLATE",
                                                          "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Hygiene und Mikrobiologie.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_HYGIENE_UND_MIKROBIOLOGIE_L2("114",
                                                         "1.2.40.0.34.5.160",
                                                         "Fachärztin/Facharzt für Hygiene und Mikrobiologie",
                                                         "Fachärztin/Facharzt für Hygiene und Mikrobiologie",
                                                         "TOTRANSLATE",
                                                         "TOTRANSLATE",
                                                         "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Immunologie.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_IMMUNOLOGIE_L2("115",
                                           "1.2.40.0.34.5.160",
                                           "Fachärztin/Facharzt für Immunologie",
                                           "Fachärztin/Facharzt für Immunologie",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Innere Medizin.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_INNERE_MEDIZIN_L2("116",
                                              "1.2.40.0.34.5.160",
                                              "Fachärztin/Facharzt für Innere Medizin",
                                              "Fachärztin/Facharzt für Innere Medizin",
                                              "TOTRANSLATE",
                                              "TOTRANSLATE",
                                              "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Kinder- und Jugendchirurgie.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_KINDER_UND_JUGENDCHIRURGIE_L2("117",
                                                          "1.2.40.0.34.5.160",
                                                          "Fachärztin/Facharzt für Kinder- und Jugendchirurgie",
                                                          "Fachärztin/Facharzt für Kinder- und Jugendchirurgie",
                                                          "TOTRANSLATE",
                                                          "TOTRANSLATE",
                                                          "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Kinder- und Jugendheilkunde.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_KINDER_UND_JUGENDHEILKUNDE_L2("118",
                                                          "1.2.40.0.34.5.160",
                                                          "Fachärztin/Facharzt für Kinder- und Jugendheilkunde",
                                                          "Fachärztin/Facharzt für Kinder- und Jugendheilkunde",
                                                          "TOTRANSLATE",
                                                          "TOTRANSLATE",
                                                          "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Kinder- und Jugendpsychiatrie.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_KINDER_UND_JUGENDPSYCHIATRIE_L2("119",
                                                            "1.2.40.0.34.5.160",
                                                            "Fachärztin/Facharzt für Kinder- und Jugendpsychiatrie",
                                                            "Fachärztin/Facharzt für Kinder- und Jugendpsychiatrie",
                                                            "TOTRANSLATE",
                                                            "TOTRANSLATE",
                                                            "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Lungenkrankheiten.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_LUNGENKRANKHEITEN_L2("120",
                                                 "1.2.40.0.34.5.160",
                                                 "Fachärztin/Facharzt für Lungenkrankheiten",
                                                 "Fachärztin/Facharzt für Lungenkrankheiten",
                                                 "TOTRANSLATE",
                                                 "TOTRANSLATE",
                                                 "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Medizinische Biologie.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_MEDIZINISCHE_BIOLOGIE_L2("121",
                                                     "1.2.40.0.34.5.160",
                                                     "Fachärztin/Facharzt für Medizinische Biologie",
                                                     "Fachärztin/Facharzt für Medizinische Biologie",
                                                     "TOTRANSLATE",
                                                     "TOTRANSLATE",
                                                     "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Medizinische Biophysik.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_MEDIZINISCHE_BIOPHYSIK_L2("122",
                                                      "1.2.40.0.34.5.160",
                                                      "Fachärztin/Facharzt für Medizinische Biophysik",
                                                      "Fachärztin/Facharzt für Medizinische Biophysik",
                                                      "TOTRANSLATE",
                                                      "TOTRANSLATE",
                                                      "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Medizinische Genetik.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_MEDIZINISCHE_GENETIK_L2("123",
                                                    "1.2.40.0.34.5.160",
                                                    "Fachärztin/Facharzt für Medizinische Genetik",
                                                    "Fachärztin/Facharzt für Medizinische Genetik",
                                                    "TOTRANSLATE",
                                                    "TOTRANSLATE",
                                                    "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Medizinische Leistungsphysiologie.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_MEDIZINISCHE_LEISTUNGSPHYSIOLOGIE_L2("125",
                                                                 "1.2.40.0.34.5.160",
                                                                 "Fachärztin/Facharzt für Medizinische Leistungsphysiologie",
                                                                 "Fachärztin/Facharzt für Medizinische Leistungsphysiologie",
                                                                 "TOTRANSLATE",
                                                                 "TOTRANSLATE",
                                                                 "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Medizinische und Chemische Labordiagnostik.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_MEDIZINISCHE_UND_CHEMISCHE_LABORDIAGNOSTIK_L2("124",
                                                                          "1.2.40.0.34.5.160",
                                                                          "Fachärztin/Facharzt für Medizinische und Chemische Labordiagnostik",
                                                                          "Fachärztin/Facharzt für Medizinische und Chemische Labordiagnostik",
                                                                          "TOTRANSLATE",
                                                                          "TOTRANSLATE",
                                                                          "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Mikrobiologisch-Serologische Labordiagnostik.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_MIKROBIOLOGISCH_SEROLOGISCHE_LABORDIAGNOSTIK_L2("126",
                                                                            "1.2.40.0.34.5.160",
                                                                            "Fachärztin/Facharzt für Mikrobiologisch-Serologische Labordiagnostik",
                                                                            "Fachärztin/Facharzt für Mikrobiologisch-Serologische Labordiagnostik",
                                                                            "TOTRANSLATE",
                                                                            "TOTRANSLATE",
                                                                            "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Mund-, Kiefer- und Gesichtschirurgie.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_MUND_KIEFER_UND_GESICHTSCHIRURGIE_L2("127",
                                                                 "1.2.40.0.34.5.160",
                                                                 "Fachärztin/Facharzt für Mund-, Kiefer- und Gesichtschirurgie",
                                                                 "Fachärztin/Facharzt für Mund-, Kiefer- und Gesichtschirurgie",
                                                                 "TOTRANSLATE",
                                                                 "TOTRANSLATE",
                                                                 "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Neurobiologie.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_NEUROBIOLOGIE_L2("128",
                                             "1.2.40.0.34.5.160",
                                             "Fachärztin/Facharzt für Neurobiologie",
                                             "Fachärztin/Facharzt für Neurobiologie",
                                             "TOTRANSLATE",
                                             "TOTRANSLATE",
                                             "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Neurochirurgie.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_NEUROCHIRURGIE_L2("129",
                                              "1.2.40.0.34.5.160",
                                              "Fachärztin/Facharzt für Neurochirurgie",
                                              "Fachärztin/Facharzt für Neurochirurgie",
                                              "TOTRANSLATE",
                                              "TOTRANSLATE",
                                              "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Neurologie.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_NEUROLOGIE_L2("130",
                                          "1.2.40.0.34.5.160",
                                          "Fachärztin/Facharzt für Neurologie",
                                          "Fachärztin/Facharzt für Neurologie",
                                          "TOTRANSLATE",
                                          "TOTRANSLATE",
                                          "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Neurologie und Psychiatrie.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_NEUROLOGIE_UND_PSYCHIATRIE_L2("131",
                                                          "1.2.40.0.34.5.160",
                                                          "Fachärztin/Facharzt für Neurologie und Psychiatrie",
                                                          "Fachärztin/Facharzt für Neurologie und Psychiatrie",
                                                          "TOTRANSLATE",
                                                          "TOTRANSLATE",
                                                          "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Neuropathologie.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_NEUROPATHOLOGIE_L2("132",
                                               "1.2.40.0.34.5.160",
                                               "Fachärztin/Facharzt für Neuropathologie",
                                               "Fachärztin/Facharzt für Neuropathologie",
                                               "TOTRANSLATE",
                                               "TOTRANSLATE",
                                               "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Nuklearmedizin.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_NUKLEARMEDIZIN_L2("133",
                                              "1.2.40.0.34.5.160",
                                              "Fachärztin/Facharzt für Nuklearmedizin",
                                              "Fachärztin/Facharzt für Nuklearmedizin",
                                              "TOTRANSLATE",
                                              "TOTRANSLATE",
                                              "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Orthopädie und Orthopädische Chirurgie.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_ORTHOP_DIE_UND_ORTHOP_DISCHE_CHIRURGIE_L2("134",
                                                                      "1.2.40.0.34.5.160",
                                                                      "Fachärztin/Facharzt für Orthopädie und Orthopädische Chirurgie",
                                                                      "Fachärztin/Facharzt für Orthopädie und Orthopädische Chirurgie",
                                                                      "TOTRANSLATE",
                                                                      "TOTRANSLATE",
                                                                      "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Pathologie.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_PATHOLOGIE_L2("135",
                                          "1.2.40.0.34.5.160",
                                          "Fachärztin/Facharzt für Pathologie",
                                          "Fachärztin/Facharzt für Pathologie",
                                          "TOTRANSLATE",
                                          "TOTRANSLATE",
                                          "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Pathophysiologie.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_PATHOPHYSIOLOGIE_L2("136",
                                                "1.2.40.0.34.5.160",
                                                "Fachärztin/Facharzt für Pathophysiologie",
                                                "Fachärztin/Facharzt für Pathophysiologie",
                                                "TOTRANSLATE",
                                                "TOTRANSLATE",
                                                "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Pharmakologie und Toxikologie.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_PHARMAKOLOGIE_UND_TOXIKOLOGIE_L2("137",
                                                             "1.2.40.0.34.5.160",
                                                             "Fachärztin/Facharzt für Pharmakologie und Toxikologie",
                                                             "Fachärztin/Facharzt für Pharmakologie und Toxikologie",
                                                             "TOTRANSLATE",
                                                             "TOTRANSLATE",
                                                             "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Physikalische Medizin und Allgemeine Rehabilitation.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_PHYSIKALISCHE_MEDIZIN_UND_ALLGEMEINE_REHABILITATION_L2("138",
                                                                                   "1.2.40.0.34.5.160",
                                                                                   "Fachärztin/Facharzt für Physikalische Medizin und Allgemeine Rehabilitation",
                                                                                   "Fachärztin/Facharzt für Physikalische Medizin und Allgemeine Rehabilitation",
                                                                                   "TOTRANSLATE",
                                                                                   "TOTRANSLATE",
                                                                                   "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Physiologie.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_PHYSIOLOGIE_L2("139",
                                           "1.2.40.0.34.5.160",
                                           "Fachärztin/Facharzt für Physiologie",
                                           "Fachärztin/Facharzt für Physiologie",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Plastische, Ästhetische und Rekonstruktive Chirurgie.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_PLASTISCHE_STHETISCHE_UND_REKONSTRUKTIVE_CHIRURGIE_L2("140",
                                                                                  "1.2.40.0.34.5.160",
                                                                                  "Fachärztin/Facharzt für Plastische, Ästhetische und Rekonstruktive Chirurgie",
                                                                                  "Fachärztin/Facharzt für Plastische, Ästhetische und Rekonstruktive Chirurgie",
                                                                                  "TOTRANSLATE",
                                                                                  "TOTRANSLATE",
                                                                                  "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Psychiatrie.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_PSYCHIATRIE_L2("141",
                                           "1.2.40.0.34.5.160",
                                           "Fachärztin/Facharzt für Psychiatrie",
                                           "Fachärztin/Facharzt für Psychiatrie",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Psychiatrie und Neurologie.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_PSYCHIATRIE_UND_NEUROLOGIE_L2("142",
                                                          "1.2.40.0.34.5.160",
                                                          "Fachärztin/Facharzt für Psychiatrie und Neurologie",
                                                          "Fachärztin/Facharzt für Psychiatrie und Neurologie",
                                                          "TOTRANSLATE",
                                                          "TOTRANSLATE",
                                                          "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Psychiatrie und Psychotherapeutische Medizin.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_PSYCHIATRIE_UND_PSYCHOTHERAPEUTISCHE_MEDIZIN_L2("143",
                                                                            "1.2.40.0.34.5.160",
                                                                            "Fachärztin/Facharzt für Psychiatrie und Psychotherapeutische Medizin",
                                                                            "Fachärztin/Facharzt für Psychiatrie und Psychotherapeutische Medizin",
                                                                            "TOTRANSLATE",
                                                                            "TOTRANSLATE",
                                                                            "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Radiologie.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_RADIOLOGIE_L2("144",
                                          "1.2.40.0.34.5.160",
                                          "Fachärztin/Facharzt für Radiologie",
                                          "Fachärztin/Facharzt für Radiologie",
                                          "TOTRANSLATE",
                                          "TOTRANSLATE",
                                          "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Sozialmedizin.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_SOZIALMEDIZIN_L2("145",
                                             "1.2.40.0.34.5.160",
                                             "Fachärztin/Facharzt für Sozialmedizin",
                                             "Fachärztin/Facharzt für Sozialmedizin",
                                             "TOTRANSLATE",
                                             "TOTRANSLATE",
                                             "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Spezifische Prophylaxe und Tropenmedizin.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_SPEZIFISCHE_PROPHYLAXE_UND_TROPENMEDIZIN_L2("146",
                                                                        "1.2.40.0.34.5.160",
                                                                        "Fachärztin/Facharzt für Spezifische Prophylaxe und Tropenmedizin",
                                                                        "Fachärztin/Facharzt für Spezifische Prophylaxe und Tropenmedizin",
                                                                        "TOTRANSLATE",
                                                                        "TOTRANSLATE",
                                                                        "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Strahlentherapie-Radioonkologie.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_STRAHLENTHERAPIE_RADIOONKOLOGIE_L2("147",
                                                               "1.2.40.0.34.5.160",
                                                               "Fachärztin/Facharzt für Strahlentherapie-Radioonkologie",
                                                               "Fachärztin/Facharzt für Strahlentherapie-Radioonkologie",
                                                               "TOTRANSLATE",
                                                               "TOTRANSLATE",
                                                               "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Theoretische Sonderfächer.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_THEORETISCHE_SONDERF_CHER_L2("148",
                                                         "1.2.40.0.34.5.160",
                                                         "Fachärztin/Facharzt für Theoretische Sonderfächer",
                                                         "Fachärztin/Facharzt für Theoretische Sonderfächer",
                                                         "TOTRANSLATE",
                                                         "TOTRANSLATE",
                                                         "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Thoraxchirurgie.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_THORAXCHIRURGIE_L2("149",
                                               "1.2.40.0.34.5.160",
                                               "Fachärztin/Facharzt für Thoraxchirurgie",
                                               "Fachärztin/Facharzt für Thoraxchirurgie",
                                               "TOTRANSLATE",
                                               "TOTRANSLATE",
                                               "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Tumorbiologie.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_TUMORBIOLOGIE_L2("150",
                                             "1.2.40.0.34.5.160",
                                             "Fachärztin/Facharzt für Tumorbiologie",
                                             "Fachärztin/Facharzt für Tumorbiologie",
                                             "TOTRANSLATE",
                                             "TOTRANSLATE",
                                             "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Unfallchirurgie.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_UNFALLCHIRURGIE_L2("151",
                                               "1.2.40.0.34.5.160",
                                               "Fachärztin/Facharzt für Unfallchirurgie",
                                               "Fachärztin/Facharzt für Unfallchirurgie",
                                               "TOTRANSLATE",
                                               "TOTRANSLATE",
                                               "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Urologie.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_UROLOGIE_L2("152",
                                        "1.2.40.0.34.5.160",
                                        "Fachärztin/Facharzt für Urologie",
                                        "Fachärztin/Facharzt für Urologie",
                                        "TOTRANSLATE",
                                        "TOTRANSLATE",
                                        "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Virologie.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_VIROLOGIE_L2("153",
                                         "1.2.40.0.34.5.160",
                                         "Fachärztin/Facharzt für Virologie",
                                         "Fachärztin/Facharzt für Virologie",
                                         "TOTRANSLATE",
                                         "TOTRANSLATE",
                                         "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt für Zahn-, Mund- und Kieferheilkunde.<br>
     */
    FACH_RZTIN_FACHARZT_F_R_ZAHN_MUND_UND_KIEFERHEILKUNDE_L2("154",
                                                             "1.2.40.0.34.5.2",
                                                             "Fachärztin/Facharzt für Zahn-, Mund- und Kieferheilkunde",
                                                             "Fachärztin/Facharzt für Zahn-, Mund- und Kieferheilkunde",
                                                             "TOTRANSLATE",
                                                             "TOTRANSLATE",
                                                             "TOTRANSLATE"),
    /**
     * EN: Fachärztin/Facharzt.<br>
     */
    FACH_RZTIN_FACHARZT_L1("158",
                           "1.2.40.0.34.5.2",
                           "Fachärztin/Facharzt",
                           "Fachärztin/Facharzt",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: Gesundheitsmanagement.<br>
     */
    GESUNDHEITSMANAGEMENT_L1("400",
                             "1.2.40.0.34.5.2",
                             "Gesundheitsmanagement",
                             "Gesundheitsmanagement",
                             "TOTRANSLATE",
                             "TOTRANSLATE",
                             "TOTRANSLATE"),
    /**
     * EN: Gesundheitspsychologin/Gesundheitspsychologe.<br>
     */
    GESUNDHEITSPSYCHOLOGIN_GESUNDHEITSPSYCHOLOGE_L1("202",
                                                    "1.2.40.0.34.5.2",
                                                    "Gesundheitspsychologin/Gesundheitspsychologe",
                                                    "Gesundheitspsychologin/Gesundheitspsychologe",
                                                    "TOTRANSLATE",
                                                    "TOTRANSLATE",
                                                    "TOTRANSLATE"),
    /**
     * EN: Gesundheitsversicherung.<br>
     */
    GESUNDHEITSVERSICHERUNG_L1("408",
                               "1.2.40.0.34.5.2",
                               "Gesundheitsversicherung",
                               "Gesundheitsversicherung",
                               "TOTRANSLATE",
                               "TOTRANSLATE",
                               "TOTRANSLATE"),
    /**
     * EN: Gewebebank.<br>
     */
    GEWEBEBANK_L1("312",
                  "1.2.40.0.34.5.2",
                  "Gewebebank",
                  "Gewebebank",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Gewebeentnahmeeinrichtung.<br>
     */
    GEWEBEENTNAHMEEINRICHTUNG_L1("321",
                                 "1.2.40.0.34.5.2",
                                 "Gewebeentnahmeeinrichtung",
                                 "Gewebeentnahmeeinrichtung",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE"),
    /**
     * EN: Hebamme.<br>
     */
    HEBAMME_L1("204",
               "1.2.40.0.34.5.2",
               "Hebamme",
               "Hebamme",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Heilmasseurin/Heilmasseur.<br>
     */
    HEILMASSEURIN_HEILMASSEUR_L1("215",
                                 "1.2.40.0.34.5.2",
                                 "Heilmasseurin/Heilmasseur",
                                 "Heilmasseurin/Heilmasseur",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE"),
    /**
     * EN: Hörgeräteakustik.<br>
     */
    H_RGER_TEAKUSTIK_L1("315",
                        "1.2.40.0.34.5.2",
                        "Hörgeräteakustik",
                        "Hörgeräteakustik",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: IKT-Gesundheitsservice.<br>
     */
    IKT_GESUNDHEITSSERVICE_L1("500",
                              "1.2.40.0.34.5.2",
                              "IKT-Gesundheitsservice",
                              "IKT-Gesundheitsservice",
                              "TOTRANSLATE",
                              "TOTRANSLATE",
                              "TOTRANSLATE"),
    /**
     * EN: Klinische Psychologin/Klinischer Psychologe.<br>
     */
    KLINISCHE_PSYCHOLOGIN_KLINISCHER_PSYCHOLOGE_L1("201",
                                                   "1.2.40.0.34.5.2",
                                                   "Klinische Psychologin/Klinischer Psychologe",
                                                   "Klinische Psychologin/Klinischer Psychologe",
                                                   "TOTRANSLATE",
                                                   "TOTRANSLATE",
                                                   "TOTRANSLATE"),
    /**
     * EN: Krankenfürsorge.<br>
     */
    KRANKENF_RSORGE_L1("407",
                       "1.2.40.0.34.5.2",
                       "Krankenfürsorge",
                       "Krankenfürsorge",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Kuranstalt.<br>
     */
    KURANSTALT_L1("307",
                  "1.2.40.0.34.5.2",
                  "Kuranstalt",
                  "Kuranstalt",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Logopädin/Logopäde.<br>
     */
    LOGOP_DIN_LOGOP_DE_L1("210",
                          "1.2.40.0.34.5.2",
                          "Logopädin/Logopäde",
                          "Logopädin/Logopäde",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: Mobile Pflege.<br>
     */
    MOBILE_PFLEGE_L1("306",
                     "1.2.40.0.34.5.2",
                     "Mobile Pflege",
                     "Mobile Pflege",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Musiktherapeutin/Musiktherapeut.<br>
     */
    MUSIKTHERAPEUTIN_MUSIKTHERAPEUT_L1("203",
                                       "1.2.40.0.34.5.2",
                                       "Musiktherapeutin/Musiktherapeut",
                                       "Musiktherapeutin/Musiktherapeut",
                                       "TOTRANSLATE",
                                       "TOTRANSLATE",
                                       "TOTRANSLATE"),
    /**
     * EN: Orthoptistin/Orthoptist.<br>
     */
    ORTHOPTISTIN_ORTHOPTIST_L1("211",
                               "1.2.40.0.34.5.2",
                               "Orthoptistin/Orthoptist",
                               "Orthoptistin/Orthoptist",
                               "TOTRANSLATE",
                               "TOTRANSLATE",
                               "TOTRANSLATE"),
    /**
     * EN: Orthopädische Produkte.<br>
     */
    ORTHOP_DISCHE_PRODUKTE_L1("316",
                              "1.2.40.0.34.5.2",
                              "Orthopädische Produkte",
                              "Orthopädische Produkte",
                              "TOTRANSLATE",
                              "TOTRANSLATE",
                              "TOTRANSLATE"),
    /**
     * EN: Patientenvertretung.<br>
     */
    PATIENTENVERTRETUNG_L1("405",
                           "1.2.40.0.34.5.2",
                           "Patientenvertretung",
                           "Patientenvertretung",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: Pflegeanstalt.<br>
     */
    PFLEGEANSTALT_L1("302",
                     "1.2.40.0.34.5.2",
                     "Pflegeanstalt",
                     "Pflegeanstalt",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Pflegeassistentin/Pflegeassistent.<br>
     */
    PFLEGEASSISTENTIN_PFLEGEASSISTENT_L1("217",
                                         "1.2.40.0.34.5.2",
                                         "Pflegeassistentin/Pflegeassistent",
                                         "Pflegeassistentin/Pflegeassistent",
                                         "TOTRANSLATE",
                                         "TOTRANSLATE",
                                         "TOTRANSLATE"),
    /**
     * EN: Pflegeeinrichtung.<br>
     */
    PFLEGEEINRICHTUNG_L1("305",
                         "1.2.40.0.34.5.2",
                         "Pflegeeinrichtung",
                         "Pflegeeinrichtung",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Pflegefachassistentin/Pflegefachassistent.<br>
     */
    PFLEGEFACHASSISTENTIN_PFLEGEFACHASSISTENT_L1("218",
                                                 "1.2.40.0.34.5.2",
                                                 "Pflegefachassistentin/Pflegefachassistent",
                                                 "Pflegefachassistentin/Pflegefachassistent",
                                                 "TOTRANSLATE",
                                                 "TOTRANSLATE",
                                                 "TOTRANSLATE"),
    /**
     * EN: Physiotherapeutin/Physiotherapeut.<br>
     */
    PHYSIOTHERAPEUTIN_PHYSIOTHERAPEUT_L1("205",
                                         "1.2.40.0.34.5.2",
                                         "Physiotherapeutin/Physiotherapeut",
                                         "Physiotherapeutin/Physiotherapeut",
                                         "TOTRANSLATE",
                                         "TOTRANSLATE",
                                         "TOTRANSLATE"),
    /**
     * EN: Psychotherapeutin/Psychotherapeut.<br>
     */
    PSYCHOTHERAPEUTIN_PSYCHOTHERAPEUT_L1("200",
                                         "1.2.40.0.34.5.2",
                                         "Psychotherapeutin/Psychotherapeut",
                                         "Psychotherapeutin/Psychotherapeut",
                                         "TOTRANSLATE",
                                         "TOTRANSLATE",
                                         "TOTRANSLATE"),
    /**
     * EN: Radiologietechnologin/Radiologietechnologe.<br>
     */
    RADIOLOGIETECHNOLOGIN_RADIOLOGIETECHNOLOGE_L1("207",
                                                  "1.2.40.0.34.5.2",
                                                  "Radiologietechnologin/Radiologietechnologe",
                                                  "Radiologietechnologin/Radiologietechnologe",
                                                  "TOTRANSLATE",
                                                  "TOTRANSLATE",
                                                  "TOTRANSLATE"),
    /**
     * EN: Rettungsdienst.<br>
     */
    RETTUNGSDIENST_L1("318",
                      "1.2.40.0.34.5.2",
                      "Rettungsdienst",
                      "Rettungsdienst",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Sanatorium.<br>
     */
    SANATORIUM_L1("303",
                  "1.2.40.0.34.5.2",
                  "Sanatorium",
                  "Sanatorium",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Selbstständiges Ambulatorium.<br>
     */
    SELBSTST_NDIGES_AMBULATORIUM_L1("304",
                                    "1.2.40.0.34.5.2",
                                    "Selbstständiges Ambulatorium",
                                    "Selbstständiges Ambulatorium",
                                    "TOTRANSLATE",
                                    "TOTRANSLATE",
                                    "TOTRANSLATE"),
    /**
     * EN: Sonderkrankenanstalt.<br>
     */
    SONDERKRANKENANSTALT_L1("301",
                            "1.2.40.0.34.5.2",
                            "Sonderkrankenanstalt",
                            "Sonderkrankenanstalt",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: Sozialversicherung.<br>
     */
    SOZIALVERSICHERUNG_L1("406",
                          "1.2.40.0.34.5.2",
                          "Sozialversicherung",
                          "Sozialversicherung",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: Straf- und Maßnahmenvollzug.<br>
     */
    STRAF_UND_MASSNAHMENVOLLZUG_L1("309",
                                   "1.2.40.0.34.5.2",
                                   "Straf- und Maßnahmenvollzug",
                                   "Straf- und Maßnahmenvollzug",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE"),
    /**
     * EN: Teil 1: Rollen für Personen.<br>
     */
    TEIL_1_ROLLEN_F_R_PERSONEN("10",
                               "1.2.40.0.34.5.2",
                               "Teil 1: Rollen für Personen",
                               "Teil 1: Rollen für Personen",
                               "TOTRANSLATE",
                               "TOTRANSLATE",
                               "TOTRANSLATE"),
    /**
     * EN: Teil 2: Rollen für Organisationen.<br>
     */
    TEIL_2_ROLLEN_F_R_ORGANISATIONEN("20",
                                     "1.2.40.0.34.5.2",
                                     "Teil 2: Rollen für Organisationen",
                                     "Teil 2: Rollen für Organisationen",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE"),
    /**
     * EN: Untersuchungsanstalt.<br>
     */
    UNTERSUCHUNGSANSTALT_L1("310",
                            "1.2.40.0.34.5.2",
                            "Untersuchungsanstalt",
                            "Untersuchungsanstalt",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: Verrechnungsservice.<br>
     */
    VERRECHNUNGSSERVICE_L1("501",
                           "1.2.40.0.34.5.2",
                           "Verrechnungsservice",
                           "Verrechnungsservice",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: Widerspruchstelle.<br>
     */
    WIDERSPRUCHSTELLE_L1("404",
                         "1.2.40.0.34.5.2",
                         "Widerspruchstelle",
                         "Widerspruchstelle",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Zahntechnik.<br>
     */
    ZAHNTECHNIK_L1("317",
                   "1.2.40.0.34.5.2",
                   "Zahntechnik",
                   "Zahntechnik",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Zahnärztin/Zahnarzt.<br>
     */
    ZAHN_RZTIN_ZAHNARZT_L1("155",
                           "1.2.40.0.34.5.2",
                           "Zahnärztin/Zahnarzt",
                           "Zahnärztin/Zahnarzt",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: Zahnärztliche Gruppenpraxis.<br>
     */
    ZAHN_RZTLICHE_GRUPPENPRAXIS_L1("319",
                                   "1.2.40.0.34.5.2",
                                   "Zahnärztliche Gruppenpraxis",
                                   "Zahnärztliche Gruppenpraxis",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE"),
    /**
     * EN: Öffentlicher Gesundheitsdienst.<br>
     */
    _FFENTLICHER_GESUNDHEITSDIENST_L1("401",
                                      "1.2.40.0.34.5.2",
                                      "Öffentlicher Gesundheitsdienst",
                                      "Öffentlicher Gesundheitsdienst",
                                      "TOTRANSLATE",
                                      "TOTRANSLATE",
                                      "TOTRANSLATE"),
    /**
     * EN: Öffentliche Apotheke.<br>
     */
    _FFENTLICHE_APOTHEKE_L1("311",
                            "1.2.40.0.34.5.2",
                            "Öffentliche Apotheke",
                            "Öffentliche Apotheke",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: Ärztin/Arzt für Allgemeinmedizin.<br>
     */
    _RZTIN_ARZT_F_R_ALLGEMEINMEDIZIN_L1("100",
                                        "1.2.40.0.34.5.2",
                                        "Ärztin/Arzt für Allgemeinmedizin",
                                        "Ärztin/Arzt für Allgemeinmedizin",
                                        "TOTRANSLATE",
                                        "TOTRANSLATE",
                                        "TOTRANSLATE"),
    /**
     * EN: Ärztin/Arzt in Ausbildung.<br>
     */
    _RZTIN_ARZT_IN_AUSBILDUNG_L1("157",
                                 "1.2.40.0.34.5.2",
                                 "Ärztin/Arzt in Ausbildung",
                                 "Ärztin/Arzt in Ausbildung",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE"),
    /**
     * EN: Ärztliche Gruppenpraxis.<br>
     */
    _RZTLICHE_GRUPPENPRAXIS_L1("320",
                               "1.2.40.0.34.5.2",
                               "Ärztliche Gruppenpraxis",
                               "Ärztliche Gruppenpraxis",
                               "TOTRANSLATE",
                               "TOTRANSLATE",
                               "TOTRANSLATE");

    /**
     * EN: Code for Allgemeine Krankenanstalt.<br>
     */
    public static final String ALLGEMEINE_KRANKENANSTALT_L1_CODE = "300";

    /**
     * EN: Code for Approbierte Ärztin/Approbierter Arzt.<br>
     */
    public static final String APPROBIERTE_RZTIN_APPROBIERTER_ARZT_L1_CODE = "101";

    /**
     * EN: Code for Arbeitsmedizinisches Zentrum.<br>
     */
    public static final String ARBEITSMEDIZINISCHES_ZENTRUM_L1_CODE = "322";

    /**
     * EN: Code for Augen- und Kontaktlinsenoptik.<br>
     */
    public static final String AUGEN_UND_KONTAKTLINSENOPTIK_L1_CODE = "314";

    /**
     * EN: Code for Biomedizinische Analytikerin/Biomedizinischer Analytiker.<br>
     */
    public static final String BIOMEDIZINISCHE_ANALYTIKERIN_BIOMEDIZINISCHER_ANALYTIKER_L1_CODE = "206";

    /**
     * EN: Code for Blutspendeeinrichtung.<br>
     */
    public static final String BLUTSPENDEEINRICHTUNG_L1_CODE = "313";

    /**
     * EN: Code for Dentistin/Dentist.<br>
     */
    public static final String DENTISTIN_DENTIST_L1_CODE = "156";

    /**
     * EN: Code for Diplomierte Gesundheits- und Krankenschwester/Diplomierter Gesundheits- und Krankenpfleger.<br>
     */
    public static final String DIPLOMIERTE_GESUNDHEITS_UND_KRANKENSCHWESTER_DIPLOMIERTER_GESUNDHEITS_UND_KRANKENPFLEGER_L1_CODE = "212";

    /**
     * EN: Code for Diplomierte Kardiotechnikerin/Diplomierter Kardiotechniker.<br>
     */
    public static final String DIPLOMIERTE_KARDIOTECHNIKERIN_DIPLOMIERTER_KARDIOTECHNIKER_L1_CODE = "216";

    /**
     * EN: Code for Diplomierte Kinderkrankenschwester/Diplomierter Kinderkrankenpfleger.<br>
     */
    public static final String DIPLOMIERTE_KINDERKRANKENSCHWESTER_DIPLOMIERTER_KINDERKRANKENPFLEGER_L1_CODE = "213";

    /**
     * EN: Code for Diplomierte psychiatrische Gesundheits- und Krankenschwester/Diplomierter psychiatrischer Gesundheits- und Krankenpfleger.<br>
     */
    public static final String DIPLOMIERTE_PSYCHIATRISCHE_GESUNDHEITS_UND_KRANKENSCHWESTER_DIPLOMIERTER_PSYCHIATRISCHER_GESUNDHEITS_UND_KRANKENPFLEGER_L1_CODE = "214";

    /**
     * EN: Code for Diätologin/Diätologe.<br>
     */
    public static final String DI_TOLOGIN_DI_TOLOGE_L1_CODE = "208";

    /**
     * EN: Code for ELGA-Ombudsstelle.<br>
     */
    public static final String ELGA_OMBUDSSTELLE_L1_CODE = "403";

    /**
     * EN: Code for Ergotherapeutin/Ergotherapeut.<br>
     */
    public static final String ERGOTHERAPEUTIN_ERGOTHERAPEUT_L1_CODE = "209";

    /**
     * EN: Code for Ergänzende Rollen.<br>
     */
    public static final String ERG_NZENDE_ROLLEN_CODE = "30";

    /**
     * EN: Code for Fachärztin/Facharzt für Anatomie.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_ANATOMIE_L2_CODE = "103";

    /**
     * EN: Code for Fachärztin/Facharzt für Anästhesiologie und Intensivmedizin.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_AN_STHESIOLOGIE_UND_INTENSIVMEDIZIN_L2_CODE = "102";

    /**
     * EN: Code for Fachärztin/Facharzt für Arbeitsmedizin.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_ARBEITSMEDIZIN_L2_CODE = "104";

    /**
     * EN: Code for Fachärztin/Facharzt für Augenheilkunde und Optometrie.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_AUGENHEILKUNDE_UND_OPTOMETRIE_L2_CODE = "105";

    /**
     * EN: Code for Fachärztin/Facharzt für Blutgruppenserologie und Transfusionsmedizin.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_BLUTGRUPPENSEROLOGIE_UND_TRANSFUSIONSMEDIZIN_L2_CODE = "106";

    /**
     * EN: Code for Fachärztin/Facharzt für Chirurgie.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_CHIRURGIE_L2_CODE = "107";

    /**
     * EN: Code for Fachärztin/Facharzt für Frauenheilkunde und Geburtshilfe.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_FRAUENHEILKUNDE_UND_GEBURTSHILFE_L2_CODE = "108";

    /**
     * EN: Code for Fachärztin/Facharzt für Gerichtsmedizin.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_GERICHTSMEDIZIN_L2_CODE = "109";

    /**
     * EN: Code for Fachärztin/Facharzt für Hals-, Nasen- und Ohrenkrankheiten.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_HALS_NASEN_UND_OHRENKRANKHEITEN_L2_CODE = "110";

    /**
     * EN: Code for Fachärztin/Facharzt für Haut- und Geschlechtskrankheiten.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_HAUT_UND_GESCHLECHTSKRANKHEITEN_L2_CODE = "111";

    /**
     * EN: Code for Fachärztin/Facharzt für Herzchirurgie.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_HERZCHIRURGIE_L2_CODE = "112";

    /**
     * EN: Code for Fachärztin/Facharzt für Histologie und Embryologie.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_HISTOLOGIE_UND_EMBRYOLOGIE_L2_CODE = "113";

    /**
     * EN: Code for Fachärztin/Facharzt für Hygiene und Mikrobiologie.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_HYGIENE_UND_MIKROBIOLOGIE_L2_CODE = "114";

    /**
     * EN: Code for Fachärztin/Facharzt für Immunologie.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_IMMUNOLOGIE_L2_CODE = "115";

    /**
     * EN: Code for Fachärztin/Facharzt für Innere Medizin.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_INNERE_MEDIZIN_L2_CODE = "116";

    /**
     * EN: Code for Fachärztin/Facharzt für Kinder- und Jugendchirurgie.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_KINDER_UND_JUGENDCHIRURGIE_L2_CODE = "117";

    /**
     * EN: Code for Fachärztin/Facharzt für Kinder- und Jugendheilkunde.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_KINDER_UND_JUGENDHEILKUNDE_L2_CODE = "118";

    /**
     * EN: Code for Fachärztin/Facharzt für Kinder- und Jugendpsychiatrie.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_KINDER_UND_JUGENDPSYCHIATRIE_L2_CODE = "119";

    /**
     * EN: Code for Fachärztin/Facharzt für Lungenkrankheiten.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_LUNGENKRANKHEITEN_L2_CODE = "120";

    /**
     * EN: Code for Fachärztin/Facharzt für Medizinische Biologie.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_MEDIZINISCHE_BIOLOGIE_L2_CODE = "121";

    /**
     * EN: Code for Fachärztin/Facharzt für Medizinische Biophysik.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_MEDIZINISCHE_BIOPHYSIK_L2_CODE = "122";

    /**
     * EN: Code for Fachärztin/Facharzt für Medizinische Genetik.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_MEDIZINISCHE_GENETIK_L2_CODE = "123";

    /**
     * EN: Code for Fachärztin/Facharzt für Medizinische Leistungsphysiologie.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_MEDIZINISCHE_LEISTUNGSPHYSIOLOGIE_L2_CODE = "125";

    /**
     * EN: Code for Fachärztin/Facharzt für Medizinische und Chemische Labordiagnostik.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_MEDIZINISCHE_UND_CHEMISCHE_LABORDIAGNOSTIK_L2_CODE = "124";

    /**
     * EN: Code for Fachärztin/Facharzt für Mikrobiologisch-Serologische Labordiagnostik.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_MIKROBIOLOGISCH_SEROLOGISCHE_LABORDIAGNOSTIK_L2_CODE = "126";

    /**
     * EN: Code for Fachärztin/Facharzt für Mund-, Kiefer- und Gesichtschirurgie.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_MUND_KIEFER_UND_GESICHTSCHIRURGIE_L2_CODE = "127";

    /**
     * EN: Code for Fachärztin/Facharzt für Neurobiologie.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_NEUROBIOLOGIE_L2_CODE = "128";

    /**
     * EN: Code for Fachärztin/Facharzt für Neurochirurgie.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_NEUROCHIRURGIE_L2_CODE = "129";

    /**
     * EN: Code for Fachärztin/Facharzt für Neurologie.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_NEUROLOGIE_L2_CODE = "130";

    /**
     * EN: Code for Fachärztin/Facharzt für Neurologie und Psychiatrie.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_NEUROLOGIE_UND_PSYCHIATRIE_L2_CODE = "131";

    /**
     * EN: Code for Fachärztin/Facharzt für Neuropathologie.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_NEUROPATHOLOGIE_L2_CODE = "132";

    /**
     * EN: Code for Fachärztin/Facharzt für Nuklearmedizin.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_NUKLEARMEDIZIN_L2_CODE = "133";

    /**
     * EN: Code for Fachärztin/Facharzt für Orthopädie und Orthopädische Chirurgie.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_ORTHOP_DIE_UND_ORTHOP_DISCHE_CHIRURGIE_L2_CODE = "134";

    /**
     * EN: Code for Fachärztin/Facharzt für Pathologie.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_PATHOLOGIE_L2_CODE = "135";

    /**
     * EN: Code for Fachärztin/Facharzt für Pathophysiologie.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_PATHOPHYSIOLOGIE_L2_CODE = "136";

    /**
     * EN: Code for Fachärztin/Facharzt für Pharmakologie und Toxikologie.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_PHARMAKOLOGIE_UND_TOXIKOLOGIE_L2_CODE = "137";

    /**
     * EN: Code for Fachärztin/Facharzt für Physikalische Medizin und Allgemeine Rehabilitation.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_PHYSIKALISCHE_MEDIZIN_UND_ALLGEMEINE_REHABILITATION_L2_CODE = "138";

    /**
     * EN: Code for Fachärztin/Facharzt für Physiologie.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_PHYSIOLOGIE_L2_CODE = "139";

    /**
     * EN: Code for Fachärztin/Facharzt für Plastische, Ästhetische und Rekonstruktive Chirurgie.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_PLASTISCHE_STHETISCHE_UND_REKONSTRUKTIVE_CHIRURGIE_L2_CODE = "140";

    /**
     * EN: Code for Fachärztin/Facharzt für Psychiatrie.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_PSYCHIATRIE_L2_CODE = "141";

    /**
     * EN: Code for Fachärztin/Facharzt für Psychiatrie und Neurologie.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_PSYCHIATRIE_UND_NEUROLOGIE_L2_CODE = "142";

    /**
     * EN: Code for Fachärztin/Facharzt für Psychiatrie und Psychotherapeutische Medizin.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_PSYCHIATRIE_UND_PSYCHOTHERAPEUTISCHE_MEDIZIN_L2_CODE = "143";

    /**
     * EN: Code for Fachärztin/Facharzt für Radiologie.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_RADIOLOGIE_L2_CODE = "144";

    /**
     * EN: Code for Fachärztin/Facharzt für Sozialmedizin.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_SOZIALMEDIZIN_L2_CODE = "145";

    /**
     * EN: Code for Fachärztin/Facharzt für Spezifische Prophylaxe und Tropenmedizin.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_SPEZIFISCHE_PROPHYLAXE_UND_TROPENMEDIZIN_L2_CODE = "146";

    /**
     * EN: Code for Fachärztin/Facharzt für Strahlentherapie-Radioonkologie.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_STRAHLENTHERAPIE_RADIOONKOLOGIE_L2_CODE = "147";

    /**
     * EN: Code for Fachärztin/Facharzt für Theoretische Sonderfächer.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_THEORETISCHE_SONDERF_CHER_L2_CODE = "148";

    /**
     * EN: Code for Fachärztin/Facharzt für Thoraxchirurgie.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_THORAXCHIRURGIE_L2_CODE = "149";

    /**
     * EN: Code for Fachärztin/Facharzt für Tumorbiologie.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_TUMORBIOLOGIE_L2_CODE = "150";

    /**
     * EN: Code for Fachärztin/Facharzt für Unfallchirurgie.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_UNFALLCHIRURGIE_L2_CODE = "151";

    /**
     * EN: Code for Fachärztin/Facharzt für Urologie.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_UROLOGIE_L2_CODE = "152";

    /**
     * EN: Code for Fachärztin/Facharzt für Virologie.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_VIROLOGIE_L2_CODE = "153";

    /**
     * EN: Code for Fachärztin/Facharzt für Zahn-, Mund- und Kieferheilkunde.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_F_R_ZAHN_MUND_UND_KIEFERHEILKUNDE_L2_CODE = "154";

    /**
     * EN: Code for Fachärztin/Facharzt.<br>
     */
    public static final String FACH_RZTIN_FACHARZT_L1_CODE = "158";

    /**
     * EN: Code for Gesundheitsmanagement.<br>
     */
    public static final String GESUNDHEITSMANAGEMENT_L1_CODE = "400";

    /**
     * EN: Code for Gesundheitspsychologin/Gesundheitspsychologe.<br>
     */
    public static final String GESUNDHEITSPSYCHOLOGIN_GESUNDHEITSPSYCHOLOGE_L1_CODE = "202";

    /**
     * EN: Code for Gesundheitsversicherung.<br>
     */
    public static final String GESUNDHEITSVERSICHERUNG_L1_CODE = "408";

    /**
     * EN: Code for Gewebebank.<br>
     */
    public static final String GEWEBEBANK_L1_CODE = "312";

    /**
     * EN: Code for Gewebeentnahmeeinrichtung.<br>
     */
    public static final String GEWEBEENTNAHMEEINRICHTUNG_L1_CODE = "321";

    /**
     * EN: Code for Hebamme.<br>
     */
    public static final String HEBAMME_L1_CODE = "204";

    /**
     * EN: Code for Heilmasseurin/Heilmasseur.<br>
     */
    public static final String HEILMASSEURIN_HEILMASSEUR_L1_CODE = "215";

    /**
     * EN: Code for Hörgeräteakustik.<br>
     */
    public static final String H_RGER_TEAKUSTIK_L1_CODE = "315";

    /**
     * EN: Code for IKT-Gesundheitsservice.<br>
     */
    public static final String IKT_GESUNDHEITSSERVICE_L1_CODE = "500";

    /**
     * EN: Code for Klinische Psychologin/Klinischer Psychologe.<br>
     */
    public static final String KLINISCHE_PSYCHOLOGIN_KLINISCHER_PSYCHOLOGE_L1_CODE = "201";

    /**
     * EN: Code for Krankenfürsorge.<br>
     */
    public static final String KRANKENF_RSORGE_L1_CODE = "407";

    /**
     * EN: Code for Kuranstalt.<br>
     */
    public static final String KURANSTALT_L1_CODE = "307";

    /**
     * EN: Code for Logopädin/Logopäde.<br>
     */
    public static final String LOGOP_DIN_LOGOP_DE_L1_CODE = "210";

    /**
     * EN: Code for Mobile Pflege.<br>
     */
    public static final String MOBILE_PFLEGE_L1_CODE = "306";

    /**
     * EN: Code for Musiktherapeutin/Musiktherapeut.<br>
     */
    public static final String MUSIKTHERAPEUTIN_MUSIKTHERAPEUT_L1_CODE = "203";

    /**
     * EN: Code for Orthoptistin/Orthoptist.<br>
     */
    public static final String ORTHOPTISTIN_ORTHOPTIST_L1_CODE = "211";

    /**
     * EN: Code for Orthopädische Produkte.<br>
     */
    public static final String ORTHOP_DISCHE_PRODUKTE_L1_CODE = "316";

    /**
     * EN: Code for Patientenvertretung.<br>
     */
    public static final String PATIENTENVERTRETUNG_L1_CODE = "405";

    /**
     * EN: Code for Pflegeanstalt.<br>
     */
    public static final String PFLEGEANSTALT_L1_CODE = "302";

    /**
     * EN: Code for Pflegeassistentin/Pflegeassistent.<br>
     */
    public static final String PFLEGEASSISTENTIN_PFLEGEASSISTENT_L1_CODE = "217";

    /**
     * EN: Code for Pflegeeinrichtung.<br>
     */
    public static final String PFLEGEEINRICHTUNG_L1_CODE = "305";

    /**
     * EN: Code for Pflegefachassistentin/Pflegefachassistent.<br>
     */
    public static final String PFLEGEFACHASSISTENTIN_PFLEGEFACHASSISTENT_L1_CODE = "218";

    /**
     * EN: Code for Physiotherapeutin/Physiotherapeut.<br>
     */
    public static final String PHYSIOTHERAPEUTIN_PHYSIOTHERAPEUT_L1_CODE = "205";

    /**
     * EN: Code for Psychotherapeutin/Psychotherapeut.<br>
     */
    public static final String PSYCHOTHERAPEUTIN_PSYCHOTHERAPEUT_L1_CODE = "200";

    /**
     * EN: Code for Radiologietechnologin/Radiologietechnologe.<br>
     */
    public static final String RADIOLOGIETECHNOLOGIN_RADIOLOGIETECHNOLOGE_L1_CODE = "207";

    /**
     * EN: Code for Rettungsdienst.<br>
     */
    public static final String RETTUNGSDIENST_L1_CODE = "318";

    /**
     * EN: Code for Sanatorium.<br>
     */
    public static final String SANATORIUM_L1_CODE = "303";

    /**
     * EN: Code for Selbstständiges Ambulatorium.<br>
     */
    public static final String SELBSTST_NDIGES_AMBULATORIUM_L1_CODE = "304";

    /**
     * EN: Code for Sonderkrankenanstalt.<br>
     */
    public static final String SONDERKRANKENANSTALT_L1_CODE = "301";

    /**
     * EN: Code for Sozialversicherung.<br>
     */
    public static final String SOZIALVERSICHERUNG_L1_CODE = "406";

    /**
     * EN: Code for Straf- und Maßnahmenvollzug.<br>
     */
    public static final String STRAF_UND_MASSNAHMENVOLLZUG_L1_CODE = "309";

    /**
     * EN: Code for Teil 1: Rollen für Personen.<br>
     */
    public static final String TEIL_1_ROLLEN_F_R_PERSONEN_CODE = "10";

    /**
     * EN: Code for Teil 2: Rollen für Organisationen.<br>
     */
    public static final String TEIL_2_ROLLEN_F_R_ORGANISATIONEN_CODE = "20";

    /**
     * EN: Code for Untersuchungsanstalt.<br>
     */
    public static final String UNTERSUCHUNGSANSTALT_L1_CODE = "310";

    /**
     * EN: Code for Verrechnungsservice.<br>
     */
    public static final String VERRECHNUNGSSERVICE_L1_CODE = "501";

    /**
     * EN: Code for Widerspruchstelle.<br>
     */
    public static final String WIDERSPRUCHSTELLE_L1_CODE = "404";

    /**
     * EN: Code for Zahntechnik.<br>
     */
    public static final String ZAHNTECHNIK_L1_CODE = "317";

    /**
     * EN: Code for Zahnärztin/Zahnarzt.<br>
     */
    public static final String ZAHN_RZTIN_ZAHNARZT_L1_CODE = "155";

    /**
     * EN: Code for Zahnärztliche Gruppenpraxis.<br>
     */
    public static final String ZAHN_RZTLICHE_GRUPPENPRAXIS_L1_CODE = "319";

    /**
     * EN: Code for Öffentlicher Gesundheitsdienst.<br>
     */
    public static final String _FFENTLICHER_GESUNDHEITSDIENST_L1_CODE = "401";

    /**
     * EN: Code for Öffentliche Apotheke.<br>
     */
    public static final String _FFENTLICHE_APOTHEKE_L1_CODE = "311";

    /**
     * EN: Code for Ärztin/Arzt für Allgemeinmedizin.<br>
     */
    public static final String _RZTIN_ARZT_F_R_ALLGEMEINMEDIZIN_L1_CODE = "100";

    /**
     * EN: Code for Ärztin/Arzt in Ausbildung.<br>
     */
    public static final String _RZTIN_ARZT_IN_AUSBILDUNG_L1_CODE = "157";

    /**
     * EN: Code for Ärztliche Gruppenpraxis.<br>
     */
    public static final String _RZTLICHE_GRUPPENPRAXIS_L1_CODE = "320";

    /**
     * Identifier of the value set.
     */
    public static final String VALUE_SET_ID = "1.2.40.0.34.10.6";

    /**
     * Name of the value set.
     */
    public static final String VALUE_SET_NAME = "ELGA_AuthorSpeciality";

    /**
     * Identifier of the code system (all values share the same).
     */
    public static final String CODE_SYSTEM_ID = "1.2.40.0.34.5.2";

    /**
     * Gets the Enum with a given code.
     *
     * @param code The code value.
     * @return the enum value found or {@code null}.
     */
    @Nullable
    public static ElgaAuthorSpeciality getEnum(@Nullable final String code) {
        for (final ElgaAuthorSpeciality x : values()) {
            if (x.getCodeValue().equals(code)) {
                return x;
            }
        }
        return null;
    }

    /**
     * Checks if a given enum is part of this value set.
     *
     * @param enumName The name of the enum.
     * @return {@code true} if the name is found in this value set, {@code false} otherwise.
     */
    public static boolean isEnumOfValueSet(@Nullable final String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(ElgaAuthorSpeciality.class,
                         enumName);
            return true;
        } catch (final IllegalArgumentException ex) {
            return false;
        }
    }

    /**
     * Checks if a given code value is in this value set.
     *
     * @param codeValue The code value.
     * @return {@code true} if the value is found in this value set, {@code false} otherwise.
     */
    public static boolean isInValueSet(@Nullable final String codeValue) {
        for (final ElgaAuthorSpeciality x : values()) {
            if (x.getCodeValue().equals(codeValue)) {
                return true;
            }
        }
        return false;
    }

    /**
     * Machine interpretable and (inside this class) unique code.
     */
    @NonNull
    private final String code;

    /**
     * Identifier of the referencing code system.
     */
    @NonNull
    private final String codeSystem;

    /**
     * The display names per language. It's always stored in the given order: default display name (0), in English (1),
     * in German (2), in French (3) and in Italian (4).
     */
    @NonNull
    private final String[] displayNames;

    /**
     * Instantiates this enum with a given code and display names.
     *
     * @param code          The code value.
     * @param codeSystem    The code system (OID).
     * @param displayName   The default display name.
     * @param displayNameEn The display name in English.
     * @param displayNameDe The display name in German.
     * @param displayNameFr The display name in French.
     * @param displayNameIt The display name in Italian.
     */
    ElgaAuthorSpeciality(@NonNull final String code, @NonNull final String codeSystem, @NonNull final String displayName, @NonNull final String displayNameEn, @NonNull final String displayNameDe, @NonNull final String displayNameFr, @NonNull final String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    /**
     * Gets the code system identifier.
     *
     * @return the code system identifier.
     */
    @Override
    @NonNull
    public String getCodeSystemId() {
        return this.codeSystem;
    }

    /**
     * Gets the code system name.
     *
     * @return the code system name.
     */
    @Override
    @NonNull
    public String getCodeSystemName() {
        final var codeSystem = CodeSystems.getEnum(this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    /**
     * Gets the code value as a string.
     *
     * @return the code value.
     */
    @Override
    @NonNull
    public String getCodeValue() {
        return this.code;
    }

    /**
     * Gets the display name defined by the language param.
     *
     * @param languageCode The language code to get the display name for, {@code null} to get the default display name.
     * @return the display name in the desired language.
     */
    @Override
    @NonNull
    public String getDisplayName(@Nullable final LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch(languageCode) {
            case ENGLISH ->
                this.displayNames[1];
            case GERMAN ->
                this.displayNames[2];
            case FRENCH ->
                this.displayNames[3];
            case ITALIAN ->
                this.displayNames[4];
            default ->
                "TOTRANSLATE";
        };
    }

    /**
     * Gets the value set identifier.
     *
     * @return the value set identifier.
     */
    @Override
    @NonNull
    public String getValueSetId() {
        return VALUE_SET_ID;
    }

    /**
     * Gets the value set name.
     *
     * @return the value set name.
     */
    @Override
    @NonNull
    public String getValueSetName() {
        return VALUE_SET_NAME;
    }
}
