/*
 * This code is made available under the terms of the Eclipse Public License v1.0
 * in the github project https://github.com/project-husky/husky there you also
 * find a list of the contributors and the license information.
 *
 * This project has been developed further and modified by the joined working group Husky
 * on the basis of the eHealth Connector opensource project from June 28, 2021,
 * whereas medshare GmbH is the initial and main contributor/author of the eHealth Connector.
 */
package org.projecthusky.cda.elga.generated.artdecor.ps.enums;

import java.util.Objects;
import javax.annotation.processing.Generated;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

/**
 * Enumeration of eImpf_ImmunizationTarget_VS values
 * <p>
 * EN: Vaccines against a specific disease or pathogen. Substances in this value set represent the individual vaccines (e.g. measles vaccines). Among the combinations are those vaccines that protect against several diseases (e.g. Measles-Mumps-Rubella).<br>
 * DE: No designation found.<br>
 * FR: No designation found.<br>
 * IT: No designation found.<br>
 * <p>
 * Identifier: 1.2.40.0.34.6.0.10.4<br>
 * Effective date: 2021-06-22 00:00<br>
 * Version: 202106(-beta)<br>
 * Status: DRAFT
 */
@Generated(value = "org.projecthusky.codegenerator.ch.valuesets.UpdateValueSets", date = "2022-03-01")
public enum EImpfImmunizationTargetVs implements ValueSetEnumInterface {

    /**
     * EN: Cholera Impfstoff.<br>
     */
    CHOLERA_IMPFSTOFF_L2("836383009",
                         "2.16.840.1.113883.6.96",
                         "Cholera Impfstoff",
                         "Cholera Impfstoff",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Denguefieber Impfstoff.<br>
     */
    DENGUEFIEBER_IMPFSTOFF_L2("840563003",
                              "2.16.840.1.113883.6.96",
                              "Denguefieber Impfstoff",
                              "Denguefieber Impfstoff",
                              "TOTRANSLATE",
                              "TOTRANSLATE",
                              "TOTRANSLATE"),
    /**
     * EN: Diphtheria-Tetanus-Pertussis-Hepatitis B Impfstoffkombination.<br>
     */
    DIPHTHERIA_TETANUS_PERTUSSIS_HEPATITIS_B_IMPFSTOFFKOMBINATION_L1("871917002",
                                                                     "2.16.840.1.113883.6.96",
                                                                     "Diphtheria-Tetanus-Pertussis-Hepatitis B Impfstoffkombination",
                                                                     "Diphtheria-Tetanus-Pertussis-Hepatitis B Impfstoffkombination",
                                                                     "TOTRANSLATE",
                                                                     "TOTRANSLATE",
                                                                     "TOTRANSLATE"),
    /**
     * EN: Diphtherie-Haemophilus-influenzae B-Pertussis-Poliomyelitis-Tetanus-Hepatitis B Impfstoffkombination.<br>
     */
    DIPHTHERIE_HAEMOPHILUS_INFLUENZAE_B_PERTUSSIS_POLIOMYELITIS_TETANUS_HEPATITIS_B_IMPFSTOFFKOMBINATION_L1("871896006",
                                                                                                            "2.16.840.1.113883.6.96",
                                                                                                            "Diphtherie-Haemophilus-influenzae B-Pertussis-Poliomyelitis-Tetanus-Hepatitis B Impfstoffkombination",
                                                                                                            "Diphtherie-Haemophilus-influenzae B-Pertussis-Poliomyelitis-Tetanus-Hepatitis B Impfstoffkombination",
                                                                                                            "TOTRANSLATE",
                                                                                                            "TOTRANSLATE",
                                                                                                            "TOTRANSLATE"),
    /**
     * EN: Diphtherie Impfstoff.<br>
     */
    DIPHTHERIE_IMPFSTOFF_L2("836381006",
                            "2.16.840.1.113883.6.96",
                            "Diphtherie Impfstoff",
                            "Diphtherie Impfstoff",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: Diphtherie-Pertussis-Hepatitis B-Polio Impfstoffkombination.<br>
     */
    DIPHTHERIE_PERTUSSIS_HEPATITIS_B_POLIO_IMPFSTOFFKOMBINATION_L1("871889009",
                                                                   "2.16.840.1.113883.6.96",
                                                                   "Diphtherie-Pertussis-Hepatitis B-Polio Impfstoffkombination",
                                                                   "Diphtherie-Pertussis-Hepatitis B-Polio Impfstoffkombination",
                                                                   "TOTRANSLATE",
                                                                   "TOTRANSLATE",
                                                                   "TOTRANSLATE"),
    /**
     * EN: Diphtherie-Pertussis-Poliomyelitis-Tetanus Impfstoffkombination.<br>
     */
    DIPHTHERIE_PERTUSSIS_POLIOMYELITIS_TETANUS_IMPFSTOFFKOMBINATION_L1("836508001",
                                                                       "2.16.840.1.113883.6.96",
                                                                       "Diphtherie-Pertussis-Poliomyelitis-Tetanus Impfstoffkombination",
                                                                       "Diphtherie-Pertussis-Poliomyelitis-Tetanus Impfstoffkombination",
                                                                       "TOTRANSLATE",
                                                                       "TOTRANSLATE",
                                                                       "TOTRANSLATE"),
    /**
     * EN: Diphtherie-Pertussis-Tetanus-Haemophilus-influenzae B Impfstoffkombination.<br>
     */
    DIPHTHERIE_PERTUSSIS_TETANUS_HAEMOPHILUS_INFLUENZAE_B_IMPFSTOFFKOMBINATION_L1("836507006",
                                                                                  "2.16.840.1.113883.6.96",
                                                                                  "Diphtherie-Pertussis-Tetanus-Haemophilus-influenzae B Impfstoffkombination",
                                                                                  "Diphtherie-Pertussis-Tetanus-Haemophilus-influenzae B Impfstoffkombination",
                                                                                  "TOTRANSLATE",
                                                                                  "TOTRANSLATE",
                                                                                  "TOTRANSLATE"),
    /**
     * EN: Diphtherie-Pertussis-Tetanus Impfstoffkombination.<br>
     */
    DIPHTHERIE_PERTUSSIS_TETANUS_IMPFSTOFFKOMBINATION_L1("836503005",
                                                         "2.16.840.1.113883.6.96",
                                                         "Diphtherie-Pertussis-Tetanus Impfstoffkombination",
                                                         "Diphtherie-Pertussis-Tetanus Impfstoffkombination",
                                                         "TOTRANSLATE",
                                                         "TOTRANSLATE",
                                                         "TOTRANSLATE"),
    /**
     * EN: Diphtherie-Pertussis-Tetanus-Poliomyelitis-Haemophilus-influenzae B Impfstoffkombination.<br>
     */
    DIPHTHERIE_PERTUSSIS_TETANUS_POLIOMYELITIS_HAEMOPHILUS_INFLUENZAE_B_IMPFSTOFFKOMBINATION_L1("838279002",
                                                                                                "2.16.840.1.113883.6.96",
                                                                                                "Diphtherie-Pertussis-Tetanus-Poliomyelitis-Haemophilus-influenzae B Impfstoffkombination",
                                                                                                "Diphtherie-Pertussis-Tetanus-Poliomyelitis-Haemophilus-influenzae B Impfstoffkombination",
                                                                                                "TOTRANSLATE",
                                                                                                "TOTRANSLATE",
                                                                                                "TOTRANSLATE"),
    /**
     * EN: Diphtherie-Pertussis-Tetanus-Poliomyelitis-Hepatitis B Impfstoffkombination.<br>
     */
    DIPHTHERIE_PERTUSSIS_TETANUS_POLIOMYELITIS_HEPATITIS_B_IMPFSTOFFKOMBINATION_L1("871892008",
                                                                                   "2.16.840.1.113883.6.96",
                                                                                   "Diphtherie-Pertussis-Tetanus-Poliomyelitis-Hepatitis B Impfstoffkombination",
                                                                                   "Diphtherie-Pertussis-Tetanus-Poliomyelitis-Hepatitis B Impfstoffkombination",
                                                                                   "TOTRANSLATE",
                                                                                   "TOTRANSLATE",
                                                                                   "TOTRANSLATE"),
    /**
     * EN: Diphtherie-Pertussis-Tetanus-Polio-Masern Impfstoffkombination.<br>
     */
    DIPHTHERIE_PERTUSSIS_TETANUS_POLIO_MASERN_IMPFSTOFFKOMBINATION_L1("871928003",
                                                                      "2.16.840.1.113883.6.96",
                                                                      "Diphtherie-Pertussis-Tetanus-Polio-Masern Impfstoffkombination",
                                                                      "Diphtherie-Pertussis-Tetanus-Polio-Masern Impfstoffkombination",
                                                                      "TOTRANSLATE",
                                                                      "TOTRANSLATE",
                                                                      "TOTRANSLATE"),
    /**
     * EN: Diphtherie-Poliomyelitis-Tetanus Impfstoffkombination.<br>
     */
    DIPHTHERIE_POLIOMYELITIS_TETANUS_IMPFSTOFFKOMBINATION_L1("836505003",
                                                             "2.16.840.1.113883.6.96",
                                                             "Diphtherie-Poliomyelitis-Tetanus Impfstoffkombination",
                                                             "Diphtherie-Poliomyelitis-Tetanus Impfstoffkombination",
                                                             "TOTRANSLATE",
                                                             "TOTRANSLATE",
                                                             "TOTRANSLATE"),
    /**
     * EN: Diphtherie-Tetanus-Hepatitis B Impfstoffkombination.<br>
     */
    DIPHTHERIE_TETANUS_HEPATITIS_B_IMPFSTOFFKOMBINATION_L1("871929006",
                                                           "2.16.840.1.113883.6.96",
                                                           "Diphtherie-Tetanus-Hepatitis B Impfstoffkombination",
                                                           "Diphtherie-Tetanus-Hepatitis B Impfstoffkombination",
                                                           "TOTRANSLATE",
                                                           "TOTRANSLATE",
                                                           "TOTRANSLATE"),
    /**
     * EN: Diphtherie-Tetanus Impfstoffkombination.<br>
     */
    DIPHTHERIE_TETANUS_IMPFSTOFFKOMBINATION_L1("836502000",
                                               "2.16.840.1.113883.6.96",
                                               "Diphtherie-Tetanus Impfstoffkombination",
                                               "Diphtherie-Tetanus Impfstoffkombination",
                                               "TOTRANSLATE",
                                               "TOTRANSLATE",
                                               "TOTRANSLATE"),
    /**
     * EN: Ebola Impfstoff.<br>
     */
    EBOLA_IMPFSTOFF_L2("836421005",
                       "2.16.840.1.113883.6.96",
                       "Ebola Impfstoff",
                       "Ebola Impfstoff",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Empfohlene Impfungen.<br>
     */
    EMPFOHLENE_IMPFUNGEN_L1("_Empfohlene",
                            "1.2.40.0.34.5.183",
                            "Empfohlene Impfungen",
                            "Empfohlene Impfungen",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: Frühsommer-Meningoencephalitis Impfstoff.<br>
     */
    FR_HSOMMER_MENINGOENCEPHALITIS_IMPFSTOFF_L2("836403007",
                                                "2.16.840.1.113883.6.96",
                                                "Frühsommer-Meningoencephalitis Impfstoff",
                                                "Frühsommer-Meningoencephalitis Impfstoff",
                                                "TOTRANSLATE",
                                                "TOTRANSLATE",
                                                "TOTRANSLATE"),
    /**
     * EN: Gelbfieber Impfstoff.<br>
     */
    GELBFIEBER_IMPFSTOFF_L2("836385002",
                            "2.16.840.1.113883.6.96",
                            "Gelbfieber Impfstoff",
                            "Gelbfieber Impfstoff",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: Haemophilus influenzae Type B-Tetanus Impfstoffkombination.<br>
     */
    HAEMOPHILUS_INFLUENZAE_TYPE_B_TETANUS_IMPFSTOFFKOMBINATION_L1("836504004",
                                                                  "2.16.840.1.113883.6.96",
                                                                  "Haemophilus influenzae Type B-Tetanus Impfstoffkombination",
                                                                  "Haemophilus influenzae Type B-Tetanus Impfstoffkombination",
                                                                  "TOTRANSLATE",
                                                                  "TOTRANSLATE",
                                                                  "TOTRANSLATE"),
    /**
     * EN: Haemophilus influenzae Typ B Impfstoff.<br>
     */
    HAEMOPHILUS_INFLUENZAE_TYP_B_IMPFSTOFF_L2("836380007",
                                              "2.16.840.1.113883.6.96",
                                              "Haemophilus influenzae Typ B Impfstoff",
                                              "Haemophilus influenzae Typ B Impfstoff",
                                              "TOTRANSLATE",
                                              "TOTRANSLATE",
                                              "TOTRANSLATE"),
    /**
     * EN: Hepatitis A-Hepatitis B Impfstoffkombination.<br>
     */
    HEPATITIS_A_HEPATITIS_B_IMPFSTOFFKOMBINATION_L1("836493003",
                                                    "2.16.840.1.113883.6.96",
                                                    "Hepatitis A-Hepatitis B Impfstoffkombination",
                                                    "Hepatitis A-Hepatitis B Impfstoffkombination",
                                                    "TOTRANSLATE",
                                                    "TOTRANSLATE",
                                                    "TOTRANSLATE"),
    /**
     * EN: Hepatitis A Impfstoff.<br>
     */
    HEPATITIS_A_IMPFSTOFF_L2("836375003",
                             "2.16.840.1.113883.6.96",
                             "Hepatitis A Impfstoff",
                             "Hepatitis A Impfstoff",
                             "TOTRANSLATE",
                             "TOTRANSLATE",
                             "TOTRANSLATE"),
    /**
     * EN: Hepatitis B-Haemophilus-influenzae B Impfstoffkombination.<br>
     */
    HEPATITIS_B_HAEMOPHILUS_INFLUENZAE_B_IMPFSTOFFKOMBINATION_L1("865946000",
                                                                 "2.16.840.1.113883.6.96",
                                                                 "Hepatitis B-Haemophilus-influenzae B Impfstoffkombination",
                                                                 "Hepatitis B-Haemophilus-influenzae B Impfstoffkombination",
                                                                 "TOTRANSLATE",
                                                                 "TOTRANSLATE",
                                                                 "TOTRANSLATE"),
    /**
     * EN: Hepatitis B Impfstoff.<br>
     */
    HEPATITIS_B_IMPFSTOFF_L2("836374004",
                             "2.16.840.1.113883.6.96",
                             "Hepatitis B Impfstoff",
                             "Hepatitis B Impfstoff",
                             "TOTRANSLATE",
                             "TOTRANSLATE",
                             "TOTRANSLATE"),
    /**
     * EN: Herpes Zoster Impfstoff.<br>
     */
    HERPES_ZOSTER_IMPFSTOFF_L2("871919004",
                               "2.16.840.1.113883.6.96",
                               "Herpes Zoster Impfstoff",
                               "Herpes Zoster Impfstoff",
                               "TOTRANSLATE",
                               "TOTRANSLATE",
                               "TOTRANSLATE"),
    /**
     * EN: Humane Papillomaviren Impfstoff.<br>
     */
    HUMANE_PAPILLOMAVIREN_IMPFSTOFF_L2("836379009",
                                       "2.16.840.1.113883.6.96",
                                       "Humane Papillomaviren Impfstoff",
                                       "Humane Papillomaviren Impfstoff",
                                       "TOTRANSLATE",
                                       "TOTRANSLATE",
                                       "TOTRANSLATE"),
    /**
     * EN: Impfungen.<br>
     */
    IMPFUNGEN("_Einzel",
              "1.2.40.0.34.5.183",
              "Impfungen",
              "Impfungen",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Influenza (H1N1) Impfstoff.<br>
     */
    INFLUENZA_H1N1_IMPFSTOFF_L2("871772009",
                                "2.16.840.1.113883.6.96",
                                "Influenza (H1N1) Impfstoff",
                                "Influenza (H1N1) Impfstoff",
                                "TOTRANSLATE",
                                "TOTRANSLATE",
                                "TOTRANSLATE"),
    /**
     * EN: Influenza (H5N1) Impfstoff.<br>
     */
    INFLUENZA_H5N1_IMPFSTOFF_L2("427036009",
                                "2.16.840.1.113883.6.96",
                                "Influenza (H5N1) Impfstoff",
                                "Influenza (H5N1) Impfstoff",
                                "TOTRANSLATE",
                                "TOTRANSLATE",
                                "TOTRANSLATE"),
    /**
     * EN: Influenza Impfstoff.<br>
     */
    INFLUENZA_IMPFSTOFF_L2("836377006",
                           "2.16.840.1.113883.6.96",
                           "Influenza Impfstoff",
                           "Influenza Impfstoff",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: Japanische Encephalitis Impfstoff.<br>
     */
    JAPANISCHE_ENCEPHALITIS_IMPFSTOFF_L2("836378001",
                                         "2.16.840.1.113883.6.96",
                                         "Japanische Encephalitis Impfstoff",
                                         "Japanische Encephalitis Impfstoff",
                                         "TOTRANSLATE",
                                         "TOTRANSLATE",
                                         "TOTRANSLATE"),
    /**
     * EN: Kombinationsimpfungen.<br>
     */
    KOMBINATIONSIMPFUNGEN("_Kombinationen",
                          "1.2.40.0.34.5.183",
                          "Kombinationsimpfungen",
                          "Kombinationsimpfungen",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: Leptospirose Impfstoff.<br>
     */
    LEPTOSPIROSE_IMPFSTOFF_L2("840564009",
                              "2.16.840.1.113883.6.96",
                              "Leptospirose Impfstoff",
                              "Leptospirose Impfstoff",
                              "TOTRANSLATE",
                              "TOTRANSLATE",
                              "TOTRANSLATE"),
    /**
     * EN: Masern Impfstoff.<br>
     */
    MASERN_IMPFSTOFF_L2("836382004",
                        "2.16.840.1.113883.6.96",
                        "Masern Impfstoff",
                        "Masern Impfstoff",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Masern-Mumps Impfstoffkombination.<br>
     */
    MASERN_MUMPS_IMPFSTOFFKOMBINATION_L1("836499004",
                                         "2.16.840.1.113883.6.96",
                                         "Masern-Mumps Impfstoffkombination",
                                         "Masern-Mumps Impfstoffkombination",
                                         "TOTRANSLATE",
                                         "TOTRANSLATE",
                                         "TOTRANSLATE"),
    /**
     * EN: Masern-Mumps-Röteln Impfstoffkombination.<br>
     */
    MASERN_MUMPS_R_TELN_IMPFSTOFFKOMBINATION_L1("836494009",
                                                "2.16.840.1.113883.6.96",
                                                "Masern-Mumps-Röteln Impfstoffkombination",
                                                "Masern-Mumps-Röteln Impfstoffkombination",
                                                "TOTRANSLATE",
                                                "TOTRANSLATE",
                                                "TOTRANSLATE"),
    /**
     * EN: Masern-Mumps-Röteln-Varizellen Impfstoffkombination.<br>
     */
    MASERN_MUMPS_R_TELN_VARIZELLEN_IMPFSTOFFKOMBINATION_L1("838280004",
                                                           "2.16.840.1.113883.6.96",
                                                           "Masern-Mumps-Röteln-Varizellen Impfstoffkombination",
                                                           "Masern-Mumps-Röteln-Varizellen Impfstoffkombination",
                                                           "TOTRANSLATE",
                                                           "TOTRANSLATE",
                                                           "TOTRANSLATE"),
    /**
     * EN: Meningokokken Impfstoff.<br>
     */
    MENINGOKOKKEN_IMPFSTOFF_L2("836401009",
                               "2.16.840.1.113883.6.96",
                               "Meningokokken Impfstoff",
                               "Meningokokken Impfstoff",
                               "TOTRANSLATE",
                               "TOTRANSLATE",
                               "TOTRANSLATE"),
    /**
     * EN: Meningokokken Serotyp A+C Impfstoff.<br>
     */
    MENINGOKOKKEN_SEROTYP_A_C_IMPFSTOFF_L2("871871008",
                                           "2.16.840.1.113883.6.96",
                                           "Meningokokken Serotyp A+C Impfstoff",
                                           "Meningokokken Serotyp A+C Impfstoff",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE"),
    /**
     * EN: Meningokokken Serotyp A+C+W135+Y Impfstoff.<br>
     */
    MENINGOKOKKEN_SEROTYP_A_C_W135_Y_IMPFSTOFF_L2("871873006",
                                                  "2.16.840.1.113883.6.96",
                                                  "Meningokokken Serotyp A+C+W135+Y Impfstoff",
                                                  "Meningokokken Serotyp A+C+W135+Y Impfstoff",
                                                  "TOTRANSLATE",
                                                  "TOTRANSLATE",
                                                  "TOTRANSLATE"),
    /**
     * EN: Meningokokken Serotyp B Impfstoff.<br>
     */
    MENINGOKOKKEN_SEROTYP_B_IMPFSTOFF_L2("1981000221108",
                                         "2.16.840.1.113883.6.96",
                                         "Meningokokken Serotyp B Impfstoff",
                                         "Meningokokken Serotyp B Impfstoff",
                                         "TOTRANSLATE",
                                         "TOTRANSLATE",
                                         "TOTRANSLATE"),
    /**
     * EN: Meningokokken Serotyp C Impfstoff.<br>
     */
    MENINGOKOKKEN_SEROTYP_C_IMPFSTOFF_L2("871866001",
                                         "2.16.840.1.113883.6.96",
                                         "Meningokokken Serotyp C Impfstoff",
                                         "Meningokokken Serotyp C Impfstoff",
                                         "TOTRANSLATE",
                                         "TOTRANSLATE",
                                         "TOTRANSLATE"),
    /**
     * EN: Mumps Impfstoff.<br>
     */
    MUMPS_IMPFSTOFF_L2("871738001",
                       "2.16.840.1.113883.6.96",
                       "Mumps Impfstoff",
                       "Mumps Impfstoff",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Pertussis Impfstoff.<br>
     */
    PERTUSSIS_IMPFSTOFF_L2("601000221108",
                           "2.16.840.1.113883.6.96",
                           "Pertussis Impfstoff",
                           "Pertussis Impfstoff",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: Pneumokokken Impfstoff.<br>
     */
    PNEUMOKOKKEN_IMPFSTOFF_L2("836398006",
                              "2.16.840.1.113883.6.96",
                              "Pneumokokken Impfstoff",
                              "Pneumokokken Impfstoff",
                              "TOTRANSLATE",
                              "TOTRANSLATE",
                              "TOTRANSLATE"),
    /**
     * EN: Pocken Impfstoff.<br>
     */
    POCKEN_IMPFSTOFF_L2("836389008",
                        "2.16.840.1.113883.6.96",
                        "Pocken Impfstoff",
                        "Pocken Impfstoff",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Poliomyelitis Impfstoff.<br>
     */
    POLIOMYELITIS_IMPFSTOFF_L2("1031000221108",
                               "2.16.840.1.113883.6.96",
                               "Poliomyelitis Impfstoff",
                               "Poliomyelitis Impfstoff",
                               "TOTRANSLATE",
                               "TOTRANSLATE",
                               "TOTRANSLATE"),
    /**
     * EN: Reiseimpfungen.<br>
     */
    REISEIMPFUNGEN_L1("_Reise",
                      "1.2.40.0.34.5.183",
                      "Reiseimpfungen",
                      "Reiseimpfungen",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Rotavirus Impfstoff.<br>
     */
    ROTAVIRUS_IMPFSTOFF_L2("836387005",
                           "2.16.840.1.113883.6.96",
                           "Rotavirus Impfstoff",
                           "Rotavirus Impfstoff",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: Röteln Impfstoff.<br>
     */
    R_TELN_IMPFSTOFF_L2("836388000",
                        "2.16.840.1.113883.6.96",
                        "Röteln Impfstoff",
                        "Röteln Impfstoff",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: SARS-CoV-2 Impfstoff.<br>
     */
    SARS_COV_2_IMPFSTOFF_L2("840534001",
                            "2.16.840.1.113883.6.96",
                            "SARS-CoV-2 Impfstoff",
                            "SARS-CoV-2 Impfstoff",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: Tetanus Impfstoff.<br>
     */
    TETANUS_IMPFSTOFF_L2("1101000221104",
                         "2.16.840.1.113883.6.96",
                         "Tetanus Impfstoff",
                         "Tetanus Impfstoff",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Tollwut Impfstoff.<br>
     */
    TOLLWUT_IMPFSTOFF_L2("836393002",
                         "2.16.840.1.113883.6.96",
                         "Tollwut Impfstoff",
                         "Tollwut Impfstoff",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Tuberkulose Impfstoff.<br>
     */
    TUBERKULOSE_IMPFSTOFF_L2("836402002",
                             "2.16.840.1.113883.6.96",
                             "Tuberkulose Impfstoff",
                             "Tuberkulose Impfstoff",
                             "TOTRANSLATE",
                             "TOTRANSLATE",
                             "TOTRANSLATE"),
    /**
     * EN: Typhus-Hepatitis A Impfstoffkombination.<br>
     */
    TYPHUS_HEPATITIS_A_IMPFSTOFFKOMBINATION_L1("836501007",
                                               "2.16.840.1.113883.6.96",
                                               "Typhus-Hepatitis A Impfstoffkombination",
                                               "Typhus-Hepatitis A Impfstoffkombination",
                                               "TOTRANSLATE",
                                               "TOTRANSLATE",
                                               "TOTRANSLATE"),
    /**
     * EN: Typhus Impfstoff.<br>
     */
    TYPHUS_IMPFSTOFF_L2("836390004",
                        "2.16.840.1.113883.6.96",
                        "Typhus Impfstoff",
                        "Typhus Impfstoff",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Varizellen Impfstoff.<br>
     */
    VARIZELLEN_IMPFSTOFF_L2("836495005",
                            "2.16.840.1.113883.6.96",
                            "Varizellen Impfstoff",
                            "Varizellen Impfstoff",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: Weitere Impfungen.<br>
     */
    WEITERE_IMPFUNGEN_L1("_Weitere",
                         "1.2.40.0.34.5.183",
                         "Weitere Impfungen",
                         "Weitere Impfungen",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE");

    /**
     * EN: Code for Cholera Impfstoff.<br>
     */
    public static final String CHOLERA_IMPFSTOFF_L2_CODE = "836383009";

    /**
     * EN: Code for Denguefieber Impfstoff.<br>
     */
    public static final String DENGUEFIEBER_IMPFSTOFF_L2_CODE = "840563003";

    /**
     * EN: Code for Diphtheria-Tetanus-Pertussis-Hepatitis B Impfstoffkombination.<br>
     */
    public static final String DIPHTHERIA_TETANUS_PERTUSSIS_HEPATITIS_B_IMPFSTOFFKOMBINATION_L1_CODE = "871917002";

    /**
     * EN: Code for Diphtherie-Haemophilus-influenzae B-Pertussis-Poliomyelitis-Tetanus-Hepatitis B Impfstoffkombination.<br>
     */
    public static final String DIPHTHERIE_HAEMOPHILUS_INFLUENZAE_B_PERTUSSIS_POLIOMYELITIS_TETANUS_HEPATITIS_B_IMPFSTOFFKOMBINATION_L1_CODE = "871896006";

    /**
     * EN: Code for Diphtherie Impfstoff.<br>
     */
    public static final String DIPHTHERIE_IMPFSTOFF_L2_CODE = "836381006";

    /**
     * EN: Code for Diphtherie-Pertussis-Hepatitis B-Polio Impfstoffkombination.<br>
     */
    public static final String DIPHTHERIE_PERTUSSIS_HEPATITIS_B_POLIO_IMPFSTOFFKOMBINATION_L1_CODE = "871889009";

    /**
     * EN: Code for Diphtherie-Pertussis-Poliomyelitis-Tetanus Impfstoffkombination.<br>
     */
    public static final String DIPHTHERIE_PERTUSSIS_POLIOMYELITIS_TETANUS_IMPFSTOFFKOMBINATION_L1_CODE = "836508001";

    /**
     * EN: Code for Diphtherie-Pertussis-Tetanus-Haemophilus-influenzae B Impfstoffkombination.<br>
     */
    public static final String DIPHTHERIE_PERTUSSIS_TETANUS_HAEMOPHILUS_INFLUENZAE_B_IMPFSTOFFKOMBINATION_L1_CODE = "836507006";

    /**
     * EN: Code for Diphtherie-Pertussis-Tetanus Impfstoffkombination.<br>
     */
    public static final String DIPHTHERIE_PERTUSSIS_TETANUS_IMPFSTOFFKOMBINATION_L1_CODE = "836503005";

    /**
     * EN: Code for Diphtherie-Pertussis-Tetanus-Poliomyelitis-Haemophilus-influenzae B Impfstoffkombination.<br>
     */
    public static final String DIPHTHERIE_PERTUSSIS_TETANUS_POLIOMYELITIS_HAEMOPHILUS_INFLUENZAE_B_IMPFSTOFFKOMBINATION_L1_CODE = "838279002";

    /**
     * EN: Code for Diphtherie-Pertussis-Tetanus-Poliomyelitis-Hepatitis B Impfstoffkombination.<br>
     */
    public static final String DIPHTHERIE_PERTUSSIS_TETANUS_POLIOMYELITIS_HEPATITIS_B_IMPFSTOFFKOMBINATION_L1_CODE = "871892008";

    /**
     * EN: Code for Diphtherie-Pertussis-Tetanus-Polio-Masern Impfstoffkombination.<br>
     */
    public static final String DIPHTHERIE_PERTUSSIS_TETANUS_POLIO_MASERN_IMPFSTOFFKOMBINATION_L1_CODE = "871928003";

    /**
     * EN: Code for Diphtherie-Poliomyelitis-Tetanus Impfstoffkombination.<br>
     */
    public static final String DIPHTHERIE_POLIOMYELITIS_TETANUS_IMPFSTOFFKOMBINATION_L1_CODE = "836505003";

    /**
     * EN: Code for Diphtherie-Tetanus-Hepatitis B Impfstoffkombination.<br>
     */
    public static final String DIPHTHERIE_TETANUS_HEPATITIS_B_IMPFSTOFFKOMBINATION_L1_CODE = "871929006";

    /**
     * EN: Code for Diphtherie-Tetanus Impfstoffkombination.<br>
     */
    public static final String DIPHTHERIE_TETANUS_IMPFSTOFFKOMBINATION_L1_CODE = "836502000";

    /**
     * EN: Code for Ebola Impfstoff.<br>
     */
    public static final String EBOLA_IMPFSTOFF_L2_CODE = "836421005";

    /**
     * EN: Code for Empfohlene Impfungen.<br>
     */
    public static final String EMPFOHLENE_IMPFUNGEN_L1_CODE = "_Empfohlene";

    /**
     * EN: Code for Frühsommer-Meningoencephalitis Impfstoff.<br>
     */
    public static final String FR_HSOMMER_MENINGOENCEPHALITIS_IMPFSTOFF_L2_CODE = "836403007";

    /**
     * EN: Code for Gelbfieber Impfstoff.<br>
     */
    public static final String GELBFIEBER_IMPFSTOFF_L2_CODE = "836385002";

    /**
     * EN: Code for Haemophilus influenzae Type B-Tetanus Impfstoffkombination.<br>
     */
    public static final String HAEMOPHILUS_INFLUENZAE_TYPE_B_TETANUS_IMPFSTOFFKOMBINATION_L1_CODE = "836504004";

    /**
     * EN: Code for Haemophilus influenzae Typ B Impfstoff.<br>
     */
    public static final String HAEMOPHILUS_INFLUENZAE_TYP_B_IMPFSTOFF_L2_CODE = "836380007";

    /**
     * EN: Code for Hepatitis A-Hepatitis B Impfstoffkombination.<br>
     */
    public static final String HEPATITIS_A_HEPATITIS_B_IMPFSTOFFKOMBINATION_L1_CODE = "836493003";

    /**
     * EN: Code for Hepatitis A Impfstoff.<br>
     */
    public static final String HEPATITIS_A_IMPFSTOFF_L2_CODE = "836375003";

    /**
     * EN: Code for Hepatitis B-Haemophilus-influenzae B Impfstoffkombination.<br>
     */
    public static final String HEPATITIS_B_HAEMOPHILUS_INFLUENZAE_B_IMPFSTOFFKOMBINATION_L1_CODE = "865946000";

    /**
     * EN: Code for Hepatitis B Impfstoff.<br>
     */
    public static final String HEPATITIS_B_IMPFSTOFF_L2_CODE = "836374004";

    /**
     * EN: Code for Herpes Zoster Impfstoff.<br>
     */
    public static final String HERPES_ZOSTER_IMPFSTOFF_L2_CODE = "871919004";

    /**
     * EN: Code for Humane Papillomaviren Impfstoff.<br>
     */
    public static final String HUMANE_PAPILLOMAVIREN_IMPFSTOFF_L2_CODE = "836379009";

    /**
     * EN: Code for Impfungen.<br>
     */
    public static final String IMPFUNGEN_CODE = "_Einzel";

    /**
     * EN: Code for Influenza (H1N1) Impfstoff.<br>
     */
    public static final String INFLUENZA_H1N1_IMPFSTOFF_L2_CODE = "871772009";

    /**
     * EN: Code for Influenza (H5N1) Impfstoff.<br>
     */
    public static final String INFLUENZA_H5N1_IMPFSTOFF_L2_CODE = "427036009";

    /**
     * EN: Code for Influenza Impfstoff.<br>
     */
    public static final String INFLUENZA_IMPFSTOFF_L2_CODE = "836377006";

    /**
     * EN: Code for Japanische Encephalitis Impfstoff.<br>
     */
    public static final String JAPANISCHE_ENCEPHALITIS_IMPFSTOFF_L2_CODE = "836378001";

    /**
     * EN: Code for Kombinationsimpfungen.<br>
     */
    public static final String KOMBINATIONSIMPFUNGEN_CODE = "_Kombinationen";

    /**
     * EN: Code for Leptospirose Impfstoff.<br>
     */
    public static final String LEPTOSPIROSE_IMPFSTOFF_L2_CODE = "840564009";

    /**
     * EN: Code for Masern Impfstoff.<br>
     */
    public static final String MASERN_IMPFSTOFF_L2_CODE = "836382004";

    /**
     * EN: Code for Masern-Mumps Impfstoffkombination.<br>
     */
    public static final String MASERN_MUMPS_IMPFSTOFFKOMBINATION_L1_CODE = "836499004";

    /**
     * EN: Code for Masern-Mumps-Röteln Impfstoffkombination.<br>
     */
    public static final String MASERN_MUMPS_R_TELN_IMPFSTOFFKOMBINATION_L1_CODE = "836494009";

    /**
     * EN: Code for Masern-Mumps-Röteln-Varizellen Impfstoffkombination.<br>
     */
    public static final String MASERN_MUMPS_R_TELN_VARIZELLEN_IMPFSTOFFKOMBINATION_L1_CODE = "838280004";

    /**
     * EN: Code for Meningokokken Impfstoff.<br>
     */
    public static final String MENINGOKOKKEN_IMPFSTOFF_L2_CODE = "836401009";

    /**
     * EN: Code for Meningokokken Serotyp A+C Impfstoff.<br>
     */
    public static final String MENINGOKOKKEN_SEROTYP_A_C_IMPFSTOFF_L2_CODE = "871871008";

    /**
     * EN: Code for Meningokokken Serotyp A+C+W135+Y Impfstoff.<br>
     */
    public static final String MENINGOKOKKEN_SEROTYP_A_C_W135_Y_IMPFSTOFF_L2_CODE = "871873006";

    /**
     * EN: Code for Meningokokken Serotyp B Impfstoff.<br>
     */
    public static final String MENINGOKOKKEN_SEROTYP_B_IMPFSTOFF_L2_CODE = "1981000221108";

    /**
     * EN: Code for Meningokokken Serotyp C Impfstoff.<br>
     */
    public static final String MENINGOKOKKEN_SEROTYP_C_IMPFSTOFF_L2_CODE = "871866001";

    /**
     * EN: Code for Mumps Impfstoff.<br>
     */
    public static final String MUMPS_IMPFSTOFF_L2_CODE = "871738001";

    /**
     * EN: Code for Pertussis Impfstoff.<br>
     */
    public static final String PERTUSSIS_IMPFSTOFF_L2_CODE = "601000221108";

    /**
     * EN: Code for Pneumokokken Impfstoff.<br>
     */
    public static final String PNEUMOKOKKEN_IMPFSTOFF_L2_CODE = "836398006";

    /**
     * EN: Code for Pocken Impfstoff.<br>
     */
    public static final String POCKEN_IMPFSTOFF_L2_CODE = "836389008";

    /**
     * EN: Code for Poliomyelitis Impfstoff.<br>
     */
    public static final String POLIOMYELITIS_IMPFSTOFF_L2_CODE = "1031000221108";

    /**
     * EN: Code for Reiseimpfungen.<br>
     */
    public static final String REISEIMPFUNGEN_L1_CODE = "_Reise";

    /**
     * EN: Code for Rotavirus Impfstoff.<br>
     */
    public static final String ROTAVIRUS_IMPFSTOFF_L2_CODE = "836387005";

    /**
     * EN: Code for Röteln Impfstoff.<br>
     */
    public static final String R_TELN_IMPFSTOFF_L2_CODE = "836388000";

    /**
     * EN: Code for SARS-CoV-2 Impfstoff.<br>
     */
    public static final String SARS_COV_2_IMPFSTOFF_L2_CODE = "840534001";

    /**
     * EN: Code for Tetanus Impfstoff.<br>
     */
    public static final String TETANUS_IMPFSTOFF_L2_CODE = "1101000221104";

    /**
     * EN: Code for Tollwut Impfstoff.<br>
     */
    public static final String TOLLWUT_IMPFSTOFF_L2_CODE = "836393002";

    /**
     * EN: Code for Tuberkulose Impfstoff.<br>
     */
    public static final String TUBERKULOSE_IMPFSTOFF_L2_CODE = "836402002";

    /**
     * EN: Code for Typhus-Hepatitis A Impfstoffkombination.<br>
     */
    public static final String TYPHUS_HEPATITIS_A_IMPFSTOFFKOMBINATION_L1_CODE = "836501007";

    /**
     * EN: Code for Typhus Impfstoff.<br>
     */
    public static final String TYPHUS_IMPFSTOFF_L2_CODE = "836390004";

    /**
     * EN: Code for Varizellen Impfstoff.<br>
     */
    public static final String VARIZELLEN_IMPFSTOFF_L2_CODE = "836495005";

    /**
     * EN: Code for Weitere Impfungen.<br>
     */
    public static final String WEITERE_IMPFUNGEN_L1_CODE = "_Weitere";

    /**
     * Identifier of the value set.
     */
    public static final String VALUE_SET_ID = "1.2.40.0.34.6.0.10.4";

    /**
     * Name of the value set.
     */
    public static final String VALUE_SET_NAME = "eImpf_ImmunizationTarget_VS";

    /**
     * Identifier of the code system (all values share the same).
     */
    public static final String CODE_SYSTEM_ID = "1.2.40.0.34.5.183";

    /**
     * Gets the Enum with a given code.
     *
     * @param code The code value.
     * @return the enum value found or {@code null}.
     */
    @Nullable
    public static EImpfImmunizationTargetVs getEnum(@Nullable final String code) {
        for (final EImpfImmunizationTargetVs x : values()) {
            if (x.getCodeValue().equals(code)) {
                return x;
            }
        }
        return null;
    }

    /**
     * Checks if a given enum is part of this value set.
     *
     * @param enumName The name of the enum.
     * @return {@code true} if the name is found in this value set, {@code false} otherwise.
     */
    public static boolean isEnumOfValueSet(@Nullable final String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(EImpfImmunizationTargetVs.class,
                         enumName);
            return true;
        } catch (final IllegalArgumentException ex) {
            return false;
        }
    }

    /**
     * Checks if a given code value is in this value set.
     *
     * @param codeValue The code value.
     * @return {@code true} if the value is found in this value set, {@code false} otherwise.
     */
    public static boolean isInValueSet(@Nullable final String codeValue) {
        for (final EImpfImmunizationTargetVs x : values()) {
            if (x.getCodeValue().equals(codeValue)) {
                return true;
            }
        }
        return false;
    }

    /**
     * Machine interpretable and (inside this class) unique code.
     */
    @NonNull
    private final String code;

    /**
     * Identifier of the referencing code system.
     */
    @NonNull
    private final String codeSystem;

    /**
     * The display names per language. It's always stored in the given order: default display name (0), in English (1),
     * in German (2), in French (3) and in Italian (4).
     */
    @NonNull
    private final String[] displayNames;

    /**
     * Instantiates this enum with a given code and display names.
     *
     * @param code          The code value.
     * @param codeSystem    The code system (OID).
     * @param displayName   The default display name.
     * @param displayNameEn The display name in English.
     * @param displayNameDe The display name in German.
     * @param displayNameFr The display name in French.
     * @param displayNameIt The display name in Italian.
     */
    EImpfImmunizationTargetVs(@NonNull final String code, @NonNull final String codeSystem, @NonNull final String displayName, @NonNull final String displayNameEn, @NonNull final String displayNameDe, @NonNull final String displayNameFr, @NonNull final String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    /**
     * Gets the code system identifier.
     *
     * @return the code system identifier.
     */
    @Override
    @NonNull
    public String getCodeSystemId() {
        return this.codeSystem;
    }

    /**
     * Gets the code system name.
     *
     * @return the code system name.
     */
    @Override
    @NonNull
    public String getCodeSystemName() {
        final var codeSystem = CodeSystems.getEnum(this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    /**
     * Gets the code value as a string.
     *
     * @return the code value.
     */
    @Override
    @NonNull
    public String getCodeValue() {
        return this.code;
    }

    /**
     * Gets the display name defined by the language param.
     *
     * @param languageCode The language code to get the display name for, {@code null} to get the default display name.
     * @return the display name in the desired language.
     */
    @Override
    @NonNull
    public String getDisplayName(@Nullable final LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch(languageCode) {
            case ENGLISH ->
                this.displayNames[1];
            case GERMAN ->
                this.displayNames[2];
            case FRENCH ->
                this.displayNames[3];
            case ITALIAN ->
                this.displayNames[4];
            default ->
                "TOTRANSLATE";
        };
    }

    /**
     * Gets the value set identifier.
     *
     * @return the value set identifier.
     */
    @Override
    @NonNull
    public String getValueSetId() {
        return VALUE_SET_ID;
    }

    /**
     * Gets the value set name.
     *
     * @return the value set name.
     */
    @Override
    @NonNull
    public String getValueSetName() {
        return VALUE_SET_NAME;
    }
}
