/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.base.enums;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum Hl7LanguageAbilityMode implements ValueSetEnumInterface
{
    EXPRESSED_SIGNED("ESGN", "2.16.840.1.113883.5.60", "Expressed signed", "Expressed signed", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    EXPRESSED_SPOKEN("ESP", "2.16.840.1.113883.5.60", "Expressed spoken", "Expressed spoken", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    EXPRESSED_WRITTEN("EWR", "2.16.840.1.113883.5.60", "Expressed written", "Expressed written", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    RECEIVED_SIGNED("RSGN", "2.16.840.1.113883.5.60", "Received signed", "Received signed", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    RECEIVED_SPOKEN("RSP", "2.16.840.1.113883.5.60", "Received spoken", "Received spoken", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    RECEIVED_WRITTEN("RWR", "2.16.840.1.113883.5.60", "Received written", "Received written", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE");

    public static final String EXPRESSED_SIGNED_CODE = "ESGN";
    public static final String EXPRESSED_SPOKEN_CODE = "ESP";
    public static final String EXPRESSED_WRITTEN_CODE = "EWR";
    public static final String RECEIVED_SIGNED_CODE = "RSGN";
    public static final String RECEIVED_SPOKEN_CODE = "RSP";
    public static final String RECEIVED_WRITTEN_CODE = "RWR";
    public static final String VALUE_SET_ID = "1.2.40.0.34.10.175";
    public static final String VALUE_SET_NAME = "HL7LanguageAbilityMode";
    public static final String CODE_SYSTEM_ID = "2.16.840.1.113883.5.60";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable Hl7LanguageAbilityMode getEnum(@Nullable String code) {
        for (Hl7LanguageAbilityMode x : Hl7LanguageAbilityMode.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(Hl7LanguageAbilityMode.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (Hl7LanguageAbilityMode x : Hl7LanguageAbilityMode.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private Hl7LanguageAbilityMode(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

