/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.enums;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum AtcdabbrLanguageCode implements ValueSetEnumInterface
{
    ARABISCH("ar", "2.16.840.1.113883.6.121", "Arabisch", "Arabisch", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    BENGALI("bn", "2.16.840.1.113883.6.121", "Bengali", "Bengali", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    CHINESISCH("zh", "2.16.840.1.113883.6.121", "Chinesisch", "Chinesisch", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    CHINESISCH_CHINA("zh-CN", "2.16.840.1.113883.6.121", "Chinesisch (China)", "Chinesisch (China)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    CHINESISCH_HONG_KONG("zh-HK", "2.16.840.1.113883.6.121", "Chinesisch (Hong Kong)", "Chinesisch (Hong Kong)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    CHINESISCH_SINGAPUR("zh-SG", "2.16.840.1.113883.6.121", "Chinesisch (Singapur)", "Chinesisch (Singapur)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    CHINESISCH_TAIWAN("zh-TW", "2.16.840.1.113883.6.121", "Chinesisch (Taiwan)", "Chinesisch (Taiwan)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    DEUTSCH("de", "2.16.840.1.113883.6.121", "Deutsch", "Deutsch", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    DEUTSCH_DEUTSCHLAND("de-DE", "2.16.840.1.113883.6.121", "Deutsch (Deutschland)", "Deutsch (Deutschland)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    DEUTSCH_SCHWEIZ("de-CH", "2.16.840.1.113883.6.121", "Deutsch (Schweiz)", "Deutsch (Schweiz)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    D_NISCH("da", "2.16.840.1.113883.6.121", "D\u00e4nisch", "D\u00e4nisch", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    ENGLISCH("en", "2.16.840.1.113883.6.121", "Englisch", "Englisch", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    ENGLISCH_AUSTRALIEN("en-AU", "2.16.840.1.113883.6.121", "Englisch (Australien)", "Englisch (Australien)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    ENGLISCH_GB("en-GB", "2.16.840.1.113883.6.121", "Englisch (GB)", "Englisch (GB)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    ENGLISCH_INDIEN("en-IN", "2.16.840.1.113883.6.121", "Englisch (Indien)", "Englisch (Indien)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    ENGLISCH_KANADA("en-CA", "2.16.840.1.113883.6.121", "Englisch (Kanada)", "Englisch (Kanada)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    ENGLISCH_NEUSEELAND("en-NZ", "2.16.840.1.113883.6.121", "Englisch (Neuseeland)", "Englisch (Neuseeland)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    ENGLISCH_SINGAPUR("en-SG", "2.16.840.1.113883.6.121", "Englisch (Singapur)", "Englisch (Singapur)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    ENGLISCH_US("en-US", "2.16.840.1.113883.6.121", "Englisch (US)", "Englisch (US)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    FINNISCH("fi", "2.16.840.1.113883.6.121", "Finnisch", "Finnisch", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    FRANZ_SISCH("fr", "2.16.840.1.113883.6.121", "Franz\u00f6sisch", "Franz\u00f6sisch", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    FRANZ_SISCH_BELGIEN("fr-BE", "2.16.840.1.113883.6.121", "Franz\u00f6sisch (Belgien)", "Franz\u00f6sisch (Belgien)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    FRANZ_SISCH_FRANKREICH("fr-FR", "2.16.840.1.113883.6.121", "Franz\u00f6sisch (Frankreich)", "Franz\u00f6sisch (Frankreich)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    FRANZ_SISCH_SCHWEIZ("fr-CH", "2.16.840.1.113883.6.121", "Franz\u00f6sisch (Schweiz)", "Franz\u00f6sisch (Schweiz)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    FRIESISCH("fy", "2.16.840.1.113883.6.121", "Friesisch", "Friesisch", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    FRIESISCH_NIEDERLANDE("fy-NL", "2.16.840.1.113883.6.121", "Friesisch (Niederlande)", "Friesisch (Niederlande)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    HINDI("hi", "2.16.840.1.113883.6.121", "Hindi", "Hindi", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    ITALIENISCH("it", "2.16.840.1.113883.6.121", "Italienisch", "Italienisch", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    ITALIENISCH_ITALIEN("it-IT", "2.16.840.1.113883.6.121", "Italienisch (Italien)", "Italienisch (Italien)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    ITALIENISCH_SCHWEIZ("it-CH", "2.16.840.1.113883.6.121", "Italienisch (Schweiz)", "Italienisch (Schweiz)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    JAPANISCH("ja", "2.16.840.1.113883.6.121", "Japanisch", "Japanisch", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    KOREANISCH("ko", "2.16.840.1.113883.6.121", "Koreanisch", "Koreanisch", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    KROATISCH("hr", "2.16.840.1.113883.6.121", "Kroatisch", "Kroatisch", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    NEUGRIECHISCH("el", "2.16.840.1.113883.6.121", "Neugriechisch", "Neugriechisch", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    NIEDERL_NDISCH("nl", "2.16.840.1.113883.6.121", "Niederl\u00e4ndisch", "Niederl\u00e4ndisch", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    NIEDERL_NDISCH_BELGIEN("nl-BE", "2.16.840.1.113883.6.121", "Niederl\u00e4ndisch (Belgien)", "Niederl\u00e4ndisch (Belgien)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    NIEDERL_NDISCH_NIEDERLANDE("nl-NL", "2.16.840.1.113883.6.121", "Niederl\u00e4ndisch (Niederlande)", "Niederl\u00e4ndisch (Niederlande)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    NORWEGISCH("no", "2.16.840.1.113883.6.121", "Norwegisch", "Norwegisch", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    NORWEGISCH_NORWEGEN("no-NO", "2.16.840.1.113883.6.121", "Norwegisch (Norwegen)", "Norwegisch (Norwegen)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    PANDSCHABI_SPRACHE("pa", "2.16.840.1.113883.6.121", "Pandschabi-Sprache", "Pandschabi-Sprache", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    POLNISCH("pl", "2.16.840.1.113883.6.121", "Polnisch", "Polnisch", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    PORTUGIESISCH("pt", "2.16.840.1.113883.6.121", "Portugiesisch", "Portugiesisch", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    PORTUGIESISCH_BRASILIEN("pt-BR", "2.16.840.1.113883.6.121", "Portugiesisch (Brasilien)", "Portugiesisch (Brasilien)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    RUSSISCH("ru", "2.16.840.1.113883.6.121", "Russisch", "Russisch", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    RUSSISCH_RUSSLAND("ru-RU", "2.16.840.1.113883.6.121", "Russisch (Russland)", "Russisch (Russland)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    SCHWEDISCH("sv", "2.16.840.1.113883.6.121", "Schwedisch", "Schwedisch", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    SCHWEDISCH_SCHWEDEN("sv-SE", "2.16.840.1.113883.6.121", "Schwedisch (Schweden)", "Schwedisch (Schweden)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    SERBISCH("sr", "2.16.840.1.113883.6.121", "Serbisch", "Serbisch", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    SERBISCH_SERBIEN("sr-RS", "2.16.840.1.113883.6.121", "Serbisch (Serbien)", "Serbisch (Serbien)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    SPANISCH("es", "2.16.840.1.113883.6.121", "Spanisch", "Spanisch", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    SPANISCH_ARGENTINIEN("es-AR", "2.16.840.1.113883.6.121", "Spanisch (Argentinien)", "Spanisch (Argentinien)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    SPANISH_SPANIEN("es-ES", "2.16.840.1.113883.6.121", "Spanish (Spanien)", "Spanish (Spanien)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    SPANISH_URUGUAY("es-UY", "2.16.840.1.113883.6.121", "Spanish (Uruguay)", "Spanish (Uruguay)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    TELUGU_SPRACHE("te", "2.16.840.1.113883.6.121", "Telugu-Sprache", "Telugu-Sprache", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    TSCHECHISCH("cs", "2.16.840.1.113883.6.121", "Tschechisch", "Tschechisch", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    _STERREICHISCHES_DEUTSCH("de-AT", "2.16.840.1.113883.6.121", "\u00d6sterreichisches Deutsch", "\u00d6sterreichisches Deutsch", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE");

    public static final String ARABISCH_CODE = "ar";
    public static final String BENGALI_CODE = "bn";
    public static final String CHINESISCH_CODE = "zh";
    public static final String CHINESISCH_CHINA_CODE = "zh-CN";
    public static final String CHINESISCH_HONG_KONG_CODE = "zh-HK";
    public static final String CHINESISCH_SINGAPUR_CODE = "zh-SG";
    public static final String CHINESISCH_TAIWAN_CODE = "zh-TW";
    public static final String DEUTSCH_CODE = "de";
    public static final String DEUTSCH_DEUTSCHLAND_CODE = "de-DE";
    public static final String DEUTSCH_SCHWEIZ_CODE = "de-CH";
    public static final String D_NISCH_CODE = "da";
    public static final String ENGLISCH_CODE = "en";
    public static final String ENGLISCH_AUSTRALIEN_CODE = "en-AU";
    public static final String ENGLISCH_GB_CODE = "en-GB";
    public static final String ENGLISCH_INDIEN_CODE = "en-IN";
    public static final String ENGLISCH_KANADA_CODE = "en-CA";
    public static final String ENGLISCH_NEUSEELAND_CODE = "en-NZ";
    public static final String ENGLISCH_SINGAPUR_CODE = "en-SG";
    public static final String ENGLISCH_US_CODE = "en-US";
    public static final String FINNISCH_CODE = "fi";
    public static final String FRANZ_SISCH_CODE = "fr";
    public static final String FRANZ_SISCH_BELGIEN_CODE = "fr-BE";
    public static final String FRANZ_SISCH_FRANKREICH_CODE = "fr-FR";
    public static final String FRANZ_SISCH_SCHWEIZ_CODE = "fr-CH";
    public static final String FRIESISCH_CODE = "fy";
    public static final String FRIESISCH_NIEDERLANDE_CODE = "fy-NL";
    public static final String HINDI_CODE = "hi";
    public static final String ITALIENISCH_CODE = "it";
    public static final String ITALIENISCH_ITALIEN_CODE = "it-IT";
    public static final String ITALIENISCH_SCHWEIZ_CODE = "it-CH";
    public static final String JAPANISCH_CODE = "ja";
    public static final String KOREANISCH_CODE = "ko";
    public static final String KROATISCH_CODE = "hr";
    public static final String NEUGRIECHISCH_CODE = "el";
    public static final String NIEDERL_NDISCH_CODE = "nl";
    public static final String NIEDERL_NDISCH_BELGIEN_CODE = "nl-BE";
    public static final String NIEDERL_NDISCH_NIEDERLANDE_CODE = "nl-NL";
    public static final String NORWEGISCH_CODE = "no";
    public static final String NORWEGISCH_NORWEGEN_CODE = "no-NO";
    public static final String PANDSCHABI_SPRACHE_CODE = "pa";
    public static final String POLNISCH_CODE = "pl";
    public static final String PORTUGIESISCH_CODE = "pt";
    public static final String PORTUGIESISCH_BRASILIEN_CODE = "pt-BR";
    public static final String RUSSISCH_CODE = "ru";
    public static final String RUSSISCH_RUSSLAND_CODE = "ru-RU";
    public static final String SCHWEDISCH_CODE = "sv";
    public static final String SCHWEDISCH_SCHWEDEN_CODE = "sv-SE";
    public static final String SERBISCH_CODE = "sr";
    public static final String SERBISCH_SERBIEN_CODE = "sr-RS";
    public static final String SPANISCH_CODE = "es";
    public static final String SPANISCH_ARGENTINIEN_CODE = "es-AR";
    public static final String SPANISH_SPANIEN_CODE = "es-ES";
    public static final String SPANISH_URUGUAY_CODE = "es-UY";
    public static final String TELUGU_SPRACHE_CODE = "te";
    public static final String TSCHECHISCH_CODE = "cs";
    public static final String _STERREICHISCHES_DEUTSCH_CODE = "de-AT";
    public static final String VALUE_SET_ID = "1.2.40.0.34.10.10";
    public static final String VALUE_SET_NAME = "atcdabbr_LanguageCode";
    public static final String CODE_SYSTEM_ID = "2.16.840.1.113883.6.121";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable AtcdabbrLanguageCode getEnum(@Nullable String code) {
        for (AtcdabbrLanguageCode x : AtcdabbrLanguageCode.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(AtcdabbrLanguageCode.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (AtcdabbrLanguageCode x : AtcdabbrLanguageCode.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private AtcdabbrLanguageCode(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

