/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.ps;

import java.util.List;
import org.projecthusky.common.hl7cdar2.ActRelationshipHasComponent;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.ObjectFactory;
import org.projecthusky.common.hl7cdar2.POCDMT000040Author;
import org.projecthusky.common.hl7cdar2.POCDMT000040Component5;
import org.projecthusky.common.hl7cdar2.POCDMT000040Entry;
import org.projecthusky.common.hl7cdar2.POCDMT000040Informant12;
import org.projecthusky.common.hl7cdar2.POCDMT000040Section;
import org.projecthusky.common.hl7cdar2.ST;
import org.projecthusky.common.hl7cdar2.StrucDocText;
import org.projecthusky.common.hl7cdar2.XActRelationshipEntry;

public class Beeintraechtigungen
extends POCDMT000040Section {
    public Beeintraechtigungen() {
        super.getTemplateId().add(Beeintraechtigungen.createHl7TemplateIdFixedValue("1.2.40.0.34.11.13.2.12"));
        super.setCode(Beeintraechtigungen.createHl7CodeFixedValue("47420-5", "2.16.840.1.113883.6.1", null, null));
    }

    public void addHl7Author(POCDMT000040Author value) {
        this.getAuthor().add(value);
    }

    public void addHl7Component(POCDMT000040Component5 value) {
        this.getComponent().add(value);
    }

    public void addHl7Informant(POCDMT000040Informant12 value) {
        this.getInformant().add(value);
    }

    public void clearHl7Author() {
        this.getAuthor().clear();
    }

    public void clearHl7Component() {
        this.getComponent().clear();
    }

    public void clearHl7Informant() {
        this.getInformant().clear();
    }

    private static CE createHl7CodeFixedValue(String code, String codeSystem, String codeSystemName, String displayName) {
        ObjectFactory factory = new ObjectFactory();
        CE retVal = factory.createCE();
        retVal.setCode(code);
        retVal.setCodeSystem(codeSystem);
        retVal.setCodeSystemName(codeSystemName);
        retVal.setDisplayName(displayName);
        return retVal;
    }

    private static POCDMT000040Component5 createHl7ComponentFixedValue(String typeCode, String contextConductionInd) {
        ObjectFactory factory = new ObjectFactory();
        POCDMT000040Component5 retVal = factory.createPOCDMT000040Component5();
        retVal.setTypeCode(ActRelationshipHasComponent.fromValue((String)typeCode));
        if (contextConductionInd != null) {
            retVal.setContextConductionInd(Boolean.valueOf(Boolean.parseBoolean(contextConductionInd)));
        }
        return retVal;
    }

    private static POCDMT000040Entry createHl7EntryFixedValue(String typeCode) {
        ObjectFactory factory = new ObjectFactory();
        POCDMT000040Entry retVal = factory.createPOCDMT000040Entry();
        retVal.setTypeCode(XActRelationshipEntry.fromValue((String)typeCode));
        return retVal;
    }

    private static II createHl7TemplateIdFixedValue(String root) {
        ObjectFactory factory = new ObjectFactory();
        II retVal = factory.createII();
        retVal.setRoot(root);
        return retVal;
    }

    public CE getHl7Code() {
        return this.code;
    }

    public List<POCDMT000040Entry> getHl7Entry() {
        return this.entry;
    }

    public II getHl7Id() {
        return this.id;
    }

    public List<II> getHl7TemplateId() {
        return this.templateId;
    }

    public StrucDocText getHl7Text() {
        return this.text;
    }

    public ST getHl7Title() {
        return this.title;
    }

    public static POCDMT000040Component5 getPredefinedComponentCompTrue() {
        return Beeintraechtigungen.createHl7ComponentFixedValue("COMP", "true");
    }

    public static POCDMT000040Entry getPredefinedEntryDriv() {
        return Beeintraechtigungen.createHl7EntryFixedValue("DRIV");
    }

    public void setHl7Code(CE value) {
        this.code = value;
    }

    public void setHl7Entry(POCDMT000040Entry value) {
        this.getEntry().clear();
        this.getEntry().add(value);
    }

    public void setHl7Id(II value) {
        this.id = value;
    }

    public void setHl7TemplateId(II value) {
        this.getTemplateId().clear();
        this.getTemplateId().add(value);
    }

    public void setHl7Text(StrucDocText value) {
        this.text = value;
    }

    public void setHl7Title(ST value) {
        this.title = value;
    }
}

