/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.ps.enums;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum ActStatus implements ValueSetEnumInterface
{
    ABORTED_L1("aborted", "2.16.840.1.113883.5.14", "aborted", "aborted", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    ACTIVE_L1("active", "2.16.840.1.113883.5.14", "active", "active", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    CANCELLED_L1("cancelled", "2.16.840.1.113883.5.14", "cancelled", "cancelled", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    COMPLETED_L1("completed", "2.16.840.1.113883.5.14", "completed", "completed", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    HELD_L1("held", "2.16.840.1.113883.5.14", "held", "held", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    NEW_L1("new", "2.16.840.1.113883.5.14", "new", "new", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    NORMAL("normal", "2.16.840.1.113883.5.14", "normal", "normal", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    NULLIFIED("nullified", "2.16.840.1.113883.5.14", "nullified", "nullified", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    OBSOLETE("obsolete", "2.16.840.1.113883.5.14", "obsolete", "obsolete", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    SUSPENDED_L1("suspended", "2.16.840.1.113883.5.14", "suspended", "suspended", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE");

    public static final String ABORTED_L1_CODE = "aborted";
    public static final String ACTIVE_L1_CODE = "active";
    public static final String CANCELLED_L1_CODE = "cancelled";
    public static final String COMPLETED_L1_CODE = "completed";
    public static final String HELD_L1_CODE = "held";
    public static final String NEW_L1_CODE = "new";
    public static final String NORMAL_CODE = "normal";
    public static final String NULLIFIED_CODE = "nullified";
    public static final String OBSOLETE_CODE = "obsolete";
    public static final String SUSPENDED_L1_CODE = "suspended";
    public static final String VALUE_SET_ID = "2.16.840.1.113883.1.11.15933";
    public static final String VALUE_SET_NAME = "ActStatus";
    public static final String CODE_SYSTEM_ID = "2.16.840.1.113883.5.14";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable ActStatus getEnum(@Nullable String code) {
        for (ActStatus x : ActStatus.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(ActStatus.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (ActStatus x : ActStatus.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private ActStatus(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

