/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models;

import java.math.BigInteger;
import java.time.LocalDate;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import org.projecthusky.cda.elga.generated.artdecor.emed.Dosierung1;
import org.projecthusky.cda.elga.generated.artdecor.emed.Dosierung2er;
import org.projecthusky.cda.elga.generated.artdecor.emed.Dosierung3;
import org.projecthusky.cda.elga.generated.artdecor.emed.Dosierung3dq;
import org.projecthusky.cda.elga.generated.artdecor.emed.Dosierung4er;
import org.projecthusky.cda.elga.generated.artdecor.emed.enums.ElgaEinnahmezeitpunkte;
import org.projecthusky.cda.elga.generated.artdecor.emed.enums.ElgaMedikationFrequenz;
import org.projecthusky.cda.elga.generated.artdecor.emed.enums.ElgaMedikationMengenart;
import org.projecthusky.common.hl7cdar2.EIVLEvent;
import org.projecthusky.common.hl7cdar2.EIVLTS;
import org.projecthusky.common.hl7cdar2.INT;
import org.projecthusky.common.hl7cdar2.IVLPQ;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.PIVLTS;
import org.projecthusky.common.hl7cdar2.POCDMT000040Consumable;
import org.projecthusky.common.hl7cdar2.POCDMT000040ManufacturedProduct;
import org.projecthusky.common.hl7cdar2.POCDMT000040Material;
import org.projecthusky.common.hl7cdar2.POCDMT000040SubstanceAdministration;
import org.projecthusky.common.hl7cdar2.PQ;
import org.projecthusky.common.hl7cdar2.SXCMTS;
import org.projecthusky.common.hl7cdar2.SXPRTS;
import org.projecthusky.common.hl7cdar2.SetOperator;
import org.projecthusky.common.hl7cdar2.TS;
import org.projecthusky.common.hl7cdar2.XDocumentSubstanceMood;
import org.projecthusky.common.model.Code;
import org.projecthusky.common.utils.time.DateTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dose {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Dose.class.getName());
    private Double quantity;
    private Code unit;
    private Code frequence;
    private Code intakeTime;
    private List<LocalDate> days = new ArrayList<LocalDate>();
    private String text;

    public Dose(POCDMT000040SubstanceAdministration substance) {
        if (substance != null) {
            if (!substance.getEffectiveTime().isEmpty()) {
                this.setDoses(substance.getEffectiveTime());
            }
            if (substance.getDoseQuantity() != null && substance.getDoseQuantity().getValue() != null) {
                try {
                    this.quantity = Double.parseDouble(substance.getDoseQuantity().getValue());
                }
                catch (NumberFormatException ex) {
                    LOGGER.error(ex.getMessage());
                }
            }
        }
    }

    private void setDoses(List<SXCMTS> effectiveTimes) {
        for (SXCMTS sxcmts : effectiveTimes) {
            if (sxcmts instanceof SXPRTS) {
                SXPRTS sxprts = (SXPRTS)sxcmts;
                for (SXCMTS sxcmts2 : sxprts.getComp()) {
                    if (sxcmts2 instanceof EIVLTS) {
                        EIVLTS eivlts = (EIVLTS)sxcmts2;
                        this.setSingleDose(eivlts);
                        continue;
                    }
                    if (!(sxcmts2 instanceof PIVLTS)) continue;
                    PIVLTS pivlts = (PIVLTS)sxcmts2;
                    this.setDailyDose(pivlts);
                }
                continue;
            }
            if (sxcmts instanceof EIVLTS) {
                EIVLTS eivlts = (EIVLTS)sxcmts;
                this.setSingleDose(eivlts);
                continue;
            }
            if (!(sxcmts instanceof PIVLTS)) continue;
            PIVLTS pivlts = (PIVLTS)sxcmts;
            this.setDailyDose(pivlts);
        }
    }

    private void setSingleDose(EIVLTS effectiveTime) {
        if (effectiveTime == null) {
            return;
        }
        if (effectiveTime.getEvent() != null && effectiveTime.getEvent().getCode() != null) {
            this.intakeTime = ElgaEinnahmezeitpunkte.getEnum(effectiveTime.getEvent().getCode()).getCode();
        }
        if (effectiveTime.getOffset() != null && !effectiveTime.getOffset().getUnit().isEmpty()) {
            this.frequence = ElgaMedikationFrequenz.getEnum(effectiveTime.getOffset().getUnit()).getCode();
        }
    }

    private void setDailyDose(PIVLTS effectiveTime) {
        if (effectiveTime == null) {
            return;
        }
        if (effectiveTime.getPhase() != null && effectiveTime.getPhase().getValue() != null) {
            this.days.add(DateTimes.toLocalDate((TS)effectiveTime.getPhase()));
        }
        if (effectiveTime.getPeriod() != null && !effectiveTime.getPeriod().getUnit().isEmpty()) {
            this.frequence = ElgaMedikationFrequenz.getEnum(effectiveTime.getPeriod().getUnit()).getCode();
        }
    }

    public List<LocalDate> getDays() {
        return this.days;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Code getFrequence() {
        return this.frequence;
    }

    public Code getIntakeTime() {
        return this.intakeTime;
    }

    public Double getQuantity() {
        return this.quantity;
    }

    public Code getUnit() {
        return this.unit;
    }

    public void setDays(List<LocalDate> days) {
        this.days = days;
    }

    public void setFrequence(Code frequence) {
        this.frequence = frequence;
    }

    public void setIntakeTime(Code intakeTime) {
        this.intakeTime = intakeTime;
    }

    public void setQuantity(Double quantity) {
        this.quantity = quantity;
    }

    public void setUnit(Code unit) {
        this.unit = unit;
    }

    public Dosierung1 getDosierung1DailyDose() {
        Dosierung1 dose1 = new Dosierung1();
        PQ pq = dose1.getHl7Period();
        pq.setUnit(this.frequence.getCode());
        pq.setValue(this.quantity.toString());
        dose1.setHl7Period(pq);
        return dose1;
    }

    protected Dosierung3 getDosierung3DailyDoseWithPauseSingleWeekDay() {
        Dosierung3 dose = new Dosierung3();
        dose.setOperator(SetOperator.A);
        if (this.days != null && !this.days.isEmpty() && this.frequence != null) {
            IVLTS phase = new IVLTS();
            phase.setValue(DateTimes.toDateTs((TemporalAccessor)this.days.get(0)).getValue());
            dose.setPhase(phase);
            dose.setPeriod(new PQ("1.0", this.frequence.getCode()));
        }
        return dose;
    }

    private PIVLTS createEffectiveTimePhasePeriod(String phaseValue, Double periodValue, String unit) {
        PIVLTS effectiveTime = new PIVLTS();
        effectiveTime.setOperator(SetOperator.A);
        IVLTS phase = new IVLTS();
        phase.setValue(phaseValue);
        effectiveTime.setPhase(phase);
        effectiveTime.setPeriod(new PQ(String.valueOf(periodValue), unit));
        return effectiveTime;
    }

    public Dosierung3dq getDosierung3dqDailyDoseWithPauseMultipleWeekDays() {
        Dosierung3dq dose = new Dosierung3dq();
        SXPRTS effectiveTime = new SXPRTS();
        if (this.days != null) {
            for (LocalDate day : this.days) {
                PIVLTS compEffTime = new PIVLTS();
                compEffTime.setOperator(SetOperator.A);
                IVLTS phase = new IVLTS();
                if (day != null) {
                    phase.setValue(DateTimes.toDateTs((TemporalAccessor)day).getValue());
                }
                compEffTime.setPhase(phase);
                if (this.frequence != null) {
                    compEffTime.setPeriod(new PQ("1.0", this.frequence.getCode()));
                }
                effectiveTime.getComp().add(compEffTime);
            }
        }
        return dose;
    }

    public Dosierung2er getDosierung2erSingleDose(int index) {
        Dosierung2er dose = new Dosierung2er();
        INT sequenceNo = new INT();
        sequenceNo.setValue(BigInteger.valueOf(index));
        dose.setSequenceNumber(sequenceNo);
        if (this.quantity != null) {
            dose.setSubstanceAdministration(this.createSubstanceAdministrationForSingleDosage(this.quantity.toString(), this.intakeTime, "0", ElgaMedikationMengenart.S.getCode()));
        }
        return dose;
    }

    public Dosierung4er getDosierung4erSingleDoseWithPause(int index) {
        Dosierung4er dose = new Dosierung4er();
        INT sequenceNo = new INT();
        sequenceNo.setValue(BigInteger.valueOf(index));
        dose.setSequenceNumber(sequenceNo);
        dose.setSubstanceAdministration(this.getHl7CdaR2Pocdmt000040SubstanceAdministrationForSingleDosageWithPause());
        return dose;
    }

    protected POCDMT000040SubstanceAdministration getHl7CdaR2Pocdmt000040SubstanceAdministrationForSingleDosageWithPause() {
        POCDMT000040SubstanceAdministration substance = new POCDMT000040SubstanceAdministration();
        substance.getClassCode().add("SBADM");
        substance.setMoodCode(XDocumentSubstanceMood.INT);
        SXPRTS effectiveTime = new SXPRTS();
        EIVLTS eivlts = new EIVLTS();
        EIVLEvent event = new EIVLEvent();
        event.setCode(this.intakeTime.getCode());
        eivlts.setEvent(event);
        IVLPQ doseQuantity = new IVLPQ("0", ElgaMedikationMengenart.S.getCodeValue());
        eivlts.setOffset(doseQuantity);
        effectiveTime.getComp().add(eivlts);
        if (this.days != null) {
            for (LocalDate day : this.days) {
                if (day == null) continue;
                effectiveTime.getComp().add(this.createEffectiveTimePhasePeriod(DateTimes.toDateTs((TemporalAccessor)day).getValue(), 1.0, "wk"));
            }
        }
        substance.getEffectiveTime().add(effectiveTime);
        if (this.quantity != null) {
            substance.setDoseQuantity(Dose.getIVLPQ(this.quantity.toString(), this.unit));
        }
        substance.setConsumable(this.getHl7CdaR2Pocdmt000040ConsumableEmpty());
        return substance;
    }

    private POCDMT000040SubstanceAdministration createSubstanceAdministrationForSingleDosage(String doseQuantity, Code event, String offsetValue, Code unit) {
        POCDMT000040SubstanceAdministration substance = new POCDMT000040SubstanceAdministration();
        substance.getClassCode().add("SBADM");
        substance.setMoodCode(XDocumentSubstanceMood.INT);
        substance.setConsumable(this.getHl7CdaR2Pocdmt000040ConsumableEmpty());
        substance.setDoseQuantity(Dose.getIVLPQ(doseQuantity, null));
        EIVLTS eivlts = new EIVLTS();
        EIVLEvent eivlEvent = new EIVLEvent();
        eivlEvent.setCode(event.getCode());
        eivlts.setEvent(eivlEvent);
        IVLPQ ivlpq = new IVLPQ(offsetValue, unit.getCode());
        eivlts.setOffset(ivlpq);
        substance.getEffectiveTime().add(eivlts);
        return substance;
    }

    public static IVLPQ getIVLPQ(String value, Code unit) {
        IVLPQ retVal = new IVLPQ();
        if (value != null) {
            retVal.setValue(value);
            if (unit != null) {
                retVal.setUnit(unit.getCode());
            }
        } else {
            retVal.nullFlavor = new ArrayList();
            retVal.nullFlavor.add("UNK");
        }
        return retVal;
    }

    private POCDMT000040Consumable getHl7CdaR2Pocdmt000040ConsumableEmpty() {
        POCDMT000040Consumable consumable = new POCDMT000040Consumable();
        consumable.getTypeCode().add("CSM");
        POCDMT000040ManufacturedProduct drugEntry = new POCDMT000040ManufacturedProduct();
        POCDMT000040Material material = new POCDMT000040Material();
        material.setClassCode("MMAT");
        material.getNullFlavor().add("NA");
        drugEntry.setManufacturedMaterial(material);
        consumable.setManufacturedProduct(drugEntry);
        return consumable;
    }
}

