/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models.lab;

import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import org.projecthusky.cda.elga.generated.artdecor.base.Annotation;
import org.projecthusky.cda.elga.generated.artdecor.base.LaboratorySpecimenEntry;
import org.projecthusky.cda.elga.generated.artdecor.base.SpecimenReceived;
import org.projecthusky.cda.elga.models.PerformerAt;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.ED;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.POCDMT000040Act;
import org.projecthusky.common.hl7cdar2.POCDMT000040EntryRelationship;
import org.projecthusky.common.hl7cdar2.POCDMT000040Participant2;
import org.projecthusky.common.hl7cdar2.POCDMT000040ParticipantRole;
import org.projecthusky.common.hl7cdar2.POCDMT000040PlayingEntity;
import org.projecthusky.common.hl7cdar2.TEL;
import org.projecthusky.common.hl7cdar2.TS;
import org.projecthusky.common.hl7cdar2.XActRelationshipEntryRelationship;
import org.projecthusky.common.model.Code;
import org.projecthusky.common.model.Identificator;
import org.projecthusky.common.utils.time.DateTimes;

public class SpecimenCollection {
    private ZonedDateTime collectedTime;
    private Code targetSite;
    private PerformerAt collector;
    private Code type;
    private ZonedDateTime receivedTime;
    private List<String> notes;
    private String materialId;
    private String material;

    public ZonedDateTime getCollectedTime() {
        return this.collectedTime;
    }

    public Code getTargetSite() {
        return this.targetSite;
    }

    public PerformerAt getCollector() {
        return this.collector;
    }

    public Code getType() {
        return this.type;
    }

    public ZonedDateTime getReceivedTime() {
        return this.receivedTime;
    }

    public List<String> getNotes() {
        return this.notes;
    }

    public String getMaterialId() {
        return this.materialId;
    }

    public String getMaterial() {
        return this.material;
    }

    public void setCollectedTime(ZonedDateTime collectedTime) {
        this.collectedTime = collectedTime;
    }

    public void setTargetSite(Code targetSite) {
        this.targetSite = targetSite;
    }

    public void setCollector(PerformerAt collector) {
        this.collector = collector;
    }

    public void setType(Code type) {
        this.type = type;
    }

    public void setReceivedTime(ZonedDateTime receivedTime) {
        this.receivedTime = receivedTime;
    }

    public void setNote(List<String> notes) {
        this.notes = notes;
    }

    public void setMaterialId(String materialId) {
        this.materialId = materialId;
    }

    public void setMaterial(String material) {
        this.material = material;
    }

    public org.projecthusky.cda.elga.generated.artdecor.base.SpecimenCollection getLaboratorySpecimenCollection(String authorOid) {
        org.projecthusky.cda.elga.generated.artdecor.base.SpecimenCollection collection = new org.projecthusky.cda.elga.generated.artdecor.base.SpecimenCollection();
        if (this.collectedTime != null) {
            collection.setHl7EffectiveTime(new IVLTS(DateTimes.toDatetimeTs((TemporalAccessor)this.collectedTime).getValue()));
        }
        if (this.targetSite != null) {
            collection.getHl7TargetSiteCode().clear();
            collection.getHl7TargetSiteCode().add((CD)this.targetSite.getHl7CdaR2Ce());
        }
        if (this.collector != null) {
            collection.getHl7Performer().clear();
            collection.getHl7Performer().add(this.collector.getHl7Cdar2Perfomer());
        }
        if (this.type != null) {
            POCDMT000040Participant2 participant = new POCDMT000040Participant2();
            participant.getTypeCode().add("PRD");
            POCDMT000040ParticipantRole participantRole = new POCDMT000040ParticipantRole();
            participantRole.getClassCode().add("SPEC");
            participantRole.getId().add(new Identificator(authorOid, this.materialId).getHl7CdaR2Ii());
            POCDMT000040PlayingEntity playingEntity = new POCDMT000040PlayingEntity();
            playingEntity.setCode(this.type.getHl7CdaR2Ce());
            participantRole.setPlayingEntity(playingEntity);
            participant.setParticipantRole(participantRole);
            collection.getHl7Participant().add(participant);
        }
        POCDMT000040EntryRelationship entryRel = new POCDMT000040EntryRelationship();
        entryRel.setTypeCode(XActRelationshipEntryRelationship.COMP);
        entryRel.setAct((POCDMT000040Act)this.getSpecimenReceived());
        collection.getHl7EntryRelationship().add(entryRel);
        return collection;
    }

    public SpecimenReceived getSpecimenReceived() {
        SpecimenReceived specimenReceived = new SpecimenReceived();
        if (this.receivedTime != null) {
            specimenReceived.setHl7EffectiveTime((TS)new IVLTS(DateTimes.toDatetimeTs((TemporalAccessor)this.receivedTime).getValue()));
        }
        if (this.notes != null && !this.notes.isEmpty()) {
            for (int index = 0; index < this.notes.size(); ++index) {
                POCDMT000040EntryRelationship entryRel = LaboratorySpecimenEntry.createHl7EntryRelationshipFixedValue("COMP", null);
                Annotation annotation = new Annotation();
                annotation.setHl7Text(new ED(null, new TEL("#commonRemark-" + index)));
                entryRel.setAct((POCDMT000040Act)annotation);
                specimenReceived.addHl7EntryRelationship(entryRel);
            }
        }
        return specimenReceived;
    }
}

