/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.narrative;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.projecthusky.cda.elga.narrative.ImmunizationBaseTextGenerator;
import org.projecthusky.common.hl7cdar2.POCDMT000040Consumable;
import org.projecthusky.common.hl7cdar2.POCDMT000040Entry;
import org.projecthusky.common.hl7cdar2.POCDMT000040Precondition;
import org.projecthusky.common.hl7cdar2.POCDMT000040SubstanceAdministration;
import org.projecthusky.common.hl7cdar2.StrucDocTable;
import org.projecthusky.common.hl7cdar2.StrucDocTbody;
import org.projecthusky.common.hl7cdar2.StrucDocTd;
import org.projecthusky.common.hl7cdar2.StrucDocTr;
import org.projecthusky.common.model.Code;

public class ImmunizationNarrativeTextGenerator
extends ImmunizationBaseTextGenerator {
    private Map<String, List<Code>> immunizationTargets;
    private Map<String, Code> immunizationSchemas;
    private Map<String, Code> immunizationDose;
    private Map<String, Code> immunization;
    private Map<String, Code> historicImmunization;
    private List<POCDMT000040Entry> entries;

    public ImmunizationNarrativeTextGenerator(Map<String, List<Code>> immunizationTargets, Map<String, Code> immunizationSchemas, Map<String, Code> immunizationDose, Map<String, Code> immunization, Map<String, Code> historicImmunization) {
        this.immunizationTargets = immunizationTargets;
        this.immunizationSchemas = immunizationSchemas;
        this.immunizationDose = immunizationDose;
        this.immunization = immunization;
        this.historicImmunization = historicImmunization;
    }

    public ImmunizationNarrativeTextGenerator(List<POCDMT000040Entry> entries) {
        this.entries = entries;
    }

    private StrucDocTable getBody(int idxImmunization, String key) {
        StrucDocTable table = new StrucDocTable();
        table.setID(String.format("sbdm-%d", idxImmunization));
        StrucDocTbody body = new StrucDocTbody();
        if (this.immunizationTargets.get(key) != null && !this.immunizationTargets.get(key).isEmpty()) {
            body.getTr().add(this.getRow(this.immunizationTargets.get(key), "target-" + key));
        }
        body.getTr().add(this.getRowWithContentId(this.immunizationSchemas.get(key), "schedule-" + key, "Impfschema:"));
        body.getTr().add(this.getRow(this.immunizationDose.get(key), "Dosis:"));
        if (this.immunization.get(key) != null) {
            body.getTr().add(this.getRow(this.immunization.get(key), "Impfstoff:"));
        }
        if (this.historicImmunization.get(key) != null) {
            body.getTr().add(this.getRow(this.historicImmunization.get(key), "Historischer Impfstoff:"));
        }
        table.getTbody().add(body);
        return table;
    }

    protected StrucDocTr getRow(List<Code> immunizationTargets, String contentId) {
        if (immunizationTargets != null && !immunizationTargets.isEmpty()) {
            StrucDocTr tr = new StrucDocTr();
            StrucDocTd td = new StrucDocTd();
            td.getStyleCode().add("xELGA_colw:20");
            td.getContent().add("Impfung gegen:");
            tr.getThOrTd().add(td);
            StringBuilder targets = new StringBuilder();
            int indexLastEntry = immunizationTargets.size() - 1;
            int indexTarget = 0;
            for (Code target : immunizationTargets) {
                if (target == null) continue;
                targets.append(target.getDisplayName());
                if (indexLastEntry == indexTarget++) continue;
                targets.append(",");
            }
            tr.getThOrTd().add(this.getCellTdWithContent(targets.toString(), contentId));
            return tr;
        }
        return null;
    }

    protected StrucDocTr getRow(Code code, String title) {
        StrucDocTr tr = new StrucDocTr();
        tr.getThOrTd().add(this.getCellTd(title));
        if (code != null) {
            tr.getThOrTd().add(this.getCellTd(code.getDisplayName()));
        }
        return tr;
    }

    protected StrucDocTr getRowWithContentId(Code code, String contentId, String title) {
        StrucDocTr tr = new StrucDocTr();
        tr.getThOrTd().add(this.getCellTd(title));
        if (code != null) {
            tr.getThOrTd().add(this.getCellTdWithContent(code.getDisplayName(), contentId));
        }
        return tr;
    }

    protected StrucDocTr getRowVaccine(POCDMT000040Consumable vaccine) {
        if (vaccine != null && vaccine.getManufacturedProduct() != null && vaccine.getManufacturedProduct().getManufacturedMaterial() != null && vaccine.getManufacturedProduct().getManufacturedMaterial().getCode() != null) {
            StrucDocTr tr = new StrucDocTr();
            tr.getThOrTd().add(this.getCellTd("Impfstoff:"));
            tr.getThOrTd().add(this.getCellTd(vaccine.getManufacturedProduct().getManufacturedMaterial().getCode().getDisplayName()));
            return tr;
        }
        return null;
    }

    public List<JAXBElement<StrucDocTable>> getTables() {
        LinkedList<JAXBElement<StrucDocTable>> tables = new LinkedList<JAXBElement<StrucDocTable>>();
        int idxImmunization = 0;
        for (String key : this.immunizationTargets.keySet()) {
            tables.add((JAXBElement<StrucDocTable>)new JAXBElement(new QName("urn:hl7-org:v3", "table"), StrucDocTable.class, (Object)this.getBody(idxImmunization++, key)));
        }
        return tables;
    }

    private StrucDocTable getBody(int idxImmunization, POCDMT000040SubstanceAdministration substanceAdministration) {
        StrucDocTable table = new StrucDocTable();
        if (substanceAdministration.getText() != null && substanceAdministration.getText().getReference() != null && substanceAdministration.getText().getReference().getValue() != null) {
            table.setID(substanceAdministration.getText().getReference().getValue().replace("#", ""));
        } else {
            table.setID(String.format("sbdm-%d", idxImmunization));
        }
        StrucDocTbody body = new StrucDocTbody();
        for (POCDMT000040Precondition precondition : substanceAdministration.getPrecondition()) {
            if (precondition == null) continue;
            body.getTr().add(this.getRowDose(precondition));
            body.getTr().add(this.getRowScheme(precondition, idxImmunization));
        }
        if (substanceAdministration.getConsumable() != null) {
            body.getTr().add(this.getRowVaccine(substanceAdministration.getConsumable()));
        }
        body.getTr().addAll(this.getRowTargetDiseases(substanceAdministration.getEntryRelationship()));
        table.getTbody().add(body);
        return table;
    }

    public List<JAXBElement<StrucDocTable>> getTablesFromCda() {
        LinkedList<JAXBElement<StrucDocTable>> tables = new LinkedList<JAXBElement<StrucDocTable>>();
        int idxImmunization = 0;
        for (POCDMT000040Entry entry : this.entries) {
            if (entry == null || entry.getSubstanceAdministration() == null) continue;
            tables.add((JAXBElement<StrucDocTable>)new JAXBElement(new QName("urn:hl7-org:v3", "table"), StrucDocTable.class, (Object)this.getBody(idxImmunization, entry.getSubstanceAdministration())));
        }
        return tables;
    }
}

