/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.narrative;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.projecthusky.cda.elga.narrative.BaseTextGenerator;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.POCDMT000040Entry;
import org.projecthusky.common.hl7cdar2.POCDMT000040Observation;
import org.projecthusky.common.hl7cdar2.StrucDocTable;
import org.projecthusky.common.hl7cdar2.StrucDocTbody;
import org.projecthusky.common.hl7cdar2.StrucDocTd;
import org.projecthusky.common.hl7cdar2.StrucDocThead;
import org.projecthusky.common.hl7cdar2.StrucDocTr;
import org.projecthusky.common.utils.time.DateTimes;
import org.projecthusky.common.utils.time.Hl7Dtm;

public class PharmRecommendationNarrativeTextGenerator
extends BaseTextGenerator {
    private List<POCDMT000040Entry> entries;

    public PharmRecommendationNarrativeTextGenerator(List<POCDMT000040Entry> entries) {
        this.entries = entries;
    }

    private StrucDocThead getTableHeader() {
        StrucDocThead thead = new StrucDocThead();
        StrucDocTr tr = new StrucDocTr();
        tr.getThOrTd().add(this.getTableHeaderCell("Rezeptart", null));
        tr.getThOrTd().add(this.getTableHeaderCell("G\u00fcltig von", null));
        tr.getThOrTd().add(this.getTableHeaderCell("G\u00fcltig bis", null));
        thead.getTr().add(tr);
        return thead;
    }

    private StrucDocTable getBody(POCDMT000040Observation observation) {
        StrucDocTable table = new StrucDocTable();
        StrucDocTbody body = new StrucDocTbody();
        if (observation != null) {
            if (!observation.getId().isEmpty()) {
                table.setID(((II)observation.getId().get(0)).getExtension());
            }
            StrucDocTr tr = new StrucDocTr();
            StrucDocTd td = new StrucDocTd();
            if (observation.getCode() != null) {
                td.getContent().add(observation.getCode().getDisplayName());
                if (observation.getCode().getOriginalText() != null && observation.getCode().getOriginalText().getReference() != null && observation.getCode().getOriginalText().getReference().getValue() != null) {
                    td.setID(observation.getCode().getOriginalText().getReference().getValue().replace("#", ""));
                }
            }
            tr.getThOrTd().add(td);
            StrucDocTd tdTime = new StrucDocTd();
            if (observation.getEffectiveTime() != null) {
                SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
                Instant instant = DateTimes.toInstant((Hl7Dtm)Hl7Dtm.fromHl7((String)observation.getEffectiveTime().getValue()));
                tdTime.getContent().add(sdf.format(instant));
            }
            tr.getThOrTd().add(tdTime);
            body.getTr().add(tr);
        }
        table.setThead(this.getTableHeader());
        table.getTbody().add(body);
        return table;
    }

    public List<JAXBElement<StrucDocTable>> getTablesFromCda() {
        LinkedList<JAXBElement<StrucDocTable>> tables = new LinkedList<JAXBElement<StrucDocTable>>();
        for (POCDMT000040Entry entry : this.entries) {
            if (entry == null || entry.getAct() == null) continue;
            tables.add((JAXBElement<StrucDocTable>)new JAXBElement(new QName("urn:hl7-org:v3", "table"), StrucDocTable.class, (Object)this.getBody(entry.getObservation())));
        }
        return tables;
    }
}

