/*
 * This code is made available under the terms of the Eclipse Public License v1.0
 * in the github project https://github.com/project-husky/husky there you also
 * find a list of the contributors and the license information.
 *
 * This project has been developed further and modified by the joined working group Husky
 * on the basis of the eHealth Connector opensource project from June 28, 2021,
 * whereas medshare GmbH is the initial and main contributor/author of the eHealth Connector.
 */
package org.projecthusky.cda.elga.generated.artdecor.base.enums;

import java.util.Objects;
import javax.annotation.processing.Generated;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

/**
 * Enumeration of ELGA_HumanActSite values
 * <p>
 * EN: No designation found.<br>
 * DE: No designation found.<br>
 * FR: No designation found.<br>
 * IT: No designation found.<br>
 * <p>
 * Identifier: 1.2.40.0.34.10.52<br>
 * Effective date: 2013-01-10 00:00<br>
 * Version: null<br>
 * Status: FINAL
 */
@Generated(value = "org.projecthusky.codegenerator.ch.valuesets.UpdateValueSets", date = "2022-02-21")
public enum ElgaHumanActSite implements ValueSetEnumInterface {

    /**
     * EN: bilateral ears.<br>
     */
    BILATERAL_EARS("BE",
                   "2.16.840.1.113883.5.1052",
                   "bilateral ears",
                   "bilateral ears",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: bilateral eyes.<br>
     */
    BILATERAL_EYES("OU",
                   "2.16.840.1.113883.5.1052",
                   "bilateral eyes",
                   "bilateral eyes",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: bilateral nares.<br>
     */
    BILATERAL_NARES("BN",
                    "2.16.840.1.113883.5.1052",
                    "bilateral nares",
                    "bilateral nares",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: buttock.<br>
     */
    BUTTOCK("BU",
            "2.16.840.1.113883.5.1052",
            "buttock",
            "buttock",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: left antecubital fossa.<br>
     */
    LEFT_ANTECUBITAL_FOSSA("LACF",
                           "2.16.840.1.113883.5.1052",
                           "left antecubital fossa",
                           "left antecubital fossa",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: left anterior chest.<br>
     */
    LEFT_ANTERIOR_CHEST("LAC",
                        "2.16.840.1.113883.5.1052",
                        "left anterior chest",
                        "left anterior chest",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: left arm.<br>
     */
    LEFT_ARM("LA",
             "2.16.840.1.113883.5.1052",
             "left arm",
             "left arm",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: left deltoid.<br>
     */
    LEFT_DELTOID("LD",
                 "2.16.840.1.113883.5.1052",
                 "left deltoid",
                 "left deltoid",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: left ear.<br>
     */
    LEFT_EAR("LE",
             "2.16.840.1.113883.5.1052",
             "left ear",
             "left ear",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: left external jugular.<br>
     */
    LEFT_EXTERNAL_JUGULAR("LEJ",
                          "2.16.840.1.113883.5.1052",
                          "left external jugular",
                          "left external jugular",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: left eye.<br>
     */
    LEFT_EYE("OS",
             "2.16.840.1.113883.5.1052",
             "left eye",
             "left eye",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: left foot.<br>
     */
    LEFT_FOOT("LF",
              "2.16.840.1.113883.5.1052",
              "left foot",
              "left foot",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: left gluteus medius.<br>
     */
    LEFT_GLUTEUS_MEDIUS("LG",
                        "2.16.840.1.113883.5.1052",
                        "left gluteus medius",
                        "left gluteus medius",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: left hand.<br>
     */
    LEFT_HAND("LH",
              "2.16.840.1.113883.5.1052",
              "left hand",
              "left hand",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: left internal jugular.<br>
     */
    LEFT_INTERNAL_JUGULAR("LIJ",
                          "2.16.840.1.113883.5.1052",
                          "left internal jugular",
                          "left internal jugular",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: left lower abd quadrant.<br>
     */
    LEFT_LOWER_ABD_QUADRANT("LLAQ",
                            "2.16.840.1.113883.5.1052",
                            "left lower abd quadrant",
                            "left lower abd quadrant",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: left lower forearm.<br>
     */
    LEFT_LOWER_FOREARM("LLFA",
                       "2.16.840.1.113883.5.1052",
                       "left lower forearm",
                       "left lower forearm",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: left mid forearm.<br>
     */
    LEFT_MID_FOREARM("LMFA",
                     "2.16.840.1.113883.5.1052",
                     "left mid forearm",
                     "left mid forearm",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: left naris.<br>
     */
    LEFT_NARIS("LN",
               "2.16.840.1.113883.5.1052",
               "left naris",
               "left naris",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: left posterior chest.<br>
     */
    LEFT_POSTERIOR_CHEST("LPC",
                         "2.16.840.1.113883.5.1052",
                         "left posterior chest",
                         "left posterior chest",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: left subclavian.<br>
     */
    LEFT_SUBCLAVIAN("LSC",
                    "2.16.840.1.113883.5.1052",
                    "left subclavian",
                    "left subclavian",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: left thigh.<br>
     */
    LEFT_THIGH("LT",
               "2.16.840.1.113883.5.1052",
               "left thigh",
               "left thigh",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: left upper abd quadrant.<br>
     */
    LEFT_UPPER_ABD_QUADRANT("LUAQ",
                            "2.16.840.1.113883.5.1052",
                            "left upper abd quadrant",
                            "left upper abd quadrant",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: left upper arm.<br>
     */
    LEFT_UPPER_ARM("LUA",
                   "2.16.840.1.113883.5.1052",
                   "left upper arm",
                   "left upper arm",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: left upper forearm.<br>
     */
    LEFT_UPPER_FOREARM("LUFA",
                       "2.16.840.1.113883.5.1052",
                       "left upper forearm",
                       "left upper forearm",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: left vastus lateralis.<br>
     */
    LEFT_VASTUS_LATERALIS("LVL",
                          "2.16.840.1.113883.5.1052",
                          "left vastus lateralis",
                          "left vastus lateralis",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: left ventragluteal.<br>
     */
    LEFT_VENTRAGLUTEAL("LVG",
                       "2.16.840.1.113883.5.1052",
                       "left ventragluteal",
                       "left ventragluteal",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: perianal.<br>
     */
    PERIANAL("PA",
             "2.16.840.1.113883.5.1052",
             "perianal",
             "perianal",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: perineal.<br>
     */
    PERINEAL("PERIN",
             "2.16.840.1.113883.5.1052",
             "perineal",
             "perineal",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: right antecubital fossa.<br>
     */
    RIGHT_ANTECUBITAL_FOSSA("RACF",
                            "2.16.840.1.113883.5.1052",
                            "right antecubital fossa",
                            "right antecubital fossa",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: right anterior chest.<br>
     */
    RIGHT_ANTERIOR_CHEST("RAC",
                         "2.16.840.1.113883.5.1052",
                         "right anterior chest",
                         "right anterior chest",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: right arm.<br>
     */
    RIGHT_ARM("RA",
              "2.16.840.1.113883.5.1052",
              "right arm",
              "right arm",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: right deltoid.<br>
     */
    RIGHT_DELTOID("RD",
                  "2.16.840.1.113883.5.1052",
                  "right deltoid",
                  "right deltoid",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: right ear.<br>
     */
    RIGHT_EAR("RE",
              "2.16.840.1.113883.5.1052",
              "right ear",
              "right ear",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: right external jugular.<br>
     */
    RIGHT_EXTERNAL_JUGULAR("REJ",
                           "2.16.840.1.113883.5.1052",
                           "right external jugular",
                           "right external jugular",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: right eye.<br>
     */
    RIGHT_EYE("OD",
              "2.16.840.1.113883.5.1052",
              "right eye",
              "right eye",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: right foot.<br>
     */
    RIGHT_FOOT("RF",
               "2.16.840.1.113883.5.1052",
               "right foot",
               "right foot",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: right gluteus medius.<br>
     */
    RIGHT_GLUTEUS_MEDIUS("RG",
                         "2.16.840.1.113883.5.1052",
                         "right gluteus medius",
                         "right gluteus medius",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: right hand.<br>
     */
    RIGHT_HAND("RH",
               "2.16.840.1.113883.5.1052",
               "right hand",
               "right hand",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: right internal jugular.<br>
     */
    RIGHT_INTERNAL_JUGULAR("RIJ",
                           "2.16.840.1.113883.5.1052",
                           "right internal jugular",
                           "right internal jugular",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: right lower abd quadrant.<br>
     */
    RIGHT_LOWER_ABD_QUADRANT("RLAQ",
                             "2.16.840.1.113883.5.1052",
                             "right lower abd quadrant",
                             "right lower abd quadrant",
                             "TOTRANSLATE",
                             "TOTRANSLATE",
                             "TOTRANSLATE"),
    /**
     * EN: right lower forearm.<br>
     */
    RIGHT_LOWER_FOREARM("RLFA",
                        "2.16.840.1.113883.5.1052",
                        "right lower forearm",
                        "right lower forearm",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: right mid forearm.<br>
     */
    RIGHT_MID_FOREARM("RMFA",
                      "2.16.840.1.113883.5.1052",
                      "right mid forearm",
                      "right mid forearm",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: right naris.<br>
     */
    RIGHT_NARIS("RN",
                "2.16.840.1.113883.5.1052",
                "right naris",
                "right naris",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: right posterior chest.<br>
     */
    RIGHT_POSTERIOR_CHEST("RPC",
                          "2.16.840.1.113883.5.1052",
                          "right posterior chest",
                          "right posterior chest",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: right subclavian.<br>
     */
    RIGHT_SUBCLAVIAN("RSC",
                     "2.16.840.1.113883.5.1052",
                     "right subclavian",
                     "right subclavian",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: right thigh.<br>
     */
    RIGHT_THIGH("RT",
                "2.16.840.1.113883.5.1052",
                "right thigh",
                "right thigh",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: right upper abd quadrant.<br>
     */
    RIGHT_UPPER_ABD_QUADRANT("RUAQ",
                             "2.16.840.1.113883.5.1052",
                             "right upper abd quadrant",
                             "right upper abd quadrant",
                             "TOTRANSLATE",
                             "TOTRANSLATE",
                             "TOTRANSLATE"),
    /**
     * EN: right upper arm.<br>
     */
    RIGHT_UPPER_ARM("RUA",
                    "2.16.840.1.113883.5.1052",
                    "right upper arm",
                    "right upper arm",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: right upper forearm.<br>
     */
    RIGHT_UPPER_FOREARM("RUFA",
                        "2.16.840.1.113883.5.1052",
                        "right upper forearm",
                        "right upper forearm",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: right vastus lateralis.<br>
     */
    RIGHT_VASTUS_LATERALIS("RVL",
                           "2.16.840.1.113883.5.1052",
                           "right vastus lateralis",
                           "right vastus lateralis",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: right ventragluteal.<br>
     */
    RIGHT_VENTRAGLUTEAL("RVG",
                        "2.16.840.1.113883.5.1052",
                        "right ventragluteal",
                        "right ventragluteal",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE");

    /**
     * EN: Code for bilateral ears.<br>
     */
    public static final String BILATERAL_EARS_CODE = "BE";

    /**
     * EN: Code for bilateral eyes.<br>
     */
    public static final String BILATERAL_EYES_CODE = "OU";

    /**
     * EN: Code for bilateral nares.<br>
     */
    public static final String BILATERAL_NARES_CODE = "BN";

    /**
     * EN: Code for buttock.<br>
     */
    public static final String BUTTOCK_CODE = "BU";

    /**
     * EN: Code for left antecubital fossa.<br>
     */
    public static final String LEFT_ANTECUBITAL_FOSSA_CODE = "LACF";

    /**
     * EN: Code for left anterior chest.<br>
     */
    public static final String LEFT_ANTERIOR_CHEST_CODE = "LAC";

    /**
     * EN: Code for left arm.<br>
     */
    public static final String LEFT_ARM_CODE = "LA";

    /**
     * EN: Code for left deltoid.<br>
     */
    public static final String LEFT_DELTOID_CODE = "LD";

    /**
     * EN: Code for left ear.<br>
     */
    public static final String LEFT_EAR_CODE = "LE";

    /**
     * EN: Code for left external jugular.<br>
     */
    public static final String LEFT_EXTERNAL_JUGULAR_CODE = "LEJ";

    /**
     * EN: Code for left eye.<br>
     */
    public static final String LEFT_EYE_CODE = "OS";

    /**
     * EN: Code for left foot.<br>
     */
    public static final String LEFT_FOOT_CODE = "LF";

    /**
     * EN: Code for left gluteus medius.<br>
     */
    public static final String LEFT_GLUTEUS_MEDIUS_CODE = "LG";

    /**
     * EN: Code for left hand.<br>
     */
    public static final String LEFT_HAND_CODE = "LH";

    /**
     * EN: Code for left internal jugular.<br>
     */
    public static final String LEFT_INTERNAL_JUGULAR_CODE = "LIJ";

    /**
     * EN: Code for left lower abd quadrant.<br>
     */
    public static final String LEFT_LOWER_ABD_QUADRANT_CODE = "LLAQ";

    /**
     * EN: Code for left lower forearm.<br>
     */
    public static final String LEFT_LOWER_FOREARM_CODE = "LLFA";

    /**
     * EN: Code for left mid forearm.<br>
     */
    public static final String LEFT_MID_FOREARM_CODE = "LMFA";

    /**
     * EN: Code for left naris.<br>
     */
    public static final String LEFT_NARIS_CODE = "LN";

    /**
     * EN: Code for left posterior chest.<br>
     */
    public static final String LEFT_POSTERIOR_CHEST_CODE = "LPC";

    /**
     * EN: Code for left subclavian.<br>
     */
    public static final String LEFT_SUBCLAVIAN_CODE = "LSC";

    /**
     * EN: Code for left thigh.<br>
     */
    public static final String LEFT_THIGH_CODE = "LT";

    /**
     * EN: Code for left upper abd quadrant.<br>
     */
    public static final String LEFT_UPPER_ABD_QUADRANT_CODE = "LUAQ";

    /**
     * EN: Code for left upper arm.<br>
     */
    public static final String LEFT_UPPER_ARM_CODE = "LUA";

    /**
     * EN: Code for left upper forearm.<br>
     */
    public static final String LEFT_UPPER_FOREARM_CODE = "LUFA";

    /**
     * EN: Code for left vastus lateralis.<br>
     */
    public static final String LEFT_VASTUS_LATERALIS_CODE = "LVL";

    /**
     * EN: Code for left ventragluteal.<br>
     */
    public static final String LEFT_VENTRAGLUTEAL_CODE = "LVG";

    /**
     * EN: Code for perianal.<br>
     */
    public static final String PERIANAL_CODE = "PA";

    /**
     * EN: Code for perineal.<br>
     */
    public static final String PERINEAL_CODE = "PERIN";

    /**
     * EN: Code for right antecubital fossa.<br>
     */
    public static final String RIGHT_ANTECUBITAL_FOSSA_CODE = "RACF";

    /**
     * EN: Code for right anterior chest.<br>
     */
    public static final String RIGHT_ANTERIOR_CHEST_CODE = "RAC";

    /**
     * EN: Code for right arm.<br>
     */
    public static final String RIGHT_ARM_CODE = "RA";

    /**
     * EN: Code for right deltoid.<br>
     */
    public static final String RIGHT_DELTOID_CODE = "RD";

    /**
     * EN: Code for right ear.<br>
     */
    public static final String RIGHT_EAR_CODE = "RE";

    /**
     * EN: Code for right external jugular.<br>
     */
    public static final String RIGHT_EXTERNAL_JUGULAR_CODE = "REJ";

    /**
     * EN: Code for right eye.<br>
     */
    public static final String RIGHT_EYE_CODE = "OD";

    /**
     * EN: Code for right foot.<br>
     */
    public static final String RIGHT_FOOT_CODE = "RF";

    /**
     * EN: Code for right gluteus medius.<br>
     */
    public static final String RIGHT_GLUTEUS_MEDIUS_CODE = "RG";

    /**
     * EN: Code for right hand.<br>
     */
    public static final String RIGHT_HAND_CODE = "RH";

    /**
     * EN: Code for right internal jugular.<br>
     */
    public static final String RIGHT_INTERNAL_JUGULAR_CODE = "RIJ";

    /**
     * EN: Code for right lower abd quadrant.<br>
     */
    public static final String RIGHT_LOWER_ABD_QUADRANT_CODE = "RLAQ";

    /**
     * EN: Code for right lower forearm.<br>
     */
    public static final String RIGHT_LOWER_FOREARM_CODE = "RLFA";

    /**
     * EN: Code for right mid forearm.<br>
     */
    public static final String RIGHT_MID_FOREARM_CODE = "RMFA";

    /**
     * EN: Code for right naris.<br>
     */
    public static final String RIGHT_NARIS_CODE = "RN";

    /**
     * EN: Code for right posterior chest.<br>
     */
    public static final String RIGHT_POSTERIOR_CHEST_CODE = "RPC";

    /**
     * EN: Code for right subclavian.<br>
     */
    public static final String RIGHT_SUBCLAVIAN_CODE = "RSC";

    /**
     * EN: Code for right thigh.<br>
     */
    public static final String RIGHT_THIGH_CODE = "RT";

    /**
     * EN: Code for right upper abd quadrant.<br>
     */
    public static final String RIGHT_UPPER_ABD_QUADRANT_CODE = "RUAQ";

    /**
     * EN: Code for right upper arm.<br>
     */
    public static final String RIGHT_UPPER_ARM_CODE = "RUA";

    /**
     * EN: Code for right upper forearm.<br>
     */
    public static final String RIGHT_UPPER_FOREARM_CODE = "RUFA";

    /**
     * EN: Code for right vastus lateralis.<br>
     */
    public static final String RIGHT_VASTUS_LATERALIS_CODE = "RVL";

    /**
     * EN: Code for right ventragluteal.<br>
     */
    public static final String RIGHT_VENTRAGLUTEAL_CODE = "RVG";

    /**
     * Identifier of the value set.
     */
    public static final String VALUE_SET_ID = "1.2.40.0.34.10.52";

    /**
     * Name of the value set.
     */
    public static final String VALUE_SET_NAME = "ELGA_HumanActSite";

    /**
     * Identifier of the code system (all values share the same).
     */
    public static final String CODE_SYSTEM_ID = "2.16.840.1.113883.5.1052";

    /**
     * Gets the Enum with a given code.
     *
     * @param code The code value.
     * @return the enum value found or {@code null}.
     */
    @Nullable
    public static ElgaHumanActSite getEnum(@Nullable final String code) {
        for (final ElgaHumanActSite x : values()) {
            if (x.getCodeValue().equals(code)) {
                return x;
            }
        }
        return null;
    }

    /**
     * Checks if a given enum is part of this value set.
     *
     * @param enumName The name of the enum.
     * @return {@code true} if the name is found in this value set, {@code false} otherwise.
     */
    public static boolean isEnumOfValueSet(@Nullable final String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(ElgaHumanActSite.class,
                         enumName);
            return true;
        } catch (final IllegalArgumentException ex) {
            return false;
        }
    }

    /**
     * Checks if a given code value is in this value set.
     *
     * @param codeValue The code value.
     * @return {@code true} if the value is found in this value set, {@code false} otherwise.
     */
    public static boolean isInValueSet(@Nullable final String codeValue) {
        for (final ElgaHumanActSite x : values()) {
            if (x.getCodeValue().equals(codeValue)) {
                return true;
            }
        }
        return false;
    }

    /**
     * Machine interpretable and (inside this class) unique code.
     */
    @NonNull
    private final String code;

    /**
     * Identifier of the referencing code system.
     */
    @NonNull
    private final String codeSystem;

    /**
     * The display names per language. It's always stored in the given order: default display name (0), in English (1),
     * in German (2), in French (3) and in Italian (4).
     */
    @NonNull
    private final String[] displayNames;

    /**
     * Instantiates this enum with a given code and display names.
     *
     * @param code          The code value.
     * @param codeSystem    The code system (OID).
     * @param displayName   The default display name.
     * @param displayNameEn The display name in English.
     * @param displayNameDe The display name in German.
     * @param displayNameFr The display name in French.
     * @param displayNameIt The display name in Italian.
     */
    ElgaHumanActSite(@NonNull final String code, @NonNull final String codeSystem, @NonNull final String displayName, @NonNull final String displayNameEn, @NonNull final String displayNameDe, @NonNull final String displayNameFr, @NonNull final String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    /**
     * Gets the code system identifier.
     *
     * @return the code system identifier.
     */
    @Override
    @NonNull
    public String getCodeSystemId() {
        return this.codeSystem;
    }

    /**
     * Gets the code system name.
     *
     * @return the code system name.
     */
    @Override
    @NonNull
    public String getCodeSystemName() {
        final var codeSystem = CodeSystems.getEnum(this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    /**
     * Gets the code value as a string.
     *
     * @return the code value.
     */
    @Override
    @NonNull
    public String getCodeValue() {
        return this.code;
    }

    /**
     * Gets the display name defined by the language param.
     *
     * @param languageCode The language code to get the display name for, {@code null} to get the default display name.
     * @return the display name in the desired language.
     */
    @Override
    @NonNull
    public String getDisplayName(@Nullable final LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch(languageCode) {
            case ENGLISH ->
                this.displayNames[1];
            case GERMAN ->
                this.displayNames[2];
            case FRENCH ->
                this.displayNames[3];
            case ITALIAN ->
                this.displayNames[4];
            default ->
                "TOTRANSLATE";
        };
    }

    /**
     * Gets the value set identifier.
     *
     * @return the value set identifier.
     */
    @Override
    @NonNull
    public String getValueSetId() {
        return VALUE_SET_ID;
    }

    /**
     * Gets the value set name.
     *
     * @return the value set name.
     */
    @Override
    @NonNull
    public String getValueSetName() {
        return VALUE_SET_NAME;
    }
}
