/*
 * This code is made available under the terms of the Eclipse Public License v1.0
 * in the github project https://github.com/project-husky/husky there you also
 * find a list of the contributors and the license information.
 *
 * This project has been developed further and modified by the joined working group Husky
 * on the basis of the eHealth Connector opensource project from June 28, 2021,
 * whereas medshare GmbH is the initial and main contributor/author of the eHealth Connector.
 */
package org.projecthusky.cda.elga.generated.artdecor.ems.enums;

import java.util.Objects;
import javax.annotation.processing.Generated;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

/**
 * Enumeration of atcdabbr_LanguageCode values
 * <p>
 * EN: ELGA_LanguageCode is used to describe the language of the documents (CDA-Element: ClinicalDocument.languageCode). Description available under: http://www.ietf.org/rfc/rfc3066.txt.<br>
 * DE: No designation found.<br>
 * FR: No designation found.<br>
 * IT: No designation found.<br>
 * <p>
 * Identifier: 1.2.40.0.34.10.10<br>
 * Effective date: 2020-08-20 10:15<br>
 * Version: 202008(-beta)<br>
 * Status: DRAFT
 */
@Generated(value = "org.projecthusky.codegenerator.ch.valuesets.UpdateValueSets", date = "2022-02-01")
public enum AtcdabbrLanguageCode implements ValueSetEnumInterface {

    /**
     * EN: Arabisch.<br>
     */
    ARABISCH("ar",
             "2.16.840.1.113883.6.121",
             "Arabisch",
             "Arabisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Bengali.<br>
     */
    BENGALI("bn",
            "2.16.840.1.113883.6.121",
            "Bengali",
            "Bengali",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Chinesisch.<br>
     */
    CHINESISCH("zh",
               "2.16.840.1.113883.6.121",
               "Chinesisch",
               "Chinesisch",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Chinesisch (China).<br>
     */
    CHINESISCH_CHINA("zh-CN",
                     "2.16.840.1.113883.6.121",
                     "Chinesisch (China)",
                     "Chinesisch (China)",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Chinesisch (Hong Kong).<br>
     */
    CHINESISCH_HONG_KONG("zh-HK",
                         "2.16.840.1.113883.6.121",
                         "Chinesisch (Hong Kong)",
                         "Chinesisch (Hong Kong)",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Chinesisch (Singapur).<br>
     */
    CHINESISCH_SINGAPUR("zh-SG",
                        "2.16.840.1.113883.6.121",
                        "Chinesisch (Singapur)",
                        "Chinesisch (Singapur)",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Chinesisch (Taiwan).<br>
     */
    CHINESISCH_TAIWAN("zh-TW",
                      "2.16.840.1.113883.6.121",
                      "Chinesisch (Taiwan)",
                      "Chinesisch (Taiwan)",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Deutsch.<br>
     */
    DEUTSCH("de",
            "2.16.840.1.113883.6.121",
            "Deutsch",
            "Deutsch",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Deutsch (Deutschland).<br>
     */
    DEUTSCH_DEUTSCHLAND("de-DE",
                        "2.16.840.1.113883.6.121",
                        "Deutsch (Deutschland)",
                        "Deutsch (Deutschland)",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Deutsch (Schweiz).<br>
     */
    DEUTSCH_SCHWEIZ("de-CH",
                    "2.16.840.1.113883.6.121",
                    "Deutsch (Schweiz)",
                    "Deutsch (Schweiz)",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Dänisch.<br>
     */
    D_NISCH("da",
            "2.16.840.1.113883.6.121",
            "Dänisch",
            "Dänisch",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Englisch.<br>
     */
    ENGLISCH("en",
             "2.16.840.1.113883.6.121",
             "Englisch",
             "Englisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Englisch (Australien).<br>
     */
    ENGLISCH_AUSTRALIEN("en-AU",
                        "2.16.840.1.113883.6.121",
                        "Englisch (Australien)",
                        "Englisch (Australien)",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Englisch (GB).<br>
     */
    ENGLISCH_GB("en-GB",
                "2.16.840.1.113883.6.121",
                "Englisch (GB)",
                "Englisch (GB)",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Englisch (Indien).<br>
     */
    ENGLISCH_INDIEN("en-IN",
                    "2.16.840.1.113883.6.121",
                    "Englisch (Indien)",
                    "Englisch (Indien)",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Englisch (Kanada).<br>
     */
    ENGLISCH_KANADA("en-CA",
                    "2.16.840.1.113883.6.121",
                    "Englisch (Kanada)",
                    "Englisch (Kanada)",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Englisch (Neuseeland).<br>
     */
    ENGLISCH_NEUSEELAND("en-NZ",
                        "2.16.840.1.113883.6.121",
                        "Englisch (Neuseeland)",
                        "Englisch (Neuseeland)",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Englisch (Singapur).<br>
     */
    ENGLISCH_SINGAPUR("en-SG",
                      "2.16.840.1.113883.6.121",
                      "Englisch (Singapur)",
                      "Englisch (Singapur)",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Englisch (US).<br>
     */
    ENGLISCH_US("en-US",
                "2.16.840.1.113883.6.121",
                "Englisch (US)",
                "Englisch (US)",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Finnisch.<br>
     */
    FINNISCH("fi",
             "2.16.840.1.113883.6.121",
             "Finnisch",
             "Finnisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Französisch.<br>
     */
    FRANZ_SISCH("fr",
                "2.16.840.1.113883.6.121",
                "Französisch",
                "Französisch",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Französisch (Belgien).<br>
     */
    FRANZ_SISCH_BELGIEN("fr-BE",
                        "2.16.840.1.113883.6.121",
                        "Französisch (Belgien)",
                        "Französisch (Belgien)",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Französisch (Frankreich).<br>
     */
    FRANZ_SISCH_FRANKREICH("fr-FR",
                           "2.16.840.1.113883.6.121",
                           "Französisch (Frankreich)",
                           "Französisch (Frankreich)",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: Französisch (Schweiz).<br>
     */
    FRANZ_SISCH_SCHWEIZ("fr-CH",
                        "2.16.840.1.113883.6.121",
                        "Französisch (Schweiz)",
                        "Französisch (Schweiz)",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Friesisch.<br>
     */
    FRIESISCH("fy",
              "2.16.840.1.113883.6.121",
              "Friesisch",
              "Friesisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Friesisch (Niederlande).<br>
     */
    FRIESISCH_NIEDERLANDE("fy-NL",
                          "2.16.840.1.113883.6.121",
                          "Friesisch (Niederlande)",
                          "Friesisch (Niederlande)",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: Hindi.<br>
     */
    HINDI("hi",
          "2.16.840.1.113883.6.121",
          "Hindi",
          "Hindi",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Italienisch.<br>
     */
    ITALIENISCH("it",
                "2.16.840.1.113883.6.121",
                "Italienisch",
                "Italienisch",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Italienisch (Italien).<br>
     */
    ITALIENISCH_ITALIEN("it-IT",
                        "2.16.840.1.113883.6.121",
                        "Italienisch (Italien)",
                        "Italienisch (Italien)",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Italienisch (Schweiz).<br>
     */
    ITALIENISCH_SCHWEIZ("it-CH",
                        "2.16.840.1.113883.6.121",
                        "Italienisch (Schweiz)",
                        "Italienisch (Schweiz)",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Japanisch.<br>
     */
    JAPANISCH("ja",
              "2.16.840.1.113883.6.121",
              "Japanisch",
              "Japanisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Koreanisch.<br>
     */
    KOREANISCH("ko",
               "2.16.840.1.113883.6.121",
               "Koreanisch",
               "Koreanisch",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Kroatisch.<br>
     */
    KROATISCH("hr",
              "2.16.840.1.113883.6.121",
              "Kroatisch",
              "Kroatisch",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Neugriechisch.<br>
     */
    NEUGRIECHISCH("el",
                  "2.16.840.1.113883.6.121",
                  "Neugriechisch",
                  "Neugriechisch",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Niederländisch.<br>
     */
    NIEDERL_NDISCH("nl",
                   "2.16.840.1.113883.6.121",
                   "Niederländisch",
                   "Niederländisch",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Niederländisch (Belgien).<br>
     */
    NIEDERL_NDISCH_BELGIEN("nl-BE",
                           "2.16.840.1.113883.6.121",
                           "Niederländisch (Belgien)",
                           "Niederländisch (Belgien)",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: Niederländisch (Niederlande).<br>
     */
    NIEDERL_NDISCH_NIEDERLANDE("nl-NL",
                               "2.16.840.1.113883.6.121",
                               "Niederländisch (Niederlande)",
                               "Niederländisch (Niederlande)",
                               "TOTRANSLATE",
                               "TOTRANSLATE",
                               "TOTRANSLATE"),
    /**
     * EN: Norwegisch.<br>
     */
    NORWEGISCH("no",
               "2.16.840.1.113883.6.121",
               "Norwegisch",
               "Norwegisch",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Norwegisch (Norwegen).<br>
     */
    NORWEGISCH_NORWEGEN("no-NO",
                        "2.16.840.1.113883.6.121",
                        "Norwegisch (Norwegen)",
                        "Norwegisch (Norwegen)",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Pandschabi-Sprache.<br>
     */
    PANDSCHABI_SPRACHE("pa",
                       "2.16.840.1.113883.6.121",
                       "Pandschabi-Sprache",
                       "Pandschabi-Sprache",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Polnisch.<br>
     */
    POLNISCH("pl",
             "2.16.840.1.113883.6.121",
             "Polnisch",
             "Polnisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Portugiesisch.<br>
     */
    PORTUGIESISCH("pt",
                  "2.16.840.1.113883.6.121",
                  "Portugiesisch",
                  "Portugiesisch",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Portugiesisch (Brasilien).<br>
     */
    PORTUGIESISCH_BRASILIEN("pt-BR",
                            "2.16.840.1.113883.6.121",
                            "Portugiesisch (Brasilien)",
                            "Portugiesisch (Brasilien)",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: Russisch.<br>
     */
    RUSSISCH("ru",
             "2.16.840.1.113883.6.121",
             "Russisch",
             "Russisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Russisch (Russland).<br>
     */
    RUSSISCH_RUSSLAND("ru-RU",
                      "2.16.840.1.113883.6.121",
                      "Russisch (Russland)",
                      "Russisch (Russland)",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Schwedisch.<br>
     */
    SCHWEDISCH("sv",
               "2.16.840.1.113883.6.121",
               "Schwedisch",
               "Schwedisch",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Schwedisch (Schweden).<br>
     */
    SCHWEDISCH_SCHWEDEN("sv-SE",
                        "2.16.840.1.113883.6.121",
                        "Schwedisch (Schweden)",
                        "Schwedisch (Schweden)",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Serbisch.<br>
     */
    SERBISCH("sr",
             "2.16.840.1.113883.6.121",
             "Serbisch",
             "Serbisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Serbisch (Serbien).<br>
     */
    SERBISCH_SERBIEN("sr-RS",
                     "2.16.840.1.113883.6.121",
                     "Serbisch (Serbien)",
                     "Serbisch (Serbien)",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Spanisch.<br>
     */
    SPANISCH("es",
             "2.16.840.1.113883.6.121",
             "Spanisch",
             "Spanisch",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Spanisch (Argentinien).<br>
     */
    SPANISCH_ARGENTINIEN("es-AR",
                         "2.16.840.1.113883.6.121",
                         "Spanisch (Argentinien)",
                         "Spanisch (Argentinien)",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Spanish (Spanien).<br>
     */
    SPANISH_SPANIEN("es-ES",
                    "2.16.840.1.113883.6.121",
                    "Spanish (Spanien)",
                    "Spanish (Spanien)",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Spanish (Uruguay).<br>
     */
    SPANISH_URUGUAY("es-UY",
                    "2.16.840.1.113883.6.121",
                    "Spanish (Uruguay)",
                    "Spanish (Uruguay)",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Telugu-Sprache.<br>
     */
    TELUGU_SPRACHE("te",
                   "2.16.840.1.113883.6.121",
                   "Telugu-Sprache",
                   "Telugu-Sprache",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Tschechisch.<br>
     */
    TSCHECHISCH("cs",
                "2.16.840.1.113883.6.121",
                "Tschechisch",
                "Tschechisch",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Österreichisches Deutsch.<br>
     */
    _STERREICHISCHES_DEUTSCH("de-AT",
                             "2.16.840.1.113883.6.121",
                             "Österreichisches Deutsch",
                             "Österreichisches Deutsch",
                             "TOTRANSLATE",
                             "TOTRANSLATE",
                             "TOTRANSLATE");

    /**
     * EN: Code for Arabisch.<br>
     */
    public static final String ARABISCH_CODE = "ar";

    /**
     * EN: Code for Bengali.<br>
     */
    public static final String BENGALI_CODE = "bn";

    /**
     * EN: Code for Chinesisch.<br>
     */
    public static final String CHINESISCH_CODE = "zh";

    /**
     * EN: Code for Chinesisch (China).<br>
     */
    public static final String CHINESISCH_CHINA_CODE = "zh-CN";

    /**
     * EN: Code for Chinesisch (Hong Kong).<br>
     */
    public static final String CHINESISCH_HONG_KONG_CODE = "zh-HK";

    /**
     * EN: Code for Chinesisch (Singapur).<br>
     */
    public static final String CHINESISCH_SINGAPUR_CODE = "zh-SG";

    /**
     * EN: Code for Chinesisch (Taiwan).<br>
     */
    public static final String CHINESISCH_TAIWAN_CODE = "zh-TW";

    /**
     * EN: Code for Deutsch.<br>
     */
    public static final String DEUTSCH_CODE = "de";

    /**
     * EN: Code for Deutsch (Deutschland).<br>
     */
    public static final String DEUTSCH_DEUTSCHLAND_CODE = "de-DE";

    /**
     * EN: Code for Deutsch (Schweiz).<br>
     */
    public static final String DEUTSCH_SCHWEIZ_CODE = "de-CH";

    /**
     * EN: Code for Dänisch.<br>
     */
    public static final String D_NISCH_CODE = "da";

    /**
     * EN: Code for Englisch.<br>
     */
    public static final String ENGLISCH_CODE = "en";

    /**
     * EN: Code for Englisch (Australien).<br>
     */
    public static final String ENGLISCH_AUSTRALIEN_CODE = "en-AU";

    /**
     * EN: Code for Englisch (GB).<br>
     */
    public static final String ENGLISCH_GB_CODE = "en-GB";

    /**
     * EN: Code for Englisch (Indien).<br>
     */
    public static final String ENGLISCH_INDIEN_CODE = "en-IN";

    /**
     * EN: Code for Englisch (Kanada).<br>
     */
    public static final String ENGLISCH_KANADA_CODE = "en-CA";

    /**
     * EN: Code for Englisch (Neuseeland).<br>
     */
    public static final String ENGLISCH_NEUSEELAND_CODE = "en-NZ";

    /**
     * EN: Code for Englisch (Singapur).<br>
     */
    public static final String ENGLISCH_SINGAPUR_CODE = "en-SG";

    /**
     * EN: Code for Englisch (US).<br>
     */
    public static final String ENGLISCH_US_CODE = "en-US";

    /**
     * EN: Code for Finnisch.<br>
     */
    public static final String FINNISCH_CODE = "fi";

    /**
     * EN: Code for Französisch.<br>
     */
    public static final String FRANZ_SISCH_CODE = "fr";

    /**
     * EN: Code for Französisch (Belgien).<br>
     */
    public static final String FRANZ_SISCH_BELGIEN_CODE = "fr-BE";

    /**
     * EN: Code for Französisch (Frankreich).<br>
     */
    public static final String FRANZ_SISCH_FRANKREICH_CODE = "fr-FR";

    /**
     * EN: Code for Französisch (Schweiz).<br>
     */
    public static final String FRANZ_SISCH_SCHWEIZ_CODE = "fr-CH";

    /**
     * EN: Code for Friesisch.<br>
     */
    public static final String FRIESISCH_CODE = "fy";

    /**
     * EN: Code for Friesisch (Niederlande).<br>
     */
    public static final String FRIESISCH_NIEDERLANDE_CODE = "fy-NL";

    /**
     * EN: Code for Hindi.<br>
     */
    public static final String HINDI_CODE = "hi";

    /**
     * EN: Code for Italienisch.<br>
     */
    public static final String ITALIENISCH_CODE = "it";

    /**
     * EN: Code for Italienisch (Italien).<br>
     */
    public static final String ITALIENISCH_ITALIEN_CODE = "it-IT";

    /**
     * EN: Code for Italienisch (Schweiz).<br>
     */
    public static final String ITALIENISCH_SCHWEIZ_CODE = "it-CH";

    /**
     * EN: Code for Japanisch.<br>
     */
    public static final String JAPANISCH_CODE = "ja";

    /**
     * EN: Code for Koreanisch.<br>
     */
    public static final String KOREANISCH_CODE = "ko";

    /**
     * EN: Code for Kroatisch.<br>
     */
    public static final String KROATISCH_CODE = "hr";

    /**
     * EN: Code for Neugriechisch.<br>
     */
    public static final String NEUGRIECHISCH_CODE = "el";

    /**
     * EN: Code for Niederländisch.<br>
     */
    public static final String NIEDERL_NDISCH_CODE = "nl";

    /**
     * EN: Code for Niederländisch (Belgien).<br>
     */
    public static final String NIEDERL_NDISCH_BELGIEN_CODE = "nl-BE";

    /**
     * EN: Code for Niederländisch (Niederlande).<br>
     */
    public static final String NIEDERL_NDISCH_NIEDERLANDE_CODE = "nl-NL";

    /**
     * EN: Code for Norwegisch.<br>
     */
    public static final String NORWEGISCH_CODE = "no";

    /**
     * EN: Code for Norwegisch (Norwegen).<br>
     */
    public static final String NORWEGISCH_NORWEGEN_CODE = "no-NO";

    /**
     * EN: Code for Pandschabi-Sprache.<br>
     */
    public static final String PANDSCHABI_SPRACHE_CODE = "pa";

    /**
     * EN: Code for Polnisch.<br>
     */
    public static final String POLNISCH_CODE = "pl";

    /**
     * EN: Code for Portugiesisch.<br>
     */
    public static final String PORTUGIESISCH_CODE = "pt";

    /**
     * EN: Code for Portugiesisch (Brasilien).<br>
     */
    public static final String PORTUGIESISCH_BRASILIEN_CODE = "pt-BR";

    /**
     * EN: Code for Russisch.<br>
     */
    public static final String RUSSISCH_CODE = "ru";

    /**
     * EN: Code for Russisch (Russland).<br>
     */
    public static final String RUSSISCH_RUSSLAND_CODE = "ru-RU";

    /**
     * EN: Code for Schwedisch.<br>
     */
    public static final String SCHWEDISCH_CODE = "sv";

    /**
     * EN: Code for Schwedisch (Schweden).<br>
     */
    public static final String SCHWEDISCH_SCHWEDEN_CODE = "sv-SE";

    /**
     * EN: Code for Serbisch.<br>
     */
    public static final String SERBISCH_CODE = "sr";

    /**
     * EN: Code for Serbisch (Serbien).<br>
     */
    public static final String SERBISCH_SERBIEN_CODE = "sr-RS";

    /**
     * EN: Code for Spanisch.<br>
     */
    public static final String SPANISCH_CODE = "es";

    /**
     * EN: Code for Spanisch (Argentinien).<br>
     */
    public static final String SPANISCH_ARGENTINIEN_CODE = "es-AR";

    /**
     * EN: Code for Spanish (Spanien).<br>
     */
    public static final String SPANISH_SPANIEN_CODE = "es-ES";

    /**
     * EN: Code for Spanish (Uruguay).<br>
     */
    public static final String SPANISH_URUGUAY_CODE = "es-UY";

    /**
     * EN: Code for Telugu-Sprache.<br>
     */
    public static final String TELUGU_SPRACHE_CODE = "te";

    /**
     * EN: Code for Tschechisch.<br>
     */
    public static final String TSCHECHISCH_CODE = "cs";

    /**
     * EN: Code for Österreichisches Deutsch.<br>
     */
    public static final String _STERREICHISCHES_DEUTSCH_CODE = "de-AT";

    /**
     * Identifier of the value set.
     */
    public static final String VALUE_SET_ID = "1.2.40.0.34.10.10";

    /**
     * Name of the value set.
     */
    public static final String VALUE_SET_NAME = "atcdabbr_LanguageCode";

    /**
     * Identifier of the code system (all values share the same).
     */
    public static final String CODE_SYSTEM_ID = "2.16.840.1.113883.6.121";

    /**
     * Gets the Enum with a given code.
     *
     * @param code The code value.
     * @return the enum value found or {@code null}.
     */
    @Nullable
    public static AtcdabbrLanguageCode getEnum(@Nullable final String code) {
        for (final AtcdabbrLanguageCode x : values()) {
            if (x.getCodeValue().equals(code)) {
                return x;
            }
        }
        return null;
    }

    /**
     * Checks if a given enum is part of this value set.
     *
     * @param enumName The name of the enum.
     * @return {@code true} if the name is found in this value set, {@code false} otherwise.
     */
    public static boolean isEnumOfValueSet(@Nullable final String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(AtcdabbrLanguageCode.class,
                         enumName);
            return true;
        } catch (final IllegalArgumentException ex) {
            return false;
        }
    }

    /**
     * Checks if a given code value is in this value set.
     *
     * @param codeValue The code value.
     * @return {@code true} if the value is found in this value set, {@code false} otherwise.
     */
    public static boolean isInValueSet(@Nullable final String codeValue) {
        for (final AtcdabbrLanguageCode x : values()) {
            if (x.getCodeValue().equals(codeValue)) {
                return true;
            }
        }
        return false;
    }

    /**
     * Machine interpretable and (inside this class) unique code.
     */
    @NonNull
    private final String code;

    /**
     * Identifier of the referencing code system.
     */
    @NonNull
    private final String codeSystem;

    /**
     * The display names per language. It's always stored in the given order: default display name (0), in English (1),
     * in German (2), in French (3) and in Italian (4).
     */
    @NonNull
    private final String[] displayNames;

    /**
     * Instantiates this enum with a given code and display names.
     *
     * @param code          The code value.
     * @param codeSystem    The code system (OID).
     * @param displayName   The default display name.
     * @param displayNameEn The display name in English.
     * @param displayNameDe The display name in German.
     * @param displayNameFr The display name in French.
     * @param displayNameIt The display name in Italian.
     */
    AtcdabbrLanguageCode(@NonNull final String code, @NonNull final String codeSystem, @NonNull final String displayName, @NonNull final String displayNameEn, @NonNull final String displayNameDe, @NonNull final String displayNameFr, @NonNull final String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    /**
     * Gets the code system identifier.
     *
     * @return the code system identifier.
     */
    @Override
    @NonNull
    public String getCodeSystemId() {
        return this.codeSystem;
    }

    /**
     * Gets the code system name.
     *
     * @return the code system name.
     */
    @Override
    @NonNull
    public String getCodeSystemName() {
        final var codeSystem = CodeSystems.getEnum(this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    /**
     * Gets the code value as a string.
     *
     * @return the code value.
     */
    @Override
    @NonNull
    public String getCodeValue() {
        return this.code;
    }

    /**
     * Gets the display name defined by the language param.
     *
     * @param languageCode The language code to get the display name for, {@code null} to get the default display name.
     * @return the display name in the desired language.
     */
    @Override
    @NonNull
    public String getDisplayName(@Nullable final LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch(languageCode) {
            case ENGLISH ->
                this.displayNames[1];
            case GERMAN ->
                this.displayNames[2];
            case FRENCH ->
                this.displayNames[3];
            case ITALIAN ->
                this.displayNames[4];
            default ->
                "TOTRANSLATE";
        };
    }

    /**
     * Gets the value set identifier.
     *
     * @return the value set identifier.
     */
    @Override
    @NonNull
    public String getValueSetId() {
        return VALUE_SET_ID;
    }

    /**
     * Gets the value set name.
     *
     * @return the value set name.
     */
    @Override
    @NonNull
    public String getValueSetName() {
        return VALUE_SET_NAME;
    }
}
