/*
 * This code is made available under the terms of the Eclipse Public License v1.0
 * in the github project https://github.com/project-husky/husky there you also
 * find a list of the contributors and the license information.
 *
 * This project has been developed further and modified by the joined working group Husky
 * on the basis of the eHealth Connector opensource project from June 28, 2021,
 * whereas medshare GmbH is the initial and main contributor/author of the eHealth Connector.
 */
package org.projecthusky.cda.elga.generated.artdecor.ems.enums;

import java.util.Objects;
import javax.annotation.processing.Generated;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

/**
 * Enumeration of epims_VS_KlinischeManifestation values
 * <p>
 * EN: No designation found.<br>
 * DE: No designation found.<br>
 * FR: No designation found.<br>
 * IT: No designation found.<br>
 * <p>
 * Identifier: 1.2.40.0.34.6.0.10.25<br>
 * Effective date: 2021-01-21 16:05<br>
 * Version: 202101<br>
 * Status: DRAFT
 */
@Generated(value = "org.projecthusky.codegenerator.ch.valuesets.UpdateValueSets", date = "2022-02-01")
public enum EpimsVsKlinischeManifestation implements ValueSetEnumInterface {

    /**
     * EN: Acute respiratory distress syndrome (disorder) .<br>
     */
    ACUTE_RESPIRATORY_DISTRESS_SYNDROME_DISORDER("67782005",
                                                 "2.16.840.1.113883.6.96",
                                                 "Acute respiratory distress syndrome (disorder) ",
                                                 "Acute respiratory distress syndrome (disorder) ",
                                                 "TOTRANSLATE",
                                                 "TOTRANSLATE",
                                                 "TOTRANSLATE"),
    /**
     * EN: akute respiratorische Symptome inkl. Husten ohne Fieber.<br>
     */
    AKUTE_RESPIRATORISCHE_SYMPTOME_INKL_HUSTEN_OHNE_FIEBER("ars_inkHusten_exFieber",
                                                           "1.2.40.0.34.5.109",
                                                           "akute respiratorische Symptome inkl. Husten ohne Fieber",
                                                           "akute respiratorische Symptome inkl. Husten ohne Fieber",
                                                           "TOTRANSLATE",
                                                           "TOTRANSLATE",
                                                           "TOTRANSLATE"),
    /**
     * EN: akute respiratorische Symptome inkl. Husten und Fieber 38°C oder mehr.<br>
     */
    AKUTE_RESPIRATORISCHE_SYMPTOME_INKL_HUSTEN_UND_FIEBER_38_C_ODER_MEHR("ars_inkHusten_inkFieber",
                                                                         "1.2.40.0.34.5.109",
                                                                         "akute respiratorische Symptome inkl. Husten und Fieber 38°C oder mehr",
                                                                         "akute respiratorische Symptome inkl. Husten und Fieber 38°C oder mehr",
                                                                         "TOTRANSLATE",
                                                                         "TOTRANSLATE",
                                                                         "TOTRANSLATE"),
    /**
     * EN: akute respiratorische Symptome mit Fieber 38°C oder mehr und ohne Husten.<br>
     */
    AKUTE_RESPIRATORISCHE_SYMPTOME_MIT_FIEBER_38_C_ODER_MEHR_UND_OHNE_HUSTEN("ars_exHuster_inkFieber",
                                                                             "1.2.40.0.34.5.109",
                                                                             "akute respiratorische Symptome mit Fieber 38°C oder mehr und ohne Husten",
                                                                             "akute respiratorische Symptome mit Fieber 38°C oder mehr und ohne Husten",
                                                                             "TOTRANSLATE",
                                                                             "TOTRANSLATE",
                                                                             "TOTRANSLATE"),
    /**
     * EN: akute respiratorische Symptome ohne Husten und ohne Fieber.<br>
     */
    AKUTE_RESPIRATORISCHE_SYMPTOME_OHNE_HUSTEN_UND_OHNE_FIEBER("ars_exHuster_exFieber",
                                                               "1.2.40.0.34.5.109",
                                                               "akute respiratorische Symptome ohne Husten und ohne Fieber",
                                                               "akute respiratorische Symptome ohne Husten und ohne Fieber",
                                                               "TOTRANSLATE",
                                                               "TOTRANSLATE",
                                                               "TOTRANSLATE"),
    /**
     * EN: Asymptomatic West Nile virus infection (disorder) .<br>
     */
    ASYMPTOMATIC_WEST_NILE_VIRUS_INFECTION_DISORDER("763018002",
                                                    "2.16.840.1.113883.6.96",
                                                    "Asymptomatic West Nile virus infection (disorder) ",
                                                    "Asymptomatic West Nile virus infection (disorder) ",
                                                    "TOTRANSLATE",
                                                    "TOTRANSLATE",
                                                    "TOTRANSLATE"),
    /**
     * EN: Asymptomatisch .<br>
     */
    ASYMPTOMATISCH("ASYMPTOMATISCH",
                   "1.2.40.0.34.5.105",
                   "Asymptomatisch ",
                   "Asymptomatisch ",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Bacterial pneumonia (disorder).<br>
     */
    BACTERIAL_PNEUMONIA_DISORDER("53084003",
                                 "2.16.840.1.113883.6.96",
                                 "Bacterial pneumonia (disorder)",
                                 "Bacterial pneumonia (disorder)",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE"),
    /**
     * EN: Congenital infection caused by Zika virus (disorder) .<br>
     */
    CONGENITAL_INFECTION_CAUSED_BY_ZIKA_VIRUS_DISORDER("762725007",
                                                       "2.16.840.1.113883.6.96",
                                                       "Congenital infection caused by Zika virus (disorder) ",
                                                       "Congenital infection caused by Zika virus (disorder) ",
                                                       "TOTRANSLATE",
                                                       "TOTRANSLATE",
                                                       "TOTRANSLATE"),
    /**
     * EN: Dengue-Fieber, schwere Verlaufsform.<br>
     */
    DENGUE_FIEBER_SCHWERE_VERLAUFSFORM("DengueSchwerVerlauf",
                                       "1.2.40.0.34.5.109",
                                       "Dengue-Fieber, schwere Verlaufsform",
                                       "Dengue-Fieber, schwere Verlaufsform",
                                       "TOTRANSLATE",
                                       "TOTRANSLATE",
                                       "TOTRANSLATE"),
    /**
     * EN: Diarrhea (finding).<br>
     */
    DIARRHEA_FINDING("62315008",
                     "2.16.840.1.113883.6.96",
                     "Diarrhea (finding)",
                     "Diarrhea (finding)",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Diphtheria of respiratory system (disorder).<br>
     */
    DIPHTHERIA_OF_RESPIRATORY_SYSTEM_DISORDER("715659006",
                                              "2.16.840.1.113883.6.96",
                                              "Diphtheria of respiratory system (disorder)",
                                              "Diphtheria of respiratory system (disorder)",
                                              "TOTRANSLATE",
                                              "TOTRANSLATE",
                                              "TOTRANSLATE"),
    /**
     * EN: Disorder of respiratory system (disorder).<br>
     */
    DISORDER_OF_RESPIRATORY_SYSTEM_DISORDER("50043002",
                                            "2.16.840.1.113883.6.96",
                                            "Disorder of respiratory system (disorder)",
                                            "Disorder of respiratory system (disorder)",
                                            "TOTRANSLATE",
                                            "TOTRANSLATE",
                                            "TOTRANSLATE"),
    /**
     * EN: Epiglottitis (disorder).<br>
     */
    EPIGLOTTITIS_DISORDER("80384002",
                          "2.16.840.1.113883.6.96",
                          "Epiglottitis (disorder)",
                          "Epiglottitis (disorder)",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: Hautdiphterie.<br>
     */
    HAUTDIPHTERIE("Hautdiphterie",
                  "1.2.40.0.34.5.109",
                  "Hautdiphterie",
                  "Hautdiphterie",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Hemolytic uremic syndrome (disorder).<br>
     */
    HEMOLYTIC_UREMIC_SYNDROME_DISORDER("111407006",
                                       "2.16.840.1.113883.6.96",
                                       "Hemolytic uremic syndrome (disorder)",
                                       "Hemolytic uremic syndrome (disorder)",
                                       "TOTRANSLATE",
                                       "TOTRANSLATE",
                                       "TOTRANSLATE"),
    /**
     * EN: Loss of sense of smell (finding).<br>
     */
    LOSS_OF_SENSE_OF_SMELL_FINDING("44169009",
                                   "2.16.840.1.113883.6.96",
                                   "Loss of sense of smell (finding)",
                                   "Loss of sense of smell (finding)",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE",
                                   "TOTRANSLATE"),
    /**
     * EN: Loss of taste (finding).<br>
     */
    LOSS_OF_TASTE_FINDING("36955009",
                          "2.16.840.1.113883.6.96",
                          "Loss of taste (finding)",
                          "Loss of taste (finding)",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: Meningitis (disorder).<br>
     */
    MENINGITIS_DISORDER("7180009",
                        "2.16.840.1.113883.6.96",
                        "Meningitis (disorder)",
                        "Meningitis (disorder)",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Osteomyelitis/septische Arthritis.<br>
     */
    OSTEOMYELITIS_SEPTISCHE_ARTHRITIS("Osteomyelitis/septischeArthritis",
                                      "1.2.40.0.34.5.109",
                                      "Osteomyelitis/septische Arthritis",
                                      "Osteomyelitis/septische Arthritis",
                                      "TOTRANSLATE",
                                      "TOTRANSLATE",
                                      "TOTRANSLATE"),
    /**
     * EN: Other (qualifier value).<br>
     */
    OTHER_QUALIFIER_VALUE("74964007",
                          "2.16.840.1.113883.6.96",
                          "Other (qualifier value)",
                          "Other (qualifier value)",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: Pneumonia (disorder).<br>
     */
    PNEUMONIA_DISORDER("233604007",
                       "2.16.840.1.113883.6.96",
                       "Pneumonia (disorder)",
                       "Pneumonia (disorder)",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Sepsis (disorder).<br>
     */
    SEPSIS_DISORDER("91302008",
                    "2.16.840.1.113883.6.96",
                    "Sepsis (disorder)",
                    "Sepsis (disorder)",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE");

    /**
     * EN: Code for Acute respiratory distress syndrome (disorder) .<br>
     */
    public static final String ACUTE_RESPIRATORY_DISTRESS_SYNDROME_DISORDER_CODE = "67782005";

    /**
     * EN: Code for akute respiratorische Symptome inkl. Husten ohne Fieber.<br>
     */
    public static final String AKUTE_RESPIRATORISCHE_SYMPTOME_INKL_HUSTEN_OHNE_FIEBER_CODE = "ars_inkHusten_exFieber";

    /**
     * EN: Code for akute respiratorische Symptome inkl. Husten und Fieber 38°C oder mehr.<br>
     */
    public static final String AKUTE_RESPIRATORISCHE_SYMPTOME_INKL_HUSTEN_UND_FIEBER_38_C_ODER_MEHR_CODE = "ars_inkHusten_inkFieber";

    /**
     * EN: Code for akute respiratorische Symptome mit Fieber 38°C oder mehr und ohne Husten.<br>
     */
    public static final String AKUTE_RESPIRATORISCHE_SYMPTOME_MIT_FIEBER_38_C_ODER_MEHR_UND_OHNE_HUSTEN_CODE = "ars_exHuster_inkFieber";

    /**
     * EN: Code for akute respiratorische Symptome ohne Husten und ohne Fieber.<br>
     */
    public static final String AKUTE_RESPIRATORISCHE_SYMPTOME_OHNE_HUSTEN_UND_OHNE_FIEBER_CODE = "ars_exHuster_exFieber";

    /**
     * EN: Code for Asymptomatic West Nile virus infection (disorder) .<br>
     */
    public static final String ASYMPTOMATIC_WEST_NILE_VIRUS_INFECTION_DISORDER_CODE = "763018002";

    /**
     * EN: Code for Asymptomatisch .<br>
     */
    public static final String ASYMPTOMATISCH_CODE = "ASYMPTOMATISCH";

    /**
     * EN: Code for Bacterial pneumonia (disorder).<br>
     */
    public static final String BACTERIAL_PNEUMONIA_DISORDER_CODE = "53084003";

    /**
     * EN: Code for Congenital infection caused by Zika virus (disorder) .<br>
     */
    public static final String CONGENITAL_INFECTION_CAUSED_BY_ZIKA_VIRUS_DISORDER_CODE = "762725007";

    /**
     * EN: Code for Dengue-Fieber, schwere Verlaufsform.<br>
     */
    public static final String DENGUE_FIEBER_SCHWERE_VERLAUFSFORM_CODE = "DengueSchwerVerlauf";

    /**
     * EN: Code for Diarrhea (finding).<br>
     */
    public static final String DIARRHEA_FINDING_CODE = "62315008";

    /**
     * EN: Code for Diphtheria of respiratory system (disorder).<br>
     */
    public static final String DIPHTHERIA_OF_RESPIRATORY_SYSTEM_DISORDER_CODE = "715659006";

    /**
     * EN: Code for Disorder of respiratory system (disorder).<br>
     */
    public static final String DISORDER_OF_RESPIRATORY_SYSTEM_DISORDER_CODE = "50043002";

    /**
     * EN: Code for Epiglottitis (disorder).<br>
     */
    public static final String EPIGLOTTITIS_DISORDER_CODE = "80384002";

    /**
     * EN: Code for Hautdiphterie.<br>
     */
    public static final String HAUTDIPHTERIE_CODE = "Hautdiphterie";

    /**
     * EN: Code for Hemolytic uremic syndrome (disorder).<br>
     */
    public static final String HEMOLYTIC_UREMIC_SYNDROME_DISORDER_CODE = "111407006";

    /**
     * EN: Code for Loss of sense of smell (finding).<br>
     */
    public static final String LOSS_OF_SENSE_OF_SMELL_FINDING_CODE = "44169009";

    /**
     * EN: Code for Loss of taste (finding).<br>
     */
    public static final String LOSS_OF_TASTE_FINDING_CODE = "36955009";

    /**
     * EN: Code for Meningitis (disorder).<br>
     */
    public static final String MENINGITIS_DISORDER_CODE = "7180009";

    /**
     * EN: Code for Osteomyelitis/septische Arthritis.<br>
     */
    public static final String OSTEOMYELITIS_SEPTISCHE_ARTHRITIS_CODE = "Osteomyelitis/septischeArthritis";

    /**
     * EN: Code for Other (qualifier value).<br>
     */
    public static final String OTHER_QUALIFIER_VALUE_CODE = "74964007";

    /**
     * EN: Code for Pneumonia (disorder).<br>
     */
    public static final String PNEUMONIA_DISORDER_CODE = "233604007";

    /**
     * EN: Code for Sepsis (disorder).<br>
     */
    public static final String SEPSIS_DISORDER_CODE = "91302008";

    /**
     * Identifier of the value set.
     */
    public static final String VALUE_SET_ID = "1.2.40.0.34.6.0.10.25";

    /**
     * Name of the value set.
     */
    public static final String VALUE_SET_NAME = "epims_VS_KlinischeManifestation";

    /**
     * Gets the Enum with a given code.
     *
     * @param code The code value.
     * @return the enum value found or {@code null}.
     */
    @Nullable
    public static EpimsVsKlinischeManifestation getEnum(@Nullable final String code) {
        for (final EpimsVsKlinischeManifestation x : values()) {
            if (x.getCodeValue().equals(code)) {
                return x;
            }
        }
        return null;
    }

    /**
     * Checks if a given enum is part of this value set.
     *
     * @param enumName The name of the enum.
     * @return {@code true} if the name is found in this value set, {@code false} otherwise.
     */
    public static boolean isEnumOfValueSet(@Nullable final String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(EpimsVsKlinischeManifestation.class,
                         enumName);
            return true;
        } catch (final IllegalArgumentException ex) {
            return false;
        }
    }

    /**
     * Checks if a given code value is in this value set.
     *
     * @param codeValue The code value.
     * @return {@code true} if the value is found in this value set, {@code false} otherwise.
     */
    public static boolean isInValueSet(@Nullable final String codeValue) {
        for (final EpimsVsKlinischeManifestation x : values()) {
            if (x.getCodeValue().equals(codeValue)) {
                return true;
            }
        }
        return false;
    }

    /**
     * Machine interpretable and (inside this class) unique code.
     */
    @NonNull
    private final String code;

    /**
     * Identifier of the referencing code system.
     */
    @NonNull
    private final String codeSystem;

    /**
     * The display names per language. It's always stored in the given order: default display name (0), in English (1),
     * in German (2), in French (3) and in Italian (4).
     */
    @NonNull
    private final String[] displayNames;

    /**
     * Instantiates this enum with a given code and display names.
     *
     * @param code          The code value.
     * @param codeSystem    The code system (OID).
     * @param displayName   The default display name.
     * @param displayNameEn The display name in English.
     * @param displayNameDe The display name in German.
     * @param displayNameFr The display name in French.
     * @param displayNameIt The display name in Italian.
     */
    EpimsVsKlinischeManifestation(@NonNull final String code, @NonNull final String codeSystem, @NonNull final String displayName, @NonNull final String displayNameEn, @NonNull final String displayNameDe, @NonNull final String displayNameFr, @NonNull final String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    /**
     * Gets the code system identifier.
     *
     * @return the code system identifier.
     */
    @Override
    @NonNull
    public String getCodeSystemId() {
        return this.codeSystem;
    }

    /**
     * Gets the code system name.
     *
     * @return the code system name.
     */
    @Override
    @NonNull
    public String getCodeSystemName() {
        final var codeSystem = CodeSystems.getEnum(this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    /**
     * Gets the code value as a string.
     *
     * @return the code value.
     */
    @Override
    @NonNull
    public String getCodeValue() {
        return this.code;
    }

    /**
     * Gets the display name defined by the language param.
     *
     * @param languageCode The language code to get the display name for, {@code null} to get the default display name.
     * @return the display name in the desired language.
     */
    @Override
    @NonNull
    public String getDisplayName(@Nullable final LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch(languageCode) {
            case ENGLISH ->
                this.displayNames[1];
            case GERMAN ->
                this.displayNames[2];
            case FRENCH ->
                this.displayNames[3];
            case ITALIAN ->
                this.displayNames[4];
            default ->
                "TOTRANSLATE";
        };
    }

    /**
     * Gets the value set identifier.
     *
     * @return the value set identifier.
     */
    @Override
    @NonNull
    public String getValueSetId() {
        return VALUE_SET_ID;
    }

    /**
     * Gets the value set name.
     *
     * @return the value set name.
     */
    @Override
    @NonNull
    public String getValueSetName() {
        return VALUE_SET_NAME;
    }
}
