/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.ems;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.projecthusky.common.basetypes.CodeBaseType;
import org.projecthusky.common.hl7cdar2.ANY;
import org.projecthusky.common.hl7cdar2.BL;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.CS;
import org.projecthusky.common.hl7cdar2.CV;
import org.projecthusky.common.hl7cdar2.ED;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.INT;
import org.projecthusky.common.hl7cdar2.IVLINT;
import org.projecthusky.common.hl7cdar2.IVLPQ;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.ObjectFactory;
import org.projecthusky.common.hl7cdar2.POCDMT000040EntryRelationship;
import org.projecthusky.common.hl7cdar2.POCDMT000040Observation;
import org.projecthusky.common.hl7cdar2.POCDMT000040Organizer;
import org.projecthusky.common.hl7cdar2.POCDMT000040Participant2;
import org.projecthusky.common.hl7cdar2.POCDMT000040Performer2;
import org.projecthusky.common.hl7cdar2.POCDMT000040ReferenceRange;
import org.projecthusky.common.hl7cdar2.PQ;
import org.projecthusky.common.hl7cdar2.RTO;
import org.projecthusky.common.hl7cdar2.RTOPQPQ;
import org.projecthusky.common.hl7cdar2.RTOQTYQTY;
import org.projecthusky.common.hl7cdar2.ST;
import org.projecthusky.common.hl7cdar2.TS;
import org.projecthusky.common.hl7cdar2.XActMoodDocumentObservation;
import org.projecthusky.common.model.Code;

public class LaboratoryObservation
extends POCDMT000040Observation {
    private final List<Code> vocabStatusCodeCode = new ArrayList<Code>();

    public LaboratoryObservation() {
        super.getClassCode().add("OBS");
        super.setMoodCode(XActMoodDocumentObservation.EVN);
        super.getTemplateId().add(LaboratoryObservation.createHl7TemplateIdFixedValue("1.3.6.1.4.1.19376.1.3.1.6"));
        super.setCode((CD)LaboratoryObservation.createHl7CodeFixedValue());
        this.vocabStatusCodeCode.add(new Code(CodeBaseType.builder().withCode("completed").build()));
        this.vocabStatusCodeCode.add(new Code(CodeBaseType.builder().withCode("aborted").build()));
    }

    public void addHl7EntryRelationship(POCDMT000040EntryRelationship value) {
        this.entryRelationship.add(value);
    }

    public void addHl7InterpretationCode(CE value) {
        this.interpretationCode.add(value);
    }

    public void addHl7Performer(POCDMT000040Performer2 value) {
        this.getPerformer().add(value);
    }

    public void addHl7ReferenceRange(POCDMT000040ReferenceRange value) {
        this.referenceRange.add(value);
    }

    public void clearHl7Performer() {
        this.getPerformer().clear();
    }

    private static CE createHl7CodeFixedValue() {
        ObjectFactory factory = new ObjectFactory();
        CE retVal = factory.createCE();
        return retVal;
    }

    private static POCDMT000040Organizer createHl7EntryRelationshipFixedValue(String typeCode, String inversionInd) {
        POCDMT000040Organizer retVal = new POCDMT000040Organizer();
        return retVal;
    }

    private static CE createHl7InterpretationCodeFixedValue() {
        CE retVal = new CE();
        return retVal;
    }

    private static POCDMT000040Participant2 createHl7ParticipantFixedValue(String typeCode) {
        ObjectFactory factory = new ObjectFactory();
        POCDMT000040Participant2 retVal = factory.createPOCDMT000040Participant2();
        retVal.getTypeCode().add(typeCode);
        return retVal;
    }

    private static POCDMT000040Organizer createHl7ReferenceRangeFixedValue(String typeCode) {
        POCDMT000040Organizer retVal = new POCDMT000040Organizer();
        return retVal;
    }

    private static II createHl7TemplateIdFixedValue(String root) {
        ObjectFactory factory = new ObjectFactory();
        II retVal = factory.createII();
        retVal.setRoot(root);
        return retVal;
    }

    public CE getHl7Code() {
        return (CE)this.code;
    }

    public IVLTS getHl7EffectiveTime() {
        return this.effectiveTime;
    }

    public List<II> getHl7Id() {
        return this.id;
    }

    public List<POCDMT000040Participant2> getHl7Participant() {
        return this.participant;
    }

    public CS getHl7StatusCode() {
        return this.statusCode;
    }

    public List<II> getHl7TemplateId() {
        return this.templateId;
    }

    public ED getHl7Text() {
        return this.text;
    }

    public ANY getHl7ValuePq() {
        if (this.value != null && !this.value.isEmpty()) {
            return (ANY)this.value.get(0);
        }
        return null;
    }

    public static POCDMT000040Organizer getPredefinedEntryRelationshipCompNull() {
        return LaboratoryObservation.createHl7EntryRelationshipFixedValue("COMP", null);
    }

    public static CE getPredefinedInterpretationCode() {
        return LaboratoryObservation.createHl7InterpretationCodeFixedValue();
    }

    public static POCDMT000040Participant2 getPredefinedParticipantAuthen() {
        return LaboratoryObservation.createHl7ParticipantFixedValue("AUTHEN");
    }

    public static POCDMT000040Organizer getPredefinedReferenceRangeRefv() {
        return LaboratoryObservation.createHl7ReferenceRangeFixedValue("REFV");
    }

    public List<Code> getVocabStatusCodeCode() {
        return this.vocabStatusCodeCode;
    }

    public void setHl7Code(CE value) {
        this.code = value;
    }

    public void setHl7EffectiveTime(IVLTS value) {
        this.effectiveTime = value;
    }

    public void setHl7Id(II value) {
        this.getId().clear();
        this.getId().add(value);
    }

    public void setHl7Participant(POCDMT000040Participant2 value) {
        this.getParticipant().clear();
        this.getParticipant().add(value);
    }

    public void setHl7StatusCode(CS value) {
        this.statusCode = value;
    }

    public void setHl7TemplateId(II value) {
        this.getTemplateId().clear();
        this.getTemplateId().add(value);
    }

    public void setHl7Text(ED value) {
        this.text = value;
    }

    public void setHl7Value(PQ value) {
        this.setHl7AnyValue((ANY)value);
    }

    public void setHl7Value(IVLPQ value) {
        this.setHl7AnyValue((ANY)value);
    }

    public void setHl7Value(INT value) {
        this.setHl7AnyValue((ANY)value);
    }

    public void setHl7Value(IVLINT value) {
        this.setHl7AnyValue((ANY)value);
    }

    public void setHl7Value(BL value) {
        this.setHl7AnyValue((ANY)value);
    }

    public void setHl7Value(ST value) {
        this.setHl7AnyValue((ANY)value);
    }

    public void setHl7Value(CV value) {
        this.setHl7AnyValue((ANY)value);
    }

    public void setHl7Value(TS value) {
        this.setHl7AnyValue((ANY)value);
    }

    public void setHl7Value(CD value) {
        this.setHl7AnyValue((ANY)value);
    }

    public void setHl7Value(RTO value) {
        this.setHl7AnyValue((ANY)value);
    }

    public void setHl7Value(RTOQTYQTY value) {
        this.setHl7AnyValue((ANY)value);
    }

    public void setHl7Value(RTOPQPQ value) {
        this.setHl7AnyValue((ANY)value);
    }

    private void setHl7AnyValue(ANY value) {
        if (this.value == null) {
            this.value = new LinkedList();
        }
        this.value.clear();
        this.value.add(value);
    }
}

