/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.ps;

import java.util.List;
import org.projecthusky.common.hl7cdar2.ActClassSupply;
import org.projecthusky.common.hl7cdar2.ED;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.ObjectFactory;
import org.projecthusky.common.hl7cdar2.POCDMT000040Author;
import org.projecthusky.common.hl7cdar2.POCDMT000040Informant12;
import org.projecthusky.common.hl7cdar2.POCDMT000040Participant2;
import org.projecthusky.common.hl7cdar2.POCDMT000040Reference;
import org.projecthusky.common.hl7cdar2.POCDMT000040Supply;
import org.projecthusky.common.hl7cdar2.SXCMTS;
import org.projecthusky.common.hl7cdar2.XDocumentSubstanceMood;

public class ElgamedicalDevice
extends POCDMT000040Supply {
    public ElgamedicalDevice() {
        super.setClassCode(ActClassSupply.SPLY);
        super.setMoodCode(XDocumentSubstanceMood.EVN);
        super.getTemplateId().add(ElgamedicalDevice.createHl7TemplateIdFixedValue("1.2.40.0.34.11.13.3.8"));
        super.getParticipant().add(ElgamedicalDevice.createHl7ParticipantFixedValue("DEV"));
    }

    public void addHl7Author(POCDMT000040Author value) {
        this.getAuthor().add(value);
    }

    public void addHl7Id(II value) {
        this.getId().add(value);
    }

    public void addHl7Informant(POCDMT000040Informant12 value) {
        this.getInformant().add(value);
    }

    public void clearHl7Author() {
        this.getAuthor().clear();
    }

    public void clearHl7Id() {
        this.getId().clear();
    }

    public void clearHl7Informant() {
        this.getInformant().clear();
    }

    private static POCDMT000040Participant2 createHl7ParticipantFixedValue(String typeCode) {
        ObjectFactory factory = new ObjectFactory();
        POCDMT000040Participant2 retVal = factory.createPOCDMT000040Participant2();
        retVal.getTypeCode().add(typeCode);
        return retVal;
    }

    private static II createHl7TemplateIdFixedValue(String root) {
        ObjectFactory factory = new ObjectFactory();
        II retVal = factory.createII();
        retVal.setRoot(root);
        return retVal;
    }

    public List<SXCMTS> getHl7EffectiveTime() {
        return this.effectiveTime;
    }

    public List<POCDMT000040Participant2> getHl7Participant() {
        return this.participant;
    }

    public List<POCDMT000040Reference> getHl7Reference() {
        return this.reference;
    }

    public List<II> getHl7TemplateId() {
        return this.templateId;
    }

    public ED getHl7Text() {
        return this.text;
    }

    public void setHl7EffectiveTime(IVLTS value) {
        this.getEffectiveTime().clear();
        this.getEffectiveTime().add(value);
    }

    public void setHl7Participant(POCDMT000040Participant2 value) {
        this.getParticipant().clear();
        this.getParticipant().add(value);
    }

    public void setHl7Reference(POCDMT000040Reference value) {
        this.getReference().clear();
        this.getReference().add(value);
    }

    public void setHl7TemplateId(II value) {
        this.getTemplateId().clear();
        this.getTemplateId().add(value);
    }

    public void setHl7Text(ED value) {
        this.text = value;
    }
}

