/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.ps.enums;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum ElgaCurrentSmokingStatus implements ValueSetEnumInterface
{
    EX_SMOKER("8517006", "2.16.840.1.113883.6.96", "Ex-smoker", "Ex-smoker", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    NEVER_SMOKED_TOBACCO("266919005", "2.16.840.1.113883.6.96", "Never smoked tobacco", "Never smoked tobacco", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    OCCASIONAL_TOBACCO_SMOKER("428041000124106", "2.16.840.1.113883.6.96", "Occasional tobacco smoker", "Occasional tobacco smoker", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    SMOKER("77176002", "2.16.840.1.113883.6.96", "Smoker", "Smoker", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    SMOKES_TOBACCO_DAILY("449868002", "2.16.840.1.113883.6.96", "Smokes tobacco daily", "Smokes tobacco daily", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    TOBACCO_SMOKING_CONSUMPTION_UNKNOWN("266927001", "2.16.840.1.113883.6.96", "Tobacco smoking consumption unknown", "Tobacco smoking consumption unknown", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE");

    public static final String EX_SMOKER_CODE = "8517006";
    public static final String NEVER_SMOKED_TOBACCO_CODE = "266919005";
    public static final String OCCASIONAL_TOBACCO_SMOKER_CODE = "428041000124106";
    public static final String SMOKER_CODE = "77176002";
    public static final String SMOKES_TOBACCO_DAILY_CODE = "449868002";
    public static final String TOBACCO_SMOKING_CONSUMPTION_UNKNOWN_CODE = "266927001";
    public static final String VALUE_SET_ID = "1.2.40.0.34.10.204";
    public static final String VALUE_SET_NAME = "ELGA_CurrentSmokingStatus";
    public static final String CODE_SYSTEM_ID = "2.16.840.1.113883.6.96";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable ElgaCurrentSmokingStatus getEnum(@Nullable String code) {
        for (ElgaCurrentSmokingStatus x : ElgaCurrentSmokingStatus.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(ElgaCurrentSmokingStatus.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (ElgaCurrentSmokingStatus x : ElgaCurrentSmokingStatus.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private ElgaCurrentSmokingStatus(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

