/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.ps.enums;

import java.util.HashMap;
import java.util.Map;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum ElgaSections implements ValueSetEnumInterface
{
    BRIEFTEXT("BRIEFT", "1.2.40.0.34.5.40", "Brieftext", "Brieftext", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    ABBEM("ABBEM", "1.2.40.0.34.5.40", "Abschlie\u00dfende Bemerkungen", "Abschlie\u00dfende Bemerkungen", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    BEILAGEN("BEIL", "1.2.40.0.34.5.40", "Beilagen", "Beilagen", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    CLINICAL_INFORMATION("55752-0", "2.16.840.1.113883.6.1", "Clinical information", "Clinical information", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    DISCHARGE_MEDICATION("75311-1", "2.16.840.1.113883.6.1", "Discharge medications Narrative", "Discharge medications Narrative", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    ALLERGIES("48765-2", "2.16.840.1.113883.6.1", "Allergies and adverse reactions", "Allergies and adverse reactions", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    CHIEF_COMPLAINT("46239-0", "2.16.840.1.113883.6.1", "Chief complaint+Reason for visit", "Chief complaint+Reason for visit", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    ALERT("74018-3", "2.16.840.1.113883.6.1", "Alert", "Alert", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    HISTORY_OF_PAST_ILLNESS("11348-0", "2.16.840.1.113883.6.1", "HISTORY OF PAST ILLNESS", "HISTORY OF PAST ILLNESS", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    LABORATORIES_STUDIES("26436-6", "2.16.840.1.113883.6.1", "Laboratory studies (set)", "Laboratory studies (set)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    TREATMENT_PLAN("18776-5", "2.16.840.1.113883.6.1", "Treatment plan", "Treatment plan", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    PROBLEM_LIST("11450-4", "2.16.840.1.113883.6.1", "Problem list", "Problem list", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    HISTORY_OF_IMMUNIZATIONS("11369-6", "2.16.840.1.113883.6.1", "HISTORY OF IMMUNIZATIONS", "HISTORY OF IMMUNIZATIONS", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE");

    public static final String BRIEFTEXT_CODE = "BRIEFT";
    public static final String ABBEM_CODE = "ABBEM";
    public static final String BEILAGEN_CODE = "BEIL";
    public static final String CLINICAL_INFORMATION_CODE = "55752-0";
    public static final String ALERT_CODE = "74018-3";
    public static final String DISCHARGE_MEDICATION_CODE = "75311-1";
    public static final String ALLERGIES_CODE = "48765-2";
    public static final String CHIEF_COMPLAINT_CODE = "46239-0";
    public static final String VALUE_SET_ID = "1.2.40.0.34.5.40";
    public static final String VALUE_SET_NAME = "ELGA_Sections";
    private String code;
    private String codeSystem;
    private Map<LanguageCode, String> displayNames;

    public static ElgaSections getEnum(String code) {
        for (ElgaSections x : ElgaSections.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(ElgaSections.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(String codeValue) {
        for (ElgaSections x : ElgaSections.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private ElgaSections(String code, String codeSystem, String displayName, String displayNameEn, String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = code;
        this.codeSystem = codeSystem;
        this.displayNames = new HashMap<LanguageCode, String>();
        this.displayNames.put(null, displayName);
        this.displayNames.put(LanguageCode.ENGLISH, displayNameEn);
        this.displayNames.put(LanguageCode.GERMAN, displayNameDe);
        this.displayNames.put(LanguageCode.FRENCH, displayNameFr);
        this.displayNames.put(LanguageCode.ITALIAN, displayNameIt);
    }

    public String getCodeSystemId() {
        return this.codeSystem;
    }

    public String getCodeSystemName() {
        String retVal = "";
        CodeSystems cs = CodeSystems.getEnum((String)this.codeSystem);
        if (cs != null) {
            retVal = cs.getCodeSystemName();
        }
        return retVal;
    }

    public String getCodeValue() {
        return this.code;
    }

    public String getDisplayName(LanguageCode languageCode) {
        String displayName = this.displayNames.get(languageCode);
        if (displayName == null && languageCode == LanguageCode.ENGLISH) {
            return this.displayNames.get(null);
        }
        return displayName;
    }

    public String getValueSetId() {
        return VALUE_SET_ID;
    }

    public String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

