/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models;

import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.CS;
import org.projecthusky.common.hl7cdar2.ED;
import org.projecthusky.common.hl7cdar2.POCDMT000040Act;
import org.projecthusky.common.hl7cdar2.POCDMT000040EntryRelationship;
import org.projecthusky.common.hl7cdar2.TEL;
import org.projecthusky.common.hl7cdar2.XActClassDocumentEntryAct;
import org.projecthusky.common.hl7cdar2.XActRelationshipEntryRelationship;
import org.projecthusky.common.hl7cdar2.XDocumentActMood;
import org.projecthusky.common.model.Code;
import org.projecthusky.common.model.Identificator;

public class AdditionalInformation {
    private Code kindOfInformation;
    private String information;

    public AdditionalInformation(POCDMT000040EntryRelationship entryRel) {
        if (entryRel != null && entryRel.getAct() != null && entryRel.getAct().getCode() != null) {
            this.kindOfInformation = new Code(entryRel.getAct().getCode());
        }
    }

    public String getInformation() {
        return this.information;
    }

    public Code getKindOfInformation() {
        return this.kindOfInformation;
    }

    public void setInformation(String information) {
        this.information = information;
    }

    public void setKindOfInformation(Code kindOfInformation) {
        this.kindOfInformation = kindOfInformation;
    }

    public POCDMT000040EntryRelationship getEntryRelationshipForPatientInformation(int index) {
        if (this.kindOfInformation == null || this.information == null) {
            return null;
        }
        POCDMT000040EntryRelationship entryRel = new POCDMT000040EntryRelationship();
        entryRel.setTypeCode(XActRelationshipEntryRelationship.SUBJ);
        entryRel.setInversionInd(Boolean.valueOf(true));
        StringBuilder sb = new StringBuilder("#");
        sb.append(this.kindOfInformation.getCode().toLowerCase());
        sb.append("-");
        sb.append(index);
        return this.createEntryRelationshipInformation(entryRel, sb.toString(), this.kindOfInformation, "1.2.40.0.34.11.8.0.3.1");
    }

    public POCDMT000040EntryRelationship getEntryRelationshipForDispenseInformation(int index) {
        if (this.kindOfInformation == null || this.information == null) {
            return null;
        }
        POCDMT000040EntryRelationship entryRel = new POCDMT000040EntryRelationship();
        entryRel.setTypeCode(XActRelationshipEntryRelationship.SUBJ);
        entryRel.setInversionInd(Boolean.valueOf(true));
        StringBuilder sb = new StringBuilder("#");
        sb.append(this.kindOfInformation.getCode().toLowerCase());
        sb.append("-");
        sb.append(index);
        return this.createEntryRelationshipInformation(entryRel, sb.toString(), this.kindOfInformation, "1.2.40.0.34.11.8.0.3.2");
    }

    protected POCDMT000040EntryRelationship createEntryRelationshipInformation(POCDMT000040EntryRelationship entryRel, String reference, Code code, String templateId) {
        POCDMT000040Act act = new POCDMT000040Act();
        act.setClassCode(XActClassDocumentEntryAct.ACT);
        act.setMoodCode(XDocumentActMood.INT);
        act.getTemplateId().add(new Identificator(templateId).getHl7CdaR2Ii());
        act.setCode((CD)code.getHl7CdaR2Ce());
        act.setStatusCode(new CS("completed"));
        act.setText(new ED(null, new TEL(reference)));
        entryRel.setAct(act);
        return entryRel;
    }
}

