/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models;

import java.time.temporal.TemporalAccessor;
import org.projecthusky.cda.elga.generated.artdecor.AtcdabbrHeaderRecordTargetEImpfpass;
import org.projecthusky.cda.elga.generated.artdecor.base.HeaderRecordTarget;
import org.projecthusky.cda.elga.generated.artdecor.ems.EpimsHeaderRecordTarget;
import org.projecthusky.cda.elga.generated.artdecor.ems.EpimsPatient;
import org.projecthusky.cda.elga.generated.artdecor.ems.EpimsPatientRole;
import org.projecthusky.common.at.Guardian;
import org.projecthusky.common.at.PatientAt;
import org.projecthusky.common.hl7cdar2.AD;
import org.projecthusky.common.hl7cdar2.BL;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.POCDMT000040Birthplace;
import org.projecthusky.common.hl7cdar2.POCDMT000040Place;
import org.projecthusky.common.hl7cdar2.POCDMT000040RecordTarget;
import org.projecthusky.common.model.Address;
import org.projecthusky.common.model.Code;
import org.projecthusky.common.model.Identificator;
import org.projecthusky.common.model.Telecom;
import org.projecthusky.common.utils.time.DateTimes;

public class PatientCdaAt
extends PatientAt {
    public PatientCdaAt() {
    }

    public PatientCdaAt(POCDMT000040RecordTarget recordTarget) {
        super(recordTarget);
    }

    public HeaderRecordTarget getHeaderRecordTargetBase() {
        HeaderRecordTarget recordTarget = new HeaderRecordTarget();
        recordTarget.setHl7PatientRole(this.getMdhtPatientRole());
        return recordTarget;
    }

    public AtcdabbrHeaderRecordTargetEImpfpass getAtcdabbrHeaderRecordTargetEImpfpass() {
        AtcdabbrHeaderRecordTargetEImpfpass recordTarget = new AtcdabbrHeaderRecordTargetEImpfpass();
        recordTarget.setPatientRole(this.getMdhtPatientRole());
        return recordTarget;
    }

    public EpimsHeaderRecordTarget getHeaderRecordTarget() {
        EpimsHeaderRecordTarget recordTarget = new EpimsHeaderRecordTarget();
        EpimsPatientRole patientRole = recordTarget.getPatientRole();
        if (this.getIds() != null) {
            for (Identificator id : this.getIds()) {
                patientRole.getId().add(id.getHl7CdaR2Ii());
            }
        }
        if (this.getAddresses() != null) {
            for (Address ad : this.getAddresses()) {
                if (ad == null) continue;
                patientRole.getAddr().add(ad.getHl7CdaR2Ad());
            }
        }
        if (this.getTelecoms() != null && !this.getTelecoms().isEmpty()) {
            for (Telecom tel : this.getTelecoms()) {
                patientRole.getTelecom().add(tel.getHl7CdaR2Tel());
            }
        }
        patientRole.setPatient(this.getEpimsPatient());
        recordTarget.setPatientRole(patientRole);
        return recordTarget;
    }

    private EpimsPatient getEpimsPatient() {
        EpimsPatient patient = new EpimsPatient();
        patient.getClassCode().add("PSN");
        patient.setDeterminerCode("INSTANCE");
        patient.getName().add(this.getName().getHl7CdaR2Pn());
        if (this.getAdministrativeGenderCode() != null) {
            patient.setAdministrativeGenderCode(this.createGenderTag(this.getAdministrativeGenderCode().getCode()));
        } else {
            CE genderCode = new CE();
            genderCode.getNullFlavor().add("UNK");
            patient.setAdministrativeGenderCode(genderCode);
        }
        if (this.getBirthday() != null) {
            patient.setBirthTime(DateTimes.toDateTs((TemporalAccessor)this.getBirthdayAsLocalDate()));
        }
        if (this.getDateOfDeath() != null) {
            patient.setDeceasedTime(DateTimes.toDateTs((TemporalAccessor)this.getDateOfDeath()));
            BL deceasedInd = new BL();
            deceasedInd.setValue(Boolean.valueOf(true));
            patient.setDeceasedInd(deceasedInd);
        }
        if (this.getGuardians() != null && !this.getGuardians().isEmpty()) {
            for (Guardian guardian : this.getGuardians()) {
                if (guardian == null) continue;
                patient.getGuardian().add(guardian.getPOCDMT000040Guardian());
            }
        }
        if (this.getBirthPlace() != null) {
            patient.setBirthplace(this.createBirthPlace(this.getBirthPlace()));
        }
        return patient;
    }

    protected POCDMT000040Birthplace createBirthPlace(Address address) {
        POCDMT000040Birthplace birthplace = new POCDMT000040Birthplace();
        birthplace.getClassCode().add("BIRTHPL");
        birthplace.setPlace(this.createPlace(address));
        return birthplace;
    }

    protected POCDMT000040Place createPlace(Address address) {
        POCDMT000040Place place = new POCDMT000040Place();
        place.setDeterminerCode("INSTANCE");
        if (address == null) {
            AD ad = new AD();
            ad.setXmlMixed("UNKNOWN");
            place.setAddr(ad);
        } else {
            place.setAddr(address.getHl7CdaR2Ad());
        }
        return place;
    }

    protected CE createGenderTag(Code genderEnum) {
        CE gender = new CE();
        gender.setCode(genderEnum.getCode());
        gender.setCodeSystem(genderEnum.getCodeSystem());
        gender.setCodeSystemName("HL7:AdministrativeGender");
        gender.setDisplayName(genderEnum.getDisplayName());
        return gender;
    }
}

