/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models.eimpf;

import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.projecthusky.cda.elga.generated.artdecor.AtcdabbrEntryExpositionsrisikoProblemConcern;
import org.projecthusky.cda.elga.models.Appendix;
import org.projecthusky.cda.elga.models.PractitionerCdaAt;
import org.projecthusky.cda.elga.models.Translation;
import org.projecthusky.cda.elga.models.eimpf.ExposureRiskProblem;
import org.projecthusky.common.hl7cdar2.CS;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.POCDMT000040Act;
import org.projecthusky.common.hl7cdar2.POCDMT000040Entry;
import org.projecthusky.common.hl7cdar2.POCDMT000040EntryRelationship;
import org.projecthusky.common.hl7cdar2.POCDMT000040ExternalDocument;
import org.projecthusky.common.hl7cdar2.POCDMT000040Observation;
import org.projecthusky.common.hl7cdar2.POCDMT000040Reference;
import org.projecthusky.common.hl7cdar2.TS;
import org.projecthusky.common.hl7cdar2.XActRelationshipEntry;
import org.projecthusky.common.hl7cdar2.XActRelationshipEntryRelationship;
import org.projecthusky.common.hl7cdar2.XActRelationshipExternalReference;
import org.projecthusky.common.model.Identificator;
import org.projecthusky.common.utils.time.DateTimes;

public class ExposureRiskPersonGroup {
    private Identificator id;
    private boolean active;
    private ZonedDateTime startProblem;
    private ZonedDateTime finishProblem;
    private PractitionerCdaAt author;
    private ZonedDateTime authTime;
    private ExposureRiskProblem risk;
    private Appendix originalReport;
    private List<Translation> translations;

    public Identificator getId() {
        return this.id;
    }

    public void setId(Identificator id) {
        this.id = id;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public ZonedDateTime getStartProblem() {
        return this.startProblem;
    }

    public void setStartProblem(ZonedDateTime startProblem) {
        this.startProblem = startProblem;
    }

    public ZonedDateTime getFinishProblem() {
        return this.finishProblem;
    }

    public void setFinishProblem(ZonedDateTime finishProblem) {
        this.finishProblem = finishProblem;
    }

    public PractitionerCdaAt getAuthor() {
        return this.author;
    }

    public void setAuthor(PractitionerCdaAt author) {
        this.author = author;
    }

    public ZonedDateTime getAuthTime() {
        return this.authTime;
    }

    public void setAuthTime(ZonedDateTime authTime) {
        this.authTime = authTime;
    }

    public ExposureRiskProblem getRisk() {
        return this.risk;
    }

    public void setRisk(ExposureRiskProblem risk) {
        this.risk = risk;
    }

    public Appendix getOriginalReport() {
        return this.originalReport;
    }

    public void setOriginalReport(Appendix originalReport) {
        this.originalReport = originalReport;
    }

    public List<Translation> getTranslations() {
        return this.translations;
    }

    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public POCDMT000040Entry getExposureRiskPersonGroupEntry(int index) {
        POCDMT000040Entry entry = new POCDMT000040Entry();
        entry.setTypeCode(XActRelationshipEntry.DRIV);
        entry.setContextConductionInd(Boolean.valueOf(true));
        AtcdabbrEntryExpositionsrisikoProblemConcern immunization = new AtcdabbrEntryExpositionsrisikoProblemConcern();
        if (this.id != null) {
            immunization.getId().add(this.id.getHl7CdaR2Ii());
        }
        if (this.active) {
            immunization.setHl7StatusCode(new CS("active"));
            if (this.startProblem != null) {
                time = new IVLTS();
                time.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "low", ""), TS.class, (Object)DateTimes.toDateTs((TemporalAccessor)this.startProblem)));
                immunization.setEffectiveTime(time);
            }
        } else {
            immunization.setHl7StatusCode(new CS("completed"));
            if (this.startProblem != null && this.finishProblem != null) {
                time = new IVLTS();
                time.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "low", ""), TS.class, (Object)DateTimes.toDateTs((TemporalAccessor)this.startProblem)));
                time.getRest().add(new JAXBElement(new QName("urn:hl7-org:v3", "high", ""), TS.class, (Object)DateTimes.toDateTs((TemporalAccessor)this.finishProblem)));
                immunization.setEffectiveTime(time);
            }
        }
        if (this.author != null) {
            immunization.getAuthor().add(this.author.getAtcdabbrOtherAuthorBodyEImpfpass(this.authTime));
        }
        if (this.risk != null) {
            POCDMT000040EntryRelationship entryRel = new POCDMT000040EntryRelationship();
            entryRel.setTypeCode(XActRelationshipEntryRelationship.SUBJ);
            entryRel.setInversionInd(Boolean.valueOf(false));
            entryRel.setContextConductionInd(Boolean.valueOf(true));
            entryRel.setObservation((POCDMT000040Observation)this.risk.getExposureRiskProblem(index));
            immunization.getEntryRelationship().add(entryRel);
        }
        if (this.originalReport != null) {
            POCDMT000040Reference reference = new POCDMT000040Reference();
            reference.setTypeCode(XActRelationshipExternalReference.REFR);
            reference.setExternalDocument((POCDMT000040ExternalDocument)this.originalReport.getAtcdabbrEntryExternalDocument(index));
            immunization.getReference().add(reference);
        }
        entry.setAct((POCDMT000040Act)immunization);
        return entry;
    }
}

