/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models.lab;

import java.util.List;
import org.projecthusky.cda.elga.generated.artdecor.base.Annotation;
import org.projecthusky.cda.elga.models.Appendix;
import org.projecthusky.cda.elga.models.lab.Organizer;
import org.projecthusky.common.hl7cdar2.ActRelationshipHasComponent;
import org.projecthusky.common.hl7cdar2.ED;
import org.projecthusky.common.hl7cdar2.POCDMT000040Act;
import org.projecthusky.common.hl7cdar2.POCDMT000040Component4;
import org.projecthusky.common.hl7cdar2.POCDMT000040ObservationMedia;
import org.projecthusky.common.hl7cdar2.POCDMT000040Organizer;
import org.projecthusky.common.hl7cdar2.TEL;
import org.projecthusky.common.model.Code;

public class LaboratoryBatteryOrganizer
extends Organizer {
    private Code structure;
    private List<Appendix> appendices;
    private List<String> notes;

    public Code getStructure() {
        return this.structure;
    }

    public List<Appendix> getAppendices() {
        return this.appendices;
    }

    public List<String> getNotes() {
        return this.notes;
    }

    public void setStructure(Code structure) {
        this.structure = structure;
    }

    public void setAppendices(List<Appendix> appendices) {
        this.appendices = appendices;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public org.projecthusky.cda.elga.generated.artdecor.base.LaboratoryBatteryOrganizer getLaboratoryBatteryOrganizer() {
        org.projecthusky.cda.elga.generated.artdecor.base.LaboratoryBatteryOrganizer organizer = new org.projecthusky.cda.elga.generated.artdecor.base.LaboratoryBatteryOrganizer();
        organizer.setHl7Code(this.structure.getHl7CdaR2Ce());
        this.fillPOCDMT000040Organizer(organizer);
        this.addAppendices(organizer);
        this.addNotes(organizer);
        return organizer;
    }

    private void addAppendices(POCDMT000040Organizer organizer) {
        if (this.appendices != null && !this.appendices.isEmpty()) {
            int index = 0;
            for (Appendix appendix : this.appendices) {
                if (appendix == null) continue;
                POCDMT000040Component4 component = new POCDMT000040Component4();
                component.setTypeCode(ActRelationshipHasComponent.COMP);
                component.setObservationMedia((POCDMT000040ObservationMedia)appendix.getEingebettetesObjektEntry("organizer", index));
                organizer.getComponent().add(component);
                ++index;
            }
        }
    }

    private void addNotes(POCDMT000040Organizer organizer) {
        if (this.notes != null && !this.notes.isEmpty()) {
            int index = 0;
            for (String note : this.notes) {
                if (note == null || note.isEmpty()) continue;
                POCDMT000040Component4 component = new POCDMT000040Component4();
                component.setTypeCode(ActRelationshipHasComponent.COMP);
                component.setAct((POCDMT000040Act)this.getAnnotation(index));
                organizer.getComponent().add(component);
                ++index;
            }
        }
    }

    private Annotation getAnnotation(int index) {
        Annotation note = new Annotation();
        note.setText(new ED(null, new TEL("#footnote-" + index)));
        return note;
    }
}

