/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.models.lab;

import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import java.util.Map;
import org.projecthusky.cda.elga.generated.artdecor.base.Annotation;
import org.projecthusky.cda.elga.generated.artdecor.base.LaboratoryObservationActive;
import org.projecthusky.cda.elga.models.Laboratory;
import org.projecthusky.cda.elga.models.PerformerAt;
import org.projecthusky.common.hl7cdar2.CS;
import org.projecthusky.common.hl7cdar2.ED;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.POCDMT000040Act;
import org.projecthusky.common.hl7cdar2.POCDMT000040EntryRelationship;
import org.projecthusky.common.hl7cdar2.POCDMT000040Observation;
import org.projecthusky.common.hl7cdar2.TEL;
import org.projecthusky.common.hl7cdar2.XActRelationshipEntryRelationship;
import org.projecthusky.common.model.Code;
import org.projecthusky.common.utils.time.DateTimes;

public class LaboratoryObservation
extends Laboratory {
    private List<String> notes;
    private List<Code> interpretationCodes;
    private boolean completed;

    public boolean isCompleted() {
        return this.completed;
    }

    public List<String> getNotes() {
        return this.notes;
    }

    public List<Code> getInterpretationCodes() {
        return this.interpretationCodes;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public void setInterpretationCodes(List<Code> interpretationCodes) {
        this.interpretationCodes = interpretationCodes;
    }

    public org.projecthusky.cda.elga.generated.artdecor.base.LaboratoryObservation getLaboratoryObservation(int index) {
        org.projecthusky.cda.elga.generated.artdecor.base.LaboratoryObservation observation = new org.projecthusky.cda.elga.generated.artdecor.base.LaboratoryObservation();
        this.fillPOCDMT000040Observation(observation, index);
        this.setLaboratories(observation);
        this.setStatusCode(observation);
        if (this.interpretationCodes != null) {
            for (Code interpretation : this.interpretationCodes) {
                if (interpretation == null) continue;
                observation.addHl7InterpretationCode(interpretation.getHl7CdaR2Ce());
            }
        }
        this.setNotes(observation);
        return observation;
    }

    private void setLaboratories(POCDMT000040Observation observation) {
        if (this.getLaboratories() != null) {
            for (Map.Entry<ZonedDateTime, PerformerAt> entry : this.getLaboratories().entrySet()) {
                if (entry == null) continue;
                observation.getPerformer().add(entry.getValue().getLaboratoryPerformer2(entry.getKey()));
            }
        }
    }

    public LaboratoryObservationActive getLaboratoryObservationActive() {
        LaboratoryObservationActive observation = new LaboratoryObservationActive();
        if (this.getLabTestId() != null) {
            observation.setHl7Id(this.getLabTestId().getHl7CdaR2Ii());
            observation.setHl7Text(new ED(null, new TEL("#" + this.getLabTestId().getExtension())));
        }
        if (this.getAnalysisCode() != null) {
            observation.setHl7Code(this.getAnalysisCode().getHl7CdaR2Ce());
        }
        observation.setHl7EffectiveTime(new IVLTS(DateTimes.toDatetimeTs((TemporalAccessor)this.getSamplingTime()).getValue()));
        return observation;
    }

    private void setStatusCode(POCDMT000040Observation observation) {
        if (this.isAborted()) {
            observation.setStatusCode(new CS("aborted"));
        } else if (this.completed) {
            observation.setStatusCode(new CS("completed"));
        } else {
            observation.setStatusCode(new CS("active"));
        }
    }

    private void setNotes(POCDMT000040Observation observation) {
        if (this.notes != null && !this.notes.isEmpty() && observation != null) {
            for (int count = 0; count < this.notes.size(); ++count) {
                POCDMT000040EntryRelationship entryRel = new POCDMT000040EntryRelationship();
                entryRel.setTypeCode(XActRelationshipEntryRelationship.COMP);
                Annotation annotation = new Annotation();
                annotation.setHl7Text(new ED(null, new TEL("#analyse-comment-" + count)));
                entryRel.setAct((POCDMT000040Act)annotation);
                observation.getEntryRelationship().add(entryRel);
            }
        }
    }
}

