/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.narrative;

import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.projecthusky.cda.elga.narrative.BaseTextGenerator;
import org.projecthusky.common.hl7cdar2.ANY;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.POCDMT000040Act;
import org.projecthusky.common.hl7cdar2.POCDMT000040Entry;
import org.projecthusky.common.hl7cdar2.POCDMT000040EntryRelationship;
import org.projecthusky.common.hl7cdar2.StrucDocTable;
import org.projecthusky.common.hl7cdar2.StrucDocTbody;
import org.projecthusky.common.hl7cdar2.StrucDocTd;
import org.projecthusky.common.hl7cdar2.StrucDocTr;

public class ExposureRiskNarrativeTextGenerator
extends BaseTextGenerator {
    private List<POCDMT000040Entry> entries;

    public ExposureRiskNarrativeTextGenerator(List<POCDMT000040Entry> entries) {
        this.entries = entries;
    }

    private StrucDocTable getBody(POCDMT000040Act act) {
        StrucDocTable table = new StrucDocTable();
        StrucDocTbody body = new StrucDocTbody();
        if (act != null) {
            for (POCDMT000040EntryRelationship entryRel : act.getEntryRelationship()) {
                if (entryRel == null || entryRel.getObservation() == null) continue;
                StrucDocTr tr = new StrucDocTr();
                tr.getThOrTd().add(this.getCellTdTime(entryRel.getObservation().getEffectiveTime()));
                tr.getThOrTd().add(this.getCellCodeValue(entryRel.getObservation().getValue()));
                body.getTr().add(tr);
            }
        }
        table.getTbody().add(body);
        return table;
    }

    private StrucDocTd getCellCodeValue(List<ANY> values) {
        StrucDocTd td = new StrucDocTd();
        if (values != null && !values.isEmpty()) {
            for (ANY value : values) {
                if (!(value instanceof CD)) continue;
                CD code = (CD)value;
                td.getContent().add(code.getDisplayName());
                if (code.getOriginalText() == null || code.getOriginalText().getReference() == null || code.getOriginalText().getReference().getValue() == null) continue;
                td.setID(code.getOriginalText().getReference().getValue().replace("#", ""));
            }
        }
        return td;
    }

    public List<JAXBElement<StrucDocTable>> getTablesFromCda() {
        LinkedList<JAXBElement<StrucDocTable>> tables = new LinkedList<JAXBElement<StrucDocTable>>();
        for (POCDMT000040Entry entry : this.entries) {
            if (entry == null || entry.getAct() == null) continue;
            tables.add((JAXBElement<StrucDocTable>)new JAXBElement(new QName("urn:hl7-org:v3", "table"), StrucDocTable.class, (Object)this.getBody(entry.getAct())));
        }
        return tables;
    }
}

