/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.narrative;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.projecthusky.cda.elga.narrative.ImmunizationBaseTextGenerator;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.POCDMT000040Consumable;
import org.projecthusky.common.hl7cdar2.POCDMT000040Entry;
import org.projecthusky.common.hl7cdar2.POCDMT000040Precondition;
import org.projecthusky.common.hl7cdar2.POCDMT000040SubstanceAdministration;
import org.projecthusky.common.hl7cdar2.StrucDocTable;
import org.projecthusky.common.hl7cdar2.StrucDocTbody;
import org.projecthusky.common.hl7cdar2.StrucDocTd;
import org.projecthusky.common.hl7cdar2.StrucDocText;
import org.projecthusky.common.hl7cdar2.StrucDocTr;
import org.projecthusky.common.utils.time.DateTimes;
import org.projecthusky.common.utils.time.Hl7Dtm;

public class ImmunizationRecommendationNarrativeTextGenerator
extends ImmunizationBaseTextGenerator {
    private List<POCDMT000040Entry> entries;

    public ImmunizationRecommendationNarrativeTextGenerator(List<POCDMT000040Entry> entries) {
        this.entries = entries;
    }

    private StrucDocTable getBody(int idxImmunization, POCDMT000040SubstanceAdministration substanceAdministration) {
        StrucDocTable table = new StrucDocTable();
        if (substanceAdministration.getText() != null && substanceAdministration.getText().getReference() != null && substanceAdministration.getText().getReference().getValue() != null) {
            table.setID(substanceAdministration.getText().getReference().getValue().replace("#", ""));
        } else {
            table.setID(String.format("sbdmrec-%d", idxImmunization));
        }
        StrucDocTbody body = new StrucDocTbody();
        body.getTr().add(this.getRowPeriod(substanceAdministration));
        for (POCDMT000040Precondition precondition : substanceAdministration.getPrecondition()) {
            if (precondition == null) continue;
            body.getTr().add(this.getRowDose(precondition));
            body.getTr().add(this.getRowScheme(precondition, idxImmunization));
        }
        if (substanceAdministration.getConsumable() != null) {
            body.getTr().add(this.getRowVaccine(substanceAdministration.getConsumable()));
        }
        body.getTr().addAll(this.getRowTargetDiseases(substanceAdministration.getEntryRelationship()));
        table.getTbody().add(body);
        return table;
    }

    protected StrucDocTr getRowPeriod(POCDMT000040SubstanceAdministration substance) {
        StrucDocTr tr = new StrucDocTr();
        tr.getStyleCode().add("xELGA_colw:12");
        tr.getThOrTd().add(this.getCellTd("Impfzeitraum:"));
        StringBuilder sb = new StringBuilder();
        StrucDocTd tdTime = new StrucDocTd();
        if (!substance.getEffectiveTime().isEmpty() && substance.getEffectiveTime().get(0) != null) {
            Map<String, String> timeMap = this.getTsElement((IVLTS)substance.getEffectiveTime().get(0));
            String lowTime = timeMap.get("low");
            String highTime = timeMap.get("high");
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy").withZone(ZoneId.systemDefault());
            if (lowTime != null) {
                sb.append(formatter.format(DateTimes.toInstant((Hl7Dtm)Hl7Dtm.fromHl7((String)lowTime))));
                sb.append(" - ");
            }
            if (highTime != null) {
                sb.append(formatter.format(DateTimes.toInstant((Hl7Dtm)Hl7Dtm.fromHl7((String)highTime))));
            }
        }
        tdTime.getContent().add(sb.toString());
        tr.getThOrTd().add(tdTime);
        return tr;
    }

    protected StrucDocTr getRowVaccine(POCDMT000040Consumable vaccine) {
        if (vaccine != null && vaccine.getManufacturedProduct() != null && vaccine.getManufacturedProduct().getManufacturedMaterial() != null && vaccine.getManufacturedProduct().getManufacturedMaterial().getCode() != null) {
            StrucDocTr tr = new StrucDocTr();
            tr.getStyleCode().add("xELGA_colw:35");
            tr.getThOrTd().add(this.getCellTd("Impfstoff:"));
            tr.getThOrTd().add(this.getCellTd("nicht anwendbar"));
            return tr;
        }
        return null;
    }

    public StrucDocText getNarrativeTextCda(Map<String, String> comments) {
        StrucDocText text = new StrucDocText();
        LinkedList<JAXBElement> tables = new LinkedList<JAXBElement>();
        int idxImmunization = 0;
        for (POCDMT000040Entry entry : this.entries) {
            if (entry == null || entry.getSubstanceAdministration() == null) continue;
            tables.add(new JAXBElement(new QName("urn:hl7-org:v3", "table"), StrucDocTable.class, (Object)this.getBody(idxImmunization, entry.getSubstanceAdministration())));
            this.addCommentContent(text, entry, comments);
        }
        text.getContent().addAll(tables);
        return text;
    }
}

