/*
 * This code is made available under the terms of the Eclipse Public License v1.0
 * in the github project https://github.com/project-husky/husky there you also
 * find a list of the contributors and the license information.
 *
 * This project has been developed further and modified by the joined working group Husky
 * on the basis of the eHealth Connector opensource project from June 28, 2021,
 * whereas medshare GmbH is the initial and main contributor/author of the eHealth Connector.
 */
package org.projecthusky.cda.elga.generated.artdecor.base.enums;

import java.util.Objects;
import javax.annotation.processing.Generated;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

/**
 * Enumeration of ELGA_ServiceEventsLabor values
 * <p>
 * EN: No designation found.<br>
 * DE: No designation found.<br>
 * FR: No designation found.<br>
 * IT: No designation found.<br>
 * <p>
 * Identifier: 1.2.40.0.34.10.22<br>
 * Effective date: 2020-08-25 00:00<br>
 * Version: 202108<br>
 * Status: DRAFT
 */
@Generated(value = "org.projecthusky.codegenerator.ch.valuesets.UpdateValueSets", date = "2022-02-21")
public enum ElgaServiceEventsLabor implements ValueSetEnumInterface {

    /**
     * EN: Allergiediagnostik.<br>
     */
    ALLERGIEDIAGNOSTIK("1800",
                       "1.2.40.0.34.5.11",
                       "Allergiediagnostik",
                       "Allergiediagnostik",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Allgemeiner Laborbefund.<br>
     */
    ALLGEMEINER_LABORBEFUND("1",
                            "1.2.40.0.34.5.11",
                            "Allgemeiner Laborbefund",
                            "Allgemeiner Laborbefund",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: Anamnese.<br>
     */
    ANAMNESE("10164-2",
             "2.16.840.1.113883.6.1",
             "Anamnese",
             "Anamnese",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Angeforderte Untersuchung.<br>
     */
    ANGEFORDERTE_UNTERSUCHUNG("400999005",
                              "2.16.840.1.113883.6.96",
                              "Angeforderte Untersuchung",
                              "Angeforderte Untersuchung",
                              "TOTRANSLATE",
                              "TOTRANSLATE",
                              "TOTRANSLATE"),
    /**
     * EN: Autoimmundiagnostik.<br>
     */
    AUTOIMMUNDIAGNOSTIK("1300",
                        "1.2.40.0.34.5.11",
                        "Autoimmundiagnostik",
                        "Autoimmundiagnostik",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Befundbewertung.<br>
     */
    BEFUNDBEWERTUNG("20",
                    "1.2.40.0.34.5.11",
                    "Befundbewertung",
                    "Befundbewertung",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Beilagen.<br>
     */
    BEILAGEN("BEIL",
             "1.2.40.0.34.5.40",
             "Beilagen",
             "Beilagen",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Blutgasanalytik.<br>
     */
    BLUTGASANALYTIK("200",
                    "1.2.40.0.34.5.11",
                    "Blutgasanalytik",
                    "Blutgasanalytik",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Blutgruppenserologie.<br>
     */
    BLUTGRUPPENSEROLOGIE("100",
                         "1.2.40.0.34.5.11",
                         "Blutgruppenserologie",
                         "Blutgruppenserologie",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Genetische Diagnostik.<br>
     */
    GENETISCHE_DIAGNOSTIK("2300",
                          "1.2.40.0.34.5.11",
                          "Genetische Diagnostik",
                          "Genetische Diagnostik",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: Gerinnung/Hämostaseologie.<br>
     */
    GERINNUNG_H_MOSTASEOLOGIE("400",
                              "1.2.40.0.34.5.11",
                              "Gerinnung/Hämostaseologie",
                              "Gerinnung/Hämostaseologie",
                              "TOTRANSLATE",
                              "TOTRANSLATE",
                              "TOTRANSLATE"),
    /**
     * EN: Hormone/Vitamine/Tumormarker.<br>
     */
    HORMONE_VITAMINE_TUMORMARKER("600",
                                 "1.2.40.0.34.5.11",
                                 "Hormone/Vitamine/Tumormarker",
                                 "Hormone/Vitamine/Tumormarker",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE"),
    /**
     * EN: Hämatologie.<br>
     */
    H_MATOLOGIE("300",
                "1.2.40.0.34.5.11",
                "Hämatologie",
                "Hämatologie",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Infektionsdiagnostik.<br>
     */
    INFEKTIONSDIAGNOSTIK("1100",
                         "1.2.40.0.34.5.11",
                         "Infektionsdiagnostik",
                         "Infektionsdiagnostik",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Infektionsserologie.<br>
     */
    INFEKTIONSSEROLOGIE("722143004",
                        "2.16.840.1.113883.6.96",
                        "Infektionsserologie",
                        "Infektionsserologie",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Klinische Chemie/Proteindiagnostik.<br>
     */
    KLINISCHE_CHEMIE_PROTEINDIAGNOSTIK("500",
                                       "1.2.40.0.34.5.11",
                                       "Klinische Chemie/Proteindiagnostik",
                                       "Klinische Chemie/Proteindiagnostik",
                                       "TOTRANSLATE",
                                       "TOTRANSLATE",
                                       "TOTRANSLATE"),
    /**
     * EN: Kultureller Erregernachweis.<br>
     */
    KULTURELLER_ERREGERNACHWEIS("446394004",
                                "2.16.840.1.113883.6.96",
                                "Kultureller Erregernachweis",
                                "Kultureller Erregernachweis",
                                "TOTRANSLATE",
                                "TOTRANSLATE",
                                "TOTRANSLATE"),
    /**
     * EN: Liquordiagnostik.<br>
     */
    LIQUORDIAGNOSTIK("1600",
                     "1.2.40.0.34.5.11",
                     "Liquordiagnostik",
                     "Liquordiagnostik",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Medikamente.<br>
     */
    MEDIKAMENTE("1000",
                "1.2.40.0.34.5.11",
                "Medikamente",
                "Medikamente",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Microbiology studies (set).<br>
     */
    MICROBIOLOGY_STUDIES_SET("18725-2",
                             "2.16.840.1.113883.6.1",
                             "Microbiology studies (set)",
                             "Microbiology studies (set)",
                             "TOTRANSLATE",
                             "TOTRANSLATE",
                             "TOTRANSLATE"),
    /**
     * EN: Mikroskopie.<br>
     */
    MIKROSKOPIE("395538009",
                "2.16.840.1.113883.6.96",
                "Mikroskopie",
                "Mikroskopie",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Molekularer Erregernachweis.<br>
     */
    MOLEKULARER_ERREGERNACHWEIS("108262000",
                                "2.16.840.1.113883.6.96",
                                "Molekularer Erregernachweis",
                                "Molekularer Erregernachweis",
                                "TOTRANSLATE",
                                "TOTRANSLATE",
                                "TOTRANSLATE"),
    /**
     * EN: Probeninformation.<br>
     */
    PROBENINFORMATION("10",
                      "1.2.40.0.34.5.11",
                      "Probeninformation",
                      "Probeninformation",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Sonstige.<br>
     */
    SONSTIGE("2500",
             "1.2.40.0.34.5.11",
             "Sonstige",
             "Sonstige",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Stuhldiagnostik.<br>
     */
    STUHLDIAGNOSTIK("1500",
                    "1.2.40.0.34.5.11",
                    "Stuhldiagnostik",
                    "Stuhldiagnostik",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Toxikologie.<br>
     */
    TOXIKOLOGIE("900",
                "1.2.40.0.34.5.11",
                "Toxikologie",
                "Toxikologie",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Urindiagnostik.<br>
     */
    URINDIAGNOSTIK("1400",
                   "1.2.40.0.34.5.11",
                   "Urindiagnostik",
                   "Urindiagnostik",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Weitere Analysen.<br>
     */
    WEITERE_ANALYSEN("15220000",
                     "2.16.840.1.113883.6.96",
                     "Weitere Analysen",
                     "Weitere Analysen",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Überweisungsgrund.<br>
     */
    _BERWEISUNGSGRUND("46239-0",
                      "2.16.840.1.113883.6.1",
                      "Überweisungsgrund",
                      "Überweisungsgrund",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE");

    /**
     * EN: Code for Allergiediagnostik.<br>
     */
    public static final String ALLERGIEDIAGNOSTIK_CODE = "1800";

    /**
     * EN: Code for Allgemeiner Laborbefund.<br>
     */
    public static final String ALLGEMEINER_LABORBEFUND_CODE = "1";

    /**
     * EN: Code for Anamnese.<br>
     */
    public static final String ANAMNESE_CODE = "10164-2";

    /**
     * EN: Code for Angeforderte Untersuchung.<br>
     */
    public static final String ANGEFORDERTE_UNTERSUCHUNG_CODE = "400999005";

    /**
     * EN: Code for Autoimmundiagnostik.<br>
     */
    public static final String AUTOIMMUNDIAGNOSTIK_CODE = "1300";

    /**
     * EN: Code for Befundbewertung.<br>
     */
    public static final String BEFUNDBEWERTUNG_CODE = "20";

    /**
     * EN: Code for Beilagen.<br>
     */
    public static final String BEILAGEN_CODE = "BEIL";

    /**
     * EN: Code for Blutgasanalytik.<br>
     */
    public static final String BLUTGASANALYTIK_CODE = "200";

    /**
     * EN: Code for Blutgruppenserologie.<br>
     */
    public static final String BLUTGRUPPENSEROLOGIE_CODE = "100";

    /**
     * EN: Code for Genetische Diagnostik.<br>
     */
    public static final String GENETISCHE_DIAGNOSTIK_CODE = "2300";

    /**
     * EN: Code for Gerinnung/Hämostaseologie.<br>
     */
    public static final String GERINNUNG_H_MOSTASEOLOGIE_CODE = "400";

    /**
     * EN: Code for Hormone/Vitamine/Tumormarker.<br>
     */
    public static final String HORMONE_VITAMINE_TUMORMARKER_CODE = "600";

    /**
     * EN: Code for Hämatologie.<br>
     */
    public static final String H_MATOLOGIE_CODE = "300";

    /**
     * EN: Code for Infektionsdiagnostik.<br>
     */
    public static final String INFEKTIONSDIAGNOSTIK_CODE = "1100";

    /**
     * EN: Code for Infektionsserologie.<br>
     */
    public static final String INFEKTIONSSEROLOGIE_CODE = "722143004";

    /**
     * EN: Code for Klinische Chemie/Proteindiagnostik.<br>
     */
    public static final String KLINISCHE_CHEMIE_PROTEINDIAGNOSTIK_CODE = "500";

    /**
     * EN: Code for Kultureller Erregernachweis.<br>
     */
    public static final String KULTURELLER_ERREGERNACHWEIS_CODE = "446394004";

    /**
     * EN: Code for Liquordiagnostik.<br>
     */
    public static final String LIQUORDIAGNOSTIK_CODE = "1600";

    /**
     * EN: Code for Medikamente.<br>
     */
    public static final String MEDIKAMENTE_CODE = "1000";

    /**
     * EN: Code for Microbiology studies (set).<br>
     */
    public static final String MICROBIOLOGY_STUDIES_SET_CODE = "18725-2";

    /**
     * EN: Code for Mikroskopie.<br>
     */
    public static final String MIKROSKOPIE_CODE = "395538009";

    /**
     * EN: Code for Molekularer Erregernachweis.<br>
     */
    public static final String MOLEKULARER_ERREGERNACHWEIS_CODE = "108262000";

    /**
     * EN: Code for Probeninformation.<br>
     */
    public static final String PROBENINFORMATION_CODE = "10";

    /**
     * EN: Code for Sonstige.<br>
     */
    public static final String SONSTIGE_CODE = "2500";

    /**
     * EN: Code for Stuhldiagnostik.<br>
     */
    public static final String STUHLDIAGNOSTIK_CODE = "1500";

    /**
     * EN: Code for Toxikologie.<br>
     */
    public static final String TOXIKOLOGIE_CODE = "900";

    /**
     * EN: Code for Urindiagnostik.<br>
     */
    public static final String URINDIAGNOSTIK_CODE = "1400";

    /**
     * EN: Code for Weitere Analysen.<br>
     */
    public static final String WEITERE_ANALYSEN_CODE = "15220000";

    /**
     * EN: Code for Überweisungsgrund.<br>
     */
    public static final String _BERWEISUNGSGRUND_CODE = "46239-0";

    /**
     * Identifier of the value set.
     */
    public static final String VALUE_SET_ID = "1.2.40.0.34.10.22";

    /**
     * Name of the value set.
     */
    public static final String VALUE_SET_NAME = "ELGA_ServiceEventsLabor";

    /**
     * Gets the Enum with a given code.
     *
     * @param code The code value.
     * @return the enum value found or {@code null}.
     */
    @Nullable
    public static ElgaServiceEventsLabor getEnum(@Nullable final String code) {
        for (final ElgaServiceEventsLabor x : values()) {
            if (x.getCodeValue().equals(code)) {
                return x;
            }
        }
        return null;
    }

    /**
     * Checks if a given enum is part of this value set.
     *
     * @param enumName The name of the enum.
     * @return {@code true} if the name is found in this value set, {@code false} otherwise.
     */
    public static boolean isEnumOfValueSet(@Nullable final String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(ElgaServiceEventsLabor.class,
                         enumName);
            return true;
        } catch (final IllegalArgumentException ex) {
            return false;
        }
    }

    /**
     * Checks if a given code value is in this value set.
     *
     * @param codeValue The code value.
     * @return {@code true} if the value is found in this value set, {@code false} otherwise.
     */
    public static boolean isInValueSet(@Nullable final String codeValue) {
        for (final ElgaServiceEventsLabor x : values()) {
            if (x.getCodeValue().equals(codeValue)) {
                return true;
            }
        }
        return false;
    }

    /**
     * Machine interpretable and (inside this class) unique code.
     */
    @NonNull
    private final String code;

    /**
     * Identifier of the referencing code system.
     */
    @NonNull
    private final String codeSystem;

    /**
     * The display names per language. It's always stored in the given order: default display name (0), in English (1),
     * in German (2), in French (3) and in Italian (4).
     */
    @NonNull
    private final String[] displayNames;

    /**
     * Instantiates this enum with a given code and display names.
     *
     * @param code          The code value.
     * @param codeSystem    The code system (OID).
     * @param displayName   The default display name.
     * @param displayNameEn The display name in English.
     * @param displayNameDe The display name in German.
     * @param displayNameFr The display name in French.
     * @param displayNameIt The display name in Italian.
     */
    ElgaServiceEventsLabor(@NonNull final String code, @NonNull final String codeSystem, @NonNull final String displayName, @NonNull final String displayNameEn, @NonNull final String displayNameDe, @NonNull final String displayNameFr, @NonNull final String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    /**
     * Gets the code system identifier.
     *
     * @return the code system identifier.
     */
    @Override
    @NonNull
    public String getCodeSystemId() {
        return this.codeSystem;
    }

    /**
     * Gets the code system name.
     *
     * @return the code system name.
     */
    @Override
    @NonNull
    public String getCodeSystemName() {
        final var codeSystem = CodeSystems.getEnum(this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    /**
     * Gets the code value as a string.
     *
     * @return the code value.
     */
    @Override
    @NonNull
    public String getCodeValue() {
        return this.code;
    }

    /**
     * Gets the display name defined by the language param.
     *
     * @param languageCode The language code to get the display name for, {@code null} to get the default display name.
     * @return the display name in the desired language.
     */
    @Override
    @NonNull
    public String getDisplayName(@Nullable final LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch(languageCode) {
            case ENGLISH ->
                this.displayNames[1];
            case GERMAN ->
                this.displayNames[2];
            case FRENCH ->
                this.displayNames[3];
            case ITALIAN ->
                this.displayNames[4];
            default ->
                "TOTRANSLATE";
        };
    }

    /**
     * Gets the value set identifier.
     *
     * @return the value set identifier.
     */
    @Override
    @NonNull
    public String getValueSetId() {
        return VALUE_SET_ID;
    }

    /**
     * Gets the value set name.
     *
     * @return the value set name.
     */
    @Override
    @NonNull
    public String getValueSetName() {
        return VALUE_SET_NAME;
    }
}
