/*
 * This code is made available under the terms of the Eclipse Public License v1.0
 * in the github project https://github.com/project-husky/husky there you also
 * find a list of the contributors and the license information.
 *
 * This project has been developed further and modified by the joined working group Husky
 * on the basis of the eHealth Connector opensource project from June 28, 2021,
 * whereas medshare GmbH is the initial and main contributor/author of the eHealth Connector.
 */
package org.projecthusky.cda.elga.generated.artdecor.base.enums;

import java.util.Objects;
import javax.annotation.processing.Generated;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

/**
 * Enumeration of ELGA_SignificantPathogens values
 * <p>
 * EN: No designation found.<br>
 * DE: No designation found.<br>
 * FR: No designation found.<br>
 * IT: No designation found.<br>
 * <p>
 * Identifier: 1.2.40.0.34.10.58<br>
 * Effective date: 2013-09-12 00:00<br>
 * Version: null<br>
 * Status: DEPRECATED
 */
@Generated(value = "org.projecthusky.codegenerator.ch.valuesets.UpdateValueSets", date = "2022-02-21")
public enum ElgaSignificantPathogens implements ValueSetEnumInterface {

    /**
     * EN: Adenovirus im Konjunktivalabstrich (*).<br>
     */
    ADENOVIRUS_IM_KONJUNKTIVALABSTRICH_STAR("SP001",
                                            "1.2.40.0.34.5.45",
                                            "Adenovirus im Konjunktivalabstrich (*)",
                                            "Adenovirus im Konjunktivalabstrich (*)",
                                            "TOTRANSLATE",
                                            "TOTRANSLATE",
                                            "TOTRANSLATE"),
    /**
     * EN: Bacillus anthracis.<br>
     */
    BACILLUS_ANTHRACIS("SP003",
                       "1.2.40.0.34.5.45",
                       "Bacillus anthracis",
                       "Bacillus anthracis",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Bordetella pertussis.<br>
     */
    BORDETELLA_PERTUSSIS("SP030",
                         "1.2.40.0.34.5.45",
                         "Bordetella pertussis",
                         "Bordetella pertussis",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Borrelia recurrentis.<br>
     */
    BORRELIA_RECURRENTIS("SP033",
                         "1.2.40.0.34.5.45",
                         "Borrelia recurrentis",
                         "Borrelia recurrentis",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Brucella spp.<br>
     */
    BRUCELLA_SPP("SP007",
                 "1.2.40.0.34.5.45",
                 "Brucella spp.",
                 "Brucella spp.",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Campylobacter spp.<br>
     */
    CAMPYLOBACTER_SPP("SP008",
                      "1.2.40.0.34.5.45",
                      "Campylobacter spp.",
                      "Campylobacter spp.",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Chlamydia trachomatis.<br>
     */
    CHLAMYDIA_TRACHOMATIS("SP009",
                          "1.2.40.0.34.5.45",
                          "Chlamydia trachomatis",
                          "Chlamydia trachomatis",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: Chlamydophila psittaci.<br>
     */
    CHLAMYDOPHILA_PSITTACI("SP044",
                           "1.2.40.0.34.5.45",
                           "Chlamydophila psittaci",
                           "Chlamydophila psittaci",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: Clostridium botulinum.<br>
     */
    CLOSTRIDIUM_BOTULINUM("SP006",
                          "1.2.40.0.34.5.45",
                          "Clostridium botulinum",
                          "Clostridium botulinum",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: Clostridium tetani.<br>
     */
    CLOSTRIDIUM_TETANI("SP057",
                       "1.2.40.0.34.5.45",
                       "Clostridium tetani",
                       "Clostridium tetani",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Corynebacterium diphtheriae.<br>
     */
    CORYNEBACTERIUM_DIPHTHERIAE("SP012",
                                "1.2.40.0.34.5.45",
                                "Corynebacterium diphtheriae",
                                "Corynebacterium diphtheriae",
                                "TOTRANSLATE",
                                "TOTRANSLATE",
                                "TOTRANSLATE"),
    /**
     * EN: Corynebacterium ulcerans.<br>
     */
    CORYNEBACTERIUM_ULCERANS("SP013",
                             "1.2.40.0.34.5.45",
                             "Corynebacterium ulcerans",
                             "Corynebacterium ulcerans",
                             "TOTRANSLATE",
                             "TOTRANSLATE",
                             "TOTRANSLATE"),
    /**
     * EN: Coxiella burnetii.<br>
     */
    COXIELLA_BURNETII("SP049",
                      "1.2.40.0.34.5.45",
                      "Coxiella burnetii",
                      "Coxiella burnetii",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Cryptosporidium spp.<br>
     */
    CRYPTOSPORIDIUM_SPP("SP031",
                        "1.2.40.0.34.5.45",
                        "Cryptosporidium spp.",
                        "Cryptosporidium spp.",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Denguevirus.<br>
     */
    DENGUEVIRUS("SP011",
                "1.2.40.0.34.5.45",
                "Denguevirus",
                "Denguevirus",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Ebolavirus.<br>
     */
    EBOLAVIRUS("SP014",
               "1.2.40.0.34.5.45",
               "Ebolavirus",
               "Ebolavirus",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Echinococcus spp.<br>
     */
    ECHINOCOCCUS_SPP("SP016",
                     "1.2.40.0.34.5.45",
                     "Echinococcus spp.",
                     "Echinococcus spp.",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Escherichia coli, sonstige darmpathogene Stämme.<br>
     */
    ESCHERICHIA_COLI_SONSTIGE_DARMPATHOGENE_ST_MME("SP015",
                                                   "1.2.40.0.34.5.45",
                                                   "Escherichia coli, sonstige darmpathogene Stämme",
                                                   "Escherichia coli, sonstige darmpathogene Stämme",
                                                   "TOTRANSLATE",
                                                   "TOTRANSLATE",
                                                   "TOTRANSLATE"),
    /**
     * EN: Francisella tularensis.<br>
     */
    FRANCISELLA_TULARENSIS("SP062",
                           "1.2.40.0.34.5.45",
                           "Francisella tularensis",
                           "Francisella tularensis",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: FSME-Virus.<br>
     */
    FSME_VIRUS("SP018",
               "1.2.40.0.34.5.45",
               "FSME-Virus",
               "FSME-Virus",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Gelbfieber-Virus.<br>
     */
    GELBFIEBER_VIRUS("SP019",
                     "1.2.40.0.34.5.45",
                     "Gelbfieber-Virus",
                     "Gelbfieber-Virus",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Giardia lamblia.<br>
     */
    GIARDIA_LAMBLIA("SP020",
                    "1.2.40.0.34.5.45",
                    "Giardia lamblia",
                    "Giardia lamblia",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Haemophilus influenzae.<br>
     */
    HAEMOPHILUS_INFLUENZAE("SP022",
                           "1.2.40.0.34.5.45",
                           "Haemophilus influenzae",
                           "Haemophilus influenzae",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: Hantavirus.<br>
     */
    HANTAVIRUS("SP023",
               "1.2.40.0.34.5.45",
               "Hantavirus",
               "Hantavirus",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: HDV - Hepatitis-D-Virus akut.<br>
     */
    HDV_HEPATITIS_D_VIRUS_AKUT("SP027",
                               "1.2.40.0.34.5.45",
                               "HDV - Hepatitis-D-Virus akut",
                               "HDV - Hepatitis-D-Virus akut",
                               "TOTRANSLATE",
                               "TOTRANSLATE",
                               "TOTRANSLATE"),
    /**
     * EN: Hepatitis-A-Virus.<br>
     */
    HEPATITIS_A_VIRUS("SP024",
                      "1.2.40.0.34.5.45",
                      "Hepatitis-A-Virus",
                      "Hepatitis-A-Virus",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Hepatitis-B-Virus.<br>
     */
    HEPATITIS_B_VIRUS("SP025",
                      "1.2.40.0.34.5.45",
                      "Hepatitis-B-Virus",
                      "Hepatitis-B-Virus",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Hepatitis-C-Virus.<br>
     */
    HEPATITIS_C_VIRUS("SP026",
                      "1.2.40.0.34.5.45",
                      "Hepatitis-C-Virus",
                      "Hepatitis-C-Virus",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: HEV - akute Virushepatitis E.<br>
     */
    HEV_AKUTE_VIRUSHEPATITIS_E("SP028",
                               "1.2.40.0.34.5.45",
                               "HEV - akute Virushepatitis E",
                               "HEV - akute Virushepatitis E",
                               "TOTRANSLATE",
                               "TOTRANSLATE",
                               "TOTRANSLATE"),
    /**
     * EN: HIV.<br>
     */
    HIV("SP002",
        "1.2.40.0.34.5.45",
        "HIV",
        "HIV",
        "TOTRANSLATE",
        "TOTRANSLATE",
        "TOTRANSLATE"),
    /**
     * EN: Influenzavirus.<br>
     */
    INFLUENZAVIRUS("SP029",
                   "1.2.40.0.34.5.45",
                   "Influenzavirus",
                   "Influenzavirus",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Influenza A/H5.<br>
     */
    INFLUENZA_A_H5("SP004",
                   "1.2.40.0.34.5.45",
                   "Influenza A/H5",
                   "Influenza A/H5",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Influenza A/H5N1.<br>
     */
    INFLUENZA_A_H5N1("SP005",
                     "1.2.40.0.34.5.45",
                     "Influenza A/H5N1",
                     "Influenza A/H5N1",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Lassavirus.<br>
     */
    LASSAVIRUS("SP032",
               "1.2.40.0.34.5.45",
               "Lassavirus",
               "Lassavirus",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Legionella spp.<br>
     */
    LEGIONELLA_SPP("SP034",
                   "1.2.40.0.34.5.45",
                   "Legionella spp.",
                   "Legionella spp.",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Leptospira interrogans.<br>
     */
    LEPTOSPIRA_INTERROGANS("SP036",
                           "1.2.40.0.34.5.45",
                           "Leptospira interrogans",
                           "Leptospira interrogans",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: Listeria monocytogenes.<br>
     */
    LISTERIA_MONOCYTOGENES("SP037",
                           "1.2.40.0.34.5.45",
                           "Listeria monocytogenes",
                           "Listeria monocytogenes",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: Lyssa-Virus.<br>
     */
    LYSSA_VIRUS("SP058",
                "1.2.40.0.34.5.45",
                "Lyssa-Virus",
                "Lyssa-Virus",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Marburgvirus.<br>
     */
    MARBURGVIRUS("SP039",
                 "1.2.40.0.34.5.45",
                 "Marburgvirus",
                 "Marburgvirus",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Masernvirus.<br>
     */
    MASERNVIRUS("SP040",
                "1.2.40.0.34.5.45",
                "Masernvirus",
                "Masernvirus",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Mumpsvirus.<br>
     */
    MUMPSVIRUS("SP042",
               "1.2.40.0.34.5.45",
               "Mumpsvirus",
               "Mumpsvirus",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Mycobacterium leprae.<br>
     */
    MYCOBACTERIUM_LEPRAE("SP035",
                         "1.2.40.0.34.5.45",
                         "Mycobacterium leprae",
                         "Mycobacterium leprae",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Mycobacterium-tuberculosis-Komplex.<br>
     */
    MYCOBACTERIUM_TUBERCULOSIS_KOMPLEX("SP061",
                                       "1.2.40.0.34.5.45",
                                       "Mycobacterium-tuberculosis-Komplex",
                                       "Mycobacterium-tuberculosis-Komplex",
                                       "TOTRANSLATE",
                                       "TOTRANSLATE",
                                       "TOTRANSLATE"),
    /**
     * EN: Neisseria gonorrhoeae.<br>
     */
    NEISSERIA_GONORRHOEAE("SP021",
                          "1.2.40.0.34.5.45",
                          "Neisseria gonorrhoeae",
                          "Neisseria gonorrhoeae",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: Neisseria meningitidis.<br>
     */
    NEISSERIA_MENINGITIDIS("SP041",
                           "1.2.40.0.34.5.45",
                           "Neisseria meningitidis",
                           "Neisseria meningitidis",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: Norovirus.<br>
     */
    NOROVIRUS("SP043",
              "1.2.40.0.34.5.45",
              "Norovirus",
              "Norovirus",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Plasmodium spp.<br>
     */
    PLASMODIUM_SPP("SP038",
                   "1.2.40.0.34.5.45",
                   "Plasmodium spp.",
                   "Plasmodium spp.",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Poliovirus.<br>
     */
    POLIOVIRUS("SP048",
               "1.2.40.0.34.5.45",
               "Poliovirus",
               "Poliovirus",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Rickettsia prowazekii.<br>
     */
    RICKETTSIA_PROWAZEKII("SP017",
                          "1.2.40.0.34.5.45",
                          "Rickettsia prowazekii",
                          "Rickettsia prowazekii",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: Rotavirus.<br>
     */
    ROTAVIRUS("SP050",
              "1.2.40.0.34.5.45",
              "Rotavirus",
              "Rotavirus",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Rubella-Virus.<br>
     */
    RUBELLA_VIRUS("SP051",
                  "1.2.40.0.34.5.45",
                  "Rubella-Virus",
                  "Rubella-Virus",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Salmonella paratyphi.<br>
     */
    SALMONELLA_PARATYPHI("SP064",
                         "1.2.40.0.34.5.45",
                         "Salmonella paratyphi",
                         "Salmonella paratyphi",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Salmonella spp. außer S. Typhi und S. Paratyphi.<br>
     */
    SALMONELLA_SPP_AUSSER_S_TYPHI_UND_S_PARATYPHI("SP053",
                                                  "1.2.40.0.34.5.45",
                                                  "Salmonella spp. außer S. Typhi und S. Paratyphi",
                                                  "Salmonella spp. außer S. Typhi und S. Paratyphi",
                                                  "TOTRANSLATE",
                                                  "TOTRANSLATE",
                                                  "TOTRANSLATE"),
    /**
     * EN: Salmonella typhi.<br>
     */
    SALMONELLA_TYPHI("SP063",
                     "1.2.40.0.34.5.45",
                     "Salmonella typhi",
                     "Salmonella typhi",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: SARS-Coronavirus, SARS-CoV.<br>
     */
    SARS_CORONAVIRUS_SARS_COV("SP054",
                              "1.2.40.0.34.5.45",
                              "SARS-Coronavirus, SARS-CoV",
                              "SARS-Coronavirus, SARS-CoV",
                              "TOTRANSLATE",
                              "TOTRANSLATE",
                              "TOTRANSLATE"),
    /**
     * EN: Shigella spp.<br>
     */
    SHIGELLA_SPP("SP055",
                 "1.2.40.0.34.5.45",
                 "Shigella spp.",
                 "Shigella spp.",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Streptococcus pneumoniae.<br>
     */
    STREPTOCOCCUS_PNEUMONIAE("SP046",
                             "1.2.40.0.34.5.45",
                             "Streptococcus pneumoniae",
                             "Streptococcus pneumoniae",
                             "TOTRANSLATE",
                             "TOTRANSLATE",
                             "TOTRANSLATE"),
    /**
     * EN: Toxoplasma gondii.<br>
     */
    TOXOPLASMA_GONDII("SP059",
                      "1.2.40.0.34.5.45",
                      "Toxoplasma gondii",
                      "Toxoplasma gondii",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Treponema pallidum.<br>
     */
    TREPONEMA_PALLIDUM("SP056",
                       "1.2.40.0.34.5.45",
                       "Treponema pallidum",
                       "Treponema pallidum",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Trichinella spp.<br>
     */
    TRICHINELLA_SPP("SP060",
                    "1.2.40.0.34.5.45",
                    "Trichinella spp.",
                    "Trichinella spp.",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Variola-Virus.<br>
     */
    VARIOLA_VIRUS("SP047",
                  "1.2.40.0.34.5.45",
                  "Variola-Virus",
                  "Variola-Virus",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Vibrio cholerae.<br>
     */
    VIBRIO_CHOLERAE("SP010",
                    "1.2.40.0.34.5.45",
                    "Vibrio cholerae",
                    "Vibrio cholerae",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: West-Nil-Virus.<br>
     */
    WEST_NIL_VIRUS("SP065",
                   "1.2.40.0.34.5.45",
                   "West-Nil-Virus",
                   "West-Nil-Virus",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Yersinia enterocolitica.<br>
     */
    YERSINIA_ENTEROCOLITICA("SP066",
                            "1.2.40.0.34.5.45",
                            "Yersinia enterocolitica",
                            "Yersinia enterocolitica",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: Yersinia pestis.<br>
     */
    YERSINIA_PESTIS("SP045",
                    "1.2.40.0.34.5.45",
                    "Yersinia pestis",
                    "Yersinia pestis",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Yersinia pseudotuberculosis.<br>
     */
    YERSINIA_PSEUDOTUBERCULOSIS("SP067",
                                "1.2.40.0.34.5.45",
                                "Yersinia pseudotuberculosis",
                                "Yersinia pseudotuberculosis",
                                "TOTRANSLATE",
                                "TOTRANSLATE",
                                "TOTRANSLATE");

    /**
     * EN: Code for Adenovirus im Konjunktivalabstrich (*).<br>
     */
    public static final String ADENOVIRUS_IM_KONJUNKTIVALABSTRICH_STAR_CODE = "SP001";

    /**
     * EN: Code for Bacillus anthracis.<br>
     */
    public static final String BACILLUS_ANTHRACIS_CODE = "SP003";

    /**
     * EN: Code for Bordetella pertussis.<br>
     */
    public static final String BORDETELLA_PERTUSSIS_CODE = "SP030";

    /**
     * EN: Code for Borrelia recurrentis.<br>
     */
    public static final String BORRELIA_RECURRENTIS_CODE = "SP033";

    /**
     * EN: Code for Brucella spp.<br>
     */
    public static final String BRUCELLA_SPP_CODE = "SP007";

    /**
     * EN: Code for Campylobacter spp.<br>
     */
    public static final String CAMPYLOBACTER_SPP_CODE = "SP008";

    /**
     * EN: Code for Chlamydia trachomatis.<br>
     */
    public static final String CHLAMYDIA_TRACHOMATIS_CODE = "SP009";

    /**
     * EN: Code for Chlamydophila psittaci.<br>
     */
    public static final String CHLAMYDOPHILA_PSITTACI_CODE = "SP044";

    /**
     * EN: Code for Clostridium botulinum.<br>
     */
    public static final String CLOSTRIDIUM_BOTULINUM_CODE = "SP006";

    /**
     * EN: Code for Clostridium tetani.<br>
     */
    public static final String CLOSTRIDIUM_TETANI_CODE = "SP057";

    /**
     * EN: Code for Corynebacterium diphtheriae.<br>
     */
    public static final String CORYNEBACTERIUM_DIPHTHERIAE_CODE = "SP012";

    /**
     * EN: Code for Corynebacterium ulcerans.<br>
     */
    public static final String CORYNEBACTERIUM_ULCERANS_CODE = "SP013";

    /**
     * EN: Code for Coxiella burnetii.<br>
     */
    public static final String COXIELLA_BURNETII_CODE = "SP049";

    /**
     * EN: Code for Cryptosporidium spp.<br>
     */
    public static final String CRYPTOSPORIDIUM_SPP_CODE = "SP031";

    /**
     * EN: Code for Denguevirus.<br>
     */
    public static final String DENGUEVIRUS_CODE = "SP011";

    /**
     * EN: Code for Ebolavirus.<br>
     */
    public static final String EBOLAVIRUS_CODE = "SP014";

    /**
     * EN: Code for Echinococcus spp.<br>
     */
    public static final String ECHINOCOCCUS_SPP_CODE = "SP016";

    /**
     * EN: Code for Escherichia coli, sonstige darmpathogene Stämme.<br>
     */
    public static final String ESCHERICHIA_COLI_SONSTIGE_DARMPATHOGENE_ST_MME_CODE = "SP015";

    /**
     * EN: Code for Francisella tularensis.<br>
     */
    public static final String FRANCISELLA_TULARENSIS_CODE = "SP062";

    /**
     * EN: Code for FSME-Virus.<br>
     */
    public static final String FSME_VIRUS_CODE = "SP018";

    /**
     * EN: Code for Gelbfieber-Virus.<br>
     */
    public static final String GELBFIEBER_VIRUS_CODE = "SP019";

    /**
     * EN: Code for Giardia lamblia.<br>
     */
    public static final String GIARDIA_LAMBLIA_CODE = "SP020";

    /**
     * EN: Code for Haemophilus influenzae.<br>
     */
    public static final String HAEMOPHILUS_INFLUENZAE_CODE = "SP022";

    /**
     * EN: Code for Hantavirus.<br>
     */
    public static final String HANTAVIRUS_CODE = "SP023";

    /**
     * EN: Code for HDV - Hepatitis-D-Virus akut.<br>
     */
    public static final String HDV_HEPATITIS_D_VIRUS_AKUT_CODE = "SP027";

    /**
     * EN: Code for Hepatitis-A-Virus.<br>
     */
    public static final String HEPATITIS_A_VIRUS_CODE = "SP024";

    /**
     * EN: Code for Hepatitis-B-Virus.<br>
     */
    public static final String HEPATITIS_B_VIRUS_CODE = "SP025";

    /**
     * EN: Code for Hepatitis-C-Virus.<br>
     */
    public static final String HEPATITIS_C_VIRUS_CODE = "SP026";

    /**
     * EN: Code for HEV - akute Virushepatitis E.<br>
     */
    public static final String HEV_AKUTE_VIRUSHEPATITIS_E_CODE = "SP028";

    /**
     * EN: Code for HIV.<br>
     */
    public static final String HIV_CODE = "SP002";

    /**
     * EN: Code for Influenzavirus.<br>
     */
    public static final String INFLUENZAVIRUS_CODE = "SP029";

    /**
     * EN: Code for Influenza A/H5.<br>
     */
    public static final String INFLUENZA_A_H5_CODE = "SP004";

    /**
     * EN: Code for Influenza A/H5N1.<br>
     */
    public static final String INFLUENZA_A_H5N1_CODE = "SP005";

    /**
     * EN: Code for Lassavirus.<br>
     */
    public static final String LASSAVIRUS_CODE = "SP032";

    /**
     * EN: Code for Legionella spp.<br>
     */
    public static final String LEGIONELLA_SPP_CODE = "SP034";

    /**
     * EN: Code for Leptospira interrogans.<br>
     */
    public static final String LEPTOSPIRA_INTERROGANS_CODE = "SP036";

    /**
     * EN: Code for Listeria monocytogenes.<br>
     */
    public static final String LISTERIA_MONOCYTOGENES_CODE = "SP037";

    /**
     * EN: Code for Lyssa-Virus.<br>
     */
    public static final String LYSSA_VIRUS_CODE = "SP058";

    /**
     * EN: Code for Marburgvirus.<br>
     */
    public static final String MARBURGVIRUS_CODE = "SP039";

    /**
     * EN: Code for Masernvirus.<br>
     */
    public static final String MASERNVIRUS_CODE = "SP040";

    /**
     * EN: Code for Mumpsvirus.<br>
     */
    public static final String MUMPSVIRUS_CODE = "SP042";

    /**
     * EN: Code for Mycobacterium leprae.<br>
     */
    public static final String MYCOBACTERIUM_LEPRAE_CODE = "SP035";

    /**
     * EN: Code for Mycobacterium-tuberculosis-Komplex.<br>
     */
    public static final String MYCOBACTERIUM_TUBERCULOSIS_KOMPLEX_CODE = "SP061";

    /**
     * EN: Code for Neisseria gonorrhoeae.<br>
     */
    public static final String NEISSERIA_GONORRHOEAE_CODE = "SP021";

    /**
     * EN: Code for Neisseria meningitidis.<br>
     */
    public static final String NEISSERIA_MENINGITIDIS_CODE = "SP041";

    /**
     * EN: Code for Norovirus.<br>
     */
    public static final String NOROVIRUS_CODE = "SP043";

    /**
     * EN: Code for Plasmodium spp.<br>
     */
    public static final String PLASMODIUM_SPP_CODE = "SP038";

    /**
     * EN: Code for Poliovirus.<br>
     */
    public static final String POLIOVIRUS_CODE = "SP048";

    /**
     * EN: Code for Rickettsia prowazekii.<br>
     */
    public static final String RICKETTSIA_PROWAZEKII_CODE = "SP017";

    /**
     * EN: Code for Rotavirus.<br>
     */
    public static final String ROTAVIRUS_CODE = "SP050";

    /**
     * EN: Code for Rubella-Virus.<br>
     */
    public static final String RUBELLA_VIRUS_CODE = "SP051";

    /**
     * EN: Code for Salmonella paratyphi.<br>
     */
    public static final String SALMONELLA_PARATYPHI_CODE = "SP064";

    /**
     * EN: Code for Salmonella spp. außer S. Typhi und S. Paratyphi.<br>
     */
    public static final String SALMONELLA_SPP_AUSSER_S_TYPHI_UND_S_PARATYPHI_CODE = "SP053";

    /**
     * EN: Code for Salmonella typhi.<br>
     */
    public static final String SALMONELLA_TYPHI_CODE = "SP063";

    /**
     * EN: Code for SARS-Coronavirus, SARS-CoV.<br>
     */
    public static final String SARS_CORONAVIRUS_SARS_COV_CODE = "SP054";

    /**
     * EN: Code for Shigella spp.<br>
     */
    public static final String SHIGELLA_SPP_CODE = "SP055";

    /**
     * EN: Code for Streptococcus pneumoniae.<br>
     */
    public static final String STREPTOCOCCUS_PNEUMONIAE_CODE = "SP046";

    /**
     * EN: Code for Toxoplasma gondii.<br>
     */
    public static final String TOXOPLASMA_GONDII_CODE = "SP059";

    /**
     * EN: Code for Treponema pallidum.<br>
     */
    public static final String TREPONEMA_PALLIDUM_CODE = "SP056";

    /**
     * EN: Code for Trichinella spp.<br>
     */
    public static final String TRICHINELLA_SPP_CODE = "SP060";

    /**
     * EN: Code for Variola-Virus.<br>
     */
    public static final String VARIOLA_VIRUS_CODE = "SP047";

    /**
     * EN: Code for Vibrio cholerae.<br>
     */
    public static final String VIBRIO_CHOLERAE_CODE = "SP010";

    /**
     * EN: Code for West-Nil-Virus.<br>
     */
    public static final String WEST_NIL_VIRUS_CODE = "SP065";

    /**
     * EN: Code for Yersinia enterocolitica.<br>
     */
    public static final String YERSINIA_ENTEROCOLITICA_CODE = "SP066";

    /**
     * EN: Code for Yersinia pestis.<br>
     */
    public static final String YERSINIA_PESTIS_CODE = "SP045";

    /**
     * EN: Code for Yersinia pseudotuberculosis.<br>
     */
    public static final String YERSINIA_PSEUDOTUBERCULOSIS_CODE = "SP067";

    /**
     * Identifier of the value set.
     */
    public static final String VALUE_SET_ID = "1.2.40.0.34.10.58";

    /**
     * Name of the value set.
     */
    public static final String VALUE_SET_NAME = "ELGA_SignificantPathogens";

    /**
     * Identifier of the code system (all values share the same).
     */
    public static final String CODE_SYSTEM_ID = "1.2.40.0.34.5.45";

    /**
     * Gets the Enum with a given code.
     *
     * @param code The code value.
     * @return the enum value found or {@code null}.
     */
    @Nullable
    public static ElgaSignificantPathogens getEnum(@Nullable final String code) {
        for (final ElgaSignificantPathogens x : values()) {
            if (x.getCodeValue().equals(code)) {
                return x;
            }
        }
        return null;
    }

    /**
     * Checks if a given enum is part of this value set.
     *
     * @param enumName The name of the enum.
     * @return {@code true} if the name is found in this value set, {@code false} otherwise.
     */
    public static boolean isEnumOfValueSet(@Nullable final String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(ElgaSignificantPathogens.class,
                         enumName);
            return true;
        } catch (final IllegalArgumentException ex) {
            return false;
        }
    }

    /**
     * Checks if a given code value is in this value set.
     *
     * @param codeValue The code value.
     * @return {@code true} if the value is found in this value set, {@code false} otherwise.
     */
    public static boolean isInValueSet(@Nullable final String codeValue) {
        for (final ElgaSignificantPathogens x : values()) {
            if (x.getCodeValue().equals(codeValue)) {
                return true;
            }
        }
        return false;
    }

    /**
     * Machine interpretable and (inside this class) unique code.
     */
    @NonNull
    private final String code;

    /**
     * Identifier of the referencing code system.
     */
    @NonNull
    private final String codeSystem;

    /**
     * The display names per language. It's always stored in the given order: default display name (0), in English (1),
     * in German (2), in French (3) and in Italian (4).
     */
    @NonNull
    private final String[] displayNames;

    /**
     * Instantiates this enum with a given code and display names.
     *
     * @param code          The code value.
     * @param codeSystem    The code system (OID).
     * @param displayName   The default display name.
     * @param displayNameEn The display name in English.
     * @param displayNameDe The display name in German.
     * @param displayNameFr The display name in French.
     * @param displayNameIt The display name in Italian.
     */
    ElgaSignificantPathogens(@NonNull final String code, @NonNull final String codeSystem, @NonNull final String displayName, @NonNull final String displayNameEn, @NonNull final String displayNameDe, @NonNull final String displayNameFr, @NonNull final String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    /**
     * Gets the code system identifier.
     *
     * @return the code system identifier.
     */
    @Override
    @NonNull
    public String getCodeSystemId() {
        return this.codeSystem;
    }

    /**
     * Gets the code system name.
     *
     * @return the code system name.
     */
    @Override
    @NonNull
    public String getCodeSystemName() {
        final var codeSystem = CodeSystems.getEnum(this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    /**
     * Gets the code value as a string.
     *
     * @return the code value.
     */
    @Override
    @NonNull
    public String getCodeValue() {
        return this.code;
    }

    /**
     * Gets the display name defined by the language param.
     *
     * @param languageCode The language code to get the display name for, {@code null} to get the default display name.
     * @return the display name in the desired language.
     */
    @Override
    @NonNull
    public String getDisplayName(@Nullable final LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch(languageCode) {
            case ENGLISH ->
                this.displayNames[1];
            case GERMAN ->
                this.displayNames[2];
            case FRENCH ->
                this.displayNames[3];
            case ITALIAN ->
                this.displayNames[4];
            default ->
                "TOTRANSLATE";
        };
    }

    /**
     * Gets the value set identifier.
     *
     * @return the value set identifier.
     */
    @Override
    @NonNull
    public String getValueSetId() {
        return VALUE_SET_ID;
    }

    /**
     * Gets the value set name.
     *
     * @return the value set name.
     */
    @Override
    @NonNull
    public String getValueSetName() {
        return VALUE_SET_NAME;
    }
}
