/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor;

import java.util.ArrayList;
import java.util.List;
import org.projecthusky.common.basetypes.CodeBaseType;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.CS;
import org.projecthusky.common.hl7cdar2.ED;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.IVLPQ;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.ObjectFactory;
import org.projecthusky.common.hl7cdar2.POCDMT000040Author;
import org.projecthusky.common.hl7cdar2.POCDMT000040Consumable;
import org.projecthusky.common.hl7cdar2.POCDMT000040EntryRelationship;
import org.projecthusky.common.hl7cdar2.POCDMT000040Participant2;
import org.projecthusky.common.hl7cdar2.POCDMT000040Precondition;
import org.projecthusky.common.hl7cdar2.POCDMT000040Reference;
import org.projecthusky.common.hl7cdar2.POCDMT000040SubstanceAdministration;
import org.projecthusky.common.hl7cdar2.SXCMTS;
import org.projecthusky.common.hl7cdar2.XActRelationshipEntryRelationship;
import org.projecthusky.common.hl7cdar2.XActRelationshipExternalReference;
import org.projecthusky.common.hl7cdar2.XDocumentSubstanceMood;
import org.projecthusky.common.model.Code;

public class AtcdabbrEntryImmunizationRecommendation
extends POCDMT000040SubstanceAdministration {
    private final List<Code> vocabCodeValueSet = new ArrayList<Code>();

    public AtcdabbrEntryImmunizationRecommendation() {
        super.getClassCode().add("SBADM");
        super.setMoodCode(XDocumentSubstanceMood.PRP);
        super.setNegationInd(Boolean.FALSE);
        super.getTemplateId().add(AtcdabbrEntryImmunizationRecommendation.createHl7TemplateIdFixedValue("1.2.40.0.34.6.0.11.3.3"));
        super.getTemplateId().add(AtcdabbrEntryImmunizationRecommendation.createHl7TemplateIdFixedValue("2.16.840.1.113883.10.20.1.25"));
        super.getTemplateId().add(AtcdabbrEntryImmunizationRecommendation.createHl7TemplateIdFixedValue("1.3.6.1.4.1.19376.1.5.3.1.4.12.2"));
        this.vocabCodeValueSet.add(new Code(CodeBaseType.builder().withCode("IMMUNIZ").withCodeSystem("2.16.840.1.113883.5.4").build()));
        this.code = new Code(CodeBaseType.builder().withCode("IMMUNIZ").withCodeSystem("2.16.840.1.113883.5.4").build()).getHl7CdaR2Cd();
        super.setCode(this.code);
        super.setStatusCode(AtcdabbrEntryImmunizationRecommendation.createHl7StatusCodeFixedValue("active"));
        super.setRouteCode(AtcdabbrEntryImmunizationRecommendation.createHl7RouteCodeFixedValue("NA"));
        super.getEntryRelationship().add(AtcdabbrEntryImmunizationRecommendation.createHl7EntryRelationshipFixedValue("RSON", "true"));
    }

    public void addHl7ApproachSiteCode(CD value) {
        this.getApproachSiteCode().add(value);
    }

    public void addHl7EntryRelationship(POCDMT000040EntryRelationship value) {
        this.getEntryRelationship().add(value);
    }

    public void clearHl7ApproachSiteCode() {
        this.getApproachSiteCode().clear();
    }

    public void clearHl7EntryRelationship() {
        this.getEntryRelationship().clear();
    }

    private static CD createHl7ApproachSiteCodeFixedValue(String nullFlavor) {
        ObjectFactory factory = new ObjectFactory();
        CD retVal = factory.createCD();
        retVal.nullFlavor = new ArrayList();
        retVal.nullFlavor.add(nullFlavor);
        return retVal;
    }

    private static CD createHl7CodeFixedValue() {
        ObjectFactory factory = new ObjectFactory();
        CD retVal = factory.createCD();
        return retVal;
    }

    private static POCDMT000040Consumable createHl7ConsumableFixedValue(String typeCode) {
        ObjectFactory factory = new ObjectFactory();
        POCDMT000040Consumable retVal = factory.createPOCDMT000040Consumable();
        retVal.getTypeCode().add(typeCode);
        return retVal;
    }

    private static IVLPQ createHl7DoseQuantityFixedValue(String nullFlavor) {
        ObjectFactory factory = new ObjectFactory();
        IVLPQ retVal = factory.createIVLPQ();
        retVal.nullFlavor = new ArrayList();
        retVal.nullFlavor.add(nullFlavor);
        return retVal;
    }

    private static POCDMT000040EntryRelationship createHl7EntryRelationshipFixedValue(String typeCode, String contextConductionInd) {
        ObjectFactory factory = new ObjectFactory();
        POCDMT000040EntryRelationship retVal = factory.createPOCDMT000040EntryRelationship();
        retVal.setTypeCode(XActRelationshipEntryRelationship.fromValue((String)typeCode));
        if (contextConductionInd != null) {
            retVal.setContextConductionInd(Boolean.valueOf(Boolean.parseBoolean(contextConductionInd)));
        }
        return retVal;
    }

    private static POCDMT000040Participant2 createHl7ParticipantFixedValue(String typeCode, String contextControlCode) {
        ObjectFactory factory = new ObjectFactory();
        POCDMT000040Participant2 retVal = factory.createPOCDMT000040Participant2();
        retVal.getTypeCode().add(typeCode);
        retVal.setContextControlCode(contextControlCode);
        return retVal;
    }

    private static POCDMT000040Precondition createHl7PreconditionFixedValue(String typeCode) {
        ObjectFactory factory = new ObjectFactory();
        POCDMT000040Precondition retVal = factory.createPOCDMT000040Precondition();
        retVal.getTypeCode().add(typeCode);
        return retVal;
    }

    private static POCDMT000040Reference createHl7ReferenceFixedValue(String typeCode) {
        ObjectFactory factory = new ObjectFactory();
        POCDMT000040Reference retVal = factory.createPOCDMT000040Reference();
        retVal.setTypeCode(XActRelationshipExternalReference.fromValue((String)typeCode));
        return retVal;
    }

    private static CE createHl7RouteCodeFixedValue(String nullFlavor) {
        ObjectFactory factory = new ObjectFactory();
        CE retVal = factory.createCE();
        retVal.nullFlavor = new ArrayList();
        retVal.nullFlavor.add(nullFlavor);
        return retVal;
    }

    private static CS createHl7StatusCodeFixedValue(String code) {
        ObjectFactory factory = new ObjectFactory();
        CS retVal = factory.createCS();
        retVal.setCode(code);
        return retVal;
    }

    private static II createHl7TemplateIdFixedValue(String root) {
        ObjectFactory factory = new ObjectFactory();
        II retVal = factory.createII();
        retVal.setRoot(root);
        return retVal;
    }

    public List<POCDMT000040Author> getHl7Author() {
        return this.author;
    }

    public CD getHl7Code() {
        return this.code;
    }

    public POCDMT000040Consumable getHl7Consumable() {
        return this.consumable;
    }

    public IVLPQ getHl7DoseQuantity() {
        return this.doseQuantity;
    }

    public List<SXCMTS> getHl7EffectiveTime() {
        return this.effectiveTime;
    }

    public List<II> getHl7Id() {
        return this.id;
    }

    public List<POCDMT000040Participant2> getHl7Participant() {
        return this.participant;
    }

    public List<POCDMT000040Precondition> getHl7Precondition() {
        return this.precondition;
    }

    public List<POCDMT000040Reference> getHl7Reference() {
        return this.reference;
    }

    public CE getHl7RouteCode() {
        return this.routeCode;
    }

    public CS getHl7StatusCode() {
        return this.statusCode;
    }

    public List<II> getHl7TemplateId() {
        return this.templateId;
    }

    public ED getHl7Text() {
        return this.text;
    }

    public static CD getPredefinedApproachSiteCodeNa() {
        return AtcdabbrEntryImmunizationRecommendation.createHl7ApproachSiteCodeFixedValue("NA");
    }

    public static POCDMT000040Consumable getPredefinedConsumableCsm() {
        return AtcdabbrEntryImmunizationRecommendation.createHl7ConsumableFixedValue("CSM");
    }

    public static IVLPQ getPredefinedDoseQuantityNa() {
        return AtcdabbrEntryImmunizationRecommendation.createHl7DoseQuantityFixedValue("NA");
    }

    public static POCDMT000040EntryRelationship getPredefinedEntryRelationshipRsonTrue() {
        return AtcdabbrEntryImmunizationRecommendation.createHl7EntryRelationshipFixedValue("RSON", "true");
    }

    public static POCDMT000040Participant2 getPredefinedParticipantAutOp() {
        return AtcdabbrEntryImmunizationRecommendation.createHl7ParticipantFixedValue("AUT", "OP");
    }

    public static POCDMT000040Participant2 getPredefinedParticipantEntOp() {
        return AtcdabbrEntryImmunizationRecommendation.createHl7ParticipantFixedValue("ENT", "OP");
    }

    public static POCDMT000040Participant2 getPredefinedParticipantVrfOp() {
        return AtcdabbrEntryImmunizationRecommendation.createHl7ParticipantFixedValue("VRF", "OP");
    }

    public static POCDMT000040Reference getPredefinedReferenceRefr() {
        return AtcdabbrEntryImmunizationRecommendation.createHl7ReferenceFixedValue("REFR");
    }

    public List<Code> getVocabCodeValueSet() {
        return this.vocabCodeValueSet;
    }

    public void setHl7Author(POCDMT000040Author value) {
        this.getAuthor().clear();
        this.getAuthor().add(value);
    }

    public void setHl7Code(CD value) {
        this.code = value;
    }

    public void setHl7Consumable(POCDMT000040Consumable value) {
        this.consumable = value;
    }

    public void setHl7DoseQuantity(IVLPQ value) {
        this.doseQuantity = value;
    }

    public void setHl7EffectiveTime(IVLTS value) {
        this.getEffectiveTime().clear();
        this.getEffectiveTime().add(value);
    }

    public void setHl7Id(II value) {
        this.getId().clear();
        this.getId().add(value);
    }

    public void setHl7Participant(POCDMT000040Participant2 value) {
        this.getParticipant().clear();
        this.getParticipant().add(value);
    }

    public void setHl7Precondition(POCDMT000040Precondition value) {
        this.getPrecondition().clear();
        this.getPrecondition().add(value);
    }

    public void setHl7Reference(POCDMT000040Reference value) {
        this.getReference().clear();
        this.getReference().add(value);
    }

    public void setHl7RouteCode(CE value) {
        this.routeCode = value;
    }

    public void setHl7StatusCode(CS value) {
        this.statusCode = value;
    }

    public void setHl7TemplateId(II value) {
        this.getTemplateId().clear();
        this.getTemplateId().add(value);
    }

    public void setHl7Text(ED value) {
        this.text = value;
    }
}

