/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.base;

import java.util.List;
import org.projecthusky.common.hl7cdar2.ActRelationshipHasComponent;
import org.projecthusky.common.hl7cdar2.CS;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.ObjectFactory;
import org.projecthusky.common.hl7cdar2.POCDMT000040Component4;
import org.projecthusky.common.hl7cdar2.POCDMT000040Organizer;
import org.projecthusky.common.hl7cdar2.POCDMT000040Specimen;
import org.projecthusky.common.hl7cdar2.XActClassDocumentEntryOrganizer;

public class Antibiogram
extends POCDMT000040Organizer {
    public Antibiogram() {
        super.setClassCode(XActClassDocumentEntryOrganizer.CLUSTER);
        super.getMoodCode().add("EVN");
        super.getTemplateId().add(Antibiogram.createHl7TemplateIdFixedValue("1.3.6.1.4.1.19376.1.3.1.5"));
        super.setStatusCode(Antibiogram.createHl7StatusCodeFixedValue("completed", null, null, null));
        super.getSpecimen().add(Antibiogram.createHl7SpecimenFixedValue("SPC"));
    }

    private static POCDMT000040Component4 createHl7ComponentFixedValue(String typeCode) {
        ObjectFactory factory = new ObjectFactory();
        POCDMT000040Component4 retVal = factory.createPOCDMT000040Component4();
        retVal.setTypeCode(ActRelationshipHasComponent.fromValue((String)typeCode));
        return retVal;
    }

    private static POCDMT000040Specimen createHl7SpecimenFixedValue(String typeCode) {
        ObjectFactory factory = new ObjectFactory();
        POCDMT000040Specimen retVal = factory.createPOCDMT000040Specimen();
        retVal.getTypeCode().add(typeCode);
        return retVal;
    }

    private static CS createHl7StatusCodeFixedValue(String code, String codeSystem, String codeSystemName, String displayName) {
        ObjectFactory factory = new ObjectFactory();
        CS retVal = factory.createCS();
        retVal.setCode(code);
        retVal.setCodeSystem(codeSystem);
        retVal.setCodeSystemName(codeSystemName);
        retVal.setDisplayName(displayName);
        return retVal;
    }

    private static II createHl7TemplateIdFixedValue(String root) {
        ObjectFactory factory = new ObjectFactory();
        II retVal = factory.createII();
        retVal.setRoot(root);
        return retVal;
    }

    public List<POCDMT000040Component4> getHl7Component() {
        return this.component;
    }

    public IVLTS getHl7EffectiveTime() {
        return this.effectiveTime;
    }

    public List<POCDMT000040Specimen> getHl7Specimen() {
        return this.specimen;
    }

    public CS getHl7StatusCode() {
        return this.statusCode;
    }

    public List<II> getHl7TemplateId() {
        return this.templateId;
    }

    public static POCDMT000040Component4 getPredefinedComponentComp() {
        return Antibiogram.createHl7ComponentFixedValue("COMP");
    }

    public void setHl7Component(POCDMT000040Component4 value) {
        this.getComponent().clear();
        this.getComponent().add(value);
    }

    public void setHl7EffectiveTime(IVLTS value) {
        this.effectiveTime = value;
    }

    public void setHl7Specimen(POCDMT000040Specimen value) {
        this.getSpecimen().clear();
        this.getSpecimen().add(value);
    }

    public void setHl7StatusCode(CS value) {
        this.statusCode = value;
    }

    public void setHl7TemplateId(II value) {
        this.getTemplateId().clear();
        this.getTemplateId().add(value);
    }
}

