/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.base.enums;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum ElgaObservationInterpretation implements ValueSetEnumInterface
{
    ABNORMAL_ALERT_L2("AA", "2.16.840.1.113883.5.83", "Abnormal Alert", "Abnormal Alert", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    ABNORMAL_L1("A", "2.16.840.1.113883.5.83", "Abnormal", "Abnormal", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    DECREASED_L1("D", "2.16.840.1.113883.5.83", "decreased", "decreased", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    HIGH_ALERT_L2("HH", "2.16.840.1.113883.5.83", "High Alert", "High Alert", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    HIGH_L1("H", "2.16.840.1.113883.5.83", "High", "High", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    HIGH_OFF_SCALE_L1(">", "2.16.840.1.113883.5.83", "high off scale", "high off scale", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    INCREASED_L1("U", "2.16.840.1.113883.5.83", "increased", "increased", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    INDETERMINATE_L1("IND", "2.16.840.1.113883.5.83", "Indeterminate", "Indeterminate", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    INTERMEDIATE_L1("I", "2.16.840.1.113883.5.83", "Intermediate", "Intermediate", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    LOW_ALERT_L2("LL", "2.16.840.1.113883.5.83", "Low Alert", "Low Alert", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    LOW_L1("L", "2.16.840.1.113883.5.83", "Low", "Low", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    LOW_OFF_SCALE_L1("<", "2.16.840.1.113883.5.83", "low off scale", "low off scale", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    NEGATIVE_L1("NEG", "2.16.840.1.113883.5.83", "Negative", "Negative", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    NORMAL_L1("N", "2.16.840.1.113883.5.83", "normal", "normal", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    OUTSIDE_THRESHOLD_L1("EX", "2.16.840.1.113883.5.83", "outside threshold", "outside threshold", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    POSITIVE_L1("POS", "2.16.840.1.113883.5.83", "Positive", "Positive", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    RESISTENT_L1("R", "2.16.840.1.113883.5.83", "Resistent", "Resistent", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    SUSCEPTIBLE_L1("S", "2.16.840.1.113883.5.83", "Susceptible", "Susceptible", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE");

    public static final String ABNORMAL_ALERT_L2_CODE = "AA";
    public static final String ABNORMAL_L1_CODE = "A";
    public static final String DECREASED_L1_CODE = "D";
    public static final String HIGH_ALERT_L2_CODE = "HH";
    public static final String HIGH_L1_CODE = "H";
    public static final String HIGH_OFF_SCALE_L1_CODE = ">";
    public static final String INCREASED_L1_CODE = "U";
    public static final String INDETERMINATE_L1_CODE = "IND";
    public static final String INTERMEDIATE_L1_CODE = "I";
    public static final String LOW_ALERT_L2_CODE = "LL";
    public static final String LOW_L1_CODE = "L";
    public static final String LOW_OFF_SCALE_L1_CODE = "<";
    public static final String NEGATIVE_L1_CODE = "NEG";
    public static final String NORMAL_L1_CODE = "N";
    public static final String OUTSIDE_THRESHOLD_L1_CODE = "EX";
    public static final String POSITIVE_L1_CODE = "POS";
    public static final String RESISTENT_L1_CODE = "R";
    public static final String SUSCEPTIBLE_L1_CODE = "S";
    public static final String VALUE_SET_ID = "1.2.40.0.34.10.13";
    public static final String VALUE_SET_NAME = "ELGA_ObservationInterpretation";
    public static final String CODE_SYSTEM_ID = "2.16.840.1.113883.5.83";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable ElgaObservationInterpretation getEnum(@Nullable String code) {
        for (ElgaObservationInterpretation x : ElgaObservationInterpretation.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(ElgaObservationInterpretation.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (ElgaObservationInterpretation x : ElgaObservationInterpretation.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private ElgaObservationInterpretation(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

