/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.base.enums;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum ElgaPersonalRelationship implements ValueSetEnumInterface
{
    ADOPTED_CHILD("CHLDADOPT", "2.16.840.1.113883.5.111", "adopted child", "adopted child", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    ADOPTED_DAUGHTER("DAUADOPT", "2.16.840.1.113883.5.111", "adopted daughter", "adopted daughter", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    ADOPTED_SON("SONADOPT", "2.16.840.1.113883.5.111", "adopted son", "adopted son", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    AUNT("AUNT", "2.16.840.1.113883.5.111", "aunt", "aunt", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    CHILD("CHILD", "2.16.840.1.113883.5.111", "child", "child", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    CHILD_IN_LAW("CHLDINLAW", "2.16.840.1.113883.5.111", "child in-law", "child in-law", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    COUSIN("COUSN", "2.16.840.1.113883.5.111", "cousin", "cousin", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    DAUGHTER("DAUC", "2.16.840.1.113883.5.111", "daughter", "daughter", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    DAUGHTER_IN_LAW("DAUINLAW", "2.16.840.1.113883.5.111", "daughter in-law", "daughter in-law", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    DOMESTIC_PARTNER("DOMPART", "2.16.840.1.113883.5.111", "domestic partner", "domestic partner", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    FAMILY_MEMBER("FAMMEMB", "2.16.840.1.113883.5.111", "family member", "family member", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    FATHER("FTH", "2.16.840.1.113883.5.111", "father", "father", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    FATHER_IN_LAW("FTHINLAW", "2.16.840.1.113883.5.111", "father-in-law", "father-in-law", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    FOSTER_CHILD("CHLDFOST", "2.16.840.1.113883.5.111", "foster child", "foster child", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    FOSTER_DAUGHTER("DAUFOST", "2.16.840.1.113883.5.111", "foster daughter", "foster daughter", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    FOSTER_SON("SONFOST", "2.16.840.1.113883.5.111", "foster son", "foster son", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    GRANDCHILD("GRNDCHILD", "2.16.840.1.113883.5.111", "grandchild", "grandchild", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    GRANDPARENT("GRPRN", "2.16.840.1.113883.5.111", "grandparent", "grandparent", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    GREAT_GRANDPARENT("GGRPRN", "2.16.840.1.113883.5.111", "great grandparent", "great grandparent", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    HUSBAND_L1("HUSB", "2.16.840.1.113883.5.111", "husband", "husband", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    MOTHER("MTH", "2.16.840.1.113883.5.111", "mother", "mother", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    MOTHER_IN_LAW("MTHINLAW", "2.16.840.1.113883.5.111", "mother-in-law", "mother-in-law", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    NATURAL_CHILD("NCHILD", "2.16.840.1.113883.5.111", "natural child", "natural child", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    NATURAL_DAUGHTER("DAU", "2.16.840.1.113883.5.111", "natural daughter", "natural daughter", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    NATURAL_SON("SON", "2.16.840.1.113883.5.111", "natural son", "natural son", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    NEIGHBOR("NBOR", "2.16.840.1.113883.5.111", "neighbor", "neighbor", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    NIECE_NEPHEW("NIENEPH", "2.16.840.1.113883.5.111", "niece/nephew", "niece/nephew", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    PARENT("PRN", "2.16.840.1.113883.5.111", "parent", "parent", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    PARENT_IN_LAW("PRNINLAW", "2.16.840.1.113883.5.111", "parent in-law", "parent in-law", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    ROOMMATE("ROOM", "2.16.840.1.113883.5.111", "roommate", "roommate", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    SIBLING("SIB", "2.16.840.1.113883.5.111", "sibling", "sibling", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    SIGNIFICANT_OTHER("SIGOTHR", "2.16.840.1.113883.5.111", "significant other", "significant other", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    SON("SONC", "2.16.840.1.113883.5.111", "son", "son", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    SON_IN_LAW("SONINLAW", "2.16.840.1.113883.5.111", "son in-law", "son in-law", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    SPOUSE("SPS", "2.16.840.1.113883.5.111", "spouse", "spouse", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    STEPDAUGHTER("STPDAU", "2.16.840.1.113883.5.111", "stepdaughter", "stepdaughter", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    STEPSON("STPSON", "2.16.840.1.113883.5.111", "stepson", "stepson", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    STEP_CHILD("STPCHLD", "2.16.840.1.113883.5.111", "step child", "step child", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    UNCLE("UNCLE", "2.16.840.1.113883.5.111", "uncle", "uncle", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    UNRELATED_FRIEND("FRND", "2.16.840.1.113883.5.111", "unrelated friend", "unrelated friend", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    WIFE_L1("WIFE", "2.16.840.1.113883.5.111", "wife", "wife", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE");

    public static final String ADOPTED_CHILD_CODE = "CHLDADOPT";
    public static final String ADOPTED_DAUGHTER_CODE = "DAUADOPT";
    public static final String ADOPTED_SON_CODE = "SONADOPT";
    public static final String AUNT_CODE = "AUNT";
    public static final String CHILD_CODE = "CHILD";
    public static final String CHILD_IN_LAW_CODE = "CHLDINLAW";
    public static final String COUSIN_CODE = "COUSN";
    public static final String DAUGHTER_CODE = "DAUC";
    public static final String DAUGHTER_IN_LAW_CODE = "DAUINLAW";
    public static final String DOMESTIC_PARTNER_CODE = "DOMPART";
    public static final String FAMILY_MEMBER_CODE = "FAMMEMB";
    public static final String FATHER_CODE = "FTH";
    public static final String FATHER_IN_LAW_CODE = "FTHINLAW";
    public static final String FOSTER_CHILD_CODE = "CHLDFOST";
    public static final String FOSTER_DAUGHTER_CODE = "DAUFOST";
    public static final String FOSTER_SON_CODE = "SONFOST";
    public static final String GRANDCHILD_CODE = "GRNDCHILD";
    public static final String GRANDPARENT_CODE = "GRPRN";
    public static final String GREAT_GRANDPARENT_CODE = "GGRPRN";
    public static final String HUSBAND_L1_CODE = "HUSB";
    public static final String MOTHER_CODE = "MTH";
    public static final String MOTHER_IN_LAW_CODE = "MTHINLAW";
    public static final String NATURAL_CHILD_CODE = "NCHILD";
    public static final String NATURAL_DAUGHTER_CODE = "DAU";
    public static final String NATURAL_SON_CODE = "SON";
    public static final String NEIGHBOR_CODE = "NBOR";
    public static final String NIECE_NEPHEW_CODE = "NIENEPH";
    public static final String PARENT_CODE = "PRN";
    public static final String PARENT_IN_LAW_CODE = "PRNINLAW";
    public static final String ROOMMATE_CODE = "ROOM";
    public static final String SIBLING_CODE = "SIB";
    public static final String SIGNIFICANT_OTHER_CODE = "SIGOTHR";
    public static final String SON_CODE = "SONC";
    public static final String SON_IN_LAW_CODE = "SONINLAW";
    public static final String SPOUSE_CODE = "SPS";
    public static final String STEPDAUGHTER_CODE = "STPDAU";
    public static final String STEPSON_CODE = "STPSON";
    public static final String STEP_CHILD_CODE = "STPCHLD";
    public static final String UNCLE_CODE = "UNCLE";
    public static final String UNRELATED_FRIEND_CODE = "FRND";
    public static final String WIFE_L1_CODE = "WIFE";
    public static final String VALUE_SET_ID = "1.2.40.0.34.10.17";
    public static final String VALUE_SET_NAME = "ELGA_PersonalRelationship";
    public static final String CODE_SYSTEM_ID = "2.16.840.1.113883.5.111";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable ElgaPersonalRelationship getEnum(@Nullable String code) {
        for (ElgaPersonalRelationship x : ElgaPersonalRelationship.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(ElgaPersonalRelationship.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (ElgaPersonalRelationship x : ElgaPersonalRelationship.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private ElgaPersonalRelationship(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

