/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.emed;

import java.util.ArrayList;
import java.util.List;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.ED;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.IVLPQ;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.ObjectFactory;
import org.projecthusky.common.hl7cdar2.PIVLTS;
import org.projecthusky.common.hl7cdar2.POCDMT000040Consumable;
import org.projecthusky.common.hl7cdar2.POCDMT000040ManufacturedProduct;
import org.projecthusky.common.hl7cdar2.POCDMT000040Material;
import org.projecthusky.common.hl7cdar2.POCDMT000040SubstanceAdministration;
import org.projecthusky.common.hl7cdar2.SXCMTS;
import org.projecthusky.common.hl7cdar2.SetOperator;
import org.projecthusky.common.hl7cdar2.XDocumentSubstanceMood;

public class AlteredSupplyInformation
extends POCDMT000040SubstanceAdministration {
    public AlteredSupplyInformation() {
        super.getClassCode().add("SBADM");
        super.setMoodCode(XDocumentSubstanceMood.INT);
        super.getTemplateId().add(AlteredSupplyInformation.createHl7TemplateIdFixedValue("1.3.6.1.4.1.19376.1.9.1.3.6"));
        super.setConsumable(AlteredSupplyInformation.createHl7ConsumableNa());
    }

    private static POCDMT000040Consumable createHl7ConsumableNa() {
        POCDMT000040Material material = new POCDMT000040Material();
        material.getNullFlavor().add("NA");
        POCDMT000040ManufacturedProduct product = new POCDMT000040ManufacturedProduct();
        product.setManufacturedMaterial(material);
        POCDMT000040Consumable consumable = new POCDMT000040Consumable();
        consumable.setManufacturedProduct(product);
        return consumable;
    }

    private static IVLPQ createHl7DoseQuantityFixedValue() {
        IVLPQ retVal = new IVLPQ();
        return retVal;
    }

    private static IVLTS createHl7EffectiveTimeFixedValue(String nullFlavor, String operator) {
        ObjectFactory factory = new ObjectFactory();
        IVLTS retVal = factory.createIVLTS();
        if (nullFlavor != null) {
            retVal.nullFlavor = new ArrayList();
            retVal.nullFlavor.add(nullFlavor);
        }
        if (operator != null) {
            retVal.setOperator(SetOperator.fromValue((String)operator));
        }
        return retVal;
    }

    private static II createHl7TemplateIdFixedValue(String root) {
        ObjectFactory factory = new ObjectFactory();
        II retVal = factory.createII();
        retVal.setRoot(root);
        return retVal;
    }

    public POCDMT000040Consumable getHl7Consumable() {
        return this.consumable;
    }

    public IVLPQ getHl7DoseQuantityIvlpq() {
        return this.doseQuantity;
    }

    public SXCMTS getHl7EffectiveTimePivlTs() {
        if (this.effectiveTime != null && !this.effectiveTime.isEmpty()) {
            return (SXCMTS)this.effectiveTime.get(0);
        }
        return null;
    }

    public CE getHl7RouteCode() {
        return this.routeCode;
    }

    public List<II> getHl7TemplateId() {
        return this.templateId;
    }

    public ED getHl7Text() {
        return this.text;
    }

    public static IVLPQ getPredefinedDoseQuantity() {
        return AlteredSupplyInformation.createHl7DoseQuantityFixedValue();
    }

    public static IVLTS getPredefinedEffectiveTimeANull() {
        return AlteredSupplyInformation.createHl7EffectiveTimeFixedValue(null, "A");
    }

    public static IVLTS getPredefinedEffectiveTimeNa() {
        return AlteredSupplyInformation.createHl7EffectiveTimeFixedValue("NA", null);
    }

    public static II getPredefinedTemplateId136141193761531421() {
        return AlteredSupplyInformation.createHl7TemplateIdFixedValue("1.3.6.1.4.1.19376.1.5.3.1.4.21");
    }

    public static II getPredefinedTemplateId136141193761531471() {
        return AlteredSupplyInformation.createHl7TemplateIdFixedValue("1.3.6.1.4.1.19376.1.5.3.1.4.7.1");
    }

    public static II getPredefinedTemplateId13614119376153149() {
        return AlteredSupplyInformation.createHl7TemplateIdFixedValue("1.3.6.1.4.1.19376.1.5.3.1.4.9");
    }

    public void setHl7Consumable(POCDMT000040Consumable value) {
        this.consumable = value;
    }

    public void setHl7DoseQuantity(IVLPQ value) {
        this.doseQuantity = value;
    }

    public void setHl7EffectiveTime(PIVLTS value) {
        this.effectiveTime.clear();
        this.effectiveTime.add(value);
    }

    public void setHl7EffectiveTime(IVLTS value) {
        this.effectiveTime.clear();
        this.effectiveTime.add(value);
    }

    public void setHl7RouteCode(CE value) {
        this.routeCode = value;
    }

    public void setHl7TemplateId(II value) {
        this.getTemplateId().clear();
        this.getTemplateId().add(value);
    }

    public void setHl7Text(ED value) {
        this.text = value;
    }
}

