/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.emed;

import java.util.List;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.ObjectFactory;
import org.projecthusky.common.hl7cdar2.POCDMT000040Entry;
import org.projecthusky.common.hl7cdar2.POCDMT000040Section;
import org.projecthusky.common.hl7cdar2.ST;
import org.projecthusky.common.hl7cdar2.StrucDocText;
import org.projecthusky.common.hl7cdar2.XActRelationshipEntry;

public class MedikationslistenSection
extends POCDMT000040Section {
    public MedikationslistenSection() {
        super.getClassCode().add("DOCSECT");
        super.getTemplateId().add(MedikationslistenSection.createHl7TemplateIdFixedValue("1.2.40.0.34.11.8.3.2.1"));
        super.getTemplateId().add(MedikationslistenSection.createHl7TemplateIdFixedValue("1.3.6.1.4.1.19376.1.9.1.2.5"));
        super.setCode(MedikationslistenSection.createHl7CodeFixedValue("10160-0", "2.16.840.1.113883.6.1", "LOINC", "History of medication use"));
    }

    private static CE createHl7CodeFixedValue(String code, String codeSystem, String codeSystemName, String displayName) {
        ObjectFactory factory = new ObjectFactory();
        CE retVal = factory.createCE();
        retVal.setCode(code);
        retVal.setCodeSystem(codeSystem);
        retVal.setCodeSystemName(codeSystemName);
        retVal.setDisplayName(displayName);
        return retVal;
    }

    private static POCDMT000040Entry createHl7EntryFixedValue(String typeCode) {
        ObjectFactory factory = new ObjectFactory();
        POCDMT000040Entry retVal = factory.createPOCDMT000040Entry();
        retVal.setTypeCode(XActRelationshipEntry.fromValue((String)typeCode));
        return retVal;
    }

    private static II createHl7TemplateIdFixedValue(String root) {
        ObjectFactory factory = new ObjectFactory();
        II retVal = factory.createII();
        retVal.setRoot(root);
        return retVal;
    }

    public CE getHl7Code() {
        return this.code;
    }

    public List<POCDMT000040Entry> getHl7Entry() {
        return this.entry;
    }

    public II getHl7Id() {
        return this.id;
    }

    public List<II> getHl7TemplateId() {
        return this.templateId;
    }

    public StrucDocText getHl7Text() {
        return this.text;
    }

    public ST getHl7Title() {
        return this.title;
    }

    public static POCDMT000040Entry getPredefinedEntryDriv() {
        return MedikationslistenSection.createHl7EntryFixedValue("DRIV");
    }

    public void setHl7Code(CE value) {
        this.code = value;
    }

    public void setHl7Entry(POCDMT000040Entry value) {
        this.getEntry().clear();
        this.getEntry().add(value);
    }

    public void setHl7Id(II value) {
        this.id = value;
    }

    public void setHl7TemplateId(II value) {
        this.getTemplateId().clear();
        this.getTemplateId().add(value);
    }

    public void setHl7Text(StrucDocText value) {
        this.text = value;
    }

    public void setHl7Title(ST value) {
        this.title = value;
    }
}

