/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.ems;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.projecthusky.cda.elga.generated.artdecor.ems.EpimsPatientRole;
import org.projecthusky.common.hl7cdar2.CS;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.POCDMT000040InfrastructureRootTypeId;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="POCD_MT000040.EpimsHeaderRecordTarget", namespace="urn:hl7-org:v3", propOrder={"realmCode", "typeId", "templateId", "patientRole"})
public class EpimsHeaderRecordTarget {
    protected List<CS> realmCode;
    protected POCDMT000040InfrastructureRootTypeId typeId;
    protected List<II> templateId;
    @XmlElement(required=true, name="patientRole")
    protected EpimsPatientRole patientRole;
    @XmlAttribute(name="nullFlavor")
    protected List<String> nullFlavor;
    @XmlAttribute(name="typeCode")
    protected List<String> typeCode;
    @XmlAttribute(name="contextControlCode")
    protected String contextControlCode;

    public EpimsHeaderRecordTarget() {
        this.getTypeCode().add("RCT");
        this.setContextControlCode("OP");
        this.setPatientRole(EpimsHeaderRecordTarget.createHl7PatientRoleFixedValue("PAT"));
    }

    private static EpimsPatientRole createHl7PatientRoleFixedValue(String classCode) {
        EpimsPatientRole retVal = new EpimsPatientRole();
        retVal.getClassCode().add(classCode);
        return retVal;
    }

    public @NonNull String getContextControlCode() {
        if (this.contextControlCode == null) {
            return "OP";
        }
        return this.contextControlCode;
    }

    public @NonNull List<String> getNullFlavor() {
        if (this.nullFlavor == null) {
            this.nullFlavor = new ArrayList<String>();
        }
        return this.nullFlavor;
    }

    public EpimsPatientRole getPatientRole() {
        return this.patientRole;
    }

    public @NonNull List<CS> getRealmCode() {
        if (this.realmCode == null) {
            this.realmCode = new ArrayList<CS>();
        }
        return this.realmCode;
    }

    public @NonNull List<II> getTemplateId() {
        if (this.templateId == null) {
            this.templateId = new ArrayList<II>();
        }
        return this.templateId;
    }

    public @NonNull List<String> getTypeCode() {
        if (this.typeCode == null) {
            this.typeCode = new ArrayList<String>();
        }
        return this.typeCode;
    }

    public POCDMT000040InfrastructureRootTypeId getTypeId() {
        return this.typeId;
    }

    public void setContextControlCode(String value) {
        this.contextControlCode = value;
    }

    public void setPatientRole(EpimsPatientRole value) {
        this.patientRole = value;
    }

    public void setTypeId(POCDMT000040InfrastructureRootTypeId value) {
        this.typeId = value;
    }
}

