/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.ems;

import java.util.ArrayList;
import java.util.List;
import org.projecthusky.common.basetypes.CodeBaseType;
import org.projecthusky.common.hl7cdar2.ANY;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.CS;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.ObjectFactory;
import org.projecthusky.common.hl7cdar2.POCDMT000040Observation;
import org.projecthusky.common.hl7cdar2.XActMoodDocumentObservation;
import org.projecthusky.common.model.Code;

public class NotifiableCondition
extends POCDMT000040Observation {
    private final List<Code> vocabStatusCodeCode = new ArrayList<Code>();

    public NotifiableCondition() {
        super.getClassCode().add("COND");
        super.setMoodCode(XActMoodDocumentObservation.EVN);
        super.getTemplateId().add(NotifiableCondition.createHl7TemplateIdFixedValue("1.3.6.1.4.1.19376.1.3.1.1.1"));
        super.setCode(NotifiableCondition.createHl7CodeFixedValue("170516003", "2.16.840.1.113883.6.96", null, null));
        this.vocabStatusCodeCode.add(new Code(CodeBaseType.builder().withCode("completed").build()));
        this.statusCode = new Code(CodeBaseType.builder().withCode("completed").build()).getHl7CdaR2Cs();
        super.getValue().add(NotifiableCondition.createHl7ValueFixedValue());
    }

    private static CD createHl7CodeFixedValue(String code, String codeSystem, String codeSystemName, String displayName) {
        ObjectFactory factory = new ObjectFactory();
        CD retVal = factory.createCD();
        retVal.setCode(code);
        retVal.setCodeSystem(codeSystem);
        retVal.setCodeSystemName(codeSystemName);
        retVal.setDisplayName(displayName);
        return retVal;
    }

    private static II createHl7TemplateIdFixedValue(String root) {
        ObjectFactory factory = new ObjectFactory();
        II retVal = factory.createII();
        retVal.setRoot(root);
        return retVal;
    }

    private static CE createHl7ValueFixedValue() {
        ObjectFactory factory = new ObjectFactory();
        CE retVal = factory.createCE();
        return retVal;
    }

    public CD getHl7Code() {
        return this.code;
    }

    public CS getHl7StatusCode() {
        return this.statusCode;
    }

    public List<II> getHl7TemplateId() {
        return this.templateId;
    }

    public List<ANY> getHl7Value() {
        return this.value;
    }

    public List<Code> getVocabStatusCodeCode() {
        return this.vocabStatusCodeCode;
    }

    public void setHl7Code(CD value) {
        this.code = value;
    }

    public void setHl7StatusCode(CS value) {
        this.statusCode = value;
    }

    public void setHl7TemplateId(II value) {
        this.getTemplateId().clear();
        this.getTemplateId().add(value);
    }

    public void setHl7Value(CE value) {
        this.getValue().clear();
        this.getValue().add(value);
    }
}

