/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.ems;

import java.util.List;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.ObjectFactory;
import org.projecthusky.common.hl7cdar2.POCDMT000040Act;
import org.projecthusky.common.hl7cdar2.POCDMT000040EntryRelationship;
import org.projecthusky.common.hl7cdar2.TS;
import org.projecthusky.common.hl7cdar2.XActClassDocumentEntryAct;
import org.projecthusky.common.hl7cdar2.XActRelationshipEntryRelationship;
import org.projecthusky.common.hl7cdar2.XDocumentActMood;

public class SpecimenReceived
extends POCDMT000040Act {
    public SpecimenReceived() {
        super.setClassCode(XActClassDocumentEntryAct.ACT);
        super.setMoodCode(XDocumentActMood.EVN);
        super.getTemplateId().add(SpecimenReceived.createHl7TemplateIdFixedValue("1.3.6.1.4.1.19376.1.3.1.3"));
        super.setCode((CD)SpecimenReceived.createHl7CodeFixedValue("SPRECEIVE", "1.3.5.1.4.1.19376.1.5.3.2", null, null));
    }

    public void addHl7EntryRelationship(POCDMT000040EntryRelationship value) {
        this.getEntryRelationship().add(value);
    }

    public void clearHl7EntryRelationship() {
        this.getEntryRelationship().clear();
    }

    private static CE createHl7CodeFixedValue(String code, String codeSystem, String codeSystemName, String displayName) {
        ObjectFactory factory = new ObjectFactory();
        CE retVal = factory.createCE();
        retVal.setCode(code);
        retVal.setCodeSystem(codeSystem);
        retVal.setCodeSystemName(codeSystemName);
        retVal.setDisplayName(displayName);
        return retVal;
    }

    private static POCDMT000040EntryRelationship createHl7EntryRelationshipFixedValue(String typeCode, String inversionInd) {
        ObjectFactory factory = new ObjectFactory();
        POCDMT000040EntryRelationship retVal = factory.createPOCDMT000040EntryRelationship();
        retVal.setTypeCode(XActRelationshipEntryRelationship.fromValue((String)typeCode));
        if (inversionInd != null) {
            retVal.setInversionInd(Boolean.valueOf(Boolean.parseBoolean(inversionInd)));
        }
        return retVal;
    }

    private static II createHl7TemplateIdFixedValue(String root) {
        ObjectFactory factory = new ObjectFactory();
        II retVal = factory.createII();
        retVal.setRoot(root);
        return retVal;
    }

    public CE getHl7Code() {
        return (CE)this.code;
    }

    public TS getHl7EffectiveTime() {
        return this.effectiveTime;
    }

    public List<II> getHl7TemplateId() {
        return this.templateId;
    }

    public static POCDMT000040EntryRelationship getPredefinedEntryRelationshipCompNull() {
        return SpecimenReceived.createHl7EntryRelationshipFixedValue("COMP", null);
    }

    public void setHl7Code(CE value) {
        this.code = value;
    }

    public void setHl7EffectiveTime(TS value) {
        ObjectFactory factory = new ObjectFactory();
        IVLTS ivlts = factory.createIVLTS();
        ivlts.setValue(value.getValue());
        this.effectiveTime = ivlts;
    }

    public void setHl7TemplateId(II value) {
        this.getTemplateId().clear();
        this.getTemplateId().add(value);
    }
}

