/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.enums;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum ElgaActEncounterCode implements ValueSetEnumInterface
{
    ACTENCOUNTERCODE("_ActEncounterCode", "2.16.840.1.113883.5.4", "ActEncounterCode", "ActEncounterCode", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    AMBULATORY_L1("AMB", "2.16.840.1.113883.5.4", "ambulatory", "ambulatory", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    EMERGENCY_L1("EMER", "2.16.840.1.113883.5.4", "emergency", "emergency", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    FIELD_L1("FLD", "2.16.840.1.113883.5.4", "field", "field", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    HOME_HEALTH_L1("HH", "2.16.840.1.113883.5.4", "home health", "home health", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    INPATIENT_ACUTE_L2("ACUTE", "2.16.840.1.113883.5.4", "inpatient acute", "inpatient acute", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    INPATIENT_ENCOUNTER_L1("IMP", "2.16.840.1.113883.5.4", "inpatient encounter", "inpatient encounter", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    INPATIENT_NON_ACUTE_L2("NONAC", "2.16.840.1.113883.5.4", "inpatient non-acute", "inpatient non-acute", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    PRE_ADMISSION_L1("PRENC", "2.16.840.1.113883.5.4", "pre-admission", "pre-admission", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    SHORT_STAY_L1("SS", "2.16.840.1.113883.5.4", "short stay", "short stay", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    VIRTUAL_L1("VR", "2.16.840.1.113883.5.4", "virtual", "virtual", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE");

    public static final String ACTENCOUNTERCODE_CODE = "_ActEncounterCode";
    public static final String AMBULATORY_L1_CODE = "AMB";
    public static final String EMERGENCY_L1_CODE = "EMER";
    public static final String FIELD_L1_CODE = "FLD";
    public static final String HOME_HEALTH_L1_CODE = "HH";
    public static final String INPATIENT_ACUTE_L2_CODE = "ACUTE";
    public static final String INPATIENT_ENCOUNTER_L1_CODE = "IMP";
    public static final String INPATIENT_NON_ACUTE_L2_CODE = "NONAC";
    public static final String PRE_ADMISSION_L1_CODE = "PRENC";
    public static final String SHORT_STAY_L1_CODE = "SS";
    public static final String VIRTUAL_L1_CODE = "VR";
    public static final String VALUE_SET_ID = "1.2.40.0.34.10.5";
    public static final String VALUE_SET_NAME = "ELGA_ActEncounterCode";
    public static final String CODE_SYSTEM_ID = "2.16.840.1.113883.5.4";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable ElgaActEncounterCode getEnum(@Nullable String code) {
        for (ElgaActEncounterCode x : ElgaActEncounterCode.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(ElgaActEncounterCode.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (ElgaActEncounterCode x : ElgaActEncounterCode.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private ElgaActEncounterCode(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

