/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.enums;

import java.util.HashMap;
import java.util.Map;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum ElgaEventCodeList implements ValueSetEnumInterface
{
    IMMUNIZATION_RECORD("41000179103", "2.16.840.1.113883.6.96", "Immunization record (record artifact)");

    public static final String IMMUNIZATION_RECORD_CODE = "41000179103";
    public static final String VALUE_SET_ID = "2.16.840.1.113883.6.96";
    public static final String VALUE_SET_NAME = "SNOMED CT";
    private String code;
    private String codeSystem;
    private Map<LanguageCode, String> displayNames;

    public static ElgaEventCodeList getEnum(String code) {
        for (ElgaEventCodeList x : ElgaEventCodeList.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(ElgaEventCodeList.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(String codeValue) {
        for (ElgaEventCodeList x : ElgaEventCodeList.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private ElgaEventCodeList(String code, String codeSystem, String displayName) {
        this.code = code;
        this.codeSystem = codeSystem;
        this.displayNames = new HashMap<LanguageCode, String>();
        this.displayNames.put(null, displayName);
    }

    public String getCodeSystemId() {
        return this.codeSystem;
    }

    public String getCodeSystemName() {
        String retVal = "";
        CodeSystems cs = CodeSystems.getEnum((String)this.codeSystem);
        if (cs != null) {
            retVal = cs.getCodeSystemName();
        }
        return retVal;
    }

    public String getCodeValue() {
        return this.code;
    }

    public String getDisplayName(LanguageCode languageCode) {
        String displayName = this.displayNames.get(languageCode);
        if (displayName == null && languageCode == LanguageCode.ENGLISH) {
            return this.displayNames.get(null);
        }
        return displayName;
    }

    public String getValueSetId() {
        return VALUE_SET_ID;
    }

    public String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

