/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.enums;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum ElgaMedientyp implements ValueSetEnumInterface
{
    MIME_TYPE_APPLICATION_DICOM("application/dicom", "1.2.840.10003.5.109", "Mime Type application/dicom", "Mime Type application/dicom", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    MIME_TYPE_APPLICATION_PDF("application/pdf", "1.2.840.10003.5.109", "Mime Type application/pdf", "Mime Type application/pdf", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    MIME_TYPE_AUDIO_MPEG("audio/mpeg", "1.2.840.10003.5.109", "Mime Type audio/mpeg", "Mime Type audio/mpeg", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    MIME_TYPE_IMAGE_GIF("image/gif", "1.2.840.10003.5.109", "Mime Type image/gif", "Mime Type image/gif", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    MIME_TYPE_IMAGE_JPEG("image/jpeg", "1.2.840.10003.5.109", "Mime Type image/jpeg", "Mime Type image/jpeg", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    MIME_TYPE_IMAGE_PNG("image/png", "1.2.840.10003.5.109", "Mime Type image/png", "Mime Type image/png", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    MIME_TYPE_TEXT_XML("text/xml", "1.2.840.10003.5.109", "Mime Type text/xml", "Mime Type text/xml", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    MIME_TYPE_VIDEO_MPEG("video/mpeg", "1.2.840.10003.5.109", "Mime Type video/mpeg", "Mime Type video/mpeg", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE");

    public static final String MIME_TYPE_APPLICATION_DICOM_CODE = "application/dicom";
    public static final String MIME_TYPE_APPLICATION_PDF_CODE = "application/pdf";
    public static final String MIME_TYPE_AUDIO_MPEG_CODE = "audio/mpeg";
    public static final String MIME_TYPE_IMAGE_GIF_CODE = "image/gif";
    public static final String MIME_TYPE_IMAGE_JPEG_CODE = "image/jpeg";
    public static final String MIME_TYPE_IMAGE_PNG_CODE = "image/png";
    public static final String MIME_TYPE_TEXT_XML_CODE = "text/xml";
    public static final String MIME_TYPE_VIDEO_MPEG_CODE = "video/mpeg";
    public static final String VALUE_SET_ID = "1.2.40.0.34.10.42";
    public static final String VALUE_SET_NAME = "ELGA_Medientyp";
    public static final String CODE_SYSTEM_ID = "1.2.840.10003.5.109";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable ElgaMedientyp getEnum(@Nullable String code) {
        for (ElgaMedientyp x : ElgaMedientyp.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(ElgaMedientyp.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (ElgaMedientyp x : ElgaMedientyp.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private ElgaMedientyp(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

