/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.enums;

import java.util.HashMap;
import java.util.Map;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum ElgaObservationInterpretation implements ValueSetEnumInterface
{
    ABNORMAL("A", "2.16.840.1.113883.5.83", "Abnormal", "Abnormal", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    DECREASED("D", "2.16.840.1.113883.5.83", "decreased", "decreased", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    HIGH("H", "2.16.840.1.113883.5.83", "High", "High", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    HIGH_OFF_SCALE(">", "2.16.840.1.113883.5.83", "high off scale", "high off scale", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    INCREASED("U", "2.16.840.1.113883.5.83", "increased", "increased", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    INDETERMINATE("IND", "2.16.840.1.113883.5.83", "Indeterminate", "Indeterminate", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    INTERMEDIATE("I", "2.16.840.1.113883.5.83", "Intermediate", "Intermediate", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    LOW("L", "2.16.840.1.113883.5.83", "Low", "Low", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    LOW_OFF_SCALE("<", "2.16.840.1.113883.5.83", "low off scale", "low off scale", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    NEGATIVE("NEG", "2.16.840.1.113883.5.83", "Negative", "Negative", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    NORMAL("N", "2.16.840.1.113883.5.83", "normal", "normal", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    OUTSIDE_THRESHOLD("EX", "2.16.840.1.113883.5.83", "outside threshold", "outside threshold", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    POSITIVE("POS", "2.16.840.1.113883.5.83", "Positive", "Positive", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    RESISTENT("R", "2.16.840.1.113883.5.83", "Resistent", "Resistent", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    SUSCEPTIBLE("S", "2.16.840.1.113883.5.83", "Susceptible", "Susceptible", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE");

    public static final String ABNORMAL_CODE = "A";
    public static final String DECREASED_CODE = "D";
    public static final String HIGH_CODE = "H";
    public static final String HIGH_OFF_SCALE_CODE = ">";
    public static final String INCREASED_CODE = "U";
    public static final String INDETERMINATE_CODE = "IND";
    public static final String INTERMEDIATE_CODE = "I";
    public static final String LOW_CODE = "L";
    public static final String LOW_OFF_SCALE_CODE = "<";
    public static final String NEGATIVE_CODE = "NEG";
    public static final String NORMAL_CODE = "N";
    public static final String OUTSIDE_THRESHOLD_CODE = "EX";
    public static final String POSITIVE_CODE = "POS";
    public static final String RESISTENT_CODE = "R";
    public static final String SUSCEPTIBLE_CODE = "S";
    public static final String VALUE_SET_ID = "1.2.40.0.34.10.13";
    public static final String VALUE_SET_NAME = "ELGA_ObservationInterpretation";
    private String code;
    private String codeSystem;
    private Map<LanguageCode, String> displayNames;

    public static ElgaObservationInterpretation getEnum(String code) {
        for (ElgaObservationInterpretation x : ElgaObservationInterpretation.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(ElgaObservationInterpretation.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(String codeValue) {
        for (ElgaObservationInterpretation x : ElgaObservationInterpretation.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private ElgaObservationInterpretation(String code, String codeSystem, String displayName, String displayNameEn, String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = code;
        this.codeSystem = codeSystem;
        this.displayNames = new HashMap<LanguageCode, String>();
        this.displayNames.put(null, displayName);
        this.displayNames.put(LanguageCode.ENGLISH, displayNameEn);
        this.displayNames.put(LanguageCode.GERMAN, displayNameDe);
        this.displayNames.put(LanguageCode.FRENCH, displayNameFr);
        this.displayNames.put(LanguageCode.ITALIAN, displayNameIt);
    }

    public String getCodeSystemId() {
        return this.codeSystem;
    }

    public String getCodeSystemName() {
        String retVal = "";
        CodeSystems cs = CodeSystems.getEnum((String)this.codeSystem);
        if (cs != null) {
            retVal = cs.getCodeSystemName();
        }
        return retVal;
    }

    public String getCodeValue() {
        return this.code;
    }

    public String getDisplayName(LanguageCode languageCode) {
        String displayName = this.displayNames.get(languageCode);
        if (displayName == null && languageCode == LanguageCode.ENGLISH) {
            return this.displayNames.get(null);
        }
        return displayName;
    }

    public String getValueSetId() {
        return VALUE_SET_ID;
    }

    public String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

