/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.enums;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum TargetAwareness implements ValueSetEnumInterface
{
    DENYING("D", "2.16.840.1.113883.5.137", "denying", "denying", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    FULL_AWARENESS("F", "2.16.840.1.113883.5.137", "full awareness", "full awareness", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    INCAPABLE("I", "2.16.840.1.113883.5.137", "incapable", "incapable", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    MARGINAL("M", "2.16.840.1.113883.5.137", "marginal", "marginal", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    PARTIAL("P", "2.16.840.1.113883.5.137", "partial", "partial", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    UNINFORMED("U", "2.16.840.1.113883.5.137", "uninformed", "uninformed", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE");

    public static final String DENYING_CODE = "D";
    public static final String FULL_AWARENESS_CODE = "F";
    public static final String INCAPABLE_CODE = "I";
    public static final String MARGINAL_CODE = "M";
    public static final String PARTIAL_CODE = "P";
    public static final String UNINFORMED_CODE = "U";
    public static final String VALUE_SET_ID = "2.16.840.1.113883.1.11.10310";
    public static final String VALUE_SET_NAME = "TargetAwareness";
    public static final String CODE_SYSTEM_ID = "2.16.840.1.113883.5.137";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable TargetAwareness getEnum(@Nullable String code) {
        for (TargetAwareness x : TargetAwareness.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(TargetAwareness.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (TargetAwareness x : TargetAwareness.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private TargetAwareness(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

