/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.ps;

import java.util.ArrayList;
import java.util.List;
import org.projecthusky.common.basetypes.CodeBaseType;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.CS;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.ObjectFactory;
import org.projecthusky.common.hl7cdar2.POCDMT000040Act;
import org.projecthusky.common.hl7cdar2.POCDMT000040Author;
import org.projecthusky.common.hl7cdar2.POCDMT000040EntryRelationship;
import org.projecthusky.common.hl7cdar2.POCDMT000040Informant12;
import org.projecthusky.common.hl7cdar2.POCDMT000040Reference;
import org.projecthusky.common.hl7cdar2.XActClassDocumentEntryAct;
import org.projecthusky.common.hl7cdar2.XActRelationshipEntryRelationship;
import org.projecthusky.common.hl7cdar2.XActRelationshipExternalReference;
import org.projecthusky.common.hl7cdar2.XDocumentActMood;
import org.projecthusky.common.model.Code;

public class AllergienUnvertraeglichkeitenEntry
extends POCDMT000040Act {
    private final List<Code> vocabStatusCodeCode = new ArrayList<Code>();

    public AllergienUnvertraeglichkeitenEntry() {
        super.setClassCode(XActClassDocumentEntryAct.ACT);
        super.setMoodCode(XDocumentActMood.EVN);
        super.getTemplateId().add(AllergienUnvertraeglichkeitenEntry.createHl7TemplateIdFixedValue("1.2.40.0.34.11.13.3.1"));
        super.setCode((CD)AllergienUnvertraeglichkeitenEntry.createHl7CodeFixedValue("CONC", "2.16.840.1.113883.5.6", null, null));
        this.vocabStatusCodeCode.add(new Code(CodeBaseType.builder().withCode("active").build()));
        this.vocabStatusCodeCode.add(new Code(CodeBaseType.builder().withCode("completed").build()));
        super.getEntryRelationship().add(AllergienUnvertraeglichkeitenEntry.createHl7EntryRelationshipFixedValue("SUBJ", "false"));
    }

    public void addHl7Author(POCDMT000040Author value) {
        this.getAuthor().add(value);
    }

    public void addHl7EntryRelationship(POCDMT000040EntryRelationship value) {
        this.getEntryRelationship().add(value);
    }

    public void addHl7Id(II value) {
        this.getId().add(value);
    }

    public void addHl7Informant(POCDMT000040Informant12 value) {
        this.getInformant().add(value);
    }

    public void clearHl7Author() {
        this.getAuthor().clear();
    }

    public void clearHl7EntryRelationship() {
        this.getEntryRelationship().clear();
    }

    public void clearHl7Id() {
        this.getId().clear();
    }

    public void clearHl7Informant() {
        this.getInformant().clear();
    }

    private static POCDMT000040Author createHl7AuthorFixedValue(String typeCode, String contextControlCode) {
        ObjectFactory factory = new ObjectFactory();
        POCDMT000040Author retVal = factory.createPOCDMT000040Author();
        retVal.getTypeCode().add(typeCode);
        retVal.setContextControlCode(contextControlCode);
        return retVal;
    }

    private static CE createHl7CodeFixedValue(String code, String codeSystem, String codeSystemName, String displayName) {
        ObjectFactory factory = new ObjectFactory();
        CE retVal = factory.createCE();
        retVal.setCode(code);
        retVal.setCodeSystem(codeSystem);
        retVal.setCodeSystemName(codeSystemName);
        retVal.setDisplayName(displayName);
        return retVal;
    }

    private static POCDMT000040EntryRelationship createHl7EntryRelationshipFixedValue(String typeCode, String inversionInd) {
        ObjectFactory factory = new ObjectFactory();
        POCDMT000040EntryRelationship retVal = factory.createPOCDMT000040EntryRelationship();
        retVal.setTypeCode(XActRelationshipEntryRelationship.fromValue((String)typeCode));
        if (inversionInd != null) {
            retVal.setInversionInd(Boolean.valueOf(Boolean.parseBoolean(inversionInd)));
        }
        return retVal;
    }

    private static POCDMT000040Informant12 createHl7InformantFixedValue(String typeCode, String contextControlCode) {
        ObjectFactory factory = new ObjectFactory();
        POCDMT000040Informant12 retVal = factory.createPOCDMT000040Informant12();
        retVal.getTypeCode().add(typeCode);
        retVal.setContextControlCode(contextControlCode);
        return retVal;
    }

    private static POCDMT000040Reference createHl7ReferenceFixedValue(String typeCode) {
        ObjectFactory factory = new ObjectFactory();
        POCDMT000040Reference retVal = factory.createPOCDMT000040Reference();
        retVal.setTypeCode(XActRelationshipExternalReference.fromValue((String)typeCode));
        return retVal;
    }

    private static II createHl7TemplateIdFixedValue(String root) {
        ObjectFactory factory = new ObjectFactory();
        II retVal = factory.createII();
        retVal.setRoot(root);
        return retVal;
    }

    public CE getHl7Code() {
        return (CE)this.code;
    }

    public IVLTS getHl7EffectiveTime() {
        return this.effectiveTime;
    }

    public List<POCDMT000040Reference> getHl7Reference() {
        return this.reference;
    }

    public CS getHl7StatusCode() {
        return this.statusCode;
    }

    public List<II> getHl7TemplateId() {
        return this.templateId;
    }

    public static POCDMT000040Author getPredefinedAuthorAutOp() {
        return AllergienUnvertraeglichkeitenEntry.createHl7AuthorFixedValue("AUT", "OP");
    }

    public static POCDMT000040Informant12 getPredefinedInformantInfOp() {
        return AllergienUnvertraeglichkeitenEntry.createHl7InformantFixedValue("INF", "OP");
    }

    public static POCDMT000040Reference getPredefinedReferenceRefr() {
        return AllergienUnvertraeglichkeitenEntry.createHl7ReferenceFixedValue("REFR");
    }

    public List<Code> getVocabStatusCodeCode() {
        return this.vocabStatusCodeCode;
    }

    public void setHl7Code(CE value) {
        this.code = value;
    }

    public void setHl7EffectiveTime(IVLTS value) {
        this.effectiveTime = value;
    }

    public void setHl7Reference(POCDMT000040Reference value) {
        this.getReference().clear();
        this.getReference().add(value);
    }

    public void setHl7StatusCode(CS value) {
        this.statusCode = value;
    }

    public void setHl7TemplateId(II value) {
        this.getTemplateId().clear();
        this.getTemplateId().add(value);
    }
}

