/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.ps;

import java.util.ArrayList;
import java.util.List;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.IVLPQ;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.ObjectFactory;
import org.projecthusky.common.hl7cdar2.PIVLTS;
import org.projecthusky.common.hl7cdar2.POCDMT000040Consumable;
import org.projecthusky.common.hl7cdar2.POCDMT000040ManufacturedProduct;
import org.projecthusky.common.hl7cdar2.POCDMT000040Material;
import org.projecthusky.common.hl7cdar2.POCDMT000040SubstanceAdministration;
import org.projecthusky.common.hl7cdar2.SXCMTS;
import org.projecthusky.common.hl7cdar2.SXPRTS;
import org.projecthusky.common.hl7cdar2.SetOperator;
import org.projecthusky.common.hl7cdar2.XDocumentSubstanceMood;

public class AlteredDosageInformation
extends POCDMT000040SubstanceAdministration {
    public AlteredDosageInformation() {
        super.getClassCode().add("SBADM");
        super.setMoodCode(XDocumentSubstanceMood.INT);
        super.getTemplateId().add(AlteredDosageInformation.createHl7TemplateIdFixedValue("1.3.6.1.4.1.19376.1.9.1.3.6"));
        super.setConsumable(AlteredDosageInformation.createHl7ConsumableNa());
    }

    private static POCDMT000040Consumable createHl7ConsumableNa() {
        POCDMT000040Material material = new POCDMT000040Material();
        material.getNullFlavor().add("NA");
        POCDMT000040ManufacturedProduct product = new POCDMT000040ManufacturedProduct();
        product.setManufacturedMaterial(material);
        POCDMT000040Consumable consumable = new POCDMT000040Consumable();
        consumable.setManufacturedProduct(product);
        return consumable;
    }

    private static IVLPQ createHl7DoseQuantityFixedValue() {
        ObjectFactory factory = new ObjectFactory();
        IVLPQ retVal = factory.createIVLPQ();
        return retVal;
    }

    private static PIVLTS createHl7EffectiveTimeFixedValue(String operator, String nullFlavor) {
        ObjectFactory factory = new ObjectFactory();
        PIVLTS retVal = factory.createPIVLTS();
        retVal.setOperator(SetOperator.valueOf((String)operator));
        if (nullFlavor != null) {
            retVal.nullFlavor = new ArrayList();
            retVal.nullFlavor.add(nullFlavor);
        }
        return retVal;
    }

    private static II createHl7TemplateIdFixedValue(String root) {
        ObjectFactory factory = new ObjectFactory();
        II retVal = factory.createII();
        retVal.setRoot(root);
        return retVal;
    }

    public POCDMT000040Consumable getHl7Consumable() {
        return this.consumable;
    }

    public IVLPQ getHl7DoseQuantity() {
        return this.doseQuantity;
    }

    public List<SXCMTS> getHl7EffectiveTimeListSxcmts() {
        return this.effectiveTime;
    }

    public CE getHl7RouteCode() {
        return this.routeCode;
    }

    public List<II> getHl7TemplateId() {
        return this.templateId;
    }

    public static IVLPQ getPredefinedDoseQuantity() {
        return AlteredDosageInformation.createHl7DoseQuantityFixedValue();
    }

    public static PIVLTS getPredefinedEffectiveTimeA() {
        return AlteredDosageInformation.createHl7EffectiveTimeFixedValue("A", null);
    }

    public static PIVLTS getPredefinedEffectiveTimeNaNull() {
        return AlteredDosageInformation.createHl7EffectiveTimeFixedValue(null, "NA");
    }

    public static II getPredefinedTemplateId136141193761531421() {
        return AlteredDosageInformation.createHl7TemplateIdFixedValue("1.3.6.1.4.1.19376.1.5.3.1.4.21");
    }

    public static II getPredefinedTemplateId136141193761531471() {
        return AlteredDosageInformation.createHl7TemplateIdFixedValue("1.3.6.1.4.1.19376.1.5.3.1.4.7.1");
    }

    public static II getPredefinedTemplateId13614119376153149() {
        return AlteredDosageInformation.createHl7TemplateIdFixedValue("1.3.6.1.4.1.19376.1.5.3.1.4.9");
    }

    public void setHl7Consumable(POCDMT000040Consumable value) {
        this.consumable = value;
    }

    public void setHl7DoseQuantity(IVLPQ value) {
        this.doseQuantity = value;
    }

    public void setHl7EffectiveTime(PIVLTS value) {
        this.getEffectiveTime().clear();
        this.getEffectiveTime().add(value);
    }

    public void setHl7EffectiveTime(SXPRTS value) {
        this.getEffectiveTime().clear();
        this.getEffectiveTime().add(value);
    }

    public void setHl7EffectiveTime(IVLTS value) {
        this.getEffectiveTime().clear();
        this.getEffectiveTime().add(value);
    }

    public void setHl7RouteCode(CE value) {
        this.routeCode = value;
    }

    public void setHl7TemplateId(II value) {
        this.getTemplateId().clear();
        this.getTemplateId().add(value);
    }
}

