/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.ps;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.projecthusky.common.hl7cdar2.ActRelationshipHasComponent;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.CS;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.INT;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.POCDMT000040Authenticator;
import org.projecthusky.common.hl7cdar2.POCDMT000040Author;
import org.projecthusky.common.hl7cdar2.POCDMT000040ClinicalDocument;
import org.projecthusky.common.hl7cdar2.POCDMT000040Component1;
import org.projecthusky.common.hl7cdar2.POCDMT000040Component2;
import org.projecthusky.common.hl7cdar2.POCDMT000040Custodian;
import org.projecthusky.common.hl7cdar2.POCDMT000040DataEnterer;
import org.projecthusky.common.hl7cdar2.POCDMT000040DocumentationOf;
import org.projecthusky.common.hl7cdar2.POCDMT000040InformationRecipient;
import org.projecthusky.common.hl7cdar2.POCDMT000040InfrastructureRootTypeId;
import org.projecthusky.common.hl7cdar2.POCDMT000040LegalAuthenticator;
import org.projecthusky.common.hl7cdar2.POCDMT000040Participant1;
import org.projecthusky.common.hl7cdar2.POCDMT000040RecordTarget;
import org.projecthusky.common.hl7cdar2.POCDMT000040RelatedDocument;
import org.projecthusky.common.hl7cdar2.ST;
import org.projecthusky.common.hl7cdar2.TS;
import org.projecthusky.common.model.Identificator;

@XmlRootElement(name="ClinicalDocument", namespace="urn:hl7-org:v3")
public class ElgapatientConsultationSummary
extends POCDMT000040ClinicalDocument {
    public ElgapatientConsultationSummary() {
        super.getMoodCode().add("EVN");
        super.getRealmCode().add(ElgapatientConsultationSummary.createHl7RealmCodeFixedValue("AT", null, null, null));
        super.setTypeId(ElgapatientConsultationSummary.createHl7TypeIdFixedValue("2.16.840.1.113883.1.3", "POCD_HD000040"));
        super.getTemplateId().add(ElgapatientConsultationSummary.createHl7TemplateIdFixedValue("2.16.840.1.113883.10.22.1.1"));
        super.setCode(ElgapatientConsultationSummary.createHl7CodeFixedValue("34131-3", "2.16.840.1.113883.6.1", null, "Outpatient Progress note"));
        super.setConfidentialityCode(ElgapatientConsultationSummary.createHl7ConfidentialityCodeFixedValue("N", "2.16.840.1.113883.5.25", "HL7:Confidentiality", "normal"));
        super.setLanguageCode(ElgapatientConsultationSummary.createHl7LanguageCodeFixedValue("de-AT", null, null, null));
    }

    public void addHl7DocumentationOf(POCDMT000040DocumentationOf value) {
        this.getDocumentationOf().add(value);
    }

    public void clearHl7DocumentationOf() {
        this.getDocumentationOf().clear();
    }

    private static CE createHl7CodeFixedValue(String code, String codeSystem, String codeSystemName, String displayName) {
        CE retVal = new CE();
        retVal.setCode(code);
        retVal.setCodeSystem(codeSystem);
        retVal.setCodeSystemName(codeSystemName);
        retVal.setDisplayName(displayName);
        return retVal;
    }

    private static POCDMT000040Component2 createHl7ComponentFixedValue(String typeCode, String contextConductionInd) {
        POCDMT000040Component2 retVal = new POCDMT000040Component2();
        retVal.setTypeCode(ActRelationshipHasComponent.fromValue((String)typeCode));
        retVal.setContextConductionInd(Boolean.valueOf(Boolean.parseBoolean(contextConductionInd)));
        return retVal;
    }

    private static CE createHl7ConfidentialityCodeFixedValue(String code, String codeSystem, String codeSystemName, String displayName) {
        CE retVal = new CE();
        retVal.setCode(code);
        retVal.setCodeSystem(codeSystem);
        retVal.setCodeSystemName(codeSystemName);
        retVal.setDisplayName(displayName);
        return retVal;
    }

    private static CS createHl7LanguageCodeFixedValue(String code, String codeSystem, String codeSystemName, String displayName) {
        CS retVal = new CS();
        retVal.setCode(code);
        retVal.setCodeSystem(codeSystem);
        retVal.setCodeSystemName(codeSystemName);
        retVal.setDisplayName(displayName);
        return retVal;
    }

    private static CS createHl7RealmCodeFixedValue(String code, String codeSystem, String codeSystemName, String displayName) {
        CS retVal = new CS();
        retVal.setCode(code);
        retVal.setCodeSystem(codeSystem);
        retVal.setCodeSystemName(codeSystemName);
        retVal.setDisplayName(displayName);
        return retVal;
    }

    private static II createHl7TemplateIdFixedValue(String root) {
        II retVal = new II();
        retVal.setRoot(root);
        return retVal;
    }

    private static POCDMT000040InfrastructureRootTypeId createHl7TypeIdFixedValue(String root, String extension) {
        POCDMT000040InfrastructureRootTypeId retVal = new POCDMT000040InfrastructureRootTypeId();
        retVal.setRoot(root);
        retVal.setExtension(extension);
        return retVal;
    }

    public List<POCDMT000040Authenticator> getHl7Authenticator() {
        return this.authenticator;
    }

    public List<POCDMT000040Author> getHl7Author() {
        return this.author;
    }

    public CD getHl7Code() {
        return this.code;
    }

    public POCDMT000040Component2 getHl7Component() {
        return this.component;
    }

    public POCDMT000040Component1 getHl7ComponentOf() {
        return this.componentOf;
    }

    public CE getHl7ConfidentialityCode() {
        return this.confidentialityCode;
    }

    public POCDMT000040Custodian getHl7Custodian() {
        return this.custodian;
    }

    public POCDMT000040DataEnterer getHl7DataEnterer() {
        return this.dataEnterer;
    }

    public TS getHl7EffectiveTime() {
        return this.effectiveTime;
    }

    public II getHl7Id() {
        return this.id;
    }

    public List<POCDMT000040InformationRecipient> getHl7InformationRecipient() {
        return this.informationRecipient;
    }

    public CS getHl7LanguageCode() {
        return this.languageCode;
    }

    public POCDMT000040LegalAuthenticator getHl7LegalAuthenticator() {
        return this.legalAuthenticator;
    }

    public List<POCDMT000040Participant1> getHl7Participant() {
        return this.participant;
    }

    public List<CS> getHl7RealmCode() {
        return this.realmCode;
    }

    public List<POCDMT000040RecordTarget> getHl7RecordTarget() {
        return this.recordTarget;
    }

    public List<POCDMT000040RelatedDocument> getHl7RelatedDocument() {
        return this.relatedDocument;
    }

    public II getHl7SetId() {
        return this.setId;
    }

    public List<II> getHl7TemplateId() {
        return this.templateId;
    }

    public ST getHl7Title() {
        return this.title;
    }

    public POCDMT000040InfrastructureRootTypeId getHl7TypeId() {
        return this.typeId;
    }

    public INT getHl7VersionNumber() {
        return this.versionNumber;
    }

    public void initFirstVersion(Identificator newDocId) {
        Identificator docId = newDocId;
        if (docId == null) {
            docId = new Identificator(Identificator.builder().withRoot(UUID.randomUUID().toString()).build());
        }
        super.setId(docId.getHl7CdaR2Ii());
        this.setVersion(docId, 1);
    }

    public void initNextVersion(Identificator newDocId) {
        II setId = this.getSetId();
        if (setId == null) {
            setId = this.getId();
        }
        if (setId == null) {
            setId = newDocId.getHl7CdaR2Ii();
        }
        Integer version = this.getVersionNumber().getValue().intValue();
        this.setId(newDocId.getHl7CdaR2Ii());
        this.setVersion(new Identificator(setId), version + 1);
    }

    public static ElgapatientConsultationSummary loadFromFile(String inputFileName) throws JAXBException, IOException {
        return ElgapatientConsultationSummary.loadFromFile(new File(inputFileName));
    }

    public static ElgapatientConsultationSummary loadFromFile(File inputFile) throws JAXBException, IOException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ElgapatientConsultationSummary.class});
        Unmarshaller mar = context.createUnmarshaller();
        StreamSource source = new StreamSource(inputFile);
        JAXBElement root = mar.unmarshal((Source)source, ElgapatientConsultationSummary.class);
        ElgapatientConsultationSummary retVal = (ElgapatientConsultationSummary)((Object)root.getValue());
        return retVal;
    }

    public void setHl7Authenticator(POCDMT000040Authenticator value) {
        this.getAuthenticator().clear();
        this.getAuthenticator().add(value);
    }

    public void setHl7Author(POCDMT000040Author value) {
        this.getAuthor().clear();
        this.getAuthor().add(value);
    }

    public void setHl7Code(CE value) {
        this.code = value;
    }

    public void setHl7Component(POCDMT000040Component2 value) {
        this.component = value;
    }

    public void setHl7ComponentOf(POCDMT000040Component1 value) {
        this.componentOf = value;
    }

    public void setHl7ConfidentialityCode(CE value) {
        this.confidentialityCode = value;
    }

    public void setHl7Custodian(POCDMT000040Custodian value) {
        this.custodian = value;
    }

    public void setHl7DataEnterer(POCDMT000040DataEnterer value) {
        this.dataEnterer = value;
    }

    public void setHl7EffectiveTime(IVLTS value) {
        this.effectiveTime = value;
    }

    public void setHl7Id(II value) {
        this.id = value;
    }

    public void setHl7InformationRecipient(POCDMT000040InformationRecipient value) {
        this.getInformationRecipient().clear();
        this.getInformationRecipient().add(value);
    }

    public void setHl7LanguageCode(CS value) {
        this.languageCode = value;
    }

    public void setHl7LegalAuthenticator(POCDMT000040LegalAuthenticator value) {
        this.legalAuthenticator = value;
    }

    public void setHl7Participant(POCDMT000040Participant1 value) {
        this.getParticipant().clear();
        this.getParticipant().add(value);
    }

    public void setHl7RealmCode(CS value) {
        this.getRealmCode().clear();
        this.getRealmCode().add(value);
    }

    public void setHl7RecordTarget(POCDMT000040RecordTarget value) {
        this.getRecordTarget().clear();
        this.getRecordTarget().add(value);
    }

    public void setHl7RelatedDocument(POCDMT000040RelatedDocument value) {
        this.getRelatedDocument().clear();
        this.getRelatedDocument().add(value);
    }

    public void setHl7SetId(II value) {
        this.setId = value;
    }

    public void setHl7TemplateId(II value) {
        this.getTemplateId().clear();
        this.getTemplateId().add(value);
    }

    public void setHl7Title(ST value) {
        this.title = value;
    }

    public void setHl7TypeId(POCDMT000040InfrastructureRootTypeId value) {
        this.typeId = value;
    }

    public void setHl7VersionNumber(INT value) {
        this.versionNumber = value;
    }

    public void setVersion(Identificator idVersion1, int version) {
        super.setSetId(idVersion1.getHl7CdaR2Ii());
        super.setVersionNumber(new INT(version));
    }
}

