/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.ps;

import java.util.List;
import org.projecthusky.common.hl7cdar2.ANY;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.CS;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.ObjectFactory;
import org.projecthusky.common.hl7cdar2.POCDMT000040Author;
import org.projecthusky.common.hl7cdar2.POCDMT000040Informant12;
import org.projecthusky.common.hl7cdar2.POCDMT000040Observation;
import org.projecthusky.common.hl7cdar2.POCDMT000040Reference;
import org.projecthusky.common.hl7cdar2.XActMoodDocumentObservation;

public class FunctionalStatusEntry
extends POCDMT000040Observation {
    public FunctionalStatusEntry() {
        super.getClassCode().add("OBS");
        super.setMoodCode(XActMoodDocumentObservation.EVN);
        super.getTemplateId().add(FunctionalStatusEntry.createHl7TemplateIdFixedValue("1.2.40.0.34.11.13.3.30"));
        super.setCode(FunctionalStatusEntry.createHl7CodeFixedValue("284773001", "2.16.840.1.113883.6.96", "SNOMED CT", "Ability to Care for Self"));
        super.setStatusCode(FunctionalStatusEntry.createHl7StatusCodeFixedValue("completed", null, null, null));
    }

    public void addHl7Author(POCDMT000040Author value) {
        this.getAuthor().add(value);
    }

    public void addHl7Id(II value) {
        this.getId().add(value);
    }

    public void addHl7Informant(POCDMT000040Informant12 value) {
        this.getInformant().add(value);
    }

    public void addHl7Reference(POCDMT000040Reference value) {
        this.getReference().add(value);
    }

    public void clearHl7Author() {
        this.getAuthor().clear();
    }

    public void clearHl7Id() {
        this.getId().clear();
    }

    public void clearHl7Informant() {
        this.getInformant().clear();
    }

    public void clearHl7Reference() {
        this.getReference().clear();
    }

    private static CD createHl7CodeFixedValue(String code, String codeSystem, String codeSystemName, String displayName) {
        ObjectFactory factory = new ObjectFactory();
        CD retVal = factory.createCD();
        retVal.setCode(code);
        retVal.setCodeSystem(codeSystem);
        retVal.setCodeSystemName(codeSystemName);
        retVal.setDisplayName(displayName);
        return retVal;
    }

    private static CS createHl7StatusCodeFixedValue(String code, String codeSystem, String codeSystemName, String displayName) {
        ObjectFactory factory = new ObjectFactory();
        CS retVal = factory.createCS();
        retVal.setCode(code);
        retVal.setCodeSystem(codeSystem);
        retVal.setCodeSystemName(codeSystemName);
        retVal.setDisplayName(displayName);
        return retVal;
    }

    private static II createHl7TemplateIdFixedValue(String root) {
        ObjectFactory factory = new ObjectFactory();
        II retVal = factory.createII();
        retVal.setRoot(root);
        return retVal;
    }

    public CD getHl7Code() {
        return this.code;
    }

    public IVLTS getHl7EffectiveTime() {
        return this.effectiveTime;
    }

    public CS getHl7StatusCode() {
        return this.statusCode;
    }

    public List<II> getHl7TemplateId() {
        return this.templateId;
    }

    public List<ANY> getHl7Value() {
        return this.value;
    }

    public void setHl7Code(CD value) {
        this.code = value;
    }

    public void setHl7EffectiveTime(IVLTS value) {
        this.effectiveTime = value;
    }

    public void setHl7StatusCode(CS value) {
        this.statusCode = value;
    }

    public void setHl7TemplateId(II value) {
        this.getTemplateId().clear();
        this.getTemplateId().add(value);
    }

    public void setHl7Value(ANY value) {
        this.getValue().clear();
        this.getValue().add(value);
    }
}

