/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.ps;

import java.util.ArrayList;
import java.util.List;
import org.projecthusky.common.basetypes.CodeBaseType;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.CS;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.ObjectFactory;
import org.projecthusky.common.hl7cdar2.POCDMT000040Act;
import org.projecthusky.common.hl7cdar2.POCDMT000040Author;
import org.projecthusky.common.hl7cdar2.POCDMT000040EntryRelationship;
import org.projecthusky.common.hl7cdar2.POCDMT000040Informant12;
import org.projecthusky.common.hl7cdar2.POCDMT000040Reference;
import org.projecthusky.common.hl7cdar2.XActClassDocumentEntryAct;
import org.projecthusky.common.hl7cdar2.XActRelationshipEntryRelationship;
import org.projecthusky.common.hl7cdar2.XDocumentActMood;
import org.projecthusky.common.model.Code;

public class GesundheitsproblemBedenkenEntry
extends POCDMT000040Act {
    private final List<Code> vocabStatusCodeCode = new ArrayList<Code>();

    public GesundheitsproblemBedenkenEntry() {
        super.setClassCode(XActClassDocumentEntryAct.ACT);
        super.setMoodCode(XDocumentActMood.EVN);
        super.getTemplateId().add(GesundheitsproblemBedenkenEntry.createHl7TemplateIdFixedValue("1.2.40.0.34.11.13.3.6"));
        super.setCode((CD)GesundheitsproblemBedenkenEntry.createHl7CodeFixedValue("CONC", "2.16.840.1.113883.5.6", null, null));
        this.vocabStatusCodeCode.add(new Code(CodeBaseType.builder().withCode("active").build()));
        this.vocabStatusCodeCode.add(new Code(CodeBaseType.builder().withCode("completed").build()));
        super.getEntryRelationship().add(GesundheitsproblemBedenkenEntry.createHl7EntryRelationshipFixedValue("SUBJ", "false"));
    }

    public void addHl7Author(POCDMT000040Author value) {
        this.getAuthor().add(value);
    }

    public void addHl7EntryRelationship(POCDMT000040EntryRelationship value) {
        this.getEntryRelationship().add(value);
    }

    public void addHl7Id(II value) {
        this.getId().add(value);
    }

    public void addHl7Informant(POCDMT000040Informant12 value) {
        this.getInformant().add(value);
    }

    public void clearHl7Author() {
        this.getAuthor().clear();
    }

    public void clearHl7EntryRelationship() {
        this.getEntryRelationship().clear();
    }

    public void clearHl7Id() {
        this.getId().clear();
    }

    public void clearHl7Informant() {
        this.getInformant().clear();
    }

    private static CE createHl7CodeFixedValue(String code, String codeSystem, String codeSystemName, String displayName) {
        ObjectFactory factory = new ObjectFactory();
        CE retVal = factory.createCE();
        retVal.setCode(code);
        retVal.setCodeSystem(codeSystem);
        retVal.setCodeSystemName(codeSystemName);
        retVal.setDisplayName(displayName);
        return retVal;
    }

    private static POCDMT000040EntryRelationship createHl7EntryRelationshipFixedValue(String typeCode, String inversionInd) {
        ObjectFactory factory = new ObjectFactory();
        POCDMT000040EntryRelationship retVal = factory.createPOCDMT000040EntryRelationship();
        retVal.setTypeCode(XActRelationshipEntryRelationship.fromValue((String)typeCode));
        if (inversionInd != null) {
            retVal.setInversionInd(Boolean.valueOf(Boolean.parseBoolean(inversionInd)));
        }
        return retVal;
    }

    private static II createHl7TemplateIdFixedValue(String root) {
        ObjectFactory factory = new ObjectFactory();
        II retVal = factory.createII();
        retVal.setRoot(root);
        return retVal;
    }

    public CE getHl7Code() {
        return (CE)this.code;
    }

    public IVLTS getHl7EffectiveTime() {
        return this.effectiveTime;
    }

    public List<POCDMT000040Reference> getHl7Reference() {
        return this.reference;
    }

    public CS getHl7StatusCode() {
        return this.statusCode;
    }

    public List<II> getHl7TemplateId() {
        return this.templateId;
    }

    public List<Code> getVocabStatusCodeCode() {
        return this.vocabStatusCodeCode;
    }

    public void setHl7Code(CE value) {
        this.code = value;
    }

    public void setHl7EffectiveTime(IVLTS value) {
        this.effectiveTime = value;
    }

    public void setHl7Reference(POCDMT000040Reference value) {
        this.getReference().clear();
        this.getReference().add(value);
    }

    public void setHl7StatusCode(CS value) {
        this.statusCode = value;
    }

    public void setHl7TemplateId(II value) {
        this.getTemplateId().clear();
        this.getTemplateId().add(value);
    }
}

