/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.ps;

import java.util.List;
import org.projecthusky.common.hl7cdar2.ActClassSupply;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.ED;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.ObjectFactory;
import org.projecthusky.common.hl7cdar2.POCDMT000040Author;
import org.projecthusky.common.hl7cdar2.POCDMT000040EntryRelationship;
import org.projecthusky.common.hl7cdar2.POCDMT000040Performer2;
import org.projecthusky.common.hl7cdar2.POCDMT000040Product;
import org.projecthusky.common.hl7cdar2.POCDMT000040Reference;
import org.projecthusky.common.hl7cdar2.POCDMT000040Supply;
import org.projecthusky.common.hl7cdar2.PQ;
import org.projecthusky.common.hl7cdar2.ParticipationPhysicalPerformer;
import org.projecthusky.common.hl7cdar2.XActRelationshipEntryRelationship;
import org.projecthusky.common.hl7cdar2.XDocumentSubstanceMood;

public class MedikationAbgabeEntryemed
extends POCDMT000040Supply {
    public MedikationAbgabeEntryemed() {
        super.setClassCode(ActClassSupply.SPLY);
        super.setMoodCode(XDocumentSubstanceMood.EVN);
        super.getTemplateId().add(MedikationAbgabeEntryemed.createHl7TemplateIdFixedValue("1.2.40.0.34.11.8.2.3.1"));
        super.getTemplateId().add(MedikationAbgabeEntryemed.createHl7TemplateIdFixedValue("2.16.840.1.113883.10.20.1.34"));
        super.getTemplateId().add(MedikationAbgabeEntryemed.createHl7TemplateIdFixedValue("1.3.6.1.4.1.19376.1.5.3.1.4.7.3"));
        super.getTemplateId().add(MedikationAbgabeEntryemed.createHl7TemplateIdFixedValue("1.3.6.1.4.1.19376.1.9.1.3.4"));
    }

    private static POCDMT000040Author createHl7AuthorFixedValue(String typeCode, String contextControlCode, String nullFlavor) {
        ObjectFactory factory = new ObjectFactory();
        POCDMT000040Author retVal = factory.createPOCDMT000040Author();
        retVal.getTypeCode().add(typeCode);
        retVal.setContextControlCode(contextControlCode);
        if (nullFlavor != null) {
            retVal.getNullFlavor().add(nullFlavor);
        }
        return retVal;
    }

    private static CE createHl7CodeFixedValue() {
        ObjectFactory factory = new ObjectFactory();
        CE retVal = factory.createCE();
        return retVal;
    }

    private static POCDMT000040EntryRelationship createHl7EntryRelationshipFixedValue(String typeCode, String inversionInd) {
        ObjectFactory factory = new ObjectFactory();
        POCDMT000040EntryRelationship retVal = factory.createPOCDMT000040EntryRelationship();
        retVal.setTypeCode(XActRelationshipEntryRelationship.fromValue((String)typeCode));
        if (inversionInd != null) {
            retVal.setInversionInd(Boolean.valueOf(Boolean.parseBoolean(inversionInd)));
        }
        return retVal;
    }

    private static II createHl7IdFixedValue(String root) {
        ObjectFactory factory = new ObjectFactory();
        II retVal = factory.createII();
        retVal.setRoot(root);
        return retVal;
    }

    private static POCDMT000040Performer2 createHl7PerformerFixedValue(String typeCode) {
        ObjectFactory factory = new ObjectFactory();
        POCDMT000040Performer2 retVal = factory.createPOCDMT000040Performer2();
        retVal.setTypeCode(ParticipationPhysicalPerformer.fromValue((String)typeCode));
        return retVal;
    }

    private static II createHl7TemplateIdFixedValue(String root) {
        ObjectFactory factory = new ObjectFactory();
        II retVal = factory.createII();
        retVal.setRoot(root);
        return retVal;
    }

    public List<POCDMT000040Author> getHl7Author() {
        return this.author;
    }

    public CE getHl7Code() {
        return (CE)this.code;
    }

    public List<POCDMT000040EntryRelationship> getHl7EntryRelationship() {
        return this.entryRelationship;
    }

    public List<II> getHl7Id() {
        return this.id;
    }

    public List<POCDMT000040Performer2> getHl7Performer() {
        return this.performer;
    }

    public POCDMT000040Product getHl7Product() {
        return this.product;
    }

    public PQ getHl7Quantity() {
        return this.quantity;
    }

    public List<POCDMT000040Reference> getHl7Reference() {
        return this.reference;
    }

    public List<II> getHl7TemplateId() {
        return this.templateId;
    }

    public ED getHl7Text() {
        return this.text;
    }

    public static POCDMT000040Author getPredefinedAuthorAutOp() {
        return MedikationAbgabeEntryemed.createHl7AuthorFixedValue("AUT", "OP", null);
    }

    public static POCDMT000040Author getPredefinedAuthorNaNullNull() {
        return MedikationAbgabeEntryemed.createHl7AuthorFixedValue(null, null, "NA");
    }

    public static CE getPredefinedCode() {
        return MedikationAbgabeEntryemed.createHl7CodeFixedValue();
    }

    public static POCDMT000040EntryRelationship getPredefinedEntryRelationshipCompNull() {
        return MedikationAbgabeEntryemed.createHl7EntryRelationshipFixedValue("COMP", null);
    }

    public static POCDMT000040EntryRelationship getPredefinedEntryRelationshipRefrNull() {
        return MedikationAbgabeEntryemed.createHl7EntryRelationshipFixedValue("REFR", null);
    }

    public static POCDMT000040EntryRelationship getPredefinedEntryRelationshipSubjTrue() {
        return MedikationAbgabeEntryemed.createHl7EntryRelationshipFixedValue("SUBJ", "true");
    }

    public static II getPredefinedId1240010143423() {
        return MedikationAbgabeEntryemed.createHl7IdFixedValue("1.2.40.0.10.1.4.3.4.2.3");
    }

    public static POCDMT000040Performer2 getPredefinedPerformerPrf() {
        return MedikationAbgabeEntryemed.createHl7PerformerFixedValue("PRF");
    }

    public void setHl7Author(POCDMT000040Author value) {
        this.getAuthor().clear();
        this.getAuthor().add(value);
    }

    public void setHl7Code(CE value) {
        this.code = value;
    }

    public void setHl7EntryRelationship(POCDMT000040EntryRelationship value) {
        this.getEntryRelationship().clear();
        this.getEntryRelationship().add(value);
    }

    public void setHl7Id(II value) {
        this.getId().clear();
        this.getId().add(value);
    }

    public void setHl7Performer(POCDMT000040Performer2 value) {
        this.getPerformer().clear();
        this.getPerformer().add(value);
    }

    public void setHl7Product(POCDMT000040Product value) {
        this.product = value;
    }

    public void setHl7Quantity(PQ value) {
        this.quantity = value;
    }

    public void setHl7Reference(POCDMT000040Reference value) {
        this.getReference().clear();
        this.getReference().add(value);
    }

    public void setHl7TemplateId(II value) {
        this.getTemplateId().clear();
        this.getTemplateId().add(value);
    }

    public void setHl7Text(ED value) {
        this.text = value;
    }
}

