/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.ps;

import java.util.ArrayList;
import java.util.List;
import org.projecthusky.common.basetypes.CodeBaseType;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.CS;
import org.projecthusky.common.hl7cdar2.ED;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.IVLINT;
import org.projecthusky.common.hl7cdar2.IVLPQ;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.ObjectFactory;
import org.projecthusky.common.hl7cdar2.PIVLTS;
import org.projecthusky.common.hl7cdar2.POCDMT000040Author;
import org.projecthusky.common.hl7cdar2.POCDMT000040Consumable;
import org.projecthusky.common.hl7cdar2.POCDMT000040EntryRelationship;
import org.projecthusky.common.hl7cdar2.POCDMT000040Reference;
import org.projecthusky.common.hl7cdar2.POCDMT000040SubstanceAdministration;
import org.projecthusky.common.hl7cdar2.SXCMTS;
import org.projecthusky.common.hl7cdar2.SXPRTS;
import org.projecthusky.common.hl7cdar2.SetOperator;
import org.projecthusky.common.hl7cdar2.XActRelationshipEntryRelationship;
import org.projecthusky.common.hl7cdar2.XDocumentSubstanceMood;
import org.projecthusky.common.model.Code;

public class MedikationVerordnungEntryemed
extends POCDMT000040SubstanceAdministration {
    private final List<Code> vocabRouteCodeCode = new ArrayList<Code>();

    public MedikationVerordnungEntryemed() {
        super.getClassCode().add("SBADM");
        super.setMoodCode(XDocumentSubstanceMood.INT);
        super.getTemplateId().add(MedikationVerordnungEntryemed.createHl7TemplateIdFixedValue("1.2.40.0.34.11.8.1.3.1"));
        super.getTemplateId().add(MedikationVerordnungEntryemed.createHl7TemplateIdFixedValue("2.16.840.1.113883.10.20.1.24"));
        super.getTemplateId().add(MedikationVerordnungEntryemed.createHl7TemplateIdFixedValue("1.3.6.1.4.1.19376.1.5.3.1.4.7"));
        super.getTemplateId().add(MedikationVerordnungEntryemed.createHl7TemplateIdFixedValue("1.3.6.1.4.1.19376.1.9.1.3.2"));
        super.getTemplateId().add(MedikationVerordnungEntryemed.createHl7TemplateIdFixedValue("1.3.6.1.4.1.19376.1.9.1.3.6"));
        super.setStatusCode(MedikationVerordnungEntryemed.createHl7StatusCodeFixedValue("completed", null, null, null));
        this.vocabRouteCodeCode.add(new Code(CodeBaseType.builder().withCodeSystem("1.2.40.0.10.1.4.3.4.3.4").build()));
        super.getEntryRelationship().add(MedikationVerordnungEntryemed.createHl7EntryRelationshipFixedValue("COMP", null));
    }

    private static POCDMT000040Author createHl7AuthorFixedValue(String typeCode, String contextControlCode, String nullFlavor) {
        ObjectFactory factory = new ObjectFactory();
        POCDMT000040Author retVal = factory.createPOCDMT000040Author();
        retVal.getTypeCode().add(typeCode);
        retVal.setContextControlCode(contextControlCode);
        if (nullFlavor != null) {
            retVal.getNullFlavor().add(nullFlavor);
        }
        return retVal;
    }

    private static IVLPQ createHl7DoseQuantityFixedValue() {
        ObjectFactory factory = new ObjectFactory();
        IVLPQ retVal = factory.createIVLPQ();
        return retVal;
    }

    private static IVLTS createHl7EffectiveTimeFixedValue(String nullFlavor, String operator) {
        ObjectFactory factory = new ObjectFactory();
        IVLTS retVal = factory.createIVLTS();
        if (nullFlavor != null) {
            retVal.getNullFlavor().add(nullFlavor);
        }
        retVal.setOperator(SetOperator.valueOf((String)operator));
        return retVal;
    }

    private static POCDMT000040EntryRelationship createHl7EntryRelationshipFixedValue(String typeCode, String inversionInd) {
        ObjectFactory factory = new ObjectFactory();
        POCDMT000040EntryRelationship retVal = factory.createPOCDMT000040EntryRelationship();
        retVal.setTypeCode(XActRelationshipEntryRelationship.fromValue((String)typeCode));
        if (inversionInd != null) {
            retVal.setInversionInd(Boolean.valueOf(Boolean.parseBoolean(inversionInd)));
        }
        return retVal;
    }

    private static II createHl7IdFixedValue(String root) {
        ObjectFactory factory = new ObjectFactory();
        II retVal = factory.createII();
        retVal.setRoot(root);
        return retVal;
    }

    private static CS createHl7StatusCodeFixedValue(String code, String codeSystem, String codeSystemName, String displayName) {
        ObjectFactory factory = new ObjectFactory();
        CS retVal = factory.createCS();
        retVal.setCode(code);
        retVal.setCodeSystem(codeSystem);
        retVal.setCodeSystemName(codeSystemName);
        retVal.setDisplayName(displayName);
        return retVal;
    }

    private static II createHl7TemplateIdFixedValue(String root) {
        ObjectFactory factory = new ObjectFactory();
        II retVal = factory.createII();
        retVal.setRoot(root);
        return retVal;
    }

    public List<POCDMT000040Author> getHl7Author() {
        return this.author;
    }

    public POCDMT000040Consumable getHl7Consumable() {
        return this.consumable;
    }

    public IVLPQ getHl7DoseQuantity() {
        return this.doseQuantity;
    }

    public List<SXCMTS> getHl7EffectiveTimeListSxcmts() {
        return this.effectiveTime;
    }

    public List<POCDMT000040EntryRelationship> getHl7EntryRelationship() {
        return this.entryRelationship;
    }

    public List<II> getHl7Id() {
        return this.id;
    }

    public List<POCDMT000040Reference> getHl7Reference() {
        return this.reference;
    }

    public IVLINT getHl7RepeatNumber() {
        return this.repeatNumber;
    }

    public CE getHl7RouteCode() {
        return this.routeCode;
    }

    public CS getHl7StatusCode() {
        return this.statusCode;
    }

    public List<II> getHl7TemplateId() {
        return this.templateId;
    }

    public ED getHl7Text() {
        return this.text;
    }

    public static POCDMT000040Author getPredefinedAuthorAutOp() {
        return MedikationVerordnungEntryemed.createHl7AuthorFixedValue("AUT", "OP", null);
    }

    public static POCDMT000040Author getPredefinedAuthorNaNullNull() {
        return MedikationVerordnungEntryemed.createHl7AuthorFixedValue(null, null, "NA");
    }

    public static IVLPQ getPredefinedDoseQuantity() {
        return MedikationVerordnungEntryemed.createHl7DoseQuantityFixedValue();
    }

    public static IVLTS getPredefinedEffectiveTimeANull() {
        return MedikationVerordnungEntryemed.createHl7EffectiveTimeFixedValue("A", null);
    }

    public static IVLTS getPredefinedEffectiveTimeNa() {
        return MedikationVerordnungEntryemed.createHl7EffectiveTimeFixedValue(null, "NA");
    }

    public static POCDMT000040EntryRelationship getPredefinedEntryRelationshipSubjTrue() {
        return MedikationVerordnungEntryemed.createHl7EntryRelationshipFixedValue("SUBJ", "true");
    }

    public static II getPredefinedId1240010143422() {
        return MedikationVerordnungEntryemed.createHl7IdFixedValue("1.2.40.0.10.1.4.3.4.2.2");
    }

    public static II getPredefinedTemplateId136141193761531421() {
        return MedikationVerordnungEntryemed.createHl7TemplateIdFixedValue("1.3.6.1.4.1.19376.1.5.3.1.4.21");
    }

    public static II getPredefinedTemplateId136141193761531471() {
        return MedikationVerordnungEntryemed.createHl7TemplateIdFixedValue("1.3.6.1.4.1.19376.1.5.3.1.4.7.1");
    }

    public static II getPredefinedTemplateId13614119376153149() {
        return MedikationVerordnungEntryemed.createHl7TemplateIdFixedValue("1.3.6.1.4.1.19376.1.5.3.1.4.9");
    }

    public List<Code> getVocabRouteCodeCode() {
        return this.vocabRouteCodeCode;
    }

    public void setHl7Author(POCDMT000040Author value) {
        this.getAuthor().clear();
        this.getAuthor().add(value);
    }

    public void setHl7Consumable(POCDMT000040Consumable value) {
        this.consumable = value;
    }

    public void setHl7DoseQuantity(IVLPQ value) {
        this.doseQuantity = value;
    }

    public void setHl7EffectiveTime(PIVLTS value) {
        this.getEffectiveTime().clear();
        this.getEffectiveTime().add(value);
    }

    public void setHl7EffectiveTime(IVLTS value) {
        this.getEffectiveTime().clear();
        this.getEffectiveTime().add(value);
    }

    public void setHl7EffectiveTime(SXPRTS value) {
        this.getEffectiveTime().clear();
        this.getEffectiveTime().add(value);
    }

    public void setHl7EntryRelationship(POCDMT000040EntryRelationship value) {
        this.getEntryRelationship().clear();
        this.getEntryRelationship().add(value);
    }

    public void setHl7Id(II value) {
        this.getId().clear();
        this.getId().add(value);
    }

    public void setHl7Reference(POCDMT000040Reference value) {
        this.getReference().clear();
        this.getReference().add(value);
    }

    public void setHl7RepeatNumber(IVLINT value) {
        this.repeatNumber = value;
    }

    public void setHl7RouteCode(CE value) {
        this.routeCode = value;
    }

    public void setHl7StatusCode(CS value) {
        this.statusCode = value;
    }

    public void setHl7TemplateId(II value) {
        this.getTemplateId().clear();
        this.getTemplateId().add(value);
    }

    public void setHl7Text(ED value) {
        this.text = value;
    }
}

